/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobInputStream;

public class ClobDataID
implements ClobData {
    long id;
    long length = -1L;

    public ClobDataID(long l2) {
        this.id = l2;
    }

    @Override
    public char[] getChars(SessionInterface sessionInterface, long l2, int n2) {
        ResultLob resultLob = ResultLob.newLobGetCharsRequest(this.id, l2, n2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getCharArray();
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
        return this.length;
    }

    @Override
    public String getSubString(SessionInterface sessionInterface, long l2, int n2) {
        long l3 = this.length(sessionInterface);
        if (l2 >= l3) {
            return "";
        }
        if (l2 + (long)n2 >= l3) {
            n2 = (int)(l3 - l2);
        }
        char[] cArray = this.getChars(sessionInterface, l2, n2);
        return new String(cArray);
    }

    @Override
    public ClobData duplicate(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobDuplicateRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            HsqlException hsqlException = result.getException();
            if (hsqlException == null) {
                hsqlException = new HsqlException(result);
            }
            throw hsqlException;
        }
        long l2 = ((ResultLob)result).getLobID();
        return new ClobDataID(l2);
    }

    @Override
    public ClobData getClob(SessionInterface sessionInterface, long l2, long l3) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l2, l3);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        long l4 = ((ResultLob)result).getLobID();
        return new ClobDataID(l4);
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l2) {
        if (l2 >= this.length(sessionInterface)) {
            return;
        }
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface) {
        long l2 = this.length(sessionInterface);
        return new ClobInputStream(sessionInterface, this, 0L, l2);
    }

    @Override
    public void setCharacterStream(SessionInterface sessionInterface, long l2, Reader reader) {
    }

    @Override
    public void setString(SessionInterface sessionInterface, long l2, String string) {
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l2, string.toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public void setClob(SessionInterface sessionInterface, long l2, ClobData clobData, long l3, long l4) {
    }

    @Override
    public void setChars(SessionInterface sessionInterface, long l2, char[] object, int n2, int n3) {
        Result result;
        Object object2;
        if (n2 != 0 || n3 != ((char[])object).length) {
            if (!ClobDataID.isInLimits(((char[])object).length, n2, n3)) {
                throw Error.error(3401);
            }
            if (n2 != 0 || n3 != ((char[])object).length) {
                object2 = new char[n3];
                System.arraycopy(object, n2, object2, 0, n3);
                object = object2;
            }
        }
        if ((result = sessionInterface.execute((Result)(object2 = ResultLob.newLobSetCharsRequest(this.id, l2, object)))).isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public long position(SessionInterface sessionInterface, String string, long l2) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, string.toCharArray(), l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, ClobData clobData, long l2) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, clobData.getId(), l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long nonSpaceLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface sessionInterface, long l2, long l3) {
        return new ClobInputStream(sessionInterface, this, l2, l3);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ClobDataID) {
            return this.id == ((ClobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

