/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.DataInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String initError;
    private static long lModified = 0L;

    public void init(ServletConfig servletConfig) {
        Object object;
        try {
            super.init(servletConfig);
        }
        catch (ServletException servletException) {
            this.log(servletException.toString());
        }
        String string = this.getInitParameter("hsqldb.server.database");
        if (string == null) {
            string = ".";
        }
        String string2 = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!string.equals(".") && "true".equalsIgnoreCase(string2) && (object = this.getServletContext().getRealPath("/")) != null) {
            if (!((String)object).endsWith("/")) {
                object = (String)object + '/';
            }
            string = (String)object + "WEB-INF/" + string;
        }
        object = DatabaseURL.parseURL(string, false, false);
        this.log("Database filename = " + string);
        if (object == null) {
            this.initError = "Bad Database name";
        } else {
            this.dbPath = ((HsqlProperties)object).getProperty("database");
            this.dbType = ((HsqlProperties)object).getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, (HsqlProperties)object);
            }
            catch (HsqlException hsqlException) {
                this.initError = hsqlException.getMessage();
            }
        }
        if (this.initError == null) {
            this.log("Initialization completed.");
        } else {
            this.log("Database could not be initialised.");
            this.log(this.initError);
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return lModified++;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getQueryString();
        if (string == null || string.length() == 0) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
            printWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            printWriter.println("The servlet is running.<p>");
            if (this.initError == null) {
                printWriter.println("Connected to the database.<p>");
                printWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
            } else {
                printWriter.println("<h2>The database is not available.</h2>");
                printWriter.println("The error message is:<p>");
                printWriter.println(this.initError);
            }
            printWriter.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        DataInputStream dataInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Result result;
            dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            int n2 = dataInputStream.readInt();
            long l2 = dataInputStream.readLong();
            byte by = dataInputStream.readByte();
            RowInputBinary rowInputBinary = new RowInputBinary(256);
            Session session = DatabaseManager.getSession(n2, l2);
            Result result2 = Result.newResult(session, by, dataInputStream, rowInputBinary);
            result2.setDatabaseId(n2);
            result2.setSessionId(l2);
            int n3 = result2.getType();
            if (n3 == 31) {
                try {
                    session = DatabaseManager.newSession(this.dbType, this.dbPath, result2.getMainString(), result2.getSubString(), new HsqlProperties(), result2.getZoneString(), result2.getUpdateCount());
                    result = Result.newConnectionAcknowledgeResponse(session);
                }
                catch (HsqlException hsqlException) {
                    result = Result.newErrorResult(hsqlException);
                }
            } else {
                long l3;
                if (n3 == 32 || n3 == 10) {
                    httpServletResponse.setHeader("Cache-Control", "no-cache");
                    httpServletResponse.setContentType("application/octet-stream");
                    httpServletResponse.setContentLength(6);
                    filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    ((DataOutputStream)filterOutputStream).writeByte(32);
                    ((DataOutputStream)filterOutputStream).writeInt(4);
                    ((DataOutputStream)filterOutputStream).writeByte(0);
                    filterOutputStream.close();
                    return;
                }
                if (n3 == 5) {
                    int n4 = result2.getDatabaseId();
                    l3 = result2.getSessionId();
                    session = DatabaseManager.getSession(n4, l3);
                    result = session.cancel(result2);
                } else {
                    int n5 = result2.getDatabaseId();
                    l3 = result2.getSessionId();
                    session = DatabaseManager.getSession(n5, l3);
                    result2.readLobResults(session, dataInputStream);
                    result = session.execute(result2);
                }
            }
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(hsqlByteArrayOutputStream);
            RowOutputBinary rowOutputBinary = new RowOutputBinary(256, 1);
            result.write(session, dataOutputStream, rowOutputBinary);
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setContentLength(hsqlByteArrayOutputStream.size());
            filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            hsqlByteArrayOutputStream.writeTo(filterOutputStream);
        }
        catch (HsqlException hsqlException) {
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
    }
}

