/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.server.HsqlSocketFactory;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    protected Object socketFactory;
    protected Object serverSocketFactory;
    protected final Object socket_factory_mutex = new Object();
    protected final Object server_socket_factory_mutex = new Object();

    protected HsqlSocketFactorySecure() throws Exception {
    }

    @Override
    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.addHandshakeCompletedListener(this);
    }

    @Override
    public ServerSocket createServerSocket(int n2) throws Exception {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n2);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n2, String string) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(string);
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n2, 128, inetAddress);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    private static void dump(String string, String[] stringArray) {
        Error.printSystemOut(string);
        Error.printSystemOut("----------------------------");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Error.printSystemOut(String.valueOf(stringArray[i2]));
        }
        Error.printSystemOut("----------------------------");
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2) throws Exception {
        if (socket == null) {
            return this.createSocket(string, n2);
        }
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(socket, string, n2, true);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string, sSLSocket.getSession());
        return sSLSocket;
    }

    @Override
    public Socket createSocket(String string, int n2) throws Exception {
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(string, n2);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string, sSLSocket.getSession());
        return sSLSocket;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLServerSocketFactory getServerSocketFactoryImpl() {
        Object object;
        Object object2 = this.server_socket_factory_mutex;
        synchronized (object2) {
            object = this.serverSocketFactory;
            if (object == null) {
                this.serverSocketFactory = object = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSocketFactoryImpl() {
        Object object;
        Object object2 = this.socket_factory_mutex;
        synchronized (object2) {
            object = this.socketFactory;
            if (object == null) {
                this.socketFactory = object = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)object;
    }

    protected void verify(String string, SSLSession sSLSession) throws Exception {
        String string2;
        Certificate[] certificateArray = sSLSession.getPeerCertificates();
        if (certificateArray == null || certificateArray.length == 0) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        if (!(certificateArray[0] instanceof X509Certificate)) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string3 = String.valueOf(x500Principal);
        int n2 = string3.indexOf("CN=");
        if (n2 < 0) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        int n3 = string3.indexOf(44, n2 += 3);
        if ((string2 = string3.substring(n2, n3 > -1 ? n3 : string3.length())).length() < 1) {
            throw new UnknownHostException(Error.getMessage(64));
        }
        if (!string2.equalsIgnoreCase(string)) {
            throw new UnknownHostException(Error.getMessage(65, 0, new String[]{string2, string}));
        }
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        if (Error.TRACESYSTEMOUT) {
            SSLSocket sSLSocket = handshakeCompletedEvent.getSocket();
            SSLSession sSLSession = handshakeCompletedEvent.getSession();
            Error.printSystemOut("SSL handshake completed:");
            Error.printSystemOut("------------------------------------------------");
            Error.printSystemOut("socket:      : " + sSLSocket);
            Error.printSystemOut("cipher suite : " + sSLSession.getCipherSuite());
            String string = StringConverter.byteArrayToHexString(sSLSession.getId());
            Error.printSystemOut("session id   : " + string);
            Error.printSystemOut("------------------------------------------------");
        }
    }
}

