/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.error.Error;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;

public class RowInputTextQuoted
extends RowInputText {
    private static final int NORMAL_FIELD = 0;
    private static final int NEED_END_QUOTE = 1;
    private static final int FOUND_QUOTE = 2;
    private final char quoteChar;
    int charLength = 0;

    public RowInputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
        this.quoteChar = textFileSettings.quoteChar;
    }

    @Override
    public void setSource(String string, long l2, int n2) {
        super.setSource(string, l2, n2);
        this.charLength = string.length();
        for (int i2 = this.charLength - 1; i2 > -1 && (string.charAt(i2) == '\r' || string.charAt(i2) == '\n'); --i2) {
            --this.charLength;
        }
    }

    @Override
    protected String getField(String string, int n2, boolean bl) {
        String string2 = null;
        if (this.next >= this.charLength || this.text.charAt(this.next) != this.quoteChar) {
            return super.getField(string, n2, bl);
        }
        try {
            ++this.field;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            int n3 = 0;
            int n4 = -1;
            if (!bl) {
                n4 = this.text.indexOf(string, this.next);
            }
            while (this.next < this.charLength) {
                switch (n3) {
                    default: {
                        if (this.next == n4) {
                            this.next += n2;
                            bl2 = true;
                            break;
                        }
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            n3 = 1;
                            break;
                        }
                        stringBuilder.append(this.text.charAt(this.next));
                        break;
                    }
                    case 1: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            n3 = 2;
                            break;
                        }
                        stringBuilder.append(this.text.charAt(this.next));
                        break;
                    }
                    case 2: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            stringBuilder.append(this.text.charAt(this.next));
                            n3 = 1;
                            break;
                        }
                        if (!bl) {
                            n4 = this.text.indexOf(string, this.next);
                            if (n4 < 0) {
                                n4 = this.charLength;
                            }
                            stringBuilder.append(this.text, this.next, n4);
                            this.next = n4 + n2;
                            bl2 = true;
                            break;
                        }
                        this.next += n2 - 1;
                        n3 = 0;
                    }
                }
                if (bl2) break;
                ++this.next;
            }
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            String string3 = String.valueOf(this.field);
            throw Error.error(exception, 41, string3);
        }
        return string2;
    }
}

