/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary180
extends RowInputBinary {
    Calendar tempCalDefault = new GregorianCalendar();

    public RowInputBinary180(byte[] byArray) {
        super(byArray);
    }

    @Override
    protected TimeData readTime(Type type) {
        if (type.typeCode == 92) {
            long l2 = this.readLong();
            l2 = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l2);
            l2 = HsqlDateTime.getNormalisedTime(l2);
            return new TimeData((int)(l2 / 1000L), 0, 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) {
        long l2 = this.readLong();
        l2 = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l2);
        l2 = HsqlDateTime.getNormalisedDate(l2);
        return new TimestampData(l2 / 1000L);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        if (type.typeCode == 93) {
            long l2 = this.readLong();
            int n2 = this.readInt();
            l2 = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, l2);
            return new TimestampData(l2 / 1000L, n2);
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }
}

