/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public final class Right {
    boolean isFull;
    boolean isFullSelect;
    boolean isFullInsert;
    boolean isFullUpdate;
    boolean isFullReferences;
    boolean isFullTrigger;
    boolean isFullDelete;
    OrderedHashSet selectColumnSet;
    OrderedHashSet insertColumnSet;
    OrderedHashSet updateColumnSet;
    OrderedHashSet referencesColumnSet;
    OrderedHashSet triggerColumnSet;
    Expression selectFilter;
    Expression insertFilter;
    Expression deleteFilter;
    Expression updateFilter;
    String selectFilterSQL;
    String insertFilterSQL;
    String deleteFilterSQL;
    String updateFilterSQL;
    Right grantableRights;
    Grantee grantor;
    Grantee grantee;
    public static final OrderedHashSet emptySet = new OrderedHashSet();
    public static final Right fullRights = new Right(true);
    public static final Right noRights = new Right();
    public static final String[] privilegeNames;
    public static final int[] privilegeTypes;

    public Right() {
        this.isFull = false;
    }

    public Right(boolean bl) {
        this.isFull = bl;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public Grantee getGrantor() {
        return this.grantor;
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public Right getGrantableRights() {
        return this.grantableRights == null ? noRights : this.grantableRights;
    }

    public Right duplicate() {
        Right right = new Right();
        right.add(this);
        right.selectFilter = this.selectFilter;
        right.selectFilterSQL = this.selectFilterSQL;
        right.deleteFilter = this.deleteFilter;
        right.deleteFilterSQL = this.deleteFilterSQL;
        right.insertFilter = this.insertFilter;
        right.insertFilterSQL = this.insertFilterSQL;
        right.updateFilter = this.updateFilter;
        right.updateFilterSQL = this.updateFilterSQL;
        return right;
    }

    public void setFilterExpression(Expression expression, String string) {
        if (this.canAccess(1)) {
            this.selectFilter = expression;
            this.selectFilterSQL = string;
        }
        if (this.canAccess(2)) {
            this.deleteFilter = expression;
            this.deleteFilterSQL = string;
        }
        if (this.canAccess(4)) {
            this.insertFilter = expression;
            this.insertFilterSQL = string;
        }
        if (this.canAccess(8)) {
            this.updateFilter = expression;
            this.updateFilterSQL = string;
        }
    }

    public void setFilterExpression(int n2, Expression expression, String string) {
        switch (n2) {
            case 1: {
                this.selectFilter = expression;
                this.selectFilterSQL = string;
                break;
            }
            case 2: {
                this.deleteFilter = expression;
                this.deleteFilterSQL = string;
                break;
            }
            case 4: {
                this.insertFilter = expression;
                this.insertFilterSQL = string;
                break;
            }
            case 8: {
                this.updateFilter = expression;
                this.updateFilterSQL = string;
                break;
            }
        }
    }

    public void add(Right right) {
        if (this.isFull) {
            return;
        }
        if (right.isFull) {
            this.clear();
            this.isFull = true;
            return;
        }
        this.isFullSelect |= right.isFullSelect;
        this.isFullInsert |= right.isFullInsert;
        this.isFullUpdate |= right.isFullUpdate;
        this.isFullReferences |= right.isFullReferences;
        this.isFullDelete |= right.isFullDelete;
        if (this.isFullSelect) {
            this.selectColumnSet = null;
        } else {
            if (right.selectColumnSet != null) {
                if (this.selectColumnSet == null) {
                    this.selectColumnSet = new OrderedHashSet();
                }
                this.selectColumnSet.addAll(right.selectColumnSet);
            }
            if (right.selectFilter != null) {
                this.selectFilter = right.selectFilter;
                this.selectFilterSQL = right.selectFilterSQL;
            }
        }
        if (this.isFullInsert) {
            this.insertColumnSet = null;
        } else if (right.insertColumnSet != null) {
            if (this.insertColumnSet == null) {
                this.insertColumnSet = new OrderedHashSet();
            }
            this.insertColumnSet.addAll(right.insertColumnSet);
        }
        if (this.isFullUpdate) {
            this.updateColumnSet = null;
        } else if (right.updateColumnSet != null) {
            if (this.updateColumnSet == null) {
                this.updateColumnSet = new OrderedHashSet();
            }
            this.updateColumnSet.addAll(right.updateColumnSet);
        }
        if (this.isFullReferences) {
            this.referencesColumnSet = null;
        } else if (right.referencesColumnSet != null) {
            if (this.referencesColumnSet == null) {
                this.referencesColumnSet = new OrderedHashSet();
            }
            this.referencesColumnSet.addAll(right.referencesColumnSet);
        }
        if (this.isFullTrigger) {
            this.triggerColumnSet = null;
        } else if (right.triggerColumnSet != null) {
            if (this.triggerColumnSet == null) {
                this.triggerColumnSet = new OrderedHashSet();
            }
            this.triggerColumnSet.addAll(right.triggerColumnSet);
        }
    }

    public void remove(SchemaObject schemaObject, Right right) {
        if (right.isFull) {
            this.clear();
            return;
        }
        if (this.isFull) {
            this.isFull = false;
            this.isFullDelete = true;
            this.isFullReferences = true;
            this.isFullUpdate = true;
            this.isFullInsert = true;
            this.isFullSelect = true;
        }
        if (right.isFullDelete) {
            this.isFullDelete = false;
        }
        if (this.isFullSelect || this.selectColumnSet != null) {
            if (right.isFullSelect) {
                this.isFullSelect = false;
                this.selectColumnSet = null;
            } else if (right.selectColumnSet != null) {
                if (this.isFullSelect) {
                    this.isFullSelect = false;
                    this.selectColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.selectColumnSet.removeAll(right.selectColumnSet);
                if (this.selectColumnSet.isEmpty()) {
                    this.selectColumnSet = null;
                }
            }
        }
        if (this.isFullInsert || this.insertColumnSet != null) {
            if (right.isFullInsert) {
                this.isFullInsert = false;
                this.insertColumnSet = null;
            } else if (right.insertColumnSet != null) {
                if (this.isFullInsert) {
                    this.isFullInsert = false;
                    this.insertColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.insertColumnSet.removeAll(right.insertColumnSet);
                if (this.insertColumnSet.isEmpty()) {
                    this.insertColumnSet = null;
                }
            }
        }
        if (this.isFullUpdate || this.updateColumnSet != null) {
            if (right.isFullUpdate) {
                this.isFullUpdate = false;
                this.updateColumnSet = null;
            } else if (right.updateColumnSet != null) {
                if (this.isFullUpdate) {
                    this.isFullUpdate = false;
                    this.updateColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.updateColumnSet.removeAll(right.updateColumnSet);
                if (this.updateColumnSet.isEmpty()) {
                    this.updateColumnSet = null;
                }
            }
        }
        if (this.isFullReferences || this.referencesColumnSet != null) {
            if (right.isFullReferences) {
                this.isFullReferences = false;
                this.referencesColumnSet = null;
            } else if (right.referencesColumnSet != null) {
                if (this.isFullReferences) {
                    this.isFullReferences = false;
                    this.referencesColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.referencesColumnSet.removeAll(right.referencesColumnSet);
                if (this.referencesColumnSet.isEmpty()) {
                    this.referencesColumnSet = null;
                }
            }
        }
        if (this.isFullTrigger || this.triggerColumnSet != null) {
            if (right.isFullTrigger) {
                this.isFullTrigger = false;
                this.triggerColumnSet = null;
            } else if (right.triggerColumnSet != null) {
                if (this.isFullTrigger) {
                    this.isFullTrigger = false;
                    this.triggerColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.triggerColumnSet.removeAll(right.triggerColumnSet);
                if (this.triggerColumnSet.isEmpty()) {
                    this.triggerColumnSet = null;
                }
            }
        }
    }

    void clear() {
        this.isFullDelete = false;
        this.isFullReferences = false;
        this.isFullUpdate = false;
        this.isFullInsert = false;
        this.isFullSelect = false;
        this.isFull = false;
        this.triggerColumnSet = null;
        this.referencesColumnSet = null;
        this.updateColumnSet = null;
        this.insertColumnSet = null;
        this.selectColumnSet = null;
    }

    public boolean isEmpty() {
        if (this.isFull || this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences || this.isFullDelete) {
            return false;
        }
        if (this.selectColumnSet != null && !this.selectColumnSet.isEmpty()) {
            return false;
        }
        if (this.insertColumnSet != null && !this.insertColumnSet.isEmpty()) {
            return false;
        }
        if (this.updateColumnSet != null && !this.updateColumnSet.isEmpty()) {
            return false;
        }
        if (this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty()) {
            return false;
        }
        return this.triggerColumnSet == null || this.triggerColumnSet.isEmpty();
    }

    OrderedHashSet getColumnsForAllRights(Table table) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences) {
            return table.getColumnNameSet();
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.selectColumnSet != null) {
            orderedHashSet.addAll(this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            orderedHashSet.addAll(this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            orderedHashSet.addAll(this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            orderedHashSet.addAll(this.referencesColumnSet);
        }
        return orderedHashSet;
    }

    public boolean contains(Right right) {
        if (this.isFull) {
            return true;
        }
        if (right.isFull) {
            return false;
        }
        if (!Right.containsRights(this.isFullSelect, this.selectColumnSet, right.selectColumnSet, right.isFullSelect)) {
            return false;
        }
        if (!Right.containsRights(this.isFullInsert, this.insertColumnSet, right.insertColumnSet, right.isFullInsert)) {
            return false;
        }
        if (!Right.containsRights(this.isFullUpdate, this.updateColumnSet, right.updateColumnSet, right.isFullUpdate)) {
            return false;
        }
        if (!Right.containsRights(this.isFullReferences, this.referencesColumnSet, right.referencesColumnSet, right.isFullReferences)) {
            return false;
        }
        if (!Right.containsRights(this.isFullTrigger, this.triggerColumnSet, right.triggerColumnSet, right.isFullTrigger)) {
            return false;
        }
        return this.isFullDelete || !right.isFullDelete;
    }

    void removeDroppedColumns(OrderedHashSet orderedHashSet, Table table) {
        for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i2);
            if (table.findColumn(hsqlName.name) < 0) continue;
            orderedHashSet.remove(i2);
            --i2;
        }
    }

    public OrderedHashSet getColumnsForPrivilege(Table table, int n2) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        switch (n2) {
            case 1: {
                return this.isFullSelect ? table.getColumnNameSet() : (this.selectColumnSet == null ? emptySet : this.selectColumnSet);
            }
            case 4: {
                return this.isFullInsert ? table.getColumnNameSet() : (this.insertColumnSet == null ? emptySet : this.insertColumnSet);
            }
            case 8: {
                return this.isFullUpdate ? table.getColumnNameSet() : (this.updateColumnSet == null ? emptySet : this.updateColumnSet);
            }
            case 64: {
                return this.isFullReferences ? table.getColumnNameSet() : (this.referencesColumnSet == null ? emptySet : this.referencesColumnSet);
            }
            case 128: {
                return this.isFullTrigger ? table.getColumnNameSet() : (this.triggerColumnSet == null ? emptySet : this.triggerColumnSet);
            }
        }
        return emptySet;
    }

    static boolean containsAllColumns(OrderedHashSet orderedHashSet, Table table, boolean[] blArray) {
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            if (orderedHashSet == null) {
                return false;
            }
            if (orderedHashSet.contains(table.getColumn(i2).getName())) continue;
            return false;
        }
        return true;
    }

    static boolean containsRights(boolean bl, OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2, boolean bl2) {
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        return orderedHashSet2 == null || orderedHashSet != null && orderedHashSet.containsAll(orderedHashSet2);
    }

    boolean canSelect(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullSelect) {
            return true;
        }
        return Right.containsAllColumns(this.selectColumnSet, table, blArray);
    }

    boolean canInsert(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullInsert) {
            return true;
        }
        return Right.containsAllColumns(this.insertColumnSet, table, blArray);
    }

    boolean canUpdate(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullUpdate) {
            return true;
        }
        return Right.containsAllColumns(this.updateColumnSet, table, blArray);
    }

    boolean canReference(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullReferences) {
            return true;
        }
        return Right.containsAllColumns(this.referencesColumnSet, table, blArray);
    }

    boolean canTrigger(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullTrigger) {
            return true;
        }
        return Right.containsAllColumns(this.triggerColumnSet, table, blArray);
    }

    boolean canDelete() {
        return this.isFull || this.isFullDelete;
    }

    public boolean canAccessFully(int n2) {
        if (this.isFull) {
            return true;
        }
        switch (n2) {
            case 2: {
                return this.isFullDelete;
            }
            case 1: {
                return this.isFullSelect;
            }
            case 4: {
                return this.isFullInsert;
            }
            case 8: {
                return this.isFullUpdate;
            }
            case 64: {
                return this.isFullReferences;
            }
            case 128: {
                return this.isFullTrigger;
            }
            case 32: {
                return this.isFull;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public boolean canAccesssNonSelect() {
        if (this.isFull) {
            return true;
        }
        if (this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean bl = false;
        bl |= this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
        bl |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        bl |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        return bl |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
    }

    public boolean canAccess(int n2) {
        if (this.isFull) {
            return true;
        }
        switch (n2) {
            case 2: {
                return this.isFullDelete;
            }
            case 1: {
                if (this.isFullSelect) {
                    return true;
                }
                return this.selectColumnSet != null && !this.selectColumnSet.isEmpty();
            }
            case 4: {
                if (this.isFullInsert) {
                    return true;
                }
                return this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
            }
            case 8: {
                if (this.isFullUpdate) {
                    return true;
                }
                return this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
            }
            case 64: {
                if (this.isFullReferences) {
                    return true;
                }
                return this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
            }
            case 128: {
                if (this.isFullTrigger) {
                    return true;
                }
                return this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
            }
            case 32: {
                return this.isFull;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public boolean canAccess(Table table, int[] nArray) {
        if (this.isFull) {
            return true;
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean bl = false;
        bl |= this.selectColumnSet != null && this.insertColumnSet.isEmpty();
        bl |= this.insertColumnSet != null && this.insertColumnSet.isEmpty();
        bl |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        bl |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        if (!(bl |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty())) {
            return false;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.selectColumnSet);
        hashSet.addAll(this.insertColumnSet);
        hashSet.addAll(this.updateColumnSet);
        hashSet.addAll(this.referencesColumnSet);
        hashSet.addAll(this.triggerColumnSet);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (hashSet.contains(table.getColumn(i2).getName())) continue;
            return false;
        }
        return bl;
    }

    public Expression getFilterExpression(int n2) {
        switch (n2) {
            case 1: {
                return this.selectFilter;
            }
            case 2: {
                return this.deleteFilter;
            }
            case 4: {
                return this.insertFilter;
            }
            case 8: {
                return this.updateFilter;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public Expression[] getFiltersArray() {
        return new Expression[]{this.selectFilter, this.deleteFilter, this.insertFilter, this.updateFilter};
    }

    public boolean hasFilter() {
        return this.selectFilter != null || this.deleteFilter != null || this.insertFilter != null || this.updateFilter != null;
    }

    String getTableRightsSQL(Table table) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isFull) {
            return "ALL";
        }
        if (this.isFullSelect) {
            stringBuilder.append("SELECT");
            Right.appendFilterSQL(this.selectFilterSQL, stringBuilder);
            stringBuilder.append(',');
        } else if (this.selectColumnSet != null) {
            stringBuilder.append("SELECT");
            Right.appendColumnList(table, this.selectColumnSet, stringBuilder);
            Right.appendFilterSQL(this.selectFilterSQL, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullInsert) {
            stringBuilder.append("INSERT");
            Right.appendFilterSQL(this.insertFilterSQL, stringBuilder);
            stringBuilder.append(',');
        } else if (this.insertColumnSet != null) {
            stringBuilder.append("INSERT");
            Right.appendColumnList(table, this.insertColumnSet, stringBuilder);
            Right.appendFilterSQL(this.insertFilterSQL, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullUpdate) {
            stringBuilder.append("UPDATE");
            Right.appendFilterSQL(this.updateFilterSQL, stringBuilder);
            stringBuilder.append(',');
        } else if (this.updateColumnSet != null) {
            stringBuilder.append("UPDATE");
            Right.appendColumnList(table, this.updateColumnSet, stringBuilder);
            Right.appendFilterSQL(this.updateFilterSQL, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullDelete) {
            stringBuilder.append("DELETE");
            Right.appendFilterSQL(this.deleteFilterSQL, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullReferences) {
            stringBuilder.append("REFERENCES");
            stringBuilder.append(',');
        } else if (this.referencesColumnSet != null) {
            stringBuilder.append("REFERENCES");
            stringBuilder.append(',');
        }
        if (this.isFullTrigger) {
            stringBuilder.append("TRIGGER");
            stringBuilder.append(',');
        } else if (this.triggerColumnSet != null) {
            stringBuilder.append("TRIGGER");
            stringBuilder.append(',');
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    static void appendFilterSQL(String string, StringBuilder stringBuilder) {
        if (string == null) {
            return;
        }
        stringBuilder.append(' ');
        stringBuilder.append(string);
    }

    private static void appendColumnList(Table table, OrderedHashSet orderedHashSet, StringBuilder stringBuilder) {
        int n2;
        int n3 = 0;
        boolean[] blArray = table.getNewColumnCheckList();
        for (n2 = 0; n2 < orderedHashSet.size(); ++n2) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(n2);
            int n4 = table.findColumn(hsqlName.name);
            if (n4 == -1) continue;
            blArray[n4] = true;
            ++n3;
        }
        if (n3 == 0) {
            throw Error.runtimeError(201, "Right");
        }
        stringBuilder.append('(');
        int n5 = 0;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            stringBuilder.append(table.getColumn((int)n2).getName().statementName);
            if (++n5 >= n3) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
    }

    public void addNewColumn(HsqlNameManager.HsqlName hsqlName) {
        if (this.selectColumnSet != null) {
            this.selectColumnSet.add(hsqlName);
        }
        if (this.insertColumnSet != null) {
            this.insertColumnSet.add(hsqlName);
        }
        if (this.updateColumnSet != null) {
            this.updateColumnSet.add(hsqlName);
        }
        if (this.referencesColumnSet != null) {
            this.referencesColumnSet.add(hsqlName);
        }
        if (this.triggerColumnSet != null) {
            this.triggerColumnSet.add(hsqlName);
        }
    }

    public void setColumns(Table table) {
        if (this.selectColumnSet != null) {
            Right.setColumns(table, this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            Right.setColumns(table, this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            Right.setColumns(table, this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            Right.setColumns(table, this.referencesColumnSet);
        }
        if (this.triggerColumnSet != null) {
            Right.setColumns(table, this.triggerColumnSet);
        }
    }

    private static void setColumns(Table table, OrderedHashSet orderedHashSet) {
        int n2;
        int n3 = 0;
        boolean[] blArray = table.getNewColumnCheckList();
        for (n2 = 0; n2 < orderedHashSet.size(); ++n2) {
            String string = (String)orderedHashSet.get(n2);
            int n4 = table.findColumn(string);
            if (n4 == -1) {
                throw Error.error(5501, string);
            }
            blArray[n4] = true;
            ++n3;
        }
        if (n3 == 0) {
            throw Error.error(5501);
        }
        orderedHashSet.clear();
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            orderedHashSet.add(table.getColumn(n2).getName());
        }
    }

    public void set(int n2, OrderedHashSet orderedHashSet) {
        switch (n2) {
            case 1: {
                if (orderedHashSet == null) {
                    this.isFullSelect = true;
                }
                this.selectColumnSet = orderedHashSet;
                break;
            }
            case 2: {
                if (orderedHashSet != null) break;
                this.isFullDelete = true;
                break;
            }
            case 4: {
                if (orderedHashSet == null) {
                    this.isFullInsert = true;
                }
                this.insertColumnSet = orderedHashSet;
                break;
            }
            case 8: {
                if (orderedHashSet == null) {
                    this.isFullUpdate = true;
                }
                this.updateColumnSet = orderedHashSet;
                break;
            }
            case 64: {
                if (orderedHashSet == null) {
                    this.isFullReferences = true;
                }
                this.referencesColumnSet = orderedHashSet;
                break;
            }
            case 128: {
                if (orderedHashSet == null) {
                    this.isFullTrigger = true;
                }
                this.triggerColumnSet = orderedHashSet;
                break;
            }
        }
    }

    static {
        Right.fullRights.grantor = GranteeManager.systemAuthorisation;
        privilegeNames = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "REFERENCES", "TRIGGER"};
        privilegeTypes = new int[]{1, 4, 8, 2, 64, 128};
    }
}

