/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    byte[] byteBuffer;
    Inflater inflater;
    Deflater deflater;
    byte[] dataBuffer;
    boolean cryptLobs;
    boolean compressLobs;
    int lobBlockSize;
    int largeLobBlockSize = 524288;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getSpanningBlocks;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement createSingleLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement mergeUnusedSpace;
    Statement getLobUseLimit;
    Statement getLobCount;
    Statement getSpanningParts;
    Statement getLastPart;
    Statement createPart;
    long usageChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static final String existsBlocksSQL = "SELECT * FROM SYSTEM_LOBS.BLOCKS LIMIT 1";
    private static final String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static final String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_IDS.LOB_ID = ?";
    private static final String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOBS.LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static final String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static final String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static final String createSingleLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_SINGLE_BLOCK(?, ?, ?)";
    private static final String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static final String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = LOB_USAGE_COUNT + ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static final String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static final String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED_LOBS(?,?)";
    private static final String mergeUnusedSpaceSQL = "CALL SYSTEM_LOBS.MERGE_EMPTY_BLOCKS()";
    private static final String getLobUseLimitSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE BLOCK_ADDR = (SELECT MAX(BLOCK_ADDR) FROM SYSTEM_LOBS.LOBS)";
    private static final String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";
    private static final String getPartsSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ?  AND PART_OFFSET + PART_LENGTH > ? AND PART_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String getLastPartSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ? ORDER BY LOB_ID DESC, BLOCK_OFFSET DESC LIMIT 1";
    private static final String createPartSQL = "INSERT INTO SYSTEM_LOBS.PARTS VALUES ?,?,?,?,?,?";

    public LobManager(Database database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        OrderedHashMap orderedHashMap = LineGroupReader.getStatementMap(resourceFileName);
        String string = (String)orderedHashMap.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(string);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        this.compileStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getSpanningBlocks = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.createSingleLobPartCall = this.sysLobSession.compileStatement(createSingleLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.mergeUnusedSpace = this.sysLobSession.compileStatement(mergeUnusedSpaceSQL);
            this.getLobUseLimit = this.sysLobSession.compileStatement(getLobUseLimitSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
            this.getSpanningParts = this.sysLobSession.compileStatement(getPartsSQL);
            this.getLastPart = this.sysLobSession.compileStatement(getLastPartSQL);
            this.createPart = this.sysLobSession.compileStatement(createPartSQL);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(existsBlocksSQL);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n2 = rowSetNavigator.getSize();
        if (n2 > 0) {
            return;
        }
        statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] objectArray = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, objectArray, 0);
    }

    public void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        this.cryptLobs = this.database.logger.cryptLobs;
        this.compressLobs = this.database.logger.propCompressLobs;
        if (this.compressLobs || this.cryptLobs) {
            int n2 = this.largeLobBlockSize + 32768;
            this.inflater = new Inflater();
            this.deflater = new Deflater(1);
            this.dataBuffer = new byte[n2];
        }
        switch (this.database.getType()) {
            case DB_FILE: {
                this.lobStore = new LobStoreRAFile(this.database, this.lobBlockSize);
                if (this.database.isFilesReadOnly()) break;
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
                break;
            }
            case DB_RES: {
                this.lobStore = new LobStoreInJar(this.database, this.lobBlockSize);
                break;
            }
            case DB_MEM: {
                this.lobStore = new LobStoreMem(this.lobBlockSize);
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
            }
        }
    }

    public void close() {
        if (this.lobStore != null) {
            this.lobStore.close();
        }
        this.lobStore = null;
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private Long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.release();
            return 0L;
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        rowSetNavigator.release();
        return (Long)objectArray[0];
    }

    private Object[] getLobHeader(long l2) {
        ResultMetaData resultMetaData = this.getLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        Object[] objectArray2 = null;
        if (bl) {
            objectArray2 = rowSetNavigator.getCurrent();
        }
        rowSetNavigator.release();
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long l2) {
        this.writeLock.lock();
        try {
            BlobDataID blobDataID;
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                BlobData blobData = null;
                return blobData;
            }
            BlobDataID blobDataID2 = blobDataID = new BlobDataID(l2);
            return blobDataID2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long l2) {
        this.writeLock.lock();
        try {
            ClobDataID clobDataID;
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                ClobData clobData = null;
                return clobData;
            }
            ClobDataID clobDataID2 = clobDataID = new ClobDataID(l2);
            return clobDataID2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(Session session, long l2) {
        this.writeLock.lock();
        try {
            Long l3 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = l3;
            objectArray[1] = ValuePool.getLong(l2);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray, 0);
            long l4 = l3;
            return l4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(Session session, long l2) {
        this.writeLock.lock();
        try {
            Long l3 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = l3;
            objectArray[1] = ValuePool.getLong(l2);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray, 0);
            long l4 = l3;
            return l4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long l2) {
        this.writeLock.lock();
        try {
            ResultMetaData resultMetaData = this.deleteLobCall.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = ValuePool.getLong(l2);
            objectArray[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, objectArray, 0);
            this.usageChanged += (long)this.lobBlockSize;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getUsageChanged() {
        return this.usageChanged;
    }

    public void setUsageChanged() {
        this.usageChanged += (long)this.lobBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs() {
        this.writeLock.lock();
        try {
            long l2;
            if (this.lobStore == null || this.byteBuffer == null || this.usageChanged == 0L) {
                Result result = Result.updateZeroResult;
                return result;
            }
            long l3 = Long.MAX_VALUE;
            ResultMetaData resultMetaData = this.deleteUnusedLobs.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            int n2 = 0;
            objectArray[0] = l3;
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, objectArray, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (objectArray[1] != null && (n2 = ((Number)objectArray[1]).intValue()) < 1) {
                Result result3 = Result.updateZeroResult;
                return result3;
            }
            result = this.sysLobSession.executeCompiledStatement(this.mergeUnusedSpace, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result4 = result;
                return result4;
            }
            result = this.sysLobSession.executeCompiledStatement(this.getLobUseLimit, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result5 = result;
                return result5;
            }
            this.usageChanged = 0L;
            long l4 = 0L;
            RowSetNavigator rowSetNavigator = result.getNavigator();
            boolean bl = rowSetNavigator.next();
            if (bl) {
                Object[] objectArray2 = rowSetNavigator.getCurrent();
                if (objectArray2[0] == null || objectArray2[1] == null) {
                    Result result6 = Result.updateOneResult;
                    return result6;
                }
                l4 = (Integer)objectArray2[0] + (Integer)objectArray2[1];
                l4 *= (long)this.lobBlockSize;
            }
            if ((l2 = this.lobStore.getLength()) > l4) {
                this.database.logger.logInfoEvent("lob file truncated to usage");
                this.lobStore.setLength(l4);
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {}
            } else if (l2 < l4) {
                this.database.logger.logInfoEvent("lob file reported smaller than usage");
            }
            Result result7 = Result.newUpdateCountResult(n2);
            return result7;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long l2) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                throw Error.error(1852);
            }
            long l3 = (Long)objectArray[1];
            int n2 = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l2, l3);
            return resultLob;
        }
        catch (HsqlException hsqlException) {
            Result result = Result.newErrorResult(hsqlException);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(long l2, byte[] byArray) {
        this.writeLock.lock();
        try {
            int n2;
            Object[] objectArray = this.getLobHeader(l2);
            long l3 = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (l3 == 0L) {
                int n6 = byArray.length == 0 ? 0 : -1;
                return n6;
            }
            if (byArray.length == 0) {
                int n7 = 1;
                return n7;
            }
            do {
                n2 = nArray[n3][0] + n5;
                byte[] byArray2 = this.getLobStore().getBlockBytes(n2, 1);
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    if (n4 + i2 >= byArray.length) {
                        if (l3 == (long)byArray.length) {
                            int n8 = 0;
                            return n8;
                        }
                        int n9 = 1;
                        return n9;
                    }
                    if (byArray2[i2] == byArray[n4 + i2]) continue;
                    int n10 = (byArray2[i2] & 0xFF) > (byArray[n4 + i2] & 0xFF) ? 1 : -1;
                    return n10;
                }
                n4 += this.lobBlockSize;
                if (++n5 != nArray[n3][1]) continue;
                n5 = 0;
                ++n3;
            } while (n3 != nArray.length && n4 < byArray.length);
            if (l3 == (long)byArray.length) {
                n2 = 0;
                return n2;
            }
            n2 = l3 > (long)byArray.length ? 1 : -1;
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData blobData, BlobData blobData2) {
        if (blobData.getId() == blobData2.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n2 = this.compareBytesCompressed(blobData.getId(), blobData2.getId());
                return n2;
            }
            int n3 = this.compareBytesNormal(blobData.getId(), blobData2.getId());
            return n3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, long l2, String string) {
        this.writeLock.lock();
        try {
            int n2;
            Object[] objectArray = this.getLobHeader(l2);
            long l3 = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (l3 == 0L) {
                int n6 = string.isEmpty() ? 0 : -1;
                return n6;
            }
            if (string.isEmpty()) {
                int n7 = 1;
                return n7;
            }
            do {
                String string2;
                int n8;
                n2 = nArray[n3][0] + n5;
                byte[] byArray = this.getLobStore().getBlockBytes(n2, 1);
                long l4 = l3 - ((long)nArray[n3][2] + (long)n5) * (long)this.lobBlockSize / 2L;
                if (l4 > (long)(this.lobBlockSize / 2)) {
                    l4 = this.lobBlockSize / 2;
                }
                String string3 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l4);
                int n9 = string.length() - n4;
                if (n9 > this.lobBlockSize / 2) {
                    n9 = this.lobBlockSize / 2;
                }
                if ((n8 = collation.compare(string3, string2 = string.substring(n4, n4 + n9))) != 0) {
                    int n10 = n8;
                    return n10;
                }
                n4 += this.lobBlockSize / 2;
                if (++n5 != nArray[n3][1]) continue;
                n5 = 0;
                ++n3;
            } while (n3 != nArray.length && n4 < string.length());
            if (l3 == (long)string.length()) {
                n2 = 0;
                return n2;
            }
            n2 = l3 > (long)string.length() ? 1 : -1;
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, ClobData clobData, ClobData clobData2) {
        if (clobData.getId() == clobData2.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n2 = this.compareTextCompressed(collation, clobData.getId(), clobData2.getId());
                return n2;
            }
            int n3 = this.compareTextNormal(collation, clobData.getId(), clobData2.getId());
            return n3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int compareBytesNormal(long l2, long l3) {
        Object[] objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l3);
        long l5 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l3, 0, Integer.MAX_VALUE);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (l4 == 0L) {
            return l5 == 0L ? 0 : -1;
        }
        if (l5 == 0L) {
            return 1;
        }
        do {
            byte[] byArray;
            int n6 = nArray[n2][0] + n4;
            int n7 = nArray2[n3][0] + n5;
            byte[] byArray2 = this.getLobStore().getBlockBytes(n6, 1);
            int n8 = ArrayUtil.compare(byArray2, byArray = this.getLobStore().getBlockBytes(n7, 1));
            if (n8 != 0) {
                return n8;
            }
            ++n5;
            if (++n4 == nArray[n2][1]) {
                n4 = 0;
                ++n2;
            }
            if (n5 != nArray2[n3][1]) continue;
            n5 = 0;
            ++n3;
        } while (n2 != nArray.length && n3 != nArray2.length);
        if (l4 == l5) {
            return 0;
        }
        return l4 > l5 ? 1 : -1;
    }

    private int compareTextNormal(Collation collation, long l2, long l3) {
        Object[] objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l3);
        long l5 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l3, 0, Integer.MAX_VALUE);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (l4 == 0L) {
            return l5 == 0L ? 0 : -1;
        }
        if (l5 == 0L) {
            return 1;
        }
        do {
            String string;
            String string2;
            int n6;
            long l6;
            int n7 = nArray[n2][0] + n4;
            int n8 = nArray2[n3][0] + n5;
            byte[] byArray = this.getLobStore().getBlockBytes(n7, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n8, 1);
            long l7 = l4 - ((long)nArray[n2][2] + (long)n4) * (long)this.lobBlockSize / 2L;
            if (l7 > (long)(this.lobBlockSize / 2)) {
                l7 = this.lobBlockSize / 2;
            }
            if ((l6 = l5 - ((long)nArray2[n3][2] + (long)n5) * (long)this.lobBlockSize / 2L) > (long)(this.lobBlockSize / 2)) {
                l6 = this.lobBlockSize / 2;
            }
            if ((n6 = collation.compare(string2 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l7), string = new String(ArrayUtil.byteArrayToChars(byArray2), 0, (int)l6))) != 0) {
                return n6;
            }
            ++n5;
            if (++n4 == nArray[n2][1]) {
                n4 = 0;
                ++n2;
            }
            if (n5 != nArray2[n3][1]) continue;
            n5 = 0;
            ++n3;
        } while (n2 != nArray.length && n3 != nArray2.length);
        if (l4 == l5) {
            return 0;
        }
        return l4 > l5 ? 1 : -1;
    }

    public Result getLob(long l2, long l3, long l4) {
        if (l3 == 0L) {
            return this.createDuplicateLob(l2, l4);
        }
        throw Error.runtimeError(201, "LobManager");
    }

    public Result createDuplicateLob(long l2) {
        Result result = this.getLength(l2);
        if (result.isError()) {
            return result;
        }
        return this.createDuplicateLob(l2, ((ResultLob)result).getBlockLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result createDuplicateLob(long l2, long l3) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object object;
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            Long l4 = this.getNewLobID();
            Object[] objectArray2 = new Object[objectArray.length];
            objectArray2[0] = l4;
            objectArray2[1] = l3;
            objectArray2[2] = ValuePool.INTEGER_0;
            objectArray2[3] = objectArray[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray2, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l3 == 0L) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l4, l3);
                return resultLob;
            }
            long l5 = l3;
            int n2 = (Integer)objectArray[3];
            if (n2 == 40) {
                l5 *= 2L;
            }
            int n3 = (int)(l5 / (long)this.lobBlockSize);
            if (l5 % (long)this.lobBlockSize != 0L) {
                ++n3;
            }
            if ((result = this.createBlockAddresses(l4, 0, n3)).isError()) {
                Result result3 = result;
                return result3;
            }
            int[][] nArray = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
            int[][] nArray2 = this.getBlockAddresses(l4, 0, Integer.MAX_VALUE);
            try {
                this.copyBlockSet(nArray, nArray2);
            }
            catch (HsqlException hsqlException) {
                Result result4 = Result.newErrorResult(hsqlException);
                this.writeLock.unlock();
                return result4;
            }
            catch (Throwable throwable) {
                Result result5 = Result.newErrorResult(throwable);
                this.writeLock.unlock();
                return result5;
            }
            int n4 = (int)(l5 % (long)this.lobBlockSize);
            if (n4 != 0) {
                object = nArray2[nArray2.length - 1];
                int n5 = object[0] + object[1] - 1;
                byte[] byArray = this.getLobStore().getBlockBytes(n5, 1);
                ArrayUtil.fillArray(byArray, n4, (byte)0);
                this.getLobStore().setBlockBytes(byArray, n5, 1);
            }
            this.lobStore.synch();
            object = ResultLob.newLobSetResponse(l4, l3);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getTruncateLength(long l2) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                throw Error.error(1852);
            }
            long l3 = (Long)objectArray[1];
            int n2 = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l2, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void copyBlockSet(int[][] nArray, int[][] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            byte[] byArray = this.getLobStore().getBlockBytes(nArray[n2][0] + n4, 1);
            this.getLobStore().setBlockBytes(byArray, nArray2[n3][0] + n5, 1);
            ++n5;
            if (++n4 == nArray[n2][1]) {
                n4 = 0;
                ++n2;
            }
            if (n5 != nArray2[n3][1]) continue;
            n5 = 0;
            ++n3;
        } while (n2 != nArray.length && n3 != nArray2.length);
        this.storeModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getChars(long l2, long l3, int n2) {
        Result result;
        this.writeLock.lock();
        try {
            result = this.compressLobs || this.cryptLobs ? this.getBytesCompressed(l2, l3 * 2L, n2 * 2, true) : this.getBytesNormal(l2, l3 * 2L, n2 * 2);
        }
        finally {
            this.writeLock.unlock();
        }
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        char[] cArray = ArrayUtil.byteArrayToChars(byArray);
        return ResultLob.newLobGetCharsResponse(l2, l3, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getBytes(long l2, long l3, int n2) {
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.getBytesCompressed(l2, l3, n2, false);
                return result;
            }
            Result result = this.getBytesNormal(l2, l3, n2);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result getBytesNormal(long l2, long l3, int n2) {
        byte[] byArray;
        int n3 = (int)(l3 / (long)this.lobBlockSize);
        int n4 = (int)(l3 % (long)this.lobBlockSize);
        int n5 = (int)((l3 + (long)n2) / (long)this.lobBlockSize);
        int n6 = (int)((l3 + (long)n2) % (long)this.lobBlockSize);
        if (n6 == 0) {
            n6 = this.lobBlockSize;
        } else {
            ++n5;
        }
        if (n2 == 0) {
            return ResultLob.newLobGetBytesResponse(l2, l3, BinaryData.zeroLengthBytes);
        }
        int n7 = 0;
        byte[] byArray2 = new byte[n2];
        int[][] nArray = this.getBlockAddresses(l2, n3, n5);
        if (nArray.length == 0) {
            return Result.newErrorResult(Error.error(1852));
        }
        int n8 = 0;
        int n9 = nArray[n8][1] + nArray[n8][2] - n3;
        if (nArray[n8][1] + nArray[n8][2] > n5) {
            n9 -= nArray[n8][1] + nArray[n8][2] - n5;
        }
        try {
            byArray = this.getLobStore().getBlockBytes(nArray[n8][0] - nArray[n8][2] + n3, n9);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        int n10 = this.lobBlockSize * n9 - n4;
        if (n10 > n2) {
            n10 = n2;
        }
        System.arraycopy(byArray, n4, byArray2, n7, n10);
        n7 += n10;
        ++n8;
        while (n8 < nArray.length && n7 < n2) {
            n9 = nArray[n8][1];
            if (nArray[n8][1] + nArray[n8][2] > n5) {
                n9 -= nArray[n8][1] + nArray[n8][2] - n5;
            }
            try {
                byArray = this.getLobStore().getBlockBytes(nArray[n8][0], n9);
            }
            catch (HsqlException hsqlException) {
                return Result.newErrorResult(hsqlException);
            }
            n10 = this.lobBlockSize * n9;
            if (n10 > n2 - n7) {
                n10 = n2 - n7;
            }
            System.arraycopy(byArray, 0, byArray2, n7, n10);
            n7 += n10;
            ++n8;
        }
        return ResultLob.newLobGetBytesResponse(l2, l3, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result setBytesBA(long l2, long l3, byte[] byArray, int n2, boolean bl) {
        if (n2 == 0) {
            return ResultLob.newLobSetResponse(l2, 0L);
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.setBytesBACompressed(l2, l3, byArray, n2, bl);
                return result;
            }
            Result result = this.setBytesBANormal(l2, l3, byArray, n2);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setBytesBANormal(long l2, long l3, byte[] byArray, int n2) {
        boolean bl = false;
        int n3 = (int)(l3 / (long)this.lobBlockSize);
        int n4 = (int)(l3 % (long)this.lobBlockSize);
        int n5 = (int)((l3 + (long)n2) / (long)this.lobBlockSize);
        int n6 = (int)((l3 + (long)n2) % (long)this.lobBlockSize);
        if (n6 == 0) {
            n6 = this.lobBlockSize;
        } else {
            ++n5;
        }
        int[][] nArray = this.getBlockAddresses(l2, n3, n5);
        int n7 = n3;
        if (nArray.length > 0) {
            n7 = nArray[nArray.length - 1][2] + nArray[nArray.length - 1][1];
        }
        if (n7 < n5) {
            this.createBlockAddresses(l2, n7, n5 - n7);
            nArray = this.getBlockAddresses(l2, n3, n5);
            bl = true;
        }
        int n8 = 0;
        int n9 = n2;
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                long l4 = (long)nArray[i2][2] * (long)this.lobBlockSize;
                long l5 = (long)nArray[i2][1] * (long)this.lobBlockSize;
                long l6 = (long)nArray[i2][0] * (long)this.lobBlockSize;
                int n10 = 0;
                if (l3 > l4) {
                    l5 -= l3 - l4;
                    l6 += l3 - l4;
                }
                if ((long)n9 < l5) {
                    if (bl) {
                        n10 = (int)((l5 - (long)n9) % (long)this.lobBlockSize);
                    }
                    l5 = n9;
                }
                this.getLobStore().setBlockBytes(byArray, l6, n8, (int)l5);
                if (n10 != 0) {
                    ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                    this.getLobStore().setBlockBytes(this.byteBuffer, l6 + l5, 0, n10);
                }
                n8 = (int)((long)n8 + l5);
                n9 = (int)((long)n9 - l5);
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        this.lobStore.synch();
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l2, n2);
    }

    private Result setBytesIS(long l2, InputStream inputStream, long l3, boolean bl) {
        if (l3 == 0L) {
            return ResultLob.newLobSetResponse(l2, 0L);
        }
        if (this.compressLobs || this.cryptLobs) {
            return this.setBytesISCompressed(l2, inputStream, l3, bl);
        }
        return this.setBytesISNormal(l2, inputStream, l3);
    }

    private Result setBytesISNormal(long l2, InputStream inputStream, long l3) {
        long l4 = 0L;
        int n2 = (int)(l3 / (long)this.lobBlockSize);
        int n3 = (int)(l3 % (long)this.lobBlockSize);
        if (n3 == 0) {
            n3 = this.lobBlockSize;
        } else {
            ++n2;
        }
        Result result = this.createBlockAddresses(l2, 0, n2);
        int[][] nArray = this.getBlockAddresses(l2, 0, n2);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2][1]; ++i3) {
                int n4 = this.lobBlockSize;
                ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                if (i2 == nArray.length - 1 && i3 == nArray[i2][1] - 1) {
                    n4 = n3;
                }
                try {
                    int n5;
                    int n6 = 0;
                    while (n4 > 0 && (n5 = inputStream.read(this.byteBuffer, n6, n4)) != -1) {
                        n4 -= n5;
                        n6 += n5;
                    }
                    l4 += (long)n6;
                }
                catch (IOException iOException) {
                    return Result.newErrorResult(iOException);
                }
                try {
                    this.getLobStore().setBlockBytes(this.byteBuffer, nArray[i2][0] + i3, 1);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException);
                }
            }
        }
        this.storeModified = true;
        this.lobStore.synch();
        return ResultLob.newLobSetResponse(l2, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long l2, long l3, byte[] byArray, int n2) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l4 = (Long)objectArray[1];
            if (n2 == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l2, l4);
                return resultLob;
            }
            Result result = this.setBytesBA(l2, l3, byArray, n2, false);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l3 + (long)n2 > l4 && (result = this.setLength(l2, l4 = l3 + (long)n2)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l2, l4);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long l2, InputStream inputStream, long l3) {
        if (this.byteBuffer == null) {
            return Result.newErrorResult(Error.error(456));
        }
        this.writeLock.lock();
        try {
            Result result = this.setBytesIS(l2, inputStream, l3, false);
            Result result2 = Result.updateZeroResult;
            if (result.isError()) {
                Result result3 = result;
                return result3;
            }
            long l4 = ((ResultLob)result).getBlockLength();
            if (l4 < l3) {
                result2 = this.truncate(l2, l4);
            }
            if (result2.isError()) {
                Result result4 = result2;
                return result4;
            }
            Result result5 = result;
            return result5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long l2, long l3, char[] cArray, int n2) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l4 = (Long)objectArray[1];
            if (n2 == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l2, l4);
                return resultLob;
            }
            byte[] byArray = ArrayUtil.charArrayToBytes(cArray, n2);
            Result result = this.setBytesBA(l2, l3 * 2L, byArray, n2 * 2, true);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l3 + (long)n2 > l4 && (result = this.setLength(l2, l4 = l3 + (long)n2)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l2, l4);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long l2, InputStream inputStream, long l3) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = this.setBytesIS(l2, inputStream, l3 * 2L, false);
            if (result2.isError()) {
                Result result3 = result2;
                return result3;
            }
            long l4 = ((ResultLob)result2).getBlockLength();
            if (l4 < l3) {
                result = this.truncate(l2, l4);
            }
            result = result2;
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long l2, long l3) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l2);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long l4 = (Long)objectArray[1];
            long l5 = l3;
            if ((Integer)objectArray[3] == 40) {
                l5 *= 2L;
            }
            int n2 = (int)((l5 + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
            ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
            Object[] objectArray2 = new Object[resultMetaData.getColumnCount()];
            objectArray2[0] = ValuePool.getLong(l2);
            objectArray2[1] = n2;
            objectArray2[2] = ValuePool.INTEGER_MAX;
            objectArray2[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray2, 0);
            this.setLength(l2, l3);
            ResultLob resultLob = ResultLob.newLobTruncateResponse(l2, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setLength(long l2, long l3) {
        ResultMetaData resultMetaData = this.updateLobLength.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l3);
        objectArray[1] = ValuePool.getLong(l2);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, objectArray, 0);
        return result;
    }

    public Result adjustUsageCount(Session session, long l2, int n2) {
        ResultMetaData resultMetaData = this.updateLobUsage.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getLong(l2);
        session.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.updateLobUsage.execute(session);
        if (n2 < 0) {
            this.usageChanged += (long)this.lobBlockSize;
        }
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long l2, int n2, int n3) {
        ResultMetaData resultMetaData = this.getSpanningBlocks.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getInt(n2);
        objectArray[2] = ValuePool.getInt(n3);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getSpanningBlocks.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n4 = rowSetNavigator.getSize();
        int[][] nArray = new int[n4][3];
        for (int i2 = 0; i2 < n4; ++i2) {
            rowSetNavigator.absolute(i2);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            nArray[i2][0] = (Integer)objectArray2[0];
            nArray[i2][1] = (Integer)objectArray2[1];
            nArray[i2][2] = (Integer)objectArray2[2];
        }
        rowSetNavigator.release();
        return nArray;
    }

    private void deleteBlockAddresses(long l2, int n2, int n3) {
        ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getInt(n2);
        objectArray[2] = ValuePool.getInt(n3);
        objectArray[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray, 0);
    }

    private void divideBlockAddresses(long l2, int n2) {
        ResultMetaData resultMetaData = this.divideLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getLong(l2);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, objectArray, 0);
    }

    private Result createBlockAddresses(long l2, int n2, int n3) {
        ResultMetaData resultMetaData = this.createLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n3);
        objectArray[1] = ValuePool.getInt(n2);
        objectArray[2] = ValuePool.getLong(l2);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, objectArray, 0);
        return result;
    }

    private Result createFullBlockAddresses(long l2, int n2, int n3) {
        ResultMetaData resultMetaData = this.createSingleLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n3);
        objectArray[1] = ValuePool.getInt(n2);
        objectArray[2] = ValuePool.getLong(l2);
        Result result = this.sysLobSession.executeCompiledStatement(this.createSingleLobPartCall, objectArray, 0);
        return result;
    }

    private Result createPart(long l2, long l3, int n2, int n3, int n4, int n5) {
        ResultMetaData resultMetaData = this.createPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n5);
        objectArray[1] = ValuePool.getInt(n4);
        objectArray[2] = ValuePool.getLong(l3);
        objectArray[3] = ValuePool.getLong(n2);
        objectArray[4] = ValuePool.getLong(n3);
        objectArray[5] = ValuePool.getLong(l2);
        Result result = this.sysLobSession.executeCompiledStatement(this.createPart, objectArray, 0);
        return result;
    }

    private int getBlockAddress(int[][] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2][2] + nArray[i2][1] <= n2) continue;
            return nArray[i2][0] - nArray[i2][2] + n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        this.writeLock.lock();
        try {
            this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
            Result result = this.getLobCount.execute(this.sysLobSession);
            this.sysLobSession.sessionContext.pop();
            RowSetNavigator rowSetNavigator = result.getNavigator();
            boolean bl = rowSetNavigator.next();
            if (!bl) {
                rowSetNavigator.release();
                int n2 = 0;
                return n2;
            }
            Object[] objectArray = rowSetNavigator.getCurrent();
            int n3 = ((Number)objectArray[0]).intValue();
            return n3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.storeModified = false;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private long[][] getParts(long l2, long l3, long l4) {
        ResultMetaData resultMetaData = this.getSpanningParts.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l3);
        objectArray[2] = ValuePool.getLong(l4);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getSpanningParts.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n2 = rowSetNavigator.getSize();
        long[][] lArray = new long[n2][6];
        for (int i2 = 0; i2 < n2; ++i2) {
            rowSetNavigator.absolute(i2);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            for (int i3 = 0; i3 < lArray[i2].length; ++i3) {
                lArray[i2][i3] = ((Number)objectArray2[i3]).longValue();
            }
        }
        rowSetNavigator.release();
        return lArray;
    }

    private void inflate(byte[] byArray, int n2, boolean bl) {
        if (this.cryptLobs) {
            n2 = this.database.logger.getCrypto().decode(byArray, 0, n2, byArray, 0);
        }
        try {
            this.inflater.setInput(byArray, 0, n2);
            n2 = this.inflater.inflate(this.dataBuffer);
            this.inflater.reset();
        }
        catch (DataFormatException dataFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n3 = (int)ArrayUtil.getBinaryMultipleCeiling(n2, this.lobBlockSize);
        for (int i2 = n2; i2 < n3; ++i2) {
            this.dataBuffer[i2] = 0;
        }
    }

    private int deflate(byte[] byArray, int n2, int n3, boolean bl) {
        this.deflater.setInput(byArray, n2, n3);
        this.deflater.finish();
        n3 = this.deflater.deflate(this.dataBuffer);
        this.deflater.reset();
        if (this.cryptLobs) {
            n3 = this.database.logger.getCrypto().encode(this.dataBuffer, 0, n3, this.dataBuffer, 0);
        }
        int n4 = (int)ArrayUtil.getBinaryMultipleCeiling(n3, this.lobBlockSize);
        for (int i2 = n3; i2 < n4; ++i2) {
            this.dataBuffer[i2] = 0;
        }
        return n3;
    }

    private int compareBytesCompressed(long l2, long l3) {
        long[][] lArray = this.getParts(l2, 0L, Long.MAX_VALUE);
        long[][] lArray2 = this.getParts(l3, 0L, Long.MAX_VALUE);
        for (int i2 = 0; i2 < lArray.length && i2 < lArray2.length; ++i2) {
            int n2 = (int)lArray[i2][3];
            this.getPartBytesCompressedInBuffer(l2, lArray[i2], false);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.dataBuffer, 0, byArray, 0, n2);
            int n3 = (int)lArray2[i2][3];
            this.getPartBytesCompressedInBuffer(l2, lArray2[i2], false);
            int n4 = ArrayUtil.compare(byArray, 0, n2, this.byteBuffer, 0, n3);
            if (n4 == 0) continue;
            return n4;
        }
        if (lArray.length == lArray2.length) {
            return 0;
        }
        return lArray.length > lArray2.length ? 1 : -1;
    }

    private int compareTextCompressed(Collation collation, long l2, long l3) {
        long[][] lArray = this.getParts(l2, 0L, Long.MAX_VALUE);
        long[][] lArray2 = this.getParts(l3, 0L, Long.MAX_VALUE);
        for (int i2 = 0; i2 < lArray.length && i2 < lArray2.length; ++i2) {
            int n2 = (int)lArray[i2][3];
            this.getPartBytesCompressedInBuffer(l2, lArray[i2], true);
            String string = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, n2));
            int n3 = (int)lArray2[i2][3];
            this.getPartBytesCompressedInBuffer(l3, lArray2[i2], true);
            String string2 = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, n3));
            int n4 = collation.compare(string, string2);
            if (n4 == 0) continue;
            return n4;
        }
        if (lArray.length == lArray2.length) {
            return 0;
        }
        return lArray.length > lArray2.length ? 1 : -1;
    }

    private Result setBytesISCompressed(long l2, InputStream inputStream, long l3, boolean bl) {
        int n2;
        long l4 = 0L;
        byte[] byArray = new byte[this.largeLobBlockSize];
        do {
            int n3;
            if ((long)(n3 = byArray.length) > l3 - l4) {
                n3 = (int)(l3 - l4);
            }
            n2 = 0;
            try {
                while (n3 > 0) {
                    int n4 = inputStream.read(byArray, n2, n3);
                    if (n4 == -1) {
                        return Result.newErrorResult(new EOFException());
                    }
                    n3 -= n4;
                    n2 += n4;
                }
            }
            catch (IOException iOException) {
                return Result.newErrorResult(iOException);
            }
            Result result = this.setBytesBACompressedPart(l2, l4, byArray, n2, bl);
            if (!result.isError()) continue;
            return result;
        } while ((l4 += (long)n2) != l3);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l2, l3);
    }

    private Result setBytesBACompressed(long l2, long l3, byte[] byArray, int n2, boolean bl) {
        if (n2 == 0) {
            return ResultLob.newLobSetResponse(l2, 0L);
        }
        if (n2 <= this.largeLobBlockSize) {
            return this.setBytesBACompressedPart(l2, l3, byArray, n2, bl);
        }
        HsqlByteArrayInputStream hsqlByteArrayInputStream = new HsqlByteArrayInputStream(byArray, 0, n2);
        return this.setBytesISCompressed(l2, hsqlByteArrayInputStream, n2, bl);
    }

    private Result setBytesBACompressedPart(long l2, long l3, byte[] byArray, int n2, boolean bl) {
        long[] lArray = this.getLastPart(l2);
        int n3 = (int)lArray[1] + (int)lArray[0];
        long l4 = lArray[2] + lArray[3];
        if (l4 != l3 || l4 % (long)this.largeLobBlockSize != 0L) {
            return Result.newErrorResult(Error.error(1551, "compressed lobs"));
        }
        int n4 = this.deflate(byArray, 0, n2, bl);
        int n5 = (n4 + this.lobBlockSize - 1) / this.lobBlockSize;
        Result result = this.createFullBlockAddresses(l2, n3, n5);
        if (result.isError()) {
            return result;
        }
        result = this.createPart(l2, l3, n2, n4, n3, n5);
        if (result.isError()) {
            return result;
        }
        long l5 = (long)n3 * (long)this.lobBlockSize;
        int n6 = (int)ArrayUtil.getBinaryMultipleCeiling(n4, this.lobBlockSize);
        this.setBytesBANormal(l2, l5, this.dataBuffer, n6);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l2, n2);
    }

    private Result getBytesCompressed(long l2, long l3, int n2, boolean bl) {
        byte[] byArray = new byte[n2];
        long[][] lArray = this.getParts(l2, l3, l3 + (long)n2);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long[] lArray2 = lArray[i2];
            long l4 = lArray2[2];
            int n3 = (int)lArray2[3];
            Result result = this.getPartBytesCompressedInBuffer(l2, lArray2, bl);
            if (result.isError()) {
                return result;
            }
            ArrayUtil.copyBytes(l4, this.dataBuffer, 0, n3, l3, byArray, n2);
        }
        return ResultLob.newLobGetBytesResponse(l2, l3, byArray);
    }

    private Result getPartBytesCompressedInBuffer(long l2, long[] lArray, boolean bl) {
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        long l6 = l3 * (long)this.lobBlockSize;
        int n2 = (int)lArray[4];
        Result result = this.getBytesNormal(l2, l6, n2);
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        this.inflate(byArray, n2, bl);
        return ResultLob.newLobSetResponse(l2, l5);
    }

    private long[] getLastPart(long l2) {
        ResultMetaData resultMetaData = this.getLastPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLastPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n2 = rowSetNavigator.getSize();
        long[] lArray = new long[6];
        if (n2 == 0) {
            lArray[5] = l2;
        } else {
            rowSetNavigator.absolute(0);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = ((Number)objectArray2[i2]).longValue();
            }
        }
        rowSetNavigator.release();
        return lArray;
    }

    private static interface ALLOC_PART {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int PART_OFFSET = 2;
        public static final int PART_LENGTH = 3;
        public static final int PART_BYTES = 4;
        public static final int LOB_ID = 5;
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

