/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.TextCache;

public class Cache
extends BaseHashMap {
    private int reserveCount;
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private final BaseHashMap.BaseHashIterator objectIterator;
    private final boolean updateAccess;
    private CachedObject[] rowTable;
    private long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch shadowTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        super(dataFileCache.capacity(), 3, 0, true);
        this.maxCapacity = dataFileCache.capacity();
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
        this.objectIterator = new BaseHashMap.BaseHashIterator(true);
        this.updateAccess = dataFileCache instanceof TextCache;
        this.comparator = this.rowComparator;
        this.reserveCount = dataFileCache instanceof TextCache || dataFileCache instanceof DataFileCacheSession ? 0 : 8;
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public CachedObject get(long l2) {
        int n2 = this.getObjectLookup(l2);
        if (n2 == -1) {
            return null;
        }
        this.accessTable[n2] = this.accessCount.incrementAndGet();
        CachedObject cachedObject = (CachedObject)this.objectKeyTable[n2];
        return cachedObject;
    }

    void put(CachedObject cachedObject) {
        int n2 = cachedObject.getStorageSize();
        if (!this.preparePut(n2)) {
            long l2 = this.size() + this.reserveCount >= this.capacity ? (long)this.capacity : this.bytesCapacity / 1024L;
            throw Error.error(471, String.valueOf(l2));
        }
        this.putNoCheck(cachedObject);
    }

    void putUsingReserve(CachedObject cachedObject) {
        int n2 = cachedObject.getStorageSize();
        this.preparePut(n2);
        if (this.size() >= this.capacity) {
            throw Error.error(471, String.valueOf(this.capacity));
        }
        this.putNoCheck(cachedObject);
    }

    boolean preparePut(int n2) {
        boolean bl;
        boolean bl2 = this.size() + this.reserveCount >= this.capacity;
        boolean bl3 = bl = (long)n2 + this.cacheBytesLength > this.bytesCapacity;
        if (bl2 || bl) {
            this.cleanUp(false);
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl4 = bl = (long)n2 + this.cacheBytesLength > this.bytesCapacity;
            if (!bl2 && !bl) {
                return true;
            }
            this.clearUnchanged();
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl5 = bl = (long)n2 + this.cacheBytesLength > this.bytesCapacity;
            if (!bl2 && !bl) {
                return true;
            }
            this.cleanUp(true);
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl6 = bl = (long)n2 + this.cacheBytesLength > this.bytesCapacity;
            if (bl2) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE ROWS limit reached");
            }
            if (bl) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE SIZE limit reached");
            }
            if (bl2 || bl) {
                return false;
            }
        }
        return true;
    }

    private void putNoCheck(CachedObject cachedObject) {
        Object object = this.addOrRemoveObject(cachedObject.getPos(), cachedObject, false);
        if (object != null) {
            this.dataFileCache.logSevereEvent("existing object in Cache.put() " + cachedObject.getPos() + " " + cachedObject.getStorageSize(), null);
        }
        cachedObject.setInMemory(true);
        this.cacheBytesLength += (long)cachedObject.getStorageSize();
    }

    CachedObject release(long l2) {
        CachedObject cachedObject = (CachedObject)this.addOrRemoveObject(l2, null, true);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        cachedObject.setInMemory(false);
        return cachedObject;
    }

    public void releaseRange(IntIndex intIndex, int n2) {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)this.objectIterator.next();
            long l2 = cachedObject.getPos();
            int n3 = (int)(l2 / (long)n2);
            int n4 = intIndex.findFirstEqualKeyIndex(n3);
            if (n4 < 0) continue;
            cachedObject.setInMemory(false);
            this.objectIterator.remove();
            this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        }
    }

    public void releaseRange(long l2, long l3) {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)this.objectIterator.next();
            long l4 = cachedObject.getPos();
            if (l4 < l2 || l4 >= l3) continue;
            cachedObject.setInMemory(false);
            this.objectIterator.remove();
            this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        }
    }

    private void updateAccessCounts() {
        if (this.updateAccess) {
            for (int i2 = 0; i2 < this.objectKeyTable.length; ++i2) {
                int n2;
                CachedObject cachedObject = (CachedObject)this.objectKeyTable[i2];
                if (cachedObject == null || (n2 = cachedObject.getAccessCount()) <= this.accessTable[i2]) continue;
                this.accessTable[i2] = n2;
            }
        }
    }

    private void updateObjectAccessCounts() {
        if (this.updateAccess) {
            for (int i2 = 0; i2 < this.objectKeyTable.length; ++i2) {
                CachedObject cachedObject = (CachedObject)this.objectKeyTable[i2];
                if (cachedObject == null) continue;
                int n2 = this.accessTable[i2];
                cachedObject.updateAccessCount(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(boolean bl) {
        this.updateAccessCounts();
        if (this.accessCount.get() > 0x7FEFFFFF || this.accessCount.get() < 0) {
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        int n2 = 0;
        int n3 = this.size() / 2;
        int n4 = bl ? this.accessCount.get() + 1 : this.getAccessCountCeiling(n3, n3 / 8);
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            CachedObject cachedObject2 = cachedObject = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject2) {
                boolean bl2;
                int n5 = this.objectIterator.getAccessCount();
                boolean bl3 = n5 < n4;
                boolean bl4 = cachedObject.isNew() && cachedObject.getStorageSize() >= 4096;
                boolean bl5 = bl2 = cachedObject.hasChanged() && (bl3 || bl4);
                if (bl2) {
                    this.rowTable[n2++] = cachedObject;
                }
                if (bl3) {
                    if (cachedObject.isKeepInMemory()) {
                        this.objectIterator.setAccessCount(n4);
                    } else {
                        cachedObject.setInMemory(false);
                        this.objectIterator.remove();
                        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                    }
                }
            }
            if (n2 != this.rowTable.length) continue;
            this.saveRows(n2);
            n2 = 0;
        }
        this.saveRows(n2);
        this.setAccessCountFloor(n4);
        this.accessCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnchanged() {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            CachedObject cachedObject2 = cachedObject = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject2) {
                if (!cachedObject.isKeepInMemory() && !cachedObject.hasChanged()) {
                    cachedObject.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
        }
    }

    private void saveRows(int n2) {
        if (n2 == 0) {
            return;
        }
        this.rowComparator.setType(1);
        ArraySort.sort(this.rowTable, n2, this.rowComparator);
        this.dataFileCache.saveRows(this.rowTable, 0, n2);
        this.saveRowCount += n2;
    }

    void saveAll() {
        int n2 = 0;
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            if (n2 == this.rowTable.length) {
                this.saveRows(n2);
                n2 = 0;
            }
            if (!(cachedObject = (CachedObject)this.objectIterator.next()).hasChanged()) continue;
            this.rowTable[n2] = cachedObject;
            ++n2;
        }
        this.saveRows(n2);
    }

    void logSaveRowsEvent(int n2, long l2, long l3) {
        long l4 = this.saveAllTimer.elapsedTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cache save rows total [count,time] ");
        stringBuilder.append(this.saveRowCount + n2);
        stringBuilder.append(',').append(l4).append(' ');
        stringBuilder.append("operation [count,time,size]").append(n2).append(',');
        stringBuilder.append(l4 - l3).append(',');
        stringBuilder.append(l2).append(' ');
        stringBuilder.append("tx-ts ");
        stringBuilder.append(this.dataFileCache.database.txManager.getGlobalChangeTimestamp());
        this.dataFileCache.logDetailEvent(stringBuilder.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    public Iterator getIterator() {
        this.objectIterator.reset();
        return this.objectIterator;
    }

    protected AtomicInteger getAccessCount() {
        return this.accessCount;
    }

    static final class CachedObjectComparator
    implements Comparator<CachedObject>,
    ObjectComparator<CachedObject> {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType = 1;
        private long compareCount;

        CachedObjectComparator() {
        }

        void setType(int n2) {
            this.compareType = n2;
            this.compareCount = 0L;
        }

        @Override
        public int compare(CachedObject cachedObject, CachedObject cachedObject2) {
            long l2;
            ++this.compareCount;
            switch (this.compareType) {
                case 1: {
                    l2 = cachedObject.getPos() - cachedObject2.getPos();
                    break;
                }
                case 2: {
                    l2 = cachedObject.getStorageSize() - cachedObject2.getStorageSize();
                    break;
                }
                default: {
                    return 0;
                }
            }
            return l2 == 0L ? 0 : (l2 > 0L ? 1 : -1);
        }

        @Override
        public boolean equals(CachedObject cachedObject, CachedObject cachedObject2) {
            return this.compare(cachedObject, cachedObject2) == 0;
        }

        @Override
        public int hashCode(CachedObject cachedObject) {
            return cachedObject.hashCode();
        }

        @Override
        public long longKey(CachedObject cachedObject) {
            return cachedObject.getPos();
        }
    }
}

