/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.util.Arrays;

public class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;
    boolean modified;

    public HashIndex(int n2, int n3, boolean bl) {
        if (n3 < n2) {
            n3 = n2;
        }
        this.reset(n2, n3);
        this.fixedSize = bl;
    }

    public void reset(int n2, int n3) {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n3];
        this.hashTable = nArray;
        this.linkTable = nArray2;
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public void resetTables() {
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
        this.modified = false;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public int getLimitPointer() {
        return this.newNodePointer;
    }

    public void clear() {
        Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public int getHashIndex(int n2) {
        return (n2 & Integer.MAX_VALUE) % this.hashTable.length;
    }

    public int getLookup(int n2) {
        if (this.elementCount == 0) {
            return -1;
        }
        int n3 = (n2 & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[n3];
    }

    public int getNewNodePointer() {
        return this.newNodePointer;
    }

    public int getNextLookup(int n2) {
        return this.linkTable[n2];
    }

    public int linkNode(int n2, int n3) {
        int n4;
        int n5 = this.reclaimedNodePointer;
        if (n5 == -1) {
            n5 = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[n5];
        }
        if (n3 == -1) {
            n4 = this.hashTable[n2];
            this.hashTable[n2] = n5;
        } else {
            n4 = this.linkTable[n3];
            this.linkTable[n3] = n5;
        }
        this.linkTable[n5] = n4;
        ++this.elementCount;
        this.modified = true;
        return n5;
    }

    public void unlinkNode(int n2, int n3, int n4) {
        if (n3 == -1) {
            this.hashTable[n2] = this.linkTable[n4];
        } else {
            this.linkTable[n3] = this.linkTable[n4];
        }
        this.linkTable[n4] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = n4;
        --this.elementCount;
        if (this.elementCount == 0) {
            Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
            this.resetTables();
        }
    }

    public boolean removeEmptyNode(int n2) {
        boolean bl = false;
        int n3 = -1;
        int n4 = this.reclaimedNodePointer;
        while (n4 >= 0) {
            if (n4 == n2) {
                if (n3 == -1) {
                    this.reclaimedNodePointer = this.linkTable[n2];
                } else {
                    this.linkTable[n3] = this.linkTable[n2];
                }
                bl = true;
                break;
            }
            n3 = n4;
            n4 = this.linkTable[n4];
        }
        if (!bl) {
            return false;
        }
        for (n4 = 0; n4 < this.newNodePointer; ++n4) {
            if (this.linkTable[n4] <= n2) continue;
            int n5 = n4;
            this.linkTable[n5] = this.linkTable[n5] - 1;
        }
        System.arraycopy(this.linkTable, n2 + 1, this.linkTable, n2, this.newNodePointer - n2 - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (n4 = 0; n4 < this.hashTable.length; ++n4) {
            if (this.hashTable[n4] <= n2) continue;
            int n6 = n4;
            this.hashTable[n6] = this.hashTable[n6] - 1;
        }
        return true;
    }

    public boolean insertEmptyNode(int n2) {
        int n3;
        for (n3 = 0; n3 < this.newNodePointer; ++n3) {
            if (this.linkTable[n3] < n2) continue;
            int n4 = n3;
            this.linkTable[n4] = this.linkTable[n4] + 1;
        }
        for (n3 = 0; n3 < this.hashTable.length; ++n3) {
            if (this.hashTable[n3] < n2) continue;
            int n5 = n3;
            this.hashTable[n5] = this.hashTable[n5] + 1;
        }
        System.arraycopy(this.linkTable, n2, this.linkTable, n2 + 1, this.newNodePointer - n2);
        ++this.newNodePointer;
        if (this.reclaimedNodePointer >= n2) {
            // empty if block
        }
        this.linkTable[n2] = ++this.reclaimedNodePointer;
        this.reclaimedNodePointer = n2;
        return true;
    }

    public HashIndex clone() {
        HashIndex hashIndex = null;
        try {
            hashIndex = (HashIndex)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashIndex.hashTable = (int[])this.hashTable.clone();
        hashIndex.linkTable = (int[])this.linkTable.clone();
        return hashIndex;
    }
}

