/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.util.Arrays;

public class BitMap {
    private boolean canChangeSize;
    private int initialSize;
    private int[] map;
    private int limitPos;

    public BitMap(int n2, boolean bl) {
        int n3 = n2 / 32;
        if (n2 == 0 || n2 % 32 != 0) {
            ++n3;
        }
        this.map = new int[n3];
        this.canChangeSize = bl;
        this.limitPos = n2;
        this.initialSize = n2;
    }

    public BitMap(int[] nArray) {
        this.map = nArray;
        this.limitPos = this.initialSize = nArray.length * 32;
        this.canChangeSize = false;
    }

    public BitMap duplicate() {
        BitMap bitMap = new BitMap(Arrays.copyOf(this.map, this.map.length));
        bitMap.canChangeSize = this.canChangeSize;
        bitMap.initialSize = this.initialSize;
        bitMap.limitPos = this.limitPos;
        return bitMap;
    }

    public int size() {
        return this.limitPos;
    }

    public void setSize(int n2) {
        if (!this.canChangeSize) {
            throw new UnsupportedOperationException("BitMap");
        }
        this.ensureCapacity(n2);
        if (this.limitPos > n2) {
            this.unsetRange(n2, this.limitPos - n2);
            this.limitPos = n2;
        }
    }

    public void reset() {
        Arrays.fill(this.map, 0);
        this.limitPos = this.initialSize;
    }

    public int countSetMatches(BitMap bitMap) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.map.length; ++i2) {
            int n3 = this.map[i2] & bitMap.map[i2];
            if (n3 == 0) continue;
            n2 += Integer.bitCount(n3);
        }
        return n2;
    }

    public int setRange(int n2, int n3) {
        return this.setOrUnsetRange(n2, n3, true);
    }

    public int unsetRange(int n2, int n3) {
        return this.setOrUnsetRange(n2, n3, false);
    }

    private int setOrUnsetRange(int n2, int n3, boolean bl) {
        if (n3 == 0) {
            return 0;
        }
        this.ensureCapacity(n2 + n3);
        int n4 = n2 >> 5;
        int n5 = n2 + n3 - 1 >> 5;
        int n6 = -1 >>> (n2 & 0x1F);
        int n7 = Integer.MIN_VALUE >> (n2 + n3 - 1 & 0x1F);
        if (n4 == n5) {
            n6 &= n7;
        }
        int n8 = this.map[n4];
        int n9 = Integer.bitCount(n8 & n6);
        this.map[n4] = bl ? n8 | n6 : n8 & (n6 ^= 0xFFFFFFFF);
        if (n4 != n5) {
            n8 = this.map[n5];
            n9 += Integer.bitCount(n8 & n7);
            this.map[n5] = bl ? n8 | n7 : n8 & (n7 ^= 0xFFFFFFFF);
            for (int i2 = n4 + 1; i2 < n5; ++i2) {
                n9 += Integer.bitCount(this.map[i2]);
                this.map[i2] = bl ? -1 : 0;
            }
        }
        return bl ? n3 - n9 : n9;
    }

    public int setValue(int n2, boolean bl) {
        return bl ? this.set(n2) : this.unset(n2);
    }

    public int set(int n2) {
        this.ensureCapacity(n2 + 1);
        int n3 = n2 >> 5;
        int n4 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        int n5 = this.map[n3];
        int n6 = (n5 & n4) == 0 ? 0 : 1;
        this.map[n3] = n5 | n4;
        return n6;
    }

    public int unset(int n2) {
        this.ensureCapacity(n2 + 1);
        int n3 = n2 >> 5;
        int n4 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        int n5 = this.map[n3];
        int n6 = (n5 & n4) == 0 ? 0 : 1;
        this.map[n3] = n5 & (n4 ^= 0xFFFFFFFF);
        return n6;
    }

    public int get(int n2) {
        if (n2 >= this.limitPos) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n2 >> 5;
        int n4 = this.map[n3];
        if (n4 == 0) {
            return 0;
        }
        if (n4 == -1) {
            return 1;
        }
        int n5 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        return (n4 & n5) == 0 ? 0 : 1;
    }

    public boolean isSet(int n2) {
        return this.get(n2) == 1;
    }

    public void set(BitMap bitMap) {
        int n2 = 0;
        while (n2 < this.map.length) {
            int n3 = bitMap.map[n2];
            int n4 = n2++;
            this.map[n4] = this.map[n4] | n3;
        }
    }

    public int countSet(int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (!this.isSet(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public int countSetBits() {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.limitPos / 32; ++n3) {
            n2 = this.map[n3];
            if (n2 == 0) continue;
            if (n2 == -1) {
                n4 += 32;
                continue;
            }
            n4 += Integer.bitCount(n2);
        }
        if (this.limitPos % 32 != 0) {
            n3 = Integer.MIN_VALUE >> (this.limitPos - 1 & 0x1F);
            n2 = this.map[this.limitPos / 32] & n3;
            n4 += Integer.bitCount(n2);
        }
        return n4;
    }

    public int countSetBitsEnd() {
        int n2 = 0;
        for (int i2 = this.limitPos / 32 - 1; i2 >= 0; --i2) {
            if (this.map[i2] == -1) {
                n2 += 32;
                continue;
            }
            int n3 = BitMap.countSetBitsEnd(this.map[i2]);
            n2 += n3;
            break;
        }
        return n2;
    }

    public int[] getIntArray() {
        return this.map;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[(this.limitPos + 7) / 8];
        if (byArray.length == 0) {
            return byArray;
        }
        int n2 = 0;
        do {
            int n3 = this.map[n2 / 4];
            byArray[n2++] = (byte)(n3 >>> 24);
            if (n2 == byArray.length) break;
            byArray[n2++] = (byte)(n3 >>> 16);
            if (n2 == byArray.length) break;
            byArray[n2++] = (byte)(n3 >>> 8);
            if (n2 == byArray.length) break;
            byArray[n2++] = (byte)n3;
        } while (n2 != byArray.length);
        return byArray;
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.limitPos && !this.canChangeSize) {
            throw new ArrayStoreException("BitMap extend");
        }
        if (n2 <= this.map.length * 32) {
            if (n2 > this.limitPos) {
                this.limitPos = n2;
            }
            return;
        }
        int n3 = this.map.length;
        while (n2 > n3 * 32) {
            n3 *= 2;
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.map, 0, nArray, 0, this.map.length);
        this.map = nArray;
        this.limitPos = n2;
    }

    public static int countSetBitsEnd(int n2) {
        int n3;
        int n4 = 1;
        for (n3 = 0; n3 < 32 && (n2 & n4) != 0; ++n3) {
            n2 >>= 1;
        }
        return n3;
    }

    public static int countUnsetBitsStart(int n2) {
        int n3;
        int n4 = Integer.MIN_VALUE;
        if (n2 == 0) {
            return 32;
        }
        for (n3 = 0; n3 < 32 && (n2 & n4) == 0; ++n3) {
            n4 >>>= 1;
        }
        return n3;
    }

    public static int setByte(int n2, byte by, int n3) {
        int n4 = (by & 0xFF) << 24 - n3;
        int n5 = -16777216 >>> n3;
        return (n2 &= (n5 ^= 0xFFFFFFFF)) | n4;
    }

    public static int set(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return n2 | n4;
    }

    public static byte set(byte by, int n2) {
        int n3 = 128 >>> n2;
        return (byte)(by | n3);
    }

    public static int unset(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return n2 & (n4 ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return (n2 & n4) != 0;
    }

    public static boolean isSet(byte by, int n2) {
        int n3 = 128 >>> n2;
        return (by & n3) != 0;
    }

    public static boolean isSet(byte[] byArray, int n2) {
        int n3 = 128 >>> (n2 & 7);
        int n4 = n2 / 8;
        if (n4 >= byArray.length) {
            return false;
        }
        byte by = byArray[n4];
        return (by & n3) != 0;
    }

    public static void unset(byte[] byArray, int n2) {
        int n3 = 128 >>> (n2 & 7);
        n3 ^= 0xFFFFFFFF;
        int n4 = n2 / 8;
        if (n4 >= byArray.length) {
            return;
        }
        byte by = byArray[n4];
        byArray[n4] = (byte)(by & n3);
    }

    public static void set(byte[] byArray, int n2) {
        int n3 = 128 >>> (n2 & 7);
        int n4 = n2 / 8;
        if (n4 >= byArray.length) {
            return;
        }
        byte by = byArray[n4];
        byArray[n4] = (byte)(by | n3);
    }

    public static void and(byte[] byArray, int n2, byte by, int n3) {
        int n4 = n2 & 7;
        int n5 = (by & 0xFF) >>> n4;
        int n6 = 255 >> n4;
        int n7 = n2 / 8;
        if (n3 < 8) {
            n6 >>>= 8 - n3;
            n6 <<= 8 - n3;
        }
        n5 &= n6;
        n6 ^= 0xFFFFFFFF;
        if (n7 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n7];
        byArray[n7] = (byte)(by2 & n6);
        by2 = (byte)(by2 & n5);
        byArray[n7] = (byte)(byArray[n7] | by2);
        if (n4 == 0) {
            return;
        }
        if (n3 > (n4 = 8 - n4)) {
            n5 = (by & 0xFF) << 8 >>> n4;
            n6 = 65280 >>> n4;
            by2 = byArray[n7 + 1];
            byArray[n7 + 1] = (byte)(by2 & (n6 ^= 0xFFFFFFFF));
            by2 = (byte)(by2 & n5);
            byArray[n7 + 1] = (byte)(byArray[n7 + 1] | by2);
        }
    }

    public static void or(byte[] byArray, int n2, byte by, int n3) {
        byte by2;
        int n4 = n2 & 7;
        int n5 = (by & 0xFF) >>> n4;
        int n6 = n2 / 8;
        if (n6 >= byArray.length) {
            return;
        }
        byArray[n6] = by2 = (byte)(byArray[n6] | n5);
        if (n4 == 0) {
            return;
        }
        if (n3 > (n4 = 8 - n4)) {
            n5 = (by & 0xFF) << 8 >>> n4;
            byArray[n6 + 1] = by2 = (byte)(byArray[n6 + 1] | n5);
        }
    }

    public static void overlay(byte[] byArray, int n2, byte by, int n3) {
        int n4 = n2 & 7;
        int n5 = (by & 0xFF) >>> n4;
        int n6 = 255 >> n4;
        int n7 = n2 / 8;
        if (n3 < 8) {
            n6 >>>= 8 - n3;
            n6 <<= 8 - n3;
        }
        n5 &= n6;
        n6 ^= 0xFFFFFFFF;
        if (n7 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n7];
        by2 = (byte)(by2 & n6);
        byArray[n7] = (byte)(by2 | n5);
        if (n4 == 0) {
            return;
        }
        if (n3 > (n4 = 8 - n4)) {
            n5 = (by & 0xFF) << 8 >>> n4;
            n6 = 65280 >>> n4;
            by2 = byArray[n7 + 1];
            by2 = (byte)(by2 & (n6 ^= 0xFFFFFFFF));
            byArray[n7 + 1] = (byte)(by2 | n5);
        }
    }

    public static byte[] and(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] & byArray2[i2]);
        }
        return byArray3;
    }

    public static byte[] or(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n2];
        if (n2 != n3) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n3, byArray3, n3, n2 - n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] | byArray2[i2]);
        }
        return byArray3;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n2];
        if (n2 != n3) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n3, byArray3, n3, n2 - n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        return byArray3;
    }

    public static byte[] not(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = ~byArray[i2];
        }
        return byArray2;
    }

    public static boolean hasAnyBitSet(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] leftShift(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[byArray.length];
        int n3 = n2 / 8;
        if (n3 >= byArray.length) {
            return byArray2;
        }
        if ((n2 %= 8) == 0) {
            int n4 = 0;
            for (int i2 = n3; i2 < byArray.length; ++i2) {
                byArray2[n4] = byArray[i2];
                ++n4;
            }
        } else {
            int n5 = 0;
            for (int i3 = n3; i3 < byArray.length; ++i3) {
                int n6 = (byArray[i3] & 0xFF) << n2;
                byArray2[n5] = (byte)n6;
                if (n5 > 0) {
                    int n7 = n5 - 1;
                    byArray2[n7] = (byte)(byArray2[n7] | (byte)(n6 >>> 8));
                }
                ++n5;
            }
        }
        return byArray2;
    }
}

