/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Map;

public class OrderedIntKeyHashMap<V>
extends IntKeyHashMap<V>
implements Map<Integer, V> {
    public OrderedIntKeyHashMap() {
        this(8);
    }

    public OrderedIntKeyHashMap(int n2) throws IllegalArgumentException {
        super(n2);
        this.isList = true;
    }

    public int getKeyAt(int n2, int n3) {
        if (n2 >= 0 && n2 < this.size()) {
            return this.intKeyTable[n2];
        }
        return n3;
    }

    public Object getValueAt(int n2) {
        this.checkRange(n2);
        return this.objectValueTable[n2];
    }

    public Object setValueAt(int n2, Object object) {
        this.checkRange(n2);
        Object object2 = this.objectValueTable[n2];
        this.objectValueTable[n2] = object;
        return object2;
    }

    public boolean set(int n2, int n3, V v) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        if (this.keySet().contains(n3) && this.getIndex(n3) != n2) {
            return false;
        }
        super.remove(this.intKeyTable[n2], 0L, null, null, false, false);
        this.put(n3, v);
        return true;
    }

    public boolean insert(int n2, int n3, V v) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = this.getLookup(n3);
        if (n4 >= 0) {
            return false;
        }
        if (n2 < this.size()) {
            super.insertRow(n2);
        }
        super.put(n3, v);
        return true;
    }

    public boolean setKeyAt(int n2, int n3) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object = this.objectValueTable[n2];
        return this.set(n2, n3, object);
    }

    public int getIndex(int n2) {
        return this.getLookup(n2);
    }

    @Override
    public V remove(int n2) {
        return (V)super.remove(n2, 0L, null, null, false, true);
    }

    public void removeEntry(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        int n3 = this.intKeyTable[n2];
        super.remove(n3, 0L, null, null, false, true);
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

