/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class MultiValueHashMap<K, V>
extends BaseHashMap
implements Map<K, V> {
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entries;

    public MultiValueHashMap() {
        this(8);
    }

    public MultiValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 3, 3, false);
        this.isMultiValue = true;
    }

    public MultiValueHashMap(int n2, ObjectComparator objectComparator) throws IllegalArgumentException {
        this(n2);
        this.comparator = objectComparator;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.comparator.hashCode(object);
        int n3 = this.getLookup(object, n2);
        if (n3 != -1) {
            return (V)this.objectValueTable[n3];
        }
        return null;
    }

    public Iterator<V> getValuesIterator(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.getMultiValuesIterator(object);
    }

    @Override
    public V put(K k2, V v) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        boolean bl = super.addMultiVal(0L, 0L, k2, v);
        return bl ? null : (V)v;
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.removeMultiVal(0L, 0L, object, null, false);
    }

    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object3 = super.removeMultiVal(0L, 0L, object, object2, true);
        return object3 != null;
    }

    public int valueCount(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.comparator.hashCode(object);
        return super.multiValueElementCount(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            this.put(e2, map.get(e2));
        }
    }

    @Override
    public void putAll(MultiValueHashMap<K, V> multiValueHashMap) {
        Iterator iterator = multiValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Iterator<V> iterator2 = multiValueHashMap.getValuesIterator(e2);
            while (iterator2.hasNext()) {
                V v = iterator2.next();
                this.put(e2, v);
            }
        }
    }

    public <T> T[] keysToArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            MultiValueHashMap multiValueHashMap = MultiValueHashMap.this;
            multiValueHashMap.getClass();
            return multiValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return MultiValueHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MultiValueHashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new BaseHashMap.MultiValueKeyIterator();
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.multiValueKeyCount();
        }

        @Override
        public boolean contains(Object object) {
            return MultiValueHashMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return MultiValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MultiValueHashMap.this.multiValueKeysToArray(TArray);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<K, V> next() {
            Object object = super.next();
            Object object2 = MultiValueHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Object, Object>(object, object2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

