/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyLongValueHashMap
extends BaseHashMap
implements Map<Long, Long> {
    private Set<Long> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Long, Long>> entries;

    public LongKeyLongValueHashMap() {
        this(8);
    }

    public LongKeyLongValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 2, 2, false);
    }

    public LongKeyLongValueHashMap(boolean bl) {
        this(8);
        this.minimizeOnEmpty = bl;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return super.containsKey(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long l2) {
        return super.containsKey(l2);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return super.containsValue(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(long l2) {
        return super.containsValue(l2);
    }

    @Override
    public Long get(Object object) {
        if (object instanceof Long) {
            long l2 = ((Long)object).intValue();
            try {
                long l3 = this.get(l2);
                return l3;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public long get(long l2) throws NoSuchElementException {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public long get(long l2, long l3) {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        return l3;
    }

    public boolean get(long l2, long[] lArray) {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            lArray[0] = this.longValueTable[n2];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Long l2, Long l3) {
        if (l2 == null || l3 == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.addOrUpdate(l2, l3, null, null);
        if (n2 == this.size()) {
            return null;
        }
        return l3;
    }

    @Override
    public boolean put(long l2, long l3) {
        int n2 = this.size();
        super.addOrUpdate(l2, l3, null, null);
        return n2 != this.size();
    }

    @Override
    public Long remove(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return (Long)super.remove(l2, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long l2) {
        Long l3 = (Long)super.remove(l2, 0L, null, null, false, false);
        return l3 != null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            long l3 = l2;
            Long l4 = map.get(l2);
            long l5 = l4;
            this.put(l3, l5);
        }
    }

    public void putAll(IntKeyIntValueHashMap intKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            long l2 = primitiveIterator.nextLong();
            int n2 = intKeyIntValueHashMap.get(l2);
            this.put(l2, n2);
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public long[] valuesToArray(long[] lArray) {
        return this.toLongArray(lArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values<Long>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Long>
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return longKeyLongValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return longKeyLongValueHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<Long, Long> next() {
            Long l2 = super.nextLong();
            Long l3 = LongKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Long, Long>(l2, l3);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Long>>
    implements Set<Map.Entry<Long, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

