/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.lib.InputStreamInterface;

public class InputStreamWrapper
implements InputStreamInterface {
    InputStream is;
    long limitSize = -1L;
    long fetchedSize = 0L;

    public InputStreamWrapper(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        int n2 = this.is.read();
        if (n2 < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        ++this.fetchedSize;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)n3) {
            n3 = (int)(this.limitSize - this.fetchedSize);
        }
        if ((n4 = this.is.read(byArray, n2, n3)) < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        this.fetchedSize += (long)n4;
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.is.skip(l2);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void setSizeLimit(long l2) {
        this.limitSize = l2;
    }

    @Override
    public long getSizeLimit() {
        return this.limitSize;
    }
}

