/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Comparator;
import java.util.Date;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.ThreadFactory;

public final class HsqlTimer
implements Comparator,
ThreadFactory {
    protected final TaskQueue taskQueue = new TaskQueue(16, (Comparator)this);
    protected final TaskRunner taskRunner = new TaskRunner();
    protected Thread taskRunnerThread;
    protected final ThreadFactory threadFactory;
    protected volatile boolean isShutdown;
    static int nowCount = 0;

    public HsqlTimer() {
        this(null);
    }

    public HsqlTimer(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory == null ? this : threadFactory;
    }

    public int compare(Object object, Object object2) {
        long l2;
        long l3 = ((Task)object).getNextScheduled();
        return l3 < (l2 = ((Task)object2).getNextScheduled()) ? -1 : (l3 == l2 ? 0 : 1);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("HSQLDB Timer @" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        return thread;
    }

    public synchronized Thread getThread() {
        return this.taskRunnerThread;
    }

    public synchronized void restart() throws IllegalStateException {
        if (this.isShutdown) {
            throw new IllegalStateException("isShutdown==true");
        }
        if (this.taskRunnerThread == null) {
            this.taskRunnerThread = this.threadFactory.newThread(this.taskRunner);
            this.taskRunnerThread.start();
        } else {
            this.taskQueue.unpark();
        }
    }

    public Object scheduleAfter(long l2, Runnable runnable) throws IllegalArgumentException {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + l2, runnable, 0L, false);
    }

    public Object scheduleAt(Date date, Runnable runnable) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, 0L, false);
    }

    public Object schedulePeriodicallyAt(Date date, long l2, Runnable runnable, boolean bl) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, l2, bl);
    }

    public Object schedulePeriodicallyAfter(long l2, long l3, Runnable runnable, boolean bl) throws IllegalArgumentException {
        if (l3 <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + l2, runnable, l3, bl);
    }

    public synchronized void shutdown() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.taskQueue.cancelAllTasks();
        }
    }

    public synchronized void shutDown() {
        this.shutdown();
    }

    public synchronized void shutdownImmediately() {
        if (!this.isShutdown) {
            Thread thread = this.taskRunnerThread;
            this.isShutdown = true;
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
            }
            this.taskQueue.cancelAllTasks();
        }
    }

    public static void cancel(Object object) {
        if (object instanceof Task) {
            ((Task)object).cancel();
        }
    }

    public static boolean isCancelled(Object object) {
        return object instanceof Task ? ((Task)object).isCancelled() : true;
    }

    public static boolean isFixedRate(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            return task.relative && task.period > 0L;
        }
        return false;
    }

    public static boolean isFixedDelay(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            return !task.relative && task.period > 0L;
        }
        return false;
    }

    public static boolean isPeriodic(Object object) {
        return object instanceof Task ? ((Task)object).period > 0L : false;
    }

    public static Date getLastScheduled(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            long l2 = task.getLastScheduled();
            return l2 == 0L ? null : new Date(l2);
        }
        return null;
    }

    public static Object setPeriod(Object object, long l2) {
        return object instanceof Task ? ((Task)object).setPeriod(l2) : object;
    }

    public static Date getNextScheduled(Object object) {
        if (object instanceof Task) {
            Task task = (Task)object;
            long l2 = task.isCancelled() ? 0L : task.getNextScheduled();
            return l2 == 0L ? null : new Date(l2);
        }
        return null;
    }

    protected Task addTask(long l2, Runnable runnable, long l3, boolean bl) {
        if (this.isShutdown) {
            throw new IllegalStateException("shutdown");
        }
        Task task = new Task(l2, runnable, l3, bl);
        this.taskQueue.addTask(task);
        this.restart();
        return task;
    }

    protected synchronized void clearThread() {
        try {
            this.taskRunnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.taskRunnerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task nextTask() {
        try {
            while (!this.isShutdown || Thread.interrupted()) {
                long l2;
                long l3;
                Task task;
                TaskQueue taskQueue = this.taskQueue;
                synchronized (taskQueue) {
                    task = this.taskQueue.peekTask();
                    if (task == null) {
                        break;
                    }
                    l3 = task.next;
                    l2 = System.currentTimeMillis();
                    long l4 = l3 - l2;
                    if (l4 > 0L) {
                        this.taskQueue.park(l4);
                        continue;
                    }
                    this.taskQueue.removeTask();
                }
                long l5 = task.period;
                if (l5 > 0L) {
                    if (task.relative) {
                        long l6 = l2 - l3;
                        if (l6 > l5) {
                            l5 = 0L;
                        } else if (l6 > 0L) {
                            l5 -= l6;
                        }
                    }
                    task.updateSchedule(l2, l2 + l5);
                    this.taskQueue.addTask(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    static long now() {
        ++nowCount;
        return System.currentTimeMillis();
    }

    protected static class TaskQueue
    extends HsqlArrayHeap {
        TaskQueue(int n2, Comparator comparator) {
            super(n2, comparator);
        }

        void addTask(Task task) {
            super.add(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAllTasks() {
            int n2;
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                Object[] objectArray = this.heap;
                n2 = this.count;
                this.heap = new Object[1];
                this.count = 0;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Task)objectArray[i2]).cancelled = true;
            }
        }

        synchronized void park(long l2) throws InterruptedException {
            this.wait(l2);
        }

        synchronized Task peekTask() {
            while (this.heap[0] != null && ((Task)this.heap[0]).isCancelled()) {
                super.remove();
            }
            return (Task)this.heap[0];
        }

        synchronized void signalTaskCancelled(Task task) {
            if (task == this.heap[0]) {
                super.remove();
                this.notify();
            }
        }

        Task removeTask() {
            return (Task)super.remove();
        }

        synchronized void unpark() {
            this.notify();
        }
    }

    protected class Task {
        Runnable runnable;
        long period;
        long last;
        long next;
        boolean cancelled = false;
        private final Object cancel_mutex = new Object();
        final boolean relative;

        Task(long l2, Runnable runnable, long l3, boolean bl) {
            this.next = l2;
            this.runnable = runnable;
            this.period = l3;
            this.relative = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean bl = false;
            Object object = this.cancel_mutex;
            synchronized (object) {
                if (!this.cancelled) {
                    bl = true;
                    this.cancelled = true;
                }
            }
            if (bl) {
                HsqlTimer.this.taskQueue.signalTaskCancelled(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCancelled() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                return this.cancelled;
            }
        }

        synchronized long getLastScheduled() {
            return this.last;
        }

        synchronized long getNextScheduled() {
            return this.next;
        }

        synchronized void updateSchedule(long l2, long l3) {
            this.last = l2;
            this.next = l3;
        }

        synchronized Object setPeriod(long l2) {
            if (this.period == l2 || this.isCancelled()) {
                return this;
            }
            if (l2 > this.period) {
                this.period = l2;
                return this;
            }
            this.cancel();
            return HsqlTimer.this.addTask(HsqlTimer.now(), this.runnable, l2, this.relative);
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Task task;
                while ((task = HsqlTimer.this.nextTask()) != null) {
                    task.runnable.run();
                }
            }
            finally {
                HsqlTimer.this.clearThread();
            }
        }
    }
}

