/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayInputStream
extends InputStream
implements DataInput {
    protected byte[] buffer;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public HsqlByteArrayInputStream(byte[] byArray) {
        this.buffer = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public HsqlByteArrayInputStream(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, byArray.length);
        this.mark = n2;
    }

    public final long getPos() {
        return this.pos;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = this.read(byArray, n2 + i2, n3 - i2);
            if (n4 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public short readShort() throws IOException {
        if (this.count - this.pos < 2) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n2 = this.buffer[this.pos++] & 0xFF;
        int n3 = this.buffer[this.pos++] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    @Override
    public char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + n2);
    }

    @Override
    public int readInt() throws IOException {
        if (this.count - this.pos < 4) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n2 = this.buffer[this.pos++] & 0xFF;
        int n3 = this.buffer[this.pos++] & 0xFF;
        int n4 = this.buffer[this.pos++] & 0xFF;
        int n5 = this.buffer[this.pos++] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int skipBytes(int n2) {
        return (int)this.skip(n2);
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        int n2 = this.readUnsignedShort();
        if (this.pos + n2 >= this.count) {
            throw new EOFException();
        }
        String string = StringConverter.readUTF(this.buffer, this.pos, n2);
        this.pos += n2;
        return string;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n3 > this.count) {
            n3 = this.count - this.pos;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.pos, byArray, n2, n3);
        this.pos += n3;
        return n3;
    }

    @Override
    public long skip(long l2) {
        if ((long)this.pos + l2 > (long)this.count) {
            l2 = this.count - this.pos;
        }
        if (l2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }
}

