/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashMap<K, V>
extends BaseHashMap
implements Map<K, V> {
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entries;

    public HashMap() {
        this(8);
    }

    public HashMap(int n2) throws IllegalArgumentException {
        super(n2, 3, 3, false);
    }

    public HashMap(int n2, ObjectComparator objectComparator) throws IllegalArgumentException {
        this(n2);
        this.comparator = objectComparator;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.comparator.hashCode(object);
        int n3 = this.getLookup(object, n2);
        if (n3 != -1) {
            return (V)this.objectValueTable[n3];
        }
        return null;
    }

    @Override
    public V put(K k2, V v) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        return (V)super.addOrUpdate(0L, 0L, k2, v);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.remove(0L, 0L, object, null, false, false);
    }

    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object3 = super.remove(0L, 0L, object, object2, true, false);
        return object3 != null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            this.put(e2, map.get(e2));
        }
    }

    public <T> T[] keysToArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return hashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return HashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return hashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return HashMap.this.toArray(TArray, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<K, V> next() {
            Object object = super.next();
            Object object2 = HashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Object, Object>(object, object2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

