/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;

public final class CountdownInputStream
extends InputStream {
    private long m_count;
    private InputStream m_input;

    public CountdownInputStream(InputStream inputStream) {
        this.m_input = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.m_count <= 0L) {
            return -1;
        }
        int n2 = this.m_input.read();
        if (n2 >= 0) {
            --this.m_count;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        int n3 = byArray.length;
        if ((long)n3 > this.m_count) {
            n3 = (int)this.m_count;
        }
        if ((n2 = this.m_input.read(byArray, 0, n3)) > 0) {
            this.m_count -= (long)n2;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        if ((long)n3 > this.m_count) {
            n3 = (int)this.m_count;
        }
        if ((n4 = this.m_input.read(byArray, n2, n3)) > 0) {
            this.m_count -= (long)n4;
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.m_input.available(), (int)Math.min(Integer.MAX_VALUE, this.m_count));
    }

    @Override
    public long skip(long l2) throws IOException {
        return l2 <= 0L ? 0L : this.m_input.skip(Math.min(this.m_count, l2));
    }

    public long getCount() {
        return this.m_count;
    }

    public void setCount(long l2) {
        this.m_count = l2;
    }
}

