/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch() {
        this(0);
    }

    public CountUpDownLatch(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(n2);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l2));
    }

    public boolean countUp() {
        return this.sync.countUp();
    }

    public boolean countUp(int n2) {
        return this.sync.countUp(n2);
    }

    public boolean countDown() {
        return this.sync.countDown();
    }

    public boolean countDown(int n2) {
        return this.sync.countDown(n2);
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public boolean setCount(int n2) {
        return this.sync.setCount(n2);
    }

    public String toString() {
        return String.format("%s[count=%d]", super.toString(), this.sync.getCount());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(CountUpDownLatch countUpDownLatch) {
        return this == countUpDownLatch;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 7224851200740908493L;

        Sync(int n2) {
            this.setState(n2);
        }

        @Override
        protected boolean tryReleaseShared(int n2) {
            return n2 == 0;
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int n2) {
            return this.getState() == 0 ? 1 : -1;
        }

        boolean setCount(int n2) {
            int n3;
            if (n2 < 0) {
                throw new IllegalArgumentException(String.format("amount must be non-negative: %d", n2));
            }
            boolean bl = n2 == 0;
            do {
                n3 = this.getState();
                if (!bl || n3 != 0) continue;
                return false;
            } while (!this.compareAndSetState(n3, n2));
            return bl ? this.releaseShared(0) : false;
        }

        boolean countDown() {
            int n2;
            int n3;
            do {
                if ((n3 = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(n3, n2 = n3 - 1));
            if (n2 == 0) {
                return this.releaseShared(0);
            }
            return false;
        }

        boolean countDown(int n2) {
            int n3;
            int n4;
            if (n2 < 1) {
                throw new IllegalArgumentException(String.format("Amount must be positive: %d", n2));
            }
            do {
                if ((n4 = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(n4, n3 = n2 >= n4 ? 0 : n4 - n2));
            return n3 == 0 ? this.releaseShared(0) : false;
        }

        boolean countUp() {
            int n2;
            int n3;
            do {
                if ((n3 = this.getState()) != Integer.MAX_VALUE) continue;
                throw new ArithmeticException(String.format("integer overflow: %d + 1", n3));
            } while (!super.compareAndSetState(n3, n2 = n3 + 1));
            return n3 == 0;
        }

        boolean countUp(int n2) {
            int n3;
            int n4;
            if (n2 < 1) {
                throw new IllegalArgumentException(String.format("amount must be positive: %d", n2));
            }
            do {
                if (n2 <= Integer.MAX_VALUE - (n4 = this.getState())) continue;
                throw new ArithmeticException(String.format("integer overflow: %d", n2));
            } while (!super.compareAndSetState(n4, n3 = n4 + n2));
            return n4 == 0;
        }
    }
}

