/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.hsqldb.lib.IntValueHashMap;

public final class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static final IntValueHashMap classCodeMap = new IntValueHashMap(16);

    static int getClassCode(Class clazz) {
        if (!clazz.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)clazz, -1);
    }

    public static void clearArray(int n2, Object object, int n3, int n4) {
        switch (n2) {
            case 66: {
                byte[] byArray = (byte[])object;
                Arrays.fill(byArray, n3, n4, (byte)0);
                return;
            }
            case 67: {
                char[] cArray = (char[])object;
                Arrays.fill(cArray, n3, n4, '\u0000');
                return;
            }
            case 83: {
                short[] sArray = (short[])object;
                Arrays.fill(sArray, n3, n4, (short)0);
                return;
            }
            case 73: {
                int[] nArray = (int[])object;
                Arrays.fill(nArray, n3, n4, 0);
                return;
            }
            case 74: {
                long[] lArray = (long[])object;
                Arrays.fill(lArray, n3, n4, 0L);
                return;
            }
            case 70: {
                float[] fArray = (float[])object;
                Arrays.fill(fArray, n3, n4, 0.0f);
                return;
            }
            case 68: {
                double[] dArray = (double[])object;
                Arrays.fill(dArray, n3, n4, 0.0);
                return;
            }
            case 90: {
                boolean[] blArray = (boolean[])object;
                Arrays.fill(blArray, n3, n4, false);
                return;
            }
        }
        Object[] objectArray = (Object[])object;
        Arrays.fill(objectArray, n3, n4, null);
    }

    public static void adjustArray(int n2, Object object, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        if (n4 >= n3 || n5 == 0) {
            return;
        }
        int n9 = n3 + n5;
        if (n5 >= 0) {
            n8 = n4;
            n7 = n4 + n5;
            n6 = n3 - n4;
        } else {
            n8 = n4 - n5;
            n7 = n4;
            n6 = n3 - n4 + n5;
        }
        if (n6 > 0) {
            System.arraycopy(object, n8, object, n7, n6);
        }
        if (n5 < 0) {
            ArrayUtil.clearArray(n2, object, n9, n3);
        }
    }

    public static void sortArray(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                if (nArray[i2] <= nArray[i2 + 1]) continue;
                int n2 = nArray[i2 + 1];
                nArray[i2 + 1] = nArray[i2];
                nArray[i2] = n2;
                bl = true;
            }
        } while (bl);
    }

    public static int find(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == object) {
                return i2;
            }
            if (object == null || !object.equals(objectArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static int find(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int find(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] != n3) continue;
            return i2;
        }
        return -1;
    }

    public static int find(short[] sArray, int n2) {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int find(short[] sArray, int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            if (sArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int find(char[] cArray, int n2) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int findNot(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == n2) continue;
            return i2;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] nArray, int[] nArray2) {
        return nArray.length == nArray2.length && ArrayUtil.haveEqualSets(nArray, nArray2, nArray.length);
    }

    public static boolean haveEqualSets(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            return false;
        }
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (nArray2[i3] == n3) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] objectArray, Object[] objectArray2, int n2) {
        if (n2 > objectArray.length || n2 > objectArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] == objectArray2[i2] || objectArray[i2] != null && objectArray[i2].equals(objectArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (n2 != nArray2[i3]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] commonElements(int[] nArray, int[] nArray2) {
        int[] nArray3 = null;
        int n2 = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n2 > 0) {
            nArray3 = new int[n2];
            int n3 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    if (nArray[i2] != nArray2[i3]) continue;
                    nArray3[n3++] = nArray[i2];
                }
            }
        }
        return nArray3;
    }

    public static int countCommonElements(int[] nArray, int[] nArray2) {
        int n2 = 0;
        block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (nArray[i2] != nArray2[i3]) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public static int countCommonElements(Object[] objectArray, int n2, Object[] objectArray2) {
        int n3 = 0;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                if (objectArray[i2] != objectArray2[i3]) continue;
                ++n3;
                continue block0;
            }
        }
        return n3;
    }

    public static int countSameElements(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = byArray.length - n2;
        if (n4 > byArray2.length) {
            n4 = byArray2.length;
        }
        for (int i2 = 0; i2 < n4 && byArray[i2 + n2] == byArray2[i2]; ++i2) {
            ++n3;
        }
        return n3;
    }

    public static int countSameElements(char[] cArray, int n2, char[] cArray2) {
        int n3 = 0;
        int n4 = cArray.length - n2;
        if (n4 > cArray2.length) {
            n4 = cArray2.length;
        }
        for (int i2 = 0; i2 < n4 && cArray[i2 + n2] == cArray2[i2]; ++i2) {
            ++n3;
        }
        return n3;
    }

    public static int countSameElements(int[] nArray, int n2, int[] nArray2) {
        int n3 = 0;
        int n4 = nArray.length - n2;
        if (n4 > nArray2.length) {
            n4 = nArray2.length;
        }
        for (int i2 = 0; i2 < n4 && nArray[i2 + n2] == nArray2[i2]; ++i2) {
            ++n3;
        }
        return n3;
    }

    public static int countSmallerElements(int[] nArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            ++n3;
        }
        return n3;
    }

    public static int countSmallerEqualElements(int[] nArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] > n2) continue;
            ++n3;
        }
        return n3;
    }

    public static int[] union(int[] nArray, int[] nArray2) {
        int n2 = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n2 == nArray2.length) {
            return nArray;
        }
        if (n2 == nArray.length) {
            return nArray2;
        }
        int n3 = nArray.length + nArray2.length - n2;
        int[] nArray3 = Arrays.copyOf(nArray, n3);
        int n4 = nArray.length;
        block0: for (int i2 = 0; i2 < nArray2.length; ++i2) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray2[i2] == nArray[i3]) continue block0;
            }
            nArray3[n4++] = nArray2[i2];
        }
        return nArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int n2 = nArray.length + nArray2.length;
        int[] nArray3 = Arrays.copyOf(nArray, n2);
        int n3 = nArray.length;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray3[n3++] = nArray2[i2];
        }
        return nArray3;
    }

    public static int find(byte[] byArray, int n2, int n3, byte[] byArray2) {
        n3 = n3 - byArray2.length + 1;
        byte by = byArray2[0];
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] != by) continue;
            if (byArray2.length == 1) {
                return i2;
            }
            if (!ArrayUtil.containsAt(byArray, i2, byArray2)) continue;
            return i2;
        }
        return -1;
    }

    public static int findNotIn(byte[] byArray, int n2, int n3, byte[] byArray2) {
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] == byArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int findIn(byte[] byArray, int n2, int n3, byte[] byArray2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] != byArray2[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int find(byte[] byArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] != n4 && byArray[i2] != n5) continue;
            return i2;
        }
        return -1;
    }

    public static int[] booleanArrayToIntIndexes(boolean[] blArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (int i3 = 0; i3 < blArray.length; ++i3) {
            if (!blArray[i3]) continue;
            nArray[n2++] = i3;
        }
        return nArray;
    }

    public static void intIndexesToBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= blArray.length) continue;
            blArray[nArray[i2]] = true;
        }
    }

    public static int countStartIntIndexesInBooleanArray(int[] nArray, boolean[] blArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length && blArray[nArray[i2]]; ++i2) {
            ++n2;
        }
        return n2;
    }

    public static void orBooleanArray(boolean[] blArray, boolean[] blArray2) {
        for (int i2 = 0; i2 < blArray2.length; ++i2) {
            int n2 = i2;
            blArray2[n2] = blArray2[n2] | blArray[i2];
        }
    }

    public static boolean areAllIntIndexesAsBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (blArray[nArray[i2]]) continue;
            return false;
        }
        return nArray.length == ArrayUtil.countTrueElements(blArray);
    }

    public static boolean areAllIntIndexesInBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (blArray[nArray[i2]]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyIntIndexInBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!blArray[nArray[i2]]) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllTrueElements(boolean[] blArray, boolean[] blArray2) {
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray2[i2] || blArray[i2]) continue;
            return false;
        }
        return true;
    }

    public static int countTrueElements(boolean[] blArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean hasNull(Object[] objectArray, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[nArray[i2]] != null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllNull(Object[] objectArray, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[nArray[i2]] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAt(byte[] byArray, int n2, byte[] byArray2) {
        return ArrayUtil.countSameElements(byArray, n2, byArray2) == byArray2.length;
    }

    public static int countStartElementsAt(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        block0: for (int i2 = n2; i2 < byArray.length; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] != byArray2[i3]) continue;
                ++n3;
                continue block0;
            }
        }
        return n3;
    }

    public static boolean containsAt(char[] cArray, int n2, char[] cArray2) {
        return ArrayUtil.countSameElements(cArray, n2, cArray2) == cArray2.length;
    }

    public static int countNonStartElementsAt(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        block0: for (int i2 = n2; i2 < byArray.length; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] == byArray2[i3]) break block0;
            }
            ++n3;
        }
        return n3;
    }

    public static int copyBytes(long l2, byte[] byArray, int n2, int n3, long l3, byte[] byArray2, int n4) {
        if (n2 >= byArray.length) {
            return 0;
        }
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        if (n4 > byArray2.length) {
            n4 = byArray2.length;
        }
        if (l2 + (long)n2 >= l3 + (long)n4 || l2 + (long)n2 + (long)n3 <= l3) {
            return 0;
        }
        long l4 = l3 - l2;
        long l5 = 0L;
        int n5 = n2 + n3;
        if (l4 >= 0L) {
            if (l4 < (long)n2) {
                l4 = n2;
            }
        } else {
            l5 = -l4 + (long)n2;
            l4 = n2;
        }
        if ((long)(n3 = n5 - (int)l4) > (long)n4 - l5) {
            n3 = n4 - (int)l5;
        }
        System.arraycopy(byArray, (int)l4, byArray2, (int)l5, n3);
        return n3;
    }

    public static byte[] copyBytes(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray.length + n2 > byArray2.length) {
            byte[] byArray3 = new byte[byArray.length + n2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray2 = byArray3;
        }
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        return byArray2;
    }

    public static void copyArray(Object object, Object object2, int n2) {
        System.arraycopy(object, 0, object2, 0, n2);
    }

    public static void copyMoveSegment(Object object, Object object2, int n2, int n3, int n4, int n5) {
        boolean bl = n3 < n5;
        int n6 = bl ? n3 : n5;
        System.arraycopy(object, 0, object2, 0, n6);
        n6 = bl ? n2 - n5 - n4 : n2 - n3 - n4;
        int n7 = bl ? n5 + n4 : n3 + n4;
        System.arraycopy(object, n7, object2, n7, n6);
        System.arraycopy(object, n3, object2, n5, n4);
        n6 = Math.abs(n3 - n5);
        n7 = bl ? n3 + n4 : n5;
        int n8 = bl ? n3 : n5 + n4;
        System.arraycopy(object, n7, object2, n8, n6);
    }

    public static int[] arraySlice(int[] nArray, int n2, int n3) {
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n2, nArray2, 0, n3);
        return nArray2;
    }

    public static void fillArray(char[] cArray, int n2, char c2) {
        int n3 = cArray.length;
        while (--n3 >= n2) {
            cArray[n3] = c2;
        }
    }

    public static void fillArray(byte[] byArray, int n2, byte by) {
        int n3 = byArray.length;
        while (--n3 >= n2) {
            byArray[n3] = by;
        }
    }

    public static void fillArray(Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            objectArray[n2] = object;
        }
    }

    public static void fillArray(int[] nArray, int n2) {
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    public static void fillArray(double[] dArray, double d2) {
        int n2 = dArray.length;
        while (--n2 >= 0) {
            dArray[n2] = d2;
        }
    }

    public static void fillArray(boolean[] blArray, boolean bl) {
        int n2 = blArray.length;
        while (--n2 >= 0) {
            blArray[n2] = bl;
        }
    }

    public static Object duplicateArray(Object object) {
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object resizeArrayIfDifferent(Object object, int n2) {
        int n3 = Array.getLength(object);
        if (n3 == n2) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        if (n3 < n2) {
            n2 = n3;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object resizeArray(Object object, int n2) {
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        int n3 = Array.getLength(object);
        if (n3 < n2) {
            n2 = n3;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static <T> T[] toAdjustedArray(T[] TArray, T t) {
        int n2 = TArray.length;
        T[] TArray2 = Arrays.copyOf(TArray, n2 + 1);
        TArray2[n2] = t;
        return TArray2;
    }

    public static Object toAdjustedArray(Object object, Object object2, int n2, int n3) {
        int n4 = Array.getLength(object) + n3;
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n4);
        ArrayUtil.copyAdjustArray(object, object3, object2, n2, n3);
        return object3;
    }

    public static void copyAdjustArray(Object object, Object object2, Object object3, int n2, int n3) {
        int n4 = Array.getLength(object);
        if (n2 < 0) {
            System.arraycopy(object, 0, object2, 0, n4);
            return;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        if (n3 == 0) {
            int n5 = n4 - n2 - 1;
            Array.set(object2, n2, object3);
            if (n5 > 0) {
                System.arraycopy(object, n2 + 1, object2, n2 + 1, n5);
            }
        } else if (n3 < 0) {
            int n6 = n4 - n2 - 1;
            if (n6 > 0) {
                System.arraycopy(object, n2 + 1, object2, n2, n6);
            }
        } else {
            int n7 = n4 - n2;
            Array.set(object2, n2, object3);
            if (n7 > 0) {
                System.arraycopy(object, n2, object2, n2 + 1, n7);
            }
        }
    }

    public static void copyAdjustArray(Object[] objectArray, Object[] objectArray2, int[] nArray, int n2) {
        if (n2 == 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; n3 < objectArray.length && i2 < objectArray2.length; ++n3, ++i2) {
            if (n4 < nArray.length) {
                int n5 = nArray[n4];
                if (n2 > 0) {
                    if (n5 == i2) {
                        ++i2;
                        ++n4;
                    }
                } else if (n5 == n3) {
                    ++n3;
                    ++n4;
                }
            }
            objectArray2[i2] = objectArray[n3];
        }
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return null;
        }
        if (n2 < 0) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] > n2) {
                nArray2[n4] = nArray[i2] + n3;
                ++n4;
                continue;
            }
            if (nArray[i2] == n2) {
                if (n3 < 0) continue;
                nArray2[n4] = nArray[i2] + n3;
                ++n4;
                continue;
            }
            nArray2[n4] = nArray[i2];
            ++n4;
        }
        if (nArray.length != n4) {
            int[] nArray3 = new int[n4];
            ArrayUtil.copyArray(nArray2, nArray3, n4);
            return nArray3;
        }
        return nArray2;
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int[] nArray2, int n2) {
        if (nArray == null) {
            return null;
        }
        int[] nArray3 = new int[nArray.length];
        if (n2 == 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray3[i2] = nArray[i2];
            }
        } else if (n2 < 0) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = ArrayUtil.countSmallerElements(nArray2, nArray[i3]);
                nArray3[i3] = nArray[i3] - n3;
            }
        } else {
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                int n4 = ArrayUtil.countSmallerEqualElements(nArray2, nArray[i4]);
                nArray3[i4] = nArray[i4] + n4;
            }
        }
        return nArray3;
    }

    public static void projectRow(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
    }

    public static void projectRow(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray3[i2] = nArray[nArray2[i2]];
        }
    }

    public static void projectRowReverse(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            objectArray[nArray[i2]] = objectArray2[i2];
        }
    }

    public static void projectMap(int[] nArray, int[] nArray2, int[] nArray3) {
        block0: for (int i2 = 0; i2 < nArray2.length; ++i2) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray2[i2] != nArray[i3]) continue;
                nArray3[i2] = i3;
                continue block0;
            }
        }
    }

    public static void reorderMaps(int[] nArray, int[] nArray2, int[] nArray3) {
        block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = i2; i3 < nArray2.length; ++i3) {
                if (nArray[i2] != nArray2[i3]) continue;
                int n2 = nArray2[i2];
                nArray2[i2] = nArray2[i3];
                nArray2[i3] = n2;
                n2 = nArray3[i2];
                nArray3[i2] = nArray3[i3];
                nArray3[i3] = n2;
                continue block0;
            }
        }
    }

    public static void fillSequence(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = i2;
        }
    }

    public static char[] byteArrayToChars(byte[] byArray) {
        return ArrayUtil.byteArrayToChars(byArray, byArray.length);
    }

    public static char[] byteArrayToChars(byte[] byArray, int n2) {
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = (char)((byArray[n3] << 8) + (byArray[n3 + 1] & 0xFF));
            n3 += 2;
        }
        return cArray;
    }

    public static byte[] charArrayToBytes(char[] cArray) {
        return ArrayUtil.charArrayToBytes(cArray, cArray.length);
    }

    public static byte[] charArrayToBytes(char[] cArray, int n2) {
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            byArray[n3] = (byte)(c2 >> 8);
            byArray[n3 + 1] = (byte)c2;
            n3 += 2;
        }
        return byArray;
    }

    public static boolean isInSortedArray(char c2, char[] cArray) {
        if (cArray.length == 0 || c2 < cArray[0] || c2 > cArray[cArray.length - 1]) {
            return false;
        }
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            if (c2 < cArray[n4]) {
                n3 = n4;
                continue;
            }
            if (c2 > cArray[n4]) {
                n2 = n4 + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean containsAll(Object[] objectArray, Object[] objectArray2) {
        block0: for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (objectArray2[i2] == objectArray[i3] || objectArray2[i2].equals(objectArray[i3])) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean containsAny(Object[] objectArray, Object[] objectArray2) {
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (objectArray2[i2] != objectArray[i3] && !objectArray2[i2].equals(objectArray[i3])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(int[] nArray, int[] nArray2) {
        block0: for (int i2 = 0; i2 < nArray2.length; ++i2) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray2[i2] == nArray[i3]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean containsAllAtStart(int[] nArray, int[] nArray2) {
        if (nArray2.length > nArray.length) {
            return false;
        }
        block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 == nArray2.length) {
                return true;
            }
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (nArray[i2] == nArray2[i3]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static byte[] toByteArray(long l2, long l3) {
        byte[] byArray = new byte[16];
        int n2 = 0;
        while (n2 < 16) {
            int n3 = n2 == 0 ? (int)(l2 >>> 32) : (n2 == 4 ? (int)l2 : (n2 == 8 ? (int)(l3 >>> 32) : (int)l3));
            byArray[n2++] = (byte)(n3 >>> 24);
            byArray[n2++] = (byte)(n3 >>> 16);
            byArray[n2++] = (byte)(n3 >>> 8);
            byArray[n2++] = (byte)n3;
        }
        return byArray;
    }

    public static long byteSequenceToLong(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l3 = byArray[n2 + i2] & 0xFF;
            l2 += l3 << (7 - i2) * 8;
        }
        return l2;
    }

    public static int compare(byte[] byArray, byte[] byArray2) {
        return ArrayUtil.compare(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static int compare(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n3;
        if (n6 > n5) {
            n6 = n5;
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            if (byArray[n2 + i2] == byArray2[n4 + i2]) continue;
            return (byArray[n2 + i2] & 0xFF) > (byArray2[n4 + i2] & 0xFF) ? 1 : -1;
        }
        if (n3 == n5) {
            return 0;
        }
        return n3 < n5 ? -1 : 1;
    }

    public static long getBinaryMultipleCeiling(long l2, long l3) {
        long l4 = l2 & -l3;
        if (l4 != l2) {
            l4 += l3;
        }
        return l4;
    }

    public static long getBinaryNormalisedCeiling(long l2, int n2) {
        long l3 = -1L << n2;
        long l4 = l2 & l3;
        if (l4 != l2) {
            l4 += 1L << n2;
        }
        return l4;
    }

    public static long getBinaryNormalisedCeiling(long l2) {
        long l3;
        for (l3 = 2L; l3 < l2; l3 <<= 1) {
        }
        return l3;
    }

    public static boolean isTwoPower(int n2, int n3) {
        for (int i2 = 0; i2 <= n3; ++i2) {
            if ((n2 & 1) != 0) {
                return n2 == 1;
            }
            n2 >>= 1;
        }
        return false;
    }

    public static int getTwoPowerFloor(int n2) {
        int n3 = ArrayUtil.getTwoPowerScale(n2);
        if (n3 == 0) {
            return 0;
        }
        return 1 << n3;
    }

    public static int getTwoPowerScale(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            if ((n2 & 1) != 0) {
                n3 = i2;
            }
            n2 >>= 1;
        }
        return n3;
    }

    public static int cdiv(int n2, int n3) {
        int n4 = n2 / n3;
        if (n2 % n3 != 0) {
            ++n4;
        }
        return n4;
    }

    public static long cdiv(long l2, long l3) {
        long l4 = l2 / l3;
        if (l2 % l3 != 0L) {
            ++l4;
        }
        return l4;
    }

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(Object.class, 76);
    }
}

