/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class JDBCArrayBasic
implements Array {
    Type arrayType;
    Type elementType;
    Object[] data;

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() {
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.data, (int)l2 - 1, objectArray, 0, n2);
        return objectArray;
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(l2, n2);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(0L, this.data.length);
        return JDBCResultSet.newJDBCResultSet(result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(l2 - 1L, n2);
        return new JDBCResultSet(null, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(l2, n2);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
    }

    public JDBCArrayBasic(Object[] objectArray, Type type) {
        this.data = objectArray;
        this.elementType = type;
    }

    Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long l2, int n2) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, l2, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Type[] typeArray = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData resultMetaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        resultMetaData.columnLabels = new String[]{"C1", "C2"};
        resultMetaData.colIndexes = new int[]{-1, -1};
        resultMetaData.columns = new ColumnBase[2];
        for (int i2 = 0; i2 < resultMetaData.columns.length; ++i2) {
            ColumnBase columnBase = new ColumnBase("", "", "", "");
            columnBase.setType(typeArray[i2]);
            resultMetaData.columns[i2] = columnBase;
        }
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
        int n3 = (int)l2;
        while ((long)n3 < l2 + (long)n2) {
            Object[] objectArray = new Object[]{n3 + 1, this.data[n3]};
            rowSetNavigatorClient.add(objectArray);
            ++n3;
        }
        Result result = Result.newDataResult(resultMetaData);
        result.setNavigator(rowSetNavigatorClient);
        return result;
    }

    private void checkClosed() throws SQLException {
    }
}

