/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;

class TransactionManagerCommon {
    Database database;
    Session lobSession;
    int txModel;
    HsqlNameManager.HsqlName[] catalogNameList;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong(1L);
    AtomicInteger transactionCount = new AtomicInteger();
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();
    volatile boolean hasExpired;
    public LongKeyHashMap rowActionMap;

    TransactionManagerCommon(Database database) {
        this.database = database;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransactionControl(Session session, int n2) {
        TransactionManagerCommon transactionManagerCommon = null;
        if (n2 == this.txModel) {
            return;
        }
        this.writeLock.lock();
        try {
            switch (this.txModel) {
                case 1: 
                case 2: {
                    if (this.liveTransactionTimestamps.size() == 1) break;
                    throw Error.error(3701);
                }
            }
            switch (n2) {
                case 2: {
                    TransactionManagerMVCC transactionManagerMVCC = new TransactionManagerMVCC(this.database);
                    transactionManagerMVCC.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    transactionManagerMVCC.catalogWriteSession = session;
                    transactionManagerMVCC.isLockedMode = true;
                    OrderedHashSet orderedHashSet = session.waitingSessions;
                    for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
                        Session session2 = (Session)orderedHashSet.get(i2);
                        session2.waitedSessions.add(session);
                    }
                    transactionManagerCommon = transactionManagerMVCC;
                    break;
                }
                case 1: {
                    transactionManagerCommon = new TransactionManagerMV2PL(this.database);
                    transactionManagerCommon.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    OrderedHashSet orderedHashSet = session.waitingSessions;
                    for (int i3 = 0; i3 < orderedHashSet.size(); ++i3) {
                        Session session3 = (Session)orderedHashSet.get(i3);
                        session3.waitedSessions.clear();
                    }
                    break;
                }
                case 0: {
                    transactionManagerCommon = new TransactionManager2PL(this.database);
                    OrderedHashSet orderedHashSet = session.waitingSessions;
                    for (int i4 = 0; i4 < orderedHashSet.size(); ++i4) {
                        Session session4 = (Session)orderedHashSet.get(i4);
                        session4.waitedSessions.clear();
                    }
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "TransactionManagerCommon");
                }
            }
            transactionManagerCommon.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
            transactionManagerCommon.transactionCount = this.transactionCount;
            this.hasExpired = true;
            this.database.txManager = transactionManagerCommon;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void beginTransactionCommon(Session session) {
        session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        session.transactionTimestamp = session.actionTimestamp;
        session.isPreTransaction = false;
        session.isTransaction = true;
        this.transactionCount.incrementAndGet();
    }

    void adjustLobUsage(Session session) {
        int n2;
        int n3 = session.rowActionList.size();
        long l2 = session.actionTimestamp;
        block4: for (n2 = 0; n2 < n3; ++n2) {
            RowAction rowAction = (RowAction)session.rowActionList.get(n2);
            if (rowAction.type == 0 || !rowAction.table.hasLobColumn) continue;
            int n4 = rowAction.getCommitTypeOn(l2);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            switch (n4) {
                case 1: {
                    session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), 1);
                    continue block4;
                }
                case 2: {
                    session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), -1);
                    continue block4;
                }
            }
        }
        n2 = session.rowActionList.size();
        if (n2 > n3) {
            for (int i2 = n3; i2 < n2; ++i2) {
                RowAction rowAction = (RowAction)session.rowActionList.get(i2);
                rowAction.commit(session);
            }
        }
    }

    Statement updateCurrentStatement(Session session, Statement statement) {
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            session.sessionContext.currentStatement = statement = session.statementManager.getStatement(statement);
        }
        return statement;
    }

    void persistCommit(Session session) {
        int n2 = session.rowActionList.size();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i2);
            if (rowAction.type == 0) continue;
            int n3 = rowAction.getCommitTypeOn(session.actionTimestamp);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (!rowAction.table.isTemp) {
                bl = true;
            }
            try {
                rowAction.store.commitRow(session, row, n3, this.txModel);
                if (this.txModel != 0 && !rowAction.table.isTemp) continue;
                rowAction.setAsNoOp();
                row.rowAction = null;
                continue;
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logWarningEvent("data commit failed", hsqlException);
            }
        }
        try {
            session.logSequences();
            if (n2 > 0 && bl) {
                this.database.logger.writeCommitStatement(session);
            }
        }
        catch (HsqlException hsqlException) {
            this.database.logger.logWarningEvent("data commit logging failed", hsqlException);
        }
    }

    void finaliseRows(Session session, Object[] objectArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            RowAction rowAction = (RowAction)objectArray[i2];
            rowAction.store.postCommitAction(session, rowAction);
        }
    }

    void mergeTransaction(Object[] objectArray, int n2, int n3, long l2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            RowAction rowAction = (RowAction)objectArray[i2];
            rowAction.mergeToTimestamp(l2);
        }
    }

    public long getNextGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    boolean checkDeadlock(Session session, OrderedHashSet orderedHashSet) {
        int n2 = session.waitingSessions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Session session2 = (Session)session.waitingSessions.get(i2);
            if (orderedHashSet.contains(session2)) {
                return false;
            }
            if (this.checkDeadlock(session2, orderedHashSet)) continue;
            return false;
        }
        return true;
    }

    boolean checkDeadlock(Session session, Session session2) {
        int n2 = session.waitingSessions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Session session3 = (Session)session.waitingSessions.get(i2);
            if (session3 == session2) {
                return false;
            }
            if (this.checkDeadlock(session3, session2)) continue;
            return false;
        }
        return true;
    }

    void getTransactionSessions(Session session) {
        OrderedHashSet orderedHashSet = session.tempSet;
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i2 = 0; i2 < sessionArray.length; ++i2) {
            long l2 = sessionArray[i2].transactionTimestamp;
            if (session == sessionArray[i2] || !sessionArray[i2].isTransaction) continue;
            orderedHashSet.add(sessionArray[i2]);
        }
    }

    void getTransactionAndPreSessions(Session session) {
        OrderedHashSet orderedHashSet = session.tempSet;
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i2 = 0; i2 < sessionArray.length; ++i2) {
            long l2 = sessionArray[i2].transactionTimestamp;
            if (session == sessionArray[i2]) continue;
            if (sessionArray[i2].isPreTransaction) {
                orderedHashSet.add(sessionArray[i2]);
                continue;
            }
            if (!sessionArray[i2].isTransaction) continue;
            orderedHashSet.add(sessionArray[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endActionTPL(Session session) {
        if (session.isolationLevel == 4 || session.isolationLevel == 8) {
            return;
        }
        if (session.sessionContext.currentStatement == null) {
            return;
        }
        if (session.sessionContext.depth > 0) {
            return;
        }
        Object[] objectArray = session.sessionContext.currentStatement.getTableNamesForRead();
        if (objectArray.length == 0) {
            return;
        }
        this.writeLock.lock();
        try {
            int n2;
            this.unlockReadTablesTPL(session, (HsqlNameManager.HsqlName[])objectArray);
            int n3 = session.waitingSessions.size();
            if (n3 == 0) {
                return;
            }
            boolean bl = false;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (this.tableWriteLocks.get(objectArray[n2]) == session) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                Session session2 = (Session)session.waitingSessions.get(n2);
                if (session2.abortTransaction) {
                    bl = true;
                    break;
                }
                Statement statement = session2.sessionContext.currentStatement;
                if (statement == null) {
                    bl = true;
                    break;
                }
                if (!ArrayUtil.containsAny(objectArray, statement.getTableNamesForWrite())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            this.resetLocks(session);
            this.resetLatchesMidTransaction(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        this.unlockTablesTPL(session);
        int n2 = session.waitingSessions.size();
        if (n2 == 0) {
            return;
        }
        this.resetLocks(session);
        this.resetLatches(session);
    }

    void resetLocks(Session session) {
        Session session2;
        int n2;
        int n3 = session.waitingSessions.size();
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl;
            session2 = (Session)session.waitingSessions.get(n2);
            session2.tempUnlocked = false;
            long l2 = session2.latch.getCount();
            if (l2 != 1L || !(bl = this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement)) || !session2.tempSet.isEmpty()) continue;
            this.lockTablesTPL(session2, session2.sessionContext.currentStatement);
            session2.tempUnlocked = true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            session2 = (Session)session.waitingSessions.get(n2);
            if (session2.tempUnlocked || session2.abortTransaction) continue;
            this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement);
        }
    }

    void resetLatches(Session session) {
        int n2 = session.waitingSessions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            Session session2 = (Session)session.waitingSessions.get(i2);
            boolean bl2 = false;
            if (bl2 && !session2.abortTransaction && session2.tempSet.isEmpty() && !(bl = this.hasLocks(session2, session2.sessionContext.currentStatement))) {
                System.out.println("tx graph");
                bl = this.hasLocks(session2, session2.sessionContext.currentStatement);
            }
            this.setWaitingSessionTPL(session2);
        }
        session.waitingSessions.clear();
        session.latch.setCount(0);
    }

    void resetLatchesMidTransaction(Session session) {
        session.tempSet.clear();
        session.tempSet.addAll(session.waitingSessions);
        session.waitingSessions.clear();
        int n2 = session.tempSet.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            Session session2 = (Session)session.tempSet.get(i2);
            boolean bl2 = false;
            if (bl2 && !session2.abortTransaction && session2.tempSet.isEmpty() && !(bl = this.hasLocks(session2, session2.sessionContext.currentStatement))) {
                System.out.println("tx graph");
                bl = this.hasLocks(session2, session2.sessionContext.currentStatement);
            }
            this.setWaitingSessionTPL(session2);
        }
        session.tempSet.clear();
    }

    boolean setWaitedSessionsTPL(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n2;
        session.tempSet.clear();
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        if (statement.isCatalogLock(this.txModel)) {
            this.getTransactionSessions(session);
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                session.tempSet.add(session2);
            }
            Iterator iterator = this.tableReadLocks.getValuesIterator(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                session.tempSet.add(session2);
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly() && hsqlNameArray.length > 0) {
            hsqlNameArray = this.catalogNameList;
        }
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            session.tempSet.add(session2);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void setWaitingSessionTPL(Session session) {
        int n2 = session.tempSet.size();
        assert (session.latch.getCount() <= n2 + 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            Session session2 = (Session)session.tempSet.get(i2);
            session2.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(n2);
    }

    void lockTablesTPL(Session session, Statement statement) {
        HsqlNameManager.HsqlName hsqlName;
        int n2;
        if (statement == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(hsqlName, session);
        }
        hsqlNameArray = statement.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly() && hsqlNameArray.length > 0) {
            hsqlNameArray = this.catalogNameList;
        }
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(hsqlName, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session session2;
        Iterator iterator = this.tableWriteLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.remove();
        }
        iterator = this.tableReadLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.remove();
        }
    }

    void unlockReadTablesTPL(Session session, HsqlNameManager.HsqlName[] hsqlNameArray) {
        for (int i2 = 0; i2 < hsqlNameArray.length; ++i2) {
            this.tableReadLocks.remove(hsqlNameArray[i2], session);
        }
    }

    boolean hasLocks(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n2;
        if (statement == null) {
            return true;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                return false;
            }
            Iterator iterator = this.tableReadLocks.getValuesIterator(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                return false;
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        for (n2 = 0; n2 < hsqlNameArray.length; ++n2) {
            hsqlName = hsqlNameArray[n2];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            return false;
        }
        return true;
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        this.writeLock.lock();
        try {
            var1_1 = this.database.sessionManager.getAllSessions();
            var2_2 = new int[var1_1.length];
            var4_3 = 0;
            var5_4 = 0;
            for (var6_6 = 0; var6_6 < var1_1.length; ++var6_6) {
                var5_4 += var1_1[var6_6].getTransactionSize();
            }
            var3_8 = new RowAction[var5_4];
            block4: while (true) {
                var5_4 = 0;
                var6_7 = 0x7FFFFFFFFFFFFFFFL;
                var8_9 = 0;
                for (var9_11 = 0; var9_11 < var1_1.length; ++var9_11) {
                    var10_12 = var1_1[var9_11].getTransactionSize();
                    if (var2_2[var9_11] >= var10_12) continue;
                    var11_14 = (RowAction)var1_1[var9_11].rowActionList.get(var2_2[var9_11]);
                    if (var11_14.actionTimestamp < var6_7) {
                        var6_7 = var11_14.actionTimestamp;
                        var8_9 = var9_11;
                    }
                    var5_4 = 1;
                }
                if (var5_4 == 0) break;
                var9_10 = var1_1[var8_9].rowActionList;
                while (true) {
                    if (var2_2[var8_9] >= var9_10.size()) continue block4;
                    var10_13 = (RowAction)var9_10.get(var2_2[var8_9]);
                    if (var10_13.actionTimestamp == var6_7 + 1L) {
                        ++var6_7;
                    }
                    if (var10_13.actionTimestamp == var6_7) ** break;
                    continue block4;
                    var3_8[var4_3++] = var10_13;
                    v0 = var8_9;
                    var2_2[v0] = var2_2[v0] + 1;
                }
                break;
            }
            var5_5 = var3_8;
            return var5_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resetSession(Session session, Session session2, long l2, int n2) {
        this.writeLock.lock();
        try {
            switch (n2) {
                case 1: {
                    if (session != session2) {
                        return;
                    }
                    if (session2.isInMidTransaction()) return;
                    session2.sessionData.closeAllNavigators();
                    return;
                }
                case 2: {
                    if (session != session2) {
                        return;
                    }
                    if (session2.isInMidTransaction()) return;
                    session2.sessionData.persistentStoreCollection.clearAllTables();
                    return;
                }
                case 3: {
                    if (session != session2) {
                        return;
                    }
                    if (session2.isInMidTransaction()) return;
                    session2.resetSession();
                    return;
                }
                case 4: {
                    if (session == session2) {
                        return;
                    }
                    if (!session2.isInMidTransaction()) return;
                    this.prepareReset(session2);
                    session2.abortTransaction = true;
                    if (session2.latch.getCount() > 0) {
                        session2.latch.setCount(0);
                        return;
                    }
                    session2.rollbackNoCheck(true);
                    return;
                }
                case 5: {
                    if (l2 != session2.statementStartTimestamp) {
                        return;
                    }
                    if (!session2.isInMidTransaction()) return;
                    this.prepareReset(session2);
                    session2.abortAction = true;
                    if (session2.latch.getCount() <= 0) return;
                    session2.latch.setCount(0);
                    return;
                }
                case 6: {
                    if (session == session2) {
                        return;
                    }
                    if (session2.isInMidTransaction()) return;
                    session2.rollbackNoCheck(true);
                    session2.close();
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void prepareReset(Session session) {
        OrderedHashSet orderedHashSet = session.waitedSessions;
        for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
            Session session2 = (Session)orderedHashSet.get(i2);
            session2.waitingSessions.remove(session);
        }
        orderedHashSet.clear();
    }

    public void abortAction(Session session) {
    }
}

