/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    boolean isTruncate;
    boolean isMergeDeleteFirst;
    Expression mergeInsertCondition;
    Expression mergeUpdateCondition;
    Expression mergeDeleteCondition;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    SortAndSlice sortAndSlice;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;

    public StatementDML(int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n2, 2004, hsqlName);
    }

    StatementDML(Session session, Table table, RangeVariable rangeVariable, RangeVariable[] rangeVariableArray, ParserDQL.CompileContext compileContext, boolean bl, int n2, SortAndSlice sortAndSlice) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        this.targetRangeVariables = rangeVariableArray;
        this.restartIdentity = bl;
        this.sortAndSlice = sortAndSlice;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (n2 == 1215) {
            this.isTruncate = true;
        }
        rangeVariable.addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, Table table, RangeVariable rangeVariable, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray2, boolean[] blArray, ParserDQL.CompileContext compileContext, SortAndSlice sortAndSlice) {
        super(92, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.targetTable = table;
        this.baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray2;
        this.updateCheckColumns = blArray;
        this.targetRangeVariables = rangeVariableArray;
        this.sortAndSlice = sortAndSlice;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        rangeVariable.addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, RangeVariable rangeVariable, RangeVariable rangeVariable2, RangeVariable[] rangeVariableArray, int[] nArray, int[] nArray2, boolean[] blArray, Expression expression, Expression expression2, Expression[] expressionArray2, boolean bl, Expression expression3, Expression expression4, Expression expression5, ParserDQL.CompileContext compileContext) {
        super(56, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.sourceTable = rangeVariable.rangeTable;
        this.targetTable = rangeVariable2.rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = blArray;
        this.insertColumnMap = nArray;
        this.updateColumnMap = nArray2;
        this.insertExpression = expression2;
        this.updateExpressions = expressionArray2;
        this.targetRangeVariables = rangeVariableArray;
        this.condition = expression;
        this.mergeInsertCondition = expression3;
        this.mergeUpdateCondition = expression4;
        this.mergeDeleteCondition = expression5;
        this.isMergeDeleteFirst = bl;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementDML() {
        super(91, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification querySpecification = this.targetTable.getQueryExpression().getMainSelect();
            this.updatableTableCheck = querySpecification.checkQueryCondition;
            this.checkRangeVariable = querySpecification.rangeVariables[querySpecification.rangeVariables.length - 1];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        int n2 = Integer.MAX_VALUE;
        if (this.sortAndSlice != null) {
            int[] nArray = this.sortAndSlice.getLimits(session, null, Integer.MAX_VALUE);
            n2 = nArray[1];
        }
        switch (this.type) {
            case 92: {
                result = this.executeUpdateStatement(session, n2);
                break;
            }
            case 56: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session, n2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        session.sessionContext.diagnosticsVariables[2] = result.getUpdateCount();
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        SchemaObject schemaObject;
        int n2;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (n2 = 0; n2 < this.baseTable.fkConstraints.length; ++n2) {
                schemaObject = this.baseTable.fkConstraints[n2];
                switch (this.type) {
                    case 92: {
                        if (!ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n2].getMain().getName());
                        continue block5;
                    }
                    case 55: {
                        orderedHashSet.add(this.baseTable.fkConstraints[n2].getMain().getName());
                        continue block5;
                    }
                    case 56: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) {
                            orderedHashSet.add(this.baseTable.fkConstraints[n2].getMain().getName());
                        }
                        if (this.insertExpression == null) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n2].getMain().getName());
                    }
                }
            }
            if (this.type == 92 || this.type == 56) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, orderedHashSet);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, false);
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            schemaObject = this.rangeVariables[n2].rangeTable;
            HsqlNameManager.HsqlName hsqlName = ((Table)schemaObject).getName();
            if (((Table)schemaObject).isDataReadOnly() || ((Table)schemaObject).isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n2 = 0; n2 < this.subqueries.length; ++n2) {
            if (this.subqueries[n2].queryExpression == null) continue;
            this.subqueries[n2].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n2 = 0; n2 < this.routines.length; ++n2) {
            orderedHashSet.addAll(this.routines[n2].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, true);
        } else if (!this.baseTable.isTemp()) {
            orderedHashSet.add(this.baseTable.getName());
            if (this.type == 92 || this.type == 56) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, orderedHashSet);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, true);
        }
    }

    @Override
    public void setGeneratedColumnInfo(int n2, ResultMetaData resultMetaData) {
        switch (this.type) {
            case 19: 
            case 55: 
            case 56: 
            case 92: {
                break;
            }
            default: {
                return;
            }
        }
        int n3 = this.baseTable.getIdentityColumnIndex();
        this.generatedType = n2;
        this.generatedInputMetaData = resultMetaData;
        switch (n2) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = resultMetaData.getGeneratedColumnIndexes();
                for (int i2 = 0; i2 < this.generatedIndexes.length; ++i2) {
                    if (this.generatedIndexes[i2] >= 0 && this.generatedIndexes[i2] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int n4;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (n3 >= 0) {
                        int n5 = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[n5];
                        int n6 = 0;
                        for (n4 = 0; n4 < this.baseTable.colGenerated.length; ++n4) {
                            if (!this.baseTable.colGenerated[n4] && n4 != n3) continue;
                            this.generatedIndexes[n6++] = n4;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (n3 >= 0) {
                    this.generatedIndexes = new int[]{n3};
                    break;
                }
                return;
            }
            case 11: {
                int n4;
                String[] stringArray = resultMetaData.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.findColumnIndexes(stringArray);
                for (n4 = 0; n4 < this.generatedIndexes.length; ++n4) {
                    if (this.generatedIndexes[n4] >= 0) continue;
                    String string = stringArray[n4].toUpperCase();
                    this.generatedIndexes[n4] = this.baseTable.findColumn(string);
                    if (this.generatedIndexes[n4] >= 0) continue;
                    throw Error.error(5501, stringArray[0]);
                }
                break;
            }
            case 31: {
                this.generatedIndexes = this.baseTable.getPrimaryKey();
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i3 = 0; i3 < this.generatedIndexes.length; ++i3) {
            ColumnSchema columnSchema = this.baseTable.getColumn(this.generatedIndexes[i3]);
            this.generatedResultMetaData.columns[i3] = columnSchema;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] objectArray) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] objectArray2 = new Object[this.generatedIndexes.length];
        for (int i2 = 0; i2 < this.generatedIndexes.length; ++i2) {
            objectArray2[i2] = objectArray[this.generatedIndexes[i2]];
        }
        return objectArray2;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet orderedHashSet, boolean bl) {
        block6: for (int i2 = 0; i2 < this.baseTable.triggerList.length; ++i2) {
            TriggerDef triggerDef = this.baseTable.triggerList[i2];
            switch (this.type) {
                case 55: {
                    if (triggerDef.getStatementType() != 55) continue block6;
                    break;
                }
                case 92: {
                    if (triggerDef.getStatementType() != 92) continue block6;
                    break;
                }
                case 19: {
                    if (triggerDef.getStatementType() != 19) continue block6;
                    break;
                }
                case 56: {
                    if (triggerDef.getStatementType() != 55 && triggerDef.getStatementType() != 92) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (triggerDef.routine == null) continue;
            if (bl) {
                orderedHashSet.addAll(triggerDef.routine.getTableNamesForWrite());
                continue;
            }
            orderedHashSet.addAll(triggerDef.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session, int n2) {
        int n3 = 0;
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        Type[] typeArray = this.baseTable.getColumnTypes();
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        int n4 = 0;
        while (rangeIterator.next()) {
            session.sessionData.startRowProcessing();
            Row row = rangeIterator.getCurrentRow();
            Object[] objectArray = row.getDataCopy();
            StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray);
            rowSetNavigatorDataChange.addRow(session, row, objectArray, typeArray, this.updateColumnMap);
            ++session.sessionContext.rownum;
            if (++n4 != n2) continue;
            break;
        }
        rowSetNavigatorDataChange.endMainDataSet();
        rangeIterator.release();
        rowSetNavigatorDataChange.beforeFirst();
        n3 = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        if (n3 == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (result == null) {
            if (n3 == 1) {
                return Result.updateOneResult;
            }
            if (n3 == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, n3);
        }
        result.setUpdateCount(n3);
        return result;
    }

    static void getUpdatedData(Session session, Expression[] expressionArray, Table table, int[] nArray, Expression[] expressionArray2, Type[] typeArray, Object[] objectArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            Cloneable cloneable;
            int n4;
            Expression expression;
            if ((expression = expressionArray2[n3++]).getType() == 25) {
                Object[] objectArray2 = expression.getRowValue(session);
                int n5 = 0;
                while (n5 < objectArray2.length) {
                    n4 = nArray[n2];
                    cloneable = expression.nodes[n5];
                    if (table.identityColumn != n4 || cloneable.getType() != 1 || cloneable.valueData != null) {
                        if (cloneable.getType() == 4) {
                            if (table.identityColumn != n4) {
                                objectArray[n4] = table.colDefaults[n4] == null ? null : table.colDefaults[n4].getValue(session);
                            }
                        } else {
                            objectArray[n4] = typeArray[n4].convertToType(session, objectArray2[n5], cloneable.dataType);
                        }
                    }
                    ++n5;
                    ++n2;
                }
                continue;
            }
            if (expression.getType() == 22) {
                Object[] objectArray3 = expression.getRowValue(session);
                int n6 = 0;
                while (n6 < objectArray3.length) {
                    n4 = nArray[n2];
                    cloneable = expression.table.queryExpression.getMetaData().columnTypes[n6];
                    objectArray[n4] = typeArray[n4].convertToType(session, objectArray3[n6], (Type)cloneable);
                    ++n6;
                    ++n2;
                }
                continue;
            }
            int n7 = nArray[n2];
            if (expression.getType() == 4) {
                if (table.identityColumn == n7) {
                    ++n2;
                    continue;
                }
                objectArray[n7] = table.colDefaults[n7] == null ? null : table.colDefaults[n7].getValue(session);
                ++n2;
                continue;
            }
            Object object = expression.getValue(session);
            objectArray[n7] = expressionArray[n2].getType() == 101 ? ((ExpressionAccessor)expressionArray[n2]).getUpdatedArray(session, (Object[])objectArray[n7], object, true) : typeArray[n7].convertToType(session, object, expression.dataType);
            ++n2;
        }
    }

    Result executeMergeStatement(Session session) {
        int n2;
        boolean bl;
        Type[] typeArray = this.baseTable.getColumnTypes();
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        boolean bl2 = bl = this.mergeDeleteCondition != null || this.updateExpressions.length != 0;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        int n3 = 0;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        RangeVariable[] rangeVariableArray = this.targetRangeVariables;
        RangeIterator[] rangeIteratorArray = new RangeIterator[rangeVariableArray.length];
        for (n2 = 0; n2 < rangeVariableArray.length; ++n2) {
            rangeIteratorArray[n2] = rangeVariableArray[n2].getIterator(session);
        }
        n2 = 0;
        while (n2 >= 0) {
            Object[] objectArray;
            RangeIterator rangeIterator = rangeIteratorArray[n2];
            boolean bl3 = rangeIterator.isBeforeFirst();
            if (rangeIterator.next()) {
                if (n2 < rangeVariableArray.length - 1) {
                    ++n2;
                    continue;
                }
            } else {
                if (n2 == 1 && bl3 && this.insertExpression != null && (objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes)) != null && this.mergeInsertCondition.testCondition(session)) {
                    rowSetNavigatorClient.add(objectArray);
                }
                rangeIterator.reset();
                --n2;
                continue;
            }
            if (!bl) continue;
            objectArray = rangeIterator.getCurrentRow();
            session.sessionData.startRowProcessing();
            try {
                boolean bl4 = false;
                if (this.isMergeDeleteFirst && this.mergeDeleteCondition != null && (bl4 = this.mergeDeleteCondition.testCondition(session))) {
                    rowSetNavigatorDataChange.addRow((Row)objectArray);
                }
                if (!bl4 && this.mergeUpdateCondition != null && (bl4 = this.mergeUpdateCondition.testCondition(session))) {
                    Object[] objectArray2 = objectArray.getDataCopy();
                    StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray2);
                    rowSetNavigatorDataChange.addRow(session, (Row)objectArray, objectArray2, typeArray, this.updateColumnMap);
                }
                if (bl4 || this.isMergeDeleteFirst || this.mergeDeleteCondition == null || !(bl4 = this.mergeDeleteCondition.testCondition(session))) continue;
                rowSetNavigatorDataChange.addRow((Row)objectArray);
            }
            catch (HsqlException hsqlException) {
                for (int i2 = 0; i2 < rangeVariableArray.length; ++i2) {
                    rangeIteratorArray[i2].reset();
                }
                throw Error.error(3201);
            }
        }
        rowSetNavigatorDataChange.endMainDataSet();
        for (n2 = 0; n2 < rangeVariableArray.length; ++n2) {
            rangeIteratorArray[n2].reset();
        }
        if (bl) {
            n3 = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        }
        if (rowSetNavigatorClient.getSize() > 0) {
            this.insertRowSet(session, rowSetNavigator, rowSetNavigatorClient);
            n3 += rowSetNavigatorClient.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigatorClient);
        }
        if (n3 == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (result == null) {
            if (n3 == 1) {
                return Result.updateOneResult;
            }
            if (n3 == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, n3);
        }
        result.setUpdateCount(n3);
        return result;
    }

    void insertRowSet(Session session, RowSetNavigator rowSetNavigator, RowSetNavigator rowSetNavigator2) {
        Object[] objectArray;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        RangeIterator rangeIterator = null;
        if (this.updatableTableCheck != null) {
            rangeIterator = session.sessionContext.getCheckIterator(this.checkRangeVariable);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.identityColumn != -1) {
            while (rowSetNavigator2.next()) {
                objectArray = rowSetNavigator2.getCurrent();
                session.sessionData.startRowProcessing();
                this.baseTable.setIdentityColumn(session, objectArray);
            }
            rowSetNavigator2.beforeFirst();
        }
        if (this.baseTable.triggerLists[6].length > 0) {
            while (rowSetNavigator2.next()) {
                objectArray = rowSetNavigator2.getCurrent();
                session.sessionData.startRowProcessing();
                this.baseTable.fireTriggers(session, 6, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
        while (rowSetNavigator2.next()) {
            objectArray = rowSetNavigator2.getCurrent();
            session.sessionData.startRowProcessing();
            this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
            if (this.updatableTableCheck != null) {
                rangeIterator.setCurrent(objectArray);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    throw Error.error(5700);
                }
            }
            if (rowSetNavigator == null) continue;
            Object[] objectArray2 = this.getGeneratedColumns(objectArray);
            rowSetNavigator.add(objectArray2);
        }
        rowSetNavigator2.beforeFirst();
        while (rowSetNavigator2.next()) {
            objectArray = rowSetNavigator2.getCurrent();
            this.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (rowSetNavigator2.next()) {
                objectArray = rowSetNavigator2.getCurrent();
                this.baseTable.fireTriggers(session, 3, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
    }

    Result insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        session.sessionData.startRowProcessing();
        this.baseTable.setIdentityColumn(session, objectArray);
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, objectArray, null);
        }
        this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
        this.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, objectArray, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, (RowSetNavigator)null);
        }
        session.sessionContext.diagnosticsVariables[2] = 1;
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] typeArray, Expression[] expressionArray) {
        Object[] objectArray = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            Expression expression = expressionArray[i2];
            int n2 = this.insertColumnMap[i2];
            if (expression.opType == 4) {
                if (this.baseTable.identityColumn == n2 || this.baseTable.colDefaults[n2] == null) continue;
                objectArray[n2] = this.baseTable.colDefaults[n2].getValue(session);
                continue;
            }
            Object object = expression.getValue(session);
            Type type = typeArray[n2];
            if (session.database.sqlSyntaxMys || session.database.sqlSyntaxPgs) {
                try {
                    object = type.convertToType(session, object, expression.dataType);
                }
                catch (HsqlException hsqlException) {
                    if (type.typeCode == 91) {
                        object = Type.SQL_TIMESTAMP.convertToType(session, object, expression.dataType);
                        object = type.convertToType(session, object, Type.SQL_TIMESTAMP);
                    }
                    if (type.typeCode == 93) {
                        object = Type.SQL_DATE.convertToType(session, object, expression.dataType);
                        object = type.convertToType(session, object, Type.SQL_DATE);
                    }
                    throw hsqlException;
                }
            }
            objectArray[n2] = object;
        }
        return objectArray;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, RowSetNavigator rowSetNavigator) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        int n2 = rowSetNavigatorDataChange.getSize();
        RangeIterator rangeIterator = null;
        if (this.updatableTableCheck != null) {
            rangeIterator = session.sessionContext.getCheckIterator(this.checkRangeVariable);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            rowSetNavigatorDataChange.next();
            Object[] objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            session.sessionData.startRowProcessing();
            table.setIdentityColumn(session, objectArray);
            table.setGeneratedColumns(session, objectArray);
            table.setUpdatedColumns(session, objectArray, this.updateColumnMap);
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet hashSet = session.sessionContext.getConstraintPath();
            for (int i3 = 0; i3 < n2; ++i3) {
                rowSetNavigatorDataChange.next();
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, (Row)object3, (Object[])object2, this.updateColumnMap, hashSet, false);
                hashSet.clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = (Object[])row.getTable();
            if (object2 instanceof TableDerived) {
                object2 = ((TableDerived)object2).view;
            }
            if (((Table)object2).triggerLists[8].length > 0) {
                session.sessionData.startRowProcessing();
                ((Table)object2).fireTriggers(session, 8, row.getData(), objectArray, (int[])object3);
                ((Table)object2).enforceRowConstraints(session, objectArray);
            }
            if (this.updatableTableCheck == null) continue;
            rangeIterator.setCurrent(objectArray);
            boolean bl2 = this.updatableTableCheck.testCondition(session);
            if (bl2) continue;
            throw Error.error(5700);
        }
        if (table.isView) {
            return n2;
        }
        rowSetNavigatorDataChange.beforeFirst();
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Table table2 = (Table)row.getTable();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = table2.getRowStore(session);
            session.addDeleteAction(table2, (PersistentStore)object2, row, (int[])object3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        while (rowSetNavigatorDataChange.next()) {
            Object[] objectArray;
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)row.getTable();
            object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            PersistentStore persistentStore = ((Table)object3).getRowStore(session);
            if (((TableBase)object3).isSystemVersioned()) {
                object = row.getData();
                objectArray = ((Table)object3).insertSystemVersionHistoryRow(session, persistentStore, (Object[])object);
            }
            if (objectArray2 == null) continue;
            object = ((Table)object3).insertSingleRow(session, persistentStore, objectArray2, (int[])object2);
            if (rowSetNavigator == null) continue;
            objectArray = this.getGeneratedColumns(objectArray2);
            rowSetNavigator.add(objectArray);
        }
        rowSetNavigatorDataChange.beforeFirst();
        OrderedHashSet<Object> orderedHashSet = null;
        boolean bl3 = bl = table.triggerLists[5].length > 0;
        while (rowSetNavigatorDataChange.next()) {
            object3 = rowSetNavigatorDataChange.getCurrentRow();
            object2 = (Table)((Row)object3).getTable();
            Object[] objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object = rowSetNavigatorDataChange.getCurrentChangedColumns();
            this.performIntegrityChecks(session, (Table)object2, ((Row)object3).getData(), objectArray, (int[])object);
            if (object2 == table) continue;
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet<Object>();
            }
            orderedHashSet.add(object2);
            if (((Table)object2).triggerLists[5].length <= 0) continue;
            bl = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl) {
            while (rowSetNavigatorDataChange.next()) {
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                int[] nArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object3).getTable();
                ((Table)object).fireTriggers(session, 5, ((Row)object3).getData(), (Object[])object2, nArray);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, rowSetNavigatorDataChange);
        if (orderedHashSet != null) {
            for (int i4 = 0; i4 < orderedHashSet.size(); ++i4) {
                object2 = (Table)orderedHashSet.get(i4);
                ((Table)object2).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        return n2;
    }

    Result executeDeleteStatement(Session session, int n2) {
        int n3 = 0;
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = session.sessionContext.getRowSetDataChange();
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        int n4 = 0;
        while (rangeIterator.next()) {
            Row row = rangeIterator.getCurrentRow();
            rowSetNavigatorDataChange.addRow(row);
            ++session.sessionContext.rownum;
            if (++n4 != n2) continue;
            break;
        }
        rangeIterator.release();
        rowSetNavigatorDataChange.endMainDataSet();
        if (rowSetNavigatorDataChange.getSize() > 0) {
            n3 = this.delete(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        }
        if (n3 == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (result == null) {
            if (n3 == 1) {
                return Result.updateOneResult;
            }
            if (n3 == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, n3);
        }
        result.setUpdateCount(n3);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore persistentStore = this.targetTable.getRowStore(session);
        RowIterator rowIterator = this.targetTable.getDefaultIndex().firstRow(persistentStore);
        boolean bl = false;
        for (int i2 = 0; i2 < this.targetTable.fkMainConstraints.length; ++i2) {
            HsqlNameManager.HsqlName hsqlName;
            Table table;
            if (this.targetTable.fkMainConstraints[i2].getRef() == this.targetTable || (table = session.database.schemaManager.getUserTable(hsqlName = this.targetTable.fkMainConstraints[i2].getRef().getName())).isEmpty(session)) continue;
            throw Error.error(8, table.getName().name);
        }
        try {
            while (rowIterator.next()) {
                Row row = rowIterator.getCurrentRow();
                session.addDeleteAction((Table)row.getTable(), persistentStore, row, null);
                bl = true;
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            rowIterator.release();
        }
        if (!bl) {
            session.addWarning(HsqlException.noDataCondition);
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, RowSetNavigator rowSetNavigator) {
        boolean bl;
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        Table table2;
        Object object4;
        int n2;
        Object object5;
        int n3 = rowSetNavigatorDataChange.getSize();
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            object5 = session.sessionContext.getConstraintPath();
            if (table.cascadingDeletes > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    rowSetNavigatorDataChange.next();
                    Row row = rowSetNavigatorDataChange.getCurrentRow();
                    StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row, null, null, (HashSet)object5, true);
                    ((BaseHashMap)object5).clear();
                }
                rowSetNavigatorDataChange.beforeFirst();
            }
            n2 = rowSetNavigatorDataChange.getSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                rowSetNavigatorDataChange.next();
                object4 = rowSetNavigatorDataChange.getCurrentRow();
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, (Row)object4, null, null, (HashSet)object5, false);
                ((BaseHashMap)object5).clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.next()) {
            object5 = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            int[] nArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object4 = (Table)((Row)object5).getTable();
            if (object4 instanceof TableDerived) {
                object4 = ((TableDerived)object4).view;
            }
            if (objectArray2 == null) {
                object4.fireTriggers(session, 7, ((Row)object5).getData(), null, null);
                continue;
            }
            object4.fireTriggers(session, 8, ((Row)object5).getData(), objectArray2, nArray);
        }
        if (table.isView) {
            return n3;
        }
        rowSetNavigatorDataChange.beforeFirst();
        boolean bl2 = false;
        n2 = 0;
        while (rowSetNavigatorDataChange.next()) {
            Row row = rowSetNavigatorDataChange.getCurrentRow();
            object4 = rowSetNavigatorDataChange.getCurrentChangedData();
            table2 = (Table)row.getTable();
            object3 = table2.getRowStore(session);
            session.addDeleteAction(table2, (PersistentStore)object3, row, null);
            if (rowSetNavigator != null) {
                objectArray = this.getGeneratedColumns(row.getData());
                rowSetNavigator.add(objectArray);
            }
            if (object4 != null) {
                bl2 = true;
            }
            if (!table2.isSystemVersioned()) continue;
            n2 = 1;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl2 || n2 != 0) {
            while (rowSetNavigatorDataChange.next()) {
                Row row = rowSetNavigatorDataChange.getCurrentRow();
                object4 = rowSetNavigatorDataChange.getCurrentChangedData();
                table2 = (Table)row.getTable();
                object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                objectArray = table2.getRowStore(session);
                if (table2.isSystemVersioned()) {
                    object2 = row.getData();
                    object = table2.insertSystemVersionHistoryRow(session, (PersistentStore)objectArray, (Object[])object2);
                }
                if (object4 == null) continue;
                object2 = table2.insertSingleRow(session, (PersistentStore)objectArray, (Object[])object4, (int[])object3);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        OrderedHashSet<Object> orderedHashSet = null;
        object4 = null;
        boolean bl3 = bl = table.triggerLists[4].length > 0;
        if (n3 != rowSetNavigatorDataChange.getSize()) {
            while (rowSetNavigatorDataChange.next()) {
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object3).getTable();
                if (objectArray != null) {
                    this.performIntegrityChecks(session, (Table)object, ((Row)object3).getData(), objectArray, (int[])object2);
                }
                if (object == table) continue;
                if (objectArray == null) {
                    if (((Table)object).triggerLists[4].length > 0) {
                        bl = true;
                    }
                    if (object4 == null) {
                        object4 = new OrderedHashSet();
                    }
                    object4.add(object);
                    continue;
                }
                if (((Table)object).triggerLists[5].length > 0) {
                    bl = true;
                }
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet<Object>();
                }
                orderedHashSet.add(object);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        if (bl) {
            while (rowSetNavigatorDataChange.next()) {
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object2 = (Table)((Row)object3).getTable();
                if (objectArray == null) {
                    ((Table)object2).fireTriggers(session, 4, ((Row)object3).getData(), null, null);
                    continue;
                }
                ((Table)object2).fireTriggers(session, 5, ((Row)object3).getData(), objectArray, null);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        table.fireTriggers(session, 1, rowSetNavigatorDataChange);
        if (orderedHashSet != null) {
            for (int i3 = 0; i3 < orderedHashSet.size(); ++i3) {
                objectArray = (Table)orderedHashSet.get(i3);
                objectArray.fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        if (object4 != null) {
            for (int i4 = 0; i4 < object4.size(); ++i4) {
                objectArray = (Table)object4.get(i4);
                objectArray.fireTriggers(session, 1, rowSetNavigatorDataChange);
            }
        }
        return n3;
    }

    void performIntegrityChecks(Session session, Table table, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n2;
        if (objectArray2 == null) {
            return;
        }
        Expression expression = this.rangeVariables[0].filterCondition;
        if (expression != null) {
            RangeIterator rangeIterator = session.sessionContext.getCheckIterator(this.rangeVariables[0]);
            rangeIterator.setCurrent(objectArray2);
            if (!expression.testCondition(session)) {
                throw Error.error(5700);
            }
        }
        int n3 = table.checkConstraints.length;
        for (n2 = 0; n2 < n3; ++n2) {
            table.checkConstraints[n2].checkInsert(session, table, objectArray2, objectArray);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        n3 = table.fkConstraints.length;
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl = objectArray == null;
            Constraint constraint = table.fkConstraints[n2];
            int[] nArray2 = constraint.getRefColumns();
            if (!bl) {
                bl = ArrayUtil.haveCommonElement(nArray2, nArray);
            }
            if (!bl) continue;
            constraint.checkInsert(session, table, objectArray2, objectArray);
        }
    }

    static void performReferentialActions(Session session, RowSetNavigatorDataChange rowSetNavigatorDataChange, Row row, Object[] objectArray, int[] nArray, HashSet hashSet, boolean bl) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean bl2 = objectArray == null;
        Table table = (Table)row.getTable();
        for (Constraint constraint : table.fkMainConstraints) {
            int n2 = bl2 ? constraint.getDeleteAction() : constraint.getUpdateAction();
            if (bl ^ (bl2 && n2 == 0) || !bl2 && (!ArrayUtil.haveCommonElement(nArray, constraint.core.mainCols) || constraint.core.mainIndex.compareRowNonUnique(session, row.getData(), objectArray, constraint.core.mainCols) == 0)) continue;
            RowIterator rowIterator = constraint.findFkRef(session, row.getData());
            block12: while (rowIterator.next()) {
                String[] stringArray;
                Row row2 = rowIterator.getCurrentRow();
                Object[] objectArray2 = null;
                if (constraint.core.refIndex.compareRowNonUnique(session, row2.getData(), row.getData(), constraint.core.mainCols) != 0) break;
                if (bl2 && row2.getId() == row.getId() || !row2.isCurrentSystemVersion()) continue;
                switch (n2) {
                    case 0: {
                        int n3;
                        if (bl2) {
                            try {
                                n3 = rowSetNavigatorDataChange.addRow(row2) ? 1 : 0;
                            }
                            catch (HsqlException hsqlException) {
                                String[] stringArray2 = StatementDML.getConstraintInfo(constraint);
                                rowIterator.release();
                                throw Error.error(null, 3900, 2, stringArray2);
                            }
                            if (n3 == 0) continue block12;
                            StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row2, null, null, hashSet, bl);
                            continue block12;
                        }
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray2[constraint.core.refCols[n3]] = objectArray[constraint.core.mainCols[n3]];
                        }
                        break;
                    }
                    case 2: {
                        int n3;
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray2[constraint.core.refCols[n3]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int n3;
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            stringArray = constraint.core.refTable.getColumn(constraint.core.refCols[n3]);
                            objectArray2[constraint.core.refCols[n3]] = stringArray.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (bl2 ? rowSetNavigatorDataChange.containsDeletedRow(row2) : rowSetNavigatorDataChange.containsUpdatedRow(row, row2, constraint.core.mainCols)) continue block12;
                    }
                    case 1: {
                        int n3 = constraint.getDeleteAction() == 3 ? 8 : 3501;
                        stringArray = StatementDML.getConstraintInfo(constraint);
                        rowIterator.release();
                        throw Error.error(null, n3, 2, stringArray);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    objectArray2 = rowSetNavigatorDataChange.addRow(session, row2, objectArray2, constraint.core.refTable.getColumnTypes(), constraint.core.refCols);
                }
                catch (HsqlException hsqlException) {
                    stringArray = StatementDML.getConstraintInfo(constraint);
                    rowIterator.release();
                    throw Error.error(null, 3900, 2, stringArray);
                }
                if (objectArray2 == null || !hashSet.add(constraint)) continue;
                StatementDML.performReferentialActions(session, rowSetNavigatorDataChange, row2, objectArray2, constraint.core.refCols, hashSet, bl);
                hashSet.remove(constraint);
            }
            rowIterator.release();
        }
    }

    static String[] getConstraintInfo(Constraint constraint) {
        return new String[]{constraint.core.refName.name, constraint.core.refTable.getName().name};
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

