/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyLongValueHashMap;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.LobData;

public class SessionData {
    private final Database database;
    private final Session session;
    public PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    Object currentValue;
    HashMap sequenceMap;
    HashMap sequenceUpdateMap;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getSubqueryRowStore(TableBase tableBase) {
        PersistentStore persistentStore = this.persistentStoreCollection.getStore(tableBase);
        persistentStore.removeAll();
        return persistentStore;
    }

    public PersistentStore getNewResultRowStore(TableBase tableBase, boolean bl) {
        try {
            PersistentStore persistentStore = this.persistentStoreCollection.getStore(tableBase);
            if (!bl) {
                persistentStore.setMemory(true);
            }
            return persistentStore;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result result, Result result2) {
        int n2 = result.rsProperties;
        int n3 = result2.getStatement().getResultProperties();
        if (n2 != n3) {
            if (ResultProperties.isUpdatable(n2) && ResultProperties.isReadOnly(n3)) {
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(n2)) {
                this.session.addWarning(Error.error(4711));
            }
            n3 = ResultProperties.addScrollable(n3, ResultProperties.isScrollable(n2));
            result2.rsProperties = n3 = ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2));
        }
    }

    Result getDataResultHead(Result result, Result result2, boolean bl) {
        int n2 = result.getFetchSize();
        result2.setResultId(this.session.actionTimestamp);
        int n3 = result.rsProperties;
        int n4 = result2.rsProperties;
        if (n3 != n4) {
            n4 = ResultProperties.isReadOnly(n3) ? ResultProperties.addHoldable(n4, ResultProperties.isHoldable(n3)) : (ResultProperties.isReadOnly(n4) ? ResultProperties.addHoldable(n4, ResultProperties.isHoldable(n3)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(n4, ResultProperties.isHoldable(n3)) : ResultProperties.addHoldable(n4, false)));
            result2.rsProperties = n4 = ResultProperties.addScrollable(n4, ResultProperties.isScrollable(n3));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (ResultProperties.isUpdatable(result2.rsProperties)) {
            bl2 = true;
        }
        if (bl) {
            if (n2 != 0 && result2.getNavigator().getSize() > n2) {
                bl3 = true;
                bl2 = true;
            }
        } else if (!result2.getNavigator().isMemory()) {
            bl2 = true;
        }
        if (bl2) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result2.getResultId(), result2);
            result2.rsProperties = ResultProperties.addIsHeld(result2.rsProperties, true);
        }
        if (bl3) {
            result2 = Result.newDataHeadResult(this.session, result2, 0, n2);
        }
        return result2;
    }

    Result getDataResultSlice(long l2, int n2, int n3) {
        Result result = (Result)this.resultMap.get(l2);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (n2 + n3 > rowSetNavigator.getSize()) {
            n3 = rowSetNavigator.getSize() - n2;
        }
        return Result.newDataRowsResult(result, n2, n3);
    }

    Result getDataResult(long l2) {
        Result result = (Result)this.resultMap.get(l2);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long l2, int n2, int n3) {
        Result result = (Result)this.resultMap.get(l2);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (n2 + n3 > rowSetNavigator.getSize()) {
            n3 = rowSetNavigator.getSize() - n2;
        }
        return new RowSetNavigatorClient(rowSetNavigator, n2, n3);
    }

    public void closeNavigator(long l2) {
        Result result = (Result)this.resultMap.remove(l2);
        if (result != null) {
            result.getNavigator().release();
        }
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            result.getNavigator().release();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().release();
            iterator.remove();
        }
    }

    public void adjustLobUsageCount(LobData lobData, int n2) {
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        if (lobData == null) {
            return;
        }
        this.database.lobManager.adjustUsageCount(this.session, lobData.getId(), n2);
    }

    public void adjustLobUsageCount(TableBase tableBase, Object[] objectArray, int n2) {
        if (!tableBase.hasLobColumn) {
            return;
        }
        if (tableBase.isTemp) {
            return;
        }
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        for (int i2 = 0; i2 < tableBase.columnCount; ++i2) {
            Object object;
            if (!tableBase.colTypes[i2].isLobType() || (object = objectArray[i2]) == null) continue;
            this.database.lobManager.adjustUsageCount(this.session, ((LobData)object).getId(), n2);
        }
    }

    public Result allocateLobForResult(ResultLob resultLob) {
        Result result = Result.updateZeroResult;
        InputStream inputStream = resultLob.getInputStream();
        long l2 = resultLob.getLobID();
        long l3 = resultLob.getBlockLength();
        try {
            switch (resultLob.getSubType()) {
                case 7: {
                    l3 = resultLob.getBlockLength();
                    if (l2 >= 0L) {
                        if (l3 < 0L) {
                            result = this.allocateBlobSegments(resultLob, inputStream);
                            break;
                        }
                        result = this.database.lobManager.setBytesForNewBlob(l2, inputStream, l3);
                        break;
                    }
                    BlobDataID blobDataID = this.session.createBlob(l3);
                    this.resultLobs.put(l2, blobDataID.getId());
                    l2 = blobDataID.getId();
                    result = this.database.lobManager.setBytesForNewBlob(l2, inputStream, l3);
                    break;
                }
                case 8: {
                    if (l2 >= 0L) {
                        if (l3 < 0L) {
                            result = this.allocateClobSegments(resultLob, resultLob.getReader());
                            break;
                        }
                        if (resultLob.getReader() != null) {
                            inputStream = new ReaderInputStream(resultLob.getReader());
                        }
                        result = this.database.lobManager.setCharsForNewClob(l2, inputStream, resultLob.getBlockLength());
                        break;
                    }
                    ClobDataID clobDataID = this.session.createClob(l3);
                    this.resultLobs.put(l2, clobDataID.getId());
                    l2 = clobDataID.getId();
                    result = this.database.lobManager.setCharsForNewClob(l2, inputStream, resultLob.getBlockLength());
                    break;
                }
                case 2: {
                    if (l2 < 0L) {
                        l2 = this.resultLobs.get(l2);
                    }
                    byte[] byArray = resultLob.getByteArray();
                    result = this.database.lobManager.setBytes(l2, resultLob.getOffset(), byArray, (int)l3);
                    break;
                }
                case 4: {
                    if (l2 < 0L) {
                        l2 = this.resultLobs.get(l2);
                    }
                    char[] cArray = resultLob.getCharArray();
                    result = this.database.lobManager.setChars(l2, resultLob.getOffset(), cArray, (int)l3);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            this.resultLobs.clear();
            throw Error.error(458, throwable);
        }
        return result;
    }

    Result allocateBlobSegments(ResultLob resultLob, InputStream inputStream) throws IOException {
        long l2 = resultLob.getOffset();
        int n2 = this.session.getStreamBlockSize();
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n2);
        Result result = null;
        long l3 = 0L;
        do {
            hsqlByteArrayOutputStream.reset();
            hsqlByteArrayOutputStream.write(inputStream, n2);
            if (hsqlByteArrayOutputStream.size() == 0) break;
            byte[] byArray = hsqlByteArrayOutputStream.getBuffer();
            result = this.database.lobManager.setBytes(resultLob.getLobID(), l2, byArray, hsqlByteArrayOutputStream.size());
            if (result.isError()) break;
            l2 += (long)hsqlByteArrayOutputStream.size();
            l3 += (long)hsqlByteArrayOutputStream.size();
        } while (hsqlByteArrayOutputStream.size() >= n2);
        if (result == null) {
            result = ResultLob.newLobSetResponse(resultLob.getLobID(), l3);
        }
        return result;
    }

    private Result allocateClobSegments(ResultLob resultLob, Reader reader) throws IOException {
        return this.allocateClobSegments(resultLob.getLobID(), resultLob.getOffset(), reader);
    }

    private Result allocateClobSegments(long l2, long l3, Reader reader) throws IOException {
        int n2 = this.session.getStreamBlockSize();
        CharArrayWriter charArrayWriter = new CharArrayWriter(n2);
        long l4 = l3;
        do {
            charArrayWriter.reset();
            charArrayWriter.write(reader, n2);
            char[] cArray = charArrayWriter.getBuffer();
            if (charArrayWriter.size() == 0) {
                return Result.updateZeroResult;
            }
            Result result = this.database.lobManager.setChars(l2, l4, cArray, charArrayWriter.size());
            if (result.isError()) {
                return result;
            }
            l4 += (long)charArrayWriter.size();
        } while (charArrayWriter.size() >= n2);
        return Result.updateZeroResult;
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (rowSetNavigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (rowSetNavigator.next()) {
                Object[] objectArray = rowSetNavigator.getCurrent();
                this.registerLobsForRow(objectArray);
            }
            rowSetNavigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            long l2;
            LobData lobData;
            if (objectArray[i2] instanceof BlobDataID) {
                lobData = (BlobDataID)objectArray[i2];
                l2 = lobData.getId();
                if (l2 < 0L) {
                    l2 = this.resultLobs.get(l2);
                }
                objectArray[i2] = this.database.lobManager.getBlob(l2);
                continue;
            }
            if (!(objectArray[i2] instanceof ClobDataID)) continue;
            lobData = (ClobDataID)objectArray[i2];
            l2 = lobData.getId();
            if (l2 < 0L) {
                l2 = this.resultLobs.get(l2);
            }
            objectArray[i2] = this.database.lobManager.getClob(l2);
        }
    }

    ClobData createClobFromFile(String string, String string2) {
        File file = this.getFile(string);
        long l2 = file.length();
        InputStream inputStream = null;
        try {
            ClobDataID clobDataID = this.session.createClob(l2);
            inputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            this.allocateClobSegments(clobDataID.getId(), 0L, inputStreamReader);
            ClobDataID clobDataID2 = clobDataID;
            return clobDataID2;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    BlobData createBlobFromFile(String string) {
        File file = this.getFile(string);
        long l2 = file.length();
        InputStream inputStream = null;
        try {
            BlobDataID blobDataID = this.session.createBlob(l2);
            inputStream = new FileInputStream(file);
            this.database.lobManager.setBytesForNewBlob(blobDataID.getId(), inputStream, l2);
            BlobDataID blobDataID2 = blobDataID;
            return blobDataID2;
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private File getFile(String string) {
        this.session.checkAdmin();
        String string2 = this.database.logger.getSecurePath(string, false, false);
        if (string2 == null) {
            throw Error.error(457, string);
        }
        File file = new File(string2);
        boolean bl = file.exists();
        if (!bl) {
            throw Error.error(452);
        }
        return file;
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence numberSequence) {
        HsqlNameManager.HsqlName hsqlName;
        Object object;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateMap = new HashMap();
        }
        if ((object = this.sequenceMap.get(hsqlName = numberSequence.getName())) == null) {
            object = numberSequence.getValueObject();
            this.sequenceMap.put(hsqlName, object);
            this.sequenceUpdateMap.put(numberSequence, object);
        }
        return object;
    }

    public Object getSequenceCurrent(NumberSequence numberSequence) {
        return this.sequenceUpdateMap == null ? null : this.sequenceUpdateMap.get(numberSequence);
    }
}

