/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;

public class RangeVariableResolver {
    Session session;
    QuerySpecification select;
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    SortAndSlice sortAndSlice = SortAndSlice.noSort;
    boolean reorder;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryConditions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean expandInExpression = true;
    int firstLeftJoinIndex;
    int firstRightJoinIndex;
    int lastRightJoinIndex;
    int firstLateralJoinIndex;
    int firstOuterJoinIndex;
    int lastOuterJoinIndex;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    IntKeyIntValueHashMap colIndexSetOther = new IntKeyIntValueHashMap();
    OrderedHashSet tempSet = new OrderedHashSet();
    HashMap tempMap = new HashMap();
    MultiValueHashMap tempMultiMap = new MultiValueHashMap();

    RangeVariableResolver(Session session, QuerySpecification querySpecification) {
        this.session = session;
        this.select = querySpecification;
        this.rangeVariables = querySpecification.rangeVariables;
        this.conditions = querySpecification.queryCondition;
        this.compileContext = querySpecification.compileContext;
        this.sortAndSlice = querySpecification.sortAndSlice;
        this.reorder = true;
        this.initialise();
    }

    RangeVariableResolver(Session session, RangeVariable[] rangeVariableArray, Expression expression, ParserDQL.CompileContext compileContext, boolean bl) {
        this.session = session;
        this.rangeVariables = rangeVariableArray;
        this.conditions = expression;
        this.compileContext = compileContext;
        this.reorder = bl;
        this.initialise();
    }

    private void initialise() {
        int n2;
        this.firstLeftJoinIndex = this.rangeVariables.length;
        this.firstRightJoinIndex = this.rangeVariables.length;
        this.firstLateralJoinIndex = this.rangeVariables.length;
        this.firstOuterJoinIndex = this.rangeVariables.length;
        this.inExpressions = new Expression[this.rangeVariables.length];
        this.inInJoin = new boolean[this.rangeVariables.length];
        this.tempJoinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.tempJoinExpressions[n2] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.joinExpressions[n2] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.whereExpressions[n2] = new HsqlArrayList();
        }
        this.queryConditions.clear();
    }

    void processConditions() {
        Object object;
        int n2;
        if (this.session.sessionOptimization < 8) {
            this.reorder = false;
        }
        RangeVariableResolver.decomposeAndConditions(this.session, this.conditions, this.queryConditions);
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.rangeVarSet.add(this.rangeVariables[n2]);
            if (this.rangeVariables[n2].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(this.session, this.rangeVariables[n2].joinCondition, this.tempJoinExpressions[n2]);
        }
        for (n2 = 0; n2 < this.queryConditions.size(); ++n2) {
            int n3;
            object = (Expression)this.queryConditions.get(n2);
            if (((Expression)object).isTrue() || !((Expression)object).isSingleColumnEqual && !((Expression)object).isColumnCondition) continue;
            RangeVariable rangeVariable = ((Expression)object).getLeftNode().getRangeVariable();
            if (((Expression)object).getLeftNode().opType == 2 && rangeVariable != null && (n3 = this.rangeVarSet.getIndex(rangeVariable)) > 0) {
                this.rangeVariables[n3].isLeftJoin = false;
            }
            rangeVariable = ((Expression)object).getRightNode().getRangeVariable();
            if (((Expression)object).getRightNode().opType != 2 || rangeVariable == null || (n3 = this.rangeVarSet.getIndex(rangeVariable)) <= 0) continue;
            this.rangeVariables[n3].isLeftJoin = false;
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            object = this.rangeVariables[n2];
            boolean bl = false;
            if (((RangeVariable)object).isLeftJoin) {
                if (this.firstLeftJoinIndex == this.rangeVariables.length) {
                    this.firstLeftJoinIndex = n2;
                }
                bl = true;
            }
            if (((RangeVariable)object).isRightJoin) {
                if (this.firstRightJoinIndex == this.rangeVariables.length) {
                    this.firstRightJoinIndex = n2;
                }
                this.lastRightJoinIndex = n2;
                bl = true;
            }
            if (((RangeVariable)object).isLateral) {
                if (this.firstLateralJoinIndex == this.rangeVariables.length) {
                    this.firstLateralJoinIndex = n2;
                }
                bl = true;
            }
            if (!bl) continue;
            if (this.firstOuterJoinIndex == this.rangeVariables.length) {
                this.firstOuterJoinIndex = n2;
            }
            this.lastOuterJoinIndex = n2;
        }
        this.expandConditions();
        this.conditions = null;
        this.reorder();
        this.assignToLists();
        this.assignToRangeVariables();
        if (this.select != null) {
            this.select.startInnerRange = 0;
            this.select.endInnerRange = this.rangeVariables.length;
            if (this.firstRightJoinIndex < this.rangeVariables.length) {
                this.select.startInnerRange = this.firstRightJoinIndex;
            }
            if (this.firstLeftJoinIndex < this.rangeVariables.length) {
                this.select.endInnerRange = this.firstLeftJoinIndex;
            }
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.rangeVariables[n2].rangePositionInJoin = n2;
        }
        if (this.expandInExpression && this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    static Expression decomposeAndConditions(Session session, Expression expression, List list) {
        if (expression == null) {
            return Expression.EXPR_TRUE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n2 = expression.getType();
        if (n2 == 49) {
            expression2 = RangeVariableResolver.decomposeAndConditions(session, expression2, list);
            expression3 = RangeVariableResolver.decomposeAndConditions(session, expression3, list);
            if (expression2.isTrue()) {
                return expression3;
            }
            if (expression3.isTrue()) {
                return expression2;
            }
            expression.setLeftNode(expression2);
            expression.setRightNode(expression3);
            return expression;
        }
        if (n2 == 40 && expression2.getType() == 25 && expression3.getType() == 25) {
            for (int i2 = 0; i2 < expression2.nodes.length; ++i2) {
                ExpressionLogical expressionLogical = new ExpressionLogical(expression2.nodes[i2], expression3.nodes[i2]);
                ((Expression)expressionLogical).resolveTypes(session, null);
                list.add(expressionLogical);
            }
            return Expression.EXPR_TRUE;
        }
        if (!expression.isTrue()) {
            list.add(expression);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression expression, List list) {
        if (expression == null) {
            return Expression.EXPR_FALSE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n2 = expression.getType();
        if (n2 == 50) {
            expression2 = RangeVariableResolver.decomposeOrConditions(expression2, list);
            expression3 = RangeVariableResolver.decomposeOrConditions(expression3, list);
            if (expression2.isFalse()) {
                return expression3;
            }
            if (expression3.isFalse()) {
                return expression2;
            }
            expression = new ExpressionLogical(50, expression2, expression3);
            return expression;
        }
        if (!expression.isFalse()) {
            list.add(expression);
        }
        return Expression.EXPR_FALSE;
    }

    void expandConditions() {
        int n2;
        List[] listArray = this.tempJoinExpressions;
        if (this.firstRightJoinIndex == this.rangeVariables.length) {
            this.moveConditions(this.tempJoinExpressions, 0, this.firstOuterJoinIndex, this.queryConditions, -1);
        }
        if (this.firstOuterJoinIndex < 2) {
            return;
        }
        for (n2 = 0; n2 < this.firstOuterJoinIndex; ++n2) {
            this.moveConditions(this.tempJoinExpressions, 0, this.firstOuterJoinIndex, this.tempJoinExpressions[n2], n2);
        }
        if (this.firstOuterJoinIndex < 3) {
            return;
        }
        for (n2 = 0; n2 < this.firstOuterJoinIndex; ++n2) {
            Expression expression;
            Object object;
            Expression expression2;
            HsqlArrayList hsqlArrayList = listArray[n2];
            this.tempMultiMap.clear();
            this.tempSet.clear();
            this.tempMap.clear();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i2 = 0; i2 < hsqlArrayList.size(); ++i2) {
                expression2 = (Expression)hsqlArrayList.get(i2);
                if (expression2.isTrue()) continue;
                if (expression2.isSingleColumnEqual) {
                    bl = true;
                    if (expression2.getLeftNode().opType == 2) {
                        this.tempMap.put(expression2.getLeftNode().getColumn(), expression2.getRightNode());
                        continue;
                    }
                    if (expression2.getRightNode().opType != 2) continue;
                    this.tempMap.put(expression2.getRightNode().getColumn(), expression2.getLeftNode());
                    continue;
                }
                if (!expression2.isColumnEqual || expression2.getLeftNode().getRangeVariable() == expression2.getRightNode().getRangeVariable() || expression2.getLeftNode().getRangeVariable() == null || expression2.getRightNode().getRangeVariable() == null) continue;
                int n3 = this.rangeVarSet.getIndex(expression2.getLeftNode().getRangeVariable());
                if (n3 < 0) {
                    expression2.isSingleColumnEqual = true;
                    expression2.isSingleColumnCondition = true;
                    this.tempMap.put(expression2.getRightNode().getColumn(), expression2.getLeftNode());
                    continue;
                }
                if (n3 >= this.firstOuterJoinIndex) continue;
                n3 = this.rangeVarSet.getIndex(expression2.getRightNode().getRangeVariable());
                if (n3 < 0) {
                    expression2.isSingleColumnEqual = true;
                    expression2.isSingleColumnCondition = true;
                    this.tempMap.put(expression2.getRightNode().getColumn(), expression2.getLeftNode());
                    continue;
                }
                if (n3 >= this.firstOuterJoinIndex) continue;
                bl2 = true;
                if (expression2.getLeftNode().getRangeVariable() == this.rangeVariables[n2]) {
                    object = expression2.getLeftNode().getColumn();
                    this.tempMultiMap.put(object, expression2.getRightNode());
                    if (this.tempMultiMap.valueCount(object) <= 1) continue;
                    bl3 = true;
                    continue;
                }
                if (expression2.getRightNode().getRangeVariable() != this.rangeVariables[n2]) continue;
                object = expression2.getRightNode().getColumn();
                this.tempMultiMap.put(object, expression2.getLeftNode());
                if (this.tempMultiMap.valueCount(object) <= 1) continue;
                bl3 = true;
            }
            if (bl3) {
                Iterator iterator = this.tempMultiMap.keySet().iterator();
                while (iterator.hasNext()) {
                    expression2 = iterator.next();
                    Iterator iterator2 = this.tempMultiMap.getValuesIterator(expression2);
                    this.tempSet.clear();
                    while (iterator2.hasNext()) {
                        this.tempSet.add(iterator2.next());
                    }
                    while (this.tempSet.size() > 1) {
                        object = (Expression)this.tempSet.remove(this.tempSet.size() - 1);
                        for (int i3 = 0; i3 < this.tempSet.size(); ++i3) {
                            expression = (Expression)this.tempSet.get(i3);
                            this.closeJoinChain(listArray, (Expression)object, expression);
                        }
                    }
                }
            }
            if (!bl2 || !bl) continue;
            Iterator iterator = this.tempMultiMap.keySet().iterator();
            while (iterator.hasNext()) {
                expression2 = iterator.next();
                Expression expression3 = (Expression)this.tempMap.get(expression2);
                if (expression3 == null) continue;
                object = this.tempMultiMap.getValuesIterator(expression2);
                while (object.hasNext()) {
                    Expression expression4 = (Expression)object.next();
                    expression = new ExpressionLogical(expression3, expression4);
                    int n4 = this.rangeVarSet.getIndex(expression4.getRangeVariable());
                    listArray[n4].add(expression);
                }
            }
        }
    }

    void moveConditions(List[] listArray, int n2, int n3, List list, int n4) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Expression expression = (Expression)list.get(i2);
            this.tempSet.clear();
            expression.collectRangeVariables(this.rangeVariables, this.tempSet);
            int n5 = this.rangeVarSet.getSmallestIndex(this.tempSet);
            if (n5 < n2 || (n5 = this.rangeVarSet.getLargestIndex(this.tempSet)) >= n3 || n5 == n4) continue;
            list.remove(i2);
            listArray[n5].add(expression);
            --i2;
        }
    }

    void closeJoinChain(List[] listArray, Expression expression, Expression expression2) {
        int n2;
        int n3;
        int n4 = this.rangeVarSet.getIndex(expression.getRangeVariable());
        int n5 = n3 = n4 > (n2 = this.rangeVarSet.getIndex(expression2.getRangeVariable())) ? n4 : n2;
        if (n4 == -1 || n2 == -1) {
            return;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(expression, expression2);
        for (int i2 = 0; i2 < listArray[n3].size(); ++i2) {
            if (!expressionLogical.equals(listArray[n3].get(i2))) continue;
            return;
        }
        listArray[n3].add(expressionLogical);
    }

    void reorder() {
        if (!this.reorder) {
            return;
        }
        if (this.rangeVariables.length == 1 || this.firstRightJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.firstLeftJoinIndex == 1) {
            return;
        }
        if (this.firstLateralJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.sortAndSlice.usingIndex && this.sortAndSlice.primaryTableIndex != null) {
            return;
        }
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        HsqlArrayList<Expression> hsqlArrayList2 = new HsqlArrayList<Expression>();
        for (int i2 = 0; i2 < this.firstLeftJoinIndex; ++i2) {
            HsqlArrayList hsqlArrayList3 = this.tempJoinExpressions[i2];
            for (int i3 = 0; i3 < hsqlArrayList3.size(); ++i3) {
                Expression expression = (Expression)hsqlArrayList3.get(i3);
                if (expression.isColumnEqual) {
                    hsqlArrayList.add(expression);
                    continue;
                }
                if (!expression.isSingleColumnCondition) continue;
                hsqlArrayList2.add(expression);
            }
        }
        this.reorderRanges(hsqlArrayList2, hsqlArrayList);
    }

    void reorderRanges(HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) {
        int n2;
        int n3;
        Object object;
        Object object2;
        if (hsqlArrayList.size() == 0) {
            return;
        }
        int n4 = -1;
        RangeVariable rangeVariable = null;
        double d2 = 1024.0;
        for (int i2 = 0; i2 < this.firstLeftJoinIndex; ++i2) {
            Table table = this.rangeVariables[i2].rangeTable;
            if (table instanceof TableDerived) continue;
            this.collectIndexableColumns(this.rangeVariables[i2], hsqlArrayList);
            object2 = table.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            object = null;
            for (n3 = 0; n3 < ((Index.IndexUse[])object2).length; ++n3) {
                object = object2[n3].index;
                double d3 = this.searchCost(this.session, table, (Index)object, object2[n3].columnCount, 40);
                if (!(d3 < d2)) continue;
                d2 = d3;
                n4 = i2;
            }
            if (object == null) {
                Iterator iterator = this.colIndexSetOther.keySet().iterator();
                while (iterator.hasNext()) {
                    int n5 = iterator.nextInt();
                    object = table.getIndexForColumn(this.session, n5);
                    if (object == null) continue;
                    d2 = (double)table.getRowStore(this.session).elementCount() / 2.0;
                    if (this.colIndexSetOther.get(n5, 0) <= 1) break;
                    d2 /= 2.0;
                    break;
                }
            }
            if (object == null || i2 != 0) continue;
            n4 = 0;
            break;
        }
        if (n4 < 0) {
            return;
        }
        if (n4 == 0 && this.firstLeftJoinIndex == 2) {
            return;
        }
        RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length];
        ArrayUtil.copyArray(this.rangeVariables, rangeVariableArray, this.rangeVariables.length);
        rangeVariable = rangeVariableArray[n4];
        rangeVariableArray[n4] = rangeVariableArray[0];
        rangeVariableArray[0] = rangeVariable;
        for (n4 = 1; n4 < this.firstLeftJoinIndex; ++n4) {
            int n6;
            boolean bl = false;
            for (n6 = 0; n6 < hsqlArrayList2.size(); ++n6) {
                object = (Expression)hsqlArrayList2.get(n6);
                if (object == null || (n3 = this.getJoinedRangePosition((Expression)object, n4, rangeVariableArray)) < n4) continue;
                rangeVariable = rangeVariableArray[n4];
                rangeVariableArray[n4] = rangeVariableArray[n3];
                rangeVariableArray[n3] = rangeVariable;
                hsqlArrayList2.set(n6, null);
                bl = true;
                break;
            }
            if (bl) continue;
            for (n6 = 0; n6 < hsqlArrayList.size(); ++n6) {
                object = rangeVariableArray[n6].rangeTable;
                this.collectIndexableColumns(rangeVariableArray[n6], hsqlArrayList);
                Index.IndexUse[] indexUseArray = ((Table)object).getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
                if (indexUseArray.length <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        if (n4 != this.firstLeftJoinIndex) {
            return;
        }
        ArrayUtil.copyArray(rangeVariableArray, this.rangeVariables, this.rangeVariables.length);
        hsqlArrayList2.clear();
        for (n2 = 0; n2 < this.firstLeftJoinIndex; ++n2) {
            object2 = this.tempJoinExpressions[n2];
            hsqlArrayList2.addAll((Collection)object2);
            ((HsqlArrayList)object2).clear();
        }
        this.tempJoinExpressions[this.firstLeftJoinIndex - 1].addAll((Collection)hsqlArrayList2);
        this.rangeVarSet.clear();
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.rangeVarSet.add(this.rangeVariables[n2]);
        }
    }

    int getJoinedRangePosition(Expression expression, int n2, RangeVariable[] rangeVariableArray) {
        int n3 = -1;
        this.tempSet.clear();
        expression.getJoinRangeVariables(rangeVariableArray, this.tempSet);
        for (int i2 = 0; i2 < this.tempSet.size(); ++i2) {
            for (int i3 = 0; i3 < rangeVariableArray.length; ++i3) {
                if (this.tempSet.get(i2) != rangeVariableArray[i3] || i3 < n2) continue;
                if (n3 > 0) {
                    return -1;
                }
                n3 = i3;
            }
        }
        return n3;
    }

    void assignToLists() {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            if (this.rangeVariables[n2].isLeftJoin) {
                n3 = n2;
            }
            if (this.rangeVariables[n2].isRightJoin) {
                n3 = n2;
            }
            if (n3 == n2) {
                this.joinExpressions[n2].addAll((Collection)this.tempJoinExpressions[n2]);
                continue;
            }
            int n4 = n3 + 1;
            for (int i2 = 0; i2 < this.tempJoinExpressions[n2].size(); ++i2) {
                Expression expression = (Expression)this.tempJoinExpressions[n2].get(i2);
                this.assignToJoinLists(expression, this.joinExpressions, n4);
            }
        }
        for (n2 = 0; n2 < this.queryConditions.size(); ++n2) {
            this.assignToJoinLists((Expression)this.queryConditions.get(n2), this.whereExpressions, this.lastRightJoinIndex);
        }
    }

    void assignToJoinLists(Expression expression, List[] listArray, int n2) {
        if (expression == null) {
            return;
        }
        this.tempSet.clear();
        expression.collectRangeVariables(this.rangeVariables, this.tempSet);
        int n3 = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (expression instanceof ExpressionLogical && ((ExpressionLogical)expression).isTerminal) {
            n3 = listArray.length - 1;
        }
        listArray[n3].add(expression);
    }

    void assignToRangeVariables() {
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            RangeVariable.RangeVariableConditions rangeVariableConditions;
            boolean bl = false;
            if (i2 < this.firstLeftJoinIndex && this.firstRightJoinIndex == this.rangeVariables.length) {
                rangeVariableConditions = this.rangeVariables[i2].joinConditions[0];
                this.joinExpressions[i2].addAll((Collection)this.whereExpressions[i2]);
                this.setIndexConditions(rangeVariableConditions, this.joinExpressions[i2], i2, true);
                this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i2]);
                continue;
            }
            rangeVariableConditions = this.rangeVariables[i2].joinConditions[0];
            this.setIndexConditions(rangeVariableConditions, this.joinExpressions[i2], i2, true);
            rangeVariableConditions = this.rangeVariables[i2].joinConditions[0];
            if (rangeVariableConditions.hasIndex()) {
                bl = true;
            }
            this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i2]);
            rangeVariableConditions = this.rangeVariables[i2].whereConditions[0];
            for (int i3 = i2 + 1; i3 < this.rangeVariables.length; ++i3) {
                if (!this.rangeVariables[i3].isRightJoin) continue;
                this.assignToRangeVariable(this.rangeVariables[i3].whereConditions[0], this.whereExpressions[i2]);
            }
            if (!bl) {
                this.setIndexConditions(rangeVariableConditions, this.whereExpressions[i2], i2, true);
            }
            this.assignToRangeVariable(rangeVariableConditions, this.whereExpressions[i2]);
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions rangeVariableConditions, List list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = (Expression)list.get(i2);
            rangeVariableConditions.addCondition(expression);
        }
    }

    private void collectIndexableColumns(RangeVariable rangeVariable, List list) {
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Expression expression = (Expression)list.get(i2);
            if (!expression.isSingleColumnCondition) continue;
            if (expression.getLeftNode().getRangeVariable() == rangeVariable) {
                n3 = expression.getLeftNode().getColumnIndex();
            } else {
                if (expression.getRightNode().getRangeVariable() != rangeVariable) continue;
                n3 = expression.getRightNode().getColumnIndex();
            }
            if (expression.isSingleColumnEqual) {
                this.colIndexSetEqual.add(n3);
                continue;
            }
            int n4 = this.colIndexSetOther.get(n3, 0);
            this.colIndexSetOther.put(n3, n4 + 1);
        }
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List list, int n2, boolean bl) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n4 = list.size();
        block8: for (n3 = 0; n3 < n4; ++n3) {
            Expression expression = (Expression)list.get(n3);
            if (expression == null || !expression.isIndexable(rangeVariableConditions.rangeVar)) continue;
            int n5 = expression.getType();
            switch (n5) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 40: {
                    if (expression.getSubType() == 52 || expression.getSubType() == 51 || expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n6 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n6);
                    continue block8;
                }
                case 47: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n6 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n6);
                    continue block8;
                }
                case 48: {
                    if (expression.getLeftNode().getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n6 = expression.getLeftNode().getLeftNode().getColumnIndex();
                    int n7 = this.colIndexSetOther.get(n6, 0);
                    this.colIndexSetOther.put(n6, n7 + 1);
                    continue block8;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n6 = expression.getLeftNode().getColumnIndex();
                    int n7 = this.colIndexSetOther.get(n6, 0);
                    this.colIndexSetOther.put(n6, n7 + 1);
                    continue block8;
                }
                default: {
                    throw Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        this.setEqualityConditions(rangeVariableConditions, list, n2);
        boolean bl2 = rangeVariableConditions.hasIndex();
        if (!bl2) {
            this.setNonEqualityConditions(rangeVariableConditions, list, n2);
            bl2 = rangeVariableConditions.hasIndex();
        }
        if (n2 == 0 && this.sortAndSlice.usingIndex) {
            bl2 = true;
        }
        n3 = 0;
        if (!bl2 && bl) {
            int n8 = list.size();
            for (n4 = 0; n4 < n8; ++n4) {
                Expression expression = (Expression)list.get(n4);
                if (expression == null) continue;
                if (expression.getType() == 50) {
                    bl2 = this.setOrConditions(rangeVariableConditions, (ExpressionLogical)expression, n2);
                    if (!bl2) continue;
                    list.set(n4, null);
                    n3 = 1;
                    break;
                }
                if (expression.getType() != 40 || expression.exprSubType != 52 || n2 >= this.firstLeftJoinIndex || this.firstRightJoinIndex != this.rangeVariables.length || expression.getRightNode().isCorrelated()) continue;
                OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
                ((ExpressionLogical)expression).addLeftColumnsForAllAny(rangeVariableConditions.rangeVar, orderedIntHashSet);
                Index.IndexUse[] indexUseArray = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, 40, false);
                if (indexUseArray.length == 0 || this.inExpressions[n2] != null) continue;
                this.inExpressions[n2] = expression;
                this.inInJoin[n2] = rangeVariableConditions.isJoin;
                ++this.inExpressionCount;
                list.set(n4, null);
                break;
            }
        }
        int n9 = list.size();
        for (n4 = 0; n4 < n9; ++n4) {
            Expression expression = (Expression)list.get(n4);
            if (expression == null) continue;
            if (n3 != 0) {
                for (int i2 = 0; i2 < rangeVariableConditions.rangeVar.joinConditions.length; ++i2) {
                    if (rangeVariableConditions.isJoin) {
                        rangeVariableConditions.rangeVar.joinConditions[i2].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.joinConditions[i2].nonIndexCondition);
                        continue;
                    }
                    rangeVariableConditions.rangeVar.whereConditions[i2].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.whereConditions[i2].nonIndexCondition);
                }
                continue;
            }
            rangeVariableConditions.addCondition(expression);
            list.set(n4, null);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, ExpressionLogical expressionLogical, int n2) {
        Object object;
        Object object2;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariableResolver.decomposeOrConditions(expressionLogical, hsqlArrayList);
        Object[] objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
        for (int i2 = 0; i2 < hsqlArrayList.size(); ++i2) {
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            object2 = (Expression)hsqlArrayList.get(i2);
            RangeVariableResolver.decomposeAndConditions(this.session, (Expression)object2, hsqlArrayList2);
            object = new RangeVariable.RangeVariableConditions(rangeVariableConditions);
            this.setIndexConditions((RangeVariable.RangeVariableConditions)object, hsqlArrayList2, n2, false);
            objectArray[i2] = object;
            if (((RangeVariable.RangeVariableConditions)object).hasIndex()) continue;
            return false;
        }
        Expression expression = null;
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            object2 = objectArray[i3];
            objectArray[i3].excludeConditions = expression;
            if (i3 == objectArray.length - 1) break;
            object = null;
            if (((RangeVariable.RangeVariableConditions)object2).indexCond != null) {
                for (int i4 = 0; i4 < ((RangeVariable.RangeVariableConditions)object2).indexedColumnCount; ++i4) {
                    object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexCond[i4]);
                }
            }
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexEndCondition);
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).nonIndexCondition);
            expression = ExpressionLogical.orExpressions((Expression)object, expression);
        }
        if (expression != null) {
            // empty if block
        }
        if (rangeVariableConditions.isJoin) {
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.whereConditions[0]);
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
        } else {
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.joinConditions[0]);
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
        }
        return true;
    }

    private void setEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List list, int n2) {
        Object object;
        int n3;
        Object[] objectArray;
        Index index = null;
        if (n2 == 0 && this.sortAndSlice.usingIndex && (index = this.sortAndSlice.primaryTableIndex) != null) {
            rangeVariableConditions.rangeIndex = index;
        }
        if (index == null) {
            objectArray = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            if (objectArray.length == 0) {
                return;
            }
            index = objectArray[0].index;
            double d2 = Double.MAX_VALUE;
            if (objectArray.length > 1) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    object = rangeVariableConditions.rangeVar.rangeTable.getRowStore(this.session);
                    double d3 = object.searchCost(this.session, objectArray[n3].index, objectArray[n3].columnCount, 40);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    index = objectArray[n3].index;
                }
            }
        }
        objectArray = index.getColumns();
        int n4 = objectArray.length;
        Expression[] expressionArray = new Expression[objectArray.length];
        for (n3 = 0; n3 < list.size(); ++n3) {
            int n5;
            int n6;
            object = (Expression)list.get(n3);
            if (object == null || (n6 = ((Expression)object).getType()) != 40 && n6 != 47 || ((Expression)object).getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || !((Expression)object).isIndexable(rangeVariableConditions.rangeVar) || (n5 = ArrayUtil.find(objectArray, ((Expression)object).getLeftNode().getColumnIndex())) == -1 || expressionArray[n5] != null) continue;
            expressionArray[n5] = object;
            list.set(n3, null);
        }
        n3 = 0;
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            Expression expression = expressionArray[i2];
            if (expression == null) {
                if (n4 == objectArray.length) {
                    n4 = i2;
                }
                n3 = 1;
                continue;
            }
            if (n3 == 0) continue;
            list.add(expression);
            expressionArray[i2] = null;
        }
        if (n4 > 0) {
            rangeVariableConditions.addIndexCondition(expressionArray, index, n4);
        }
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List list, int n2) {
        Object object;
        int n3;
        if (this.colIndexSetOther.isEmpty()) {
            return;
        }
        int n4 = 0;
        Object object2 = null;
        if (n2 == 0 && this.sortAndSlice.usingIndex) {
            object2 = this.sortAndSlice.primaryTableIndex;
        }
        if (object2 == null) {
            Iterator iterator = this.colIndexSetOther.keySet().iterator();
            while (iterator.hasNext()) {
                int n5 = iterator.nextInt();
                n3 = this.colIndexSetOther.get(n5, 0);
                if (n3 <= n4 || (object = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumn(this.session, n5)) == null) continue;
                object2 = object;
                n4 = n3;
            }
        }
        if (object2 == null) {
            return;
        }
        int[] nArray = object2.getColumns();
        for (n3 = 0; n3 < list.size(); ++n3) {
            object = (Expression)list.get(n3);
            if (object == null) continue;
            boolean bl = false;
            switch (((Expression)object).getType()) {
                case 48: {
                    if (((Expression)object).getLeftNode().getType() != 47 || nArray[0] != ((Expression)object).getLeftNode().getLeftNode().getColumnIndex()) break;
                    bl = true;
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (nArray[0] != ((Expression)object).getLeftNode().getColumnIndex() || ((Expression)object).getRightNode() == null || ((Expression)object).getRightNode().isCorrelated()) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            Expression[] expressionArray = new Expression[object2.getColumnCount()];
            expressionArray[0] = object;
            rangeVariableConditions.addIndexCondition(expressionArray, (Index)object2, 1);
            list.set(n3, null);
            break;
        }
    }

    void setInConditionsAsTables() {
        for (int i2 = this.rangeVariables.length - 1; i2 >= 0; --i2) {
            int n2;
            int n3;
            RangeVariable rangeVariable = this.rangeVariables[i2];
            ExpressionLogical expressionLogical = (ExpressionLogical)this.inExpressions[i2];
            if (expressionLogical == null) continue;
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            expressionLogical.addLeftColumnsForAllAny(rangeVariable, orderedIntHashSet);
            Index.IndexUse[] indexUseArray = rangeVariable.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, 40, false);
            Index index = indexUseArray[0].index;
            int n4 = 0;
            for (int i3 = 0; i3 < index.getColumnCount() && orderedIntHashSet.contains(index.getColumns()[i3]); ++i3) {
                ++n4;
            }
            RangeVariable rangeVariable2 = new RangeVariable(expressionLogical.getRightNode().getTable(), null, null, null, this.compileContext);
            rangeVariable2.isGenerated = true;
            RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, rangeVariableArray, rangeVariable2, i2, 1);
            this.rangeVariables = rangeVariableArray;
            Expression[] expressionArray = new Expression[index.getColumnCount()];
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = index.getColumns()[n3];
                n2 = orderedIntHashSet.getIndex(n5);
                ExpressionLogical expressionLogical2 = new ExpressionLogical(rangeVariable, n5, rangeVariable2, n2);
                expressionArray[n3] = expressionLogical2;
            }
            n3 = this.rangeVariables[i2].isLeftJoin || this.rangeVariables[i2].isRightJoin ? 1 : 0;
            RangeVariable.RangeVariableConditions rangeVariableConditions = !this.inInJoin[i2] && n3 != 0 ? rangeVariable.whereConditions[0] : rangeVariable.joinConditions[0];
            rangeVariableConditions.addIndexCondition(expressionArray, index, n4);
            n2 = 0;
            while (n2 < orderedIntHashSet.size()) {
                int n6 = orderedIntHashSet.get(n2);
                int n7 = n2++;
                ExpressionLogical expressionLogical3 = new ExpressionLogical(rangeVariable, n6, rangeVariable2, n7);
                rangeVariableConditions.addCondition(expressionLogical3);
            }
        }
    }

    private double searchCost(Session session, Table table, Index index, int n2, int n3) {
        if (table instanceof TableDerived) {
            return 1000.0;
        }
        return table.getRowStore(session).searchCost(session, index, n2, n3);
    }
}

