/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.List;
import org.hsqldb.lib.Set;

public class ExpressionPeriod
extends Expression {
    PeriodDefinition period;
    ExpressionColumn columnExpr;

    ExpressionPeriod() {
        super(57);
    }

    ExpressionPeriod(Expression expression, Expression expression2) {
        super(57);
        this.nodes = new Expression[]{expression, expression2};
    }

    ExpressionPeriod(ExpressionColumn expressionColumn) {
        super(57);
        this.columnExpr = expressionColumn;
    }

    ExpressionPeriod(PeriodDefinition periodDefinition) {
        super(57);
        this.period = periodDefinition;
    }

    ExpressionPeriod(Expression expression) {
        super(57);
        this.nodes = expression.nodes;
    }

    boolean isNamedPeriod() {
        return this.period != null;
    }

    int getPeriodType() {
        if (this.period == null) {
            return 0;
        }
        return this.period.getPeriodType();
    }

    void setRangeVariable(RangeVariable rangeVariable) {
        Table table = rangeVariable.getTable();
        this.period = table.getSystemPeriod();
        ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, this.period.startColumn);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable, this.period.endColumn);
        this.nodes = new Expression[]{expressionColumn, expressionColumn2};
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List list, boolean bl) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            list = this.nodes[i2].resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
        }
        RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
        if (this.columnExpr != null) {
            for (int i3 = 0; i3 < n2; ++i3) {
                RangeVariable rangeVariable = rangeVariableArray[i3];
                PeriodDefinition periodDefinition = rangeVariable.findPeriod(this.columnExpr.schema, this.columnExpr.tableName, this.columnExpr.columnName);
                if (periodDefinition == null) continue;
                if (this.period == null) {
                    this.period = periodDefinition;
                    ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, this.period.startColumn);
                    ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable, this.period.endColumn);
                    this.nodes = new Expression[]{expressionColumn, expressionColumn2};
                    continue;
                }
                throw Error.error(5516);
            }
            if (this.period == null) {
                throw Error.error(5516);
            }
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].resolveTypes(session, this);
        }
    }

    @Override
    void collectObjectNames(Set set) {
        if (this.period != null) {
            set.add(this.period.getName());
        }
    }
}

