/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttSubscribe
extends MqttWireMessage {
    private String[] names;
    private int[] qos;
    private int count;

    public MqttSubscribe(byte info, byte[] data) throws IOException {
        super((byte)8);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.msgId = dis.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        this.qos = new int[10];
        boolean end = false;
        while (!end) {
            try {
                this.names[this.count] = MqttSubscribe.decodeUTF8(dis);
                this.qos[this.count++] = dis.readByte();
            }
            catch (Exception e2) {
                end = true;
            }
        }
        dis.close();
    }

    public MqttSubscribe(String[] names, int[] qos) {
        super((byte)8);
        if (names == null || qos == null) {
            throw new IllegalArgumentException();
        }
        this.names = (String[])names.clone();
        this.qos = (int[])qos.clone();
        if (this.names.length != this.qos.length) {
            throw new IllegalArgumentException();
        }
        this.count = names.length;
        int[] nArray = qos;
        int n2 = qos.length;
        int n3 = 0;
        while (n3 < n2) {
            int qo = nArray[n3];
            MqttMessage.validateQos(qo);
            ++n3;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" names:[");
        int i2 = 0;
        while (i2 < this.count) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(this.names[i2]).append("\"");
            ++i2;
        }
        sb.append("] qos:[");
        i2 = 0;
        while (i2 < this.count) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.qos[i2]);
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int i2 = 0;
            while (i2 < this.names.length) {
                MqttSubscribe.encodeUTF8(dos, this.names[i2]);
                dos.writeByte(this.qos[i2]);
                ++i2;
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

