/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.PartialHashTreeVerificationException;
import org.bouncycastle.util.Arrays;

public class PartialHashTreeProcessor {
    private final byte[][] values;

    public PartialHashTreeProcessor(PartialHashtree partialHashtree) {
        this.values = partialHashtree.getValues();
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.values.length == 1) {
            return this.values[0];
        }
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            for (int i2 = 1; i2 != this.values.length; ++i2) {
                outputStream.write(this.values[i2]);
            }
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("calculator failed: " + iOException.getMessage());
        }
    }

    public void verifyContainsHash(byte[] byArray) throws PartialHashTreeVerificationException {
        if (!this.containsHash(byArray)) {
            throw new PartialHashTreeVerificationException("calculated hash is not present in partial hash tree");
        }
    }

    public boolean containsHash(byte[] byArray) {
        for (int i2 = 1; i2 != this.values.length; ++i2) {
            if (!Arrays.areEqual(byArray, this.values[i2])) continue;
            return true;
        }
        return false;
    }
}

