/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Arrays;

final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] v) {
        int i2;
        double r = 0.0;
        double m2 = 0.0;
        double s = 0.0;
        int iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s += v[i2];
        }
        m2 = s / (double)v.length;
        s = 0.0;
        iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s += Math.abs(v[i2] - m2);
        }
        r = s / (double)v.length;
        return r;
    }

    public static double stdev(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length > 1) {
            r = Math.sqrt(StatsLib.devsq(v) / (double)(v.length - 1));
        }
        return r;
    }

    public static double var(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length > 1) {
            r = StatsLib.devsq(v) / (double)(v.length - 1);
        }
        return r;
    }

    public static double varp(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length > 1) {
            r = StatsLib.devsq(v) / (double)v.length;
        }
        return r;
    }

    public static double median(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length >= 1) {
            int n2 = v.length;
            Arrays.sort(v);
            r = n2 % 2 == 0 ? (v[n2 / 2] + v[n2 / 2 - 1]) / 2.0 : v[n2 / 2];
        }
        return r;
    }

    public static double devsq(double[] v) {
        double r = Double.NaN;
        if (v != null && v.length >= 1) {
            int i2;
            double m2 = 0.0;
            double s = 0.0;
            int n2 = v.length;
            for (i2 = 0; i2 < n2; ++i2) {
                s += v[i2];
            }
            m2 = s / (double)n2;
            s = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                s += (v[i2] - m2) * (v[i2] - m2);
            }
            r = n2 == 1 ? 0.0 : s;
        }
        return r;
    }

    public static double kthLargest(double[] v, int k2) {
        double r = Double.NaN;
        int index = k2 - 1;
        if (v != null && v.length > index && index >= 0) {
            Arrays.sort(v);
            r = v[v.length - index - 1];
        }
        return r;
    }

    public static double kthSmallest(double[] v, int k2) {
        double r = Double.NaN;
        int index = k2 - 1;
        if (v != null && v.length > index && index >= 0) {
            Arrays.sort(v);
            r = v[index];
        }
        return r;
    }
}

