/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDFCloneUtility {
    private PDDocument destination;
    private Map<Object, COSBase> clonedVersion = new HashMap<Object, COSBase>();

    public PDFCloneUtility(PDDocument dest) {
        this.destination = dest;
    }

    public PDDocument getDestination() {
        return this.destination;
    }

    public COSBase cloneForNewDocument(Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval == null) {
            if (base instanceof List) {
                COSArray array = new COSArray();
                List list = (List)base;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    array.add(this.cloneForNewDocument(list.get(i2)));
                }
                retval = array;
            } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
                retval = this.cloneForNewDocument(((COSObjectable)base).getCOSObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSObject) {
                COSObject object = (COSObject)base;
                retval = this.cloneForNewDocument(object.getObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSArray) {
                COSArray newArray = new COSArray();
                COSArray array = (COSArray)base;
                for (int i3 = 0; i3 < array.size(); ++i3) {
                    newArray.add(this.cloneForNewDocument(array.get(i3)));
                }
                retval = newArray;
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStreamArray) {
                COSStreamArray originalStream = (COSStreamArray)base;
                if (originalStream.size() > 0) {
                    throw new IllegalStateException("Cannot close stream array with items next to the streams.");
                }
                COSArray array = new COSArray();
                for (int i4 = 0; i4 < originalStream.getStreamCount(); ++i4) {
                    COSBase base2 = originalStream.get(i4);
                    COSBase cloneForNewDocument = this.cloneForNewDocument(base2);
                    array.add(cloneForNewDocument);
                }
                retval = new COSStreamArray(array);
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStream) {
                COSStream originalStream = (COSStream)base;
                PDStream stream = new PDStream(this.destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                    stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
                retval = stream.getStream();
            } else if (base instanceof COSDictionary) {
                COSDictionary dic = (COSDictionary)base;
                retval = new COSDictionary();
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
            } else {
                retval = (COSBase)base;
            }
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    public void cloneMerge(COSObjectable base, COSObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)((Object)base);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                array.add(this.cloneForNewDocument(list.get(i2)));
            }
            ((List)((Object)target)).add(array);
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            this.cloneMerge(base.getCOSObject(), target.getCOSObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSObject) {
            if (target instanceof COSObject) {
                this.cloneMerge(((COSObject)base).getObject(), ((COSObject)target).getObject());
            } else if (target instanceof COSDictionary) {
                this.cloneMerge(((COSObject)base).getObject(), (COSDictionary)target);
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            for (int i3 = 0; i3 < array.size(); ++i3) {
                ((COSArray)target).add(this.cloneForNewDocument(array.get(i3)));
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            PDStream stream = new PDStream(this.destination, originalStream.getFilteredStream(), true);
            this.clonedVersion.put(base, stream.getStream());
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream.getStream();
            target = retval;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                COSName key = entry.getKey();
                COSBase value = entry.getValue();
                if (((COSDictionary)target).getItem(key) != null) {
                    this.cloneMerge(value, ((COSDictionary)target).getItem(key));
                    continue;
                }
                ((COSDictionary)target).setItem(key, this.cloneForNewDocument(value));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
    }
}

