/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.util.Matrix;

public class RadialShadingContext
implements PaintContext {
    private ColorModel outputColorModel;
    private PDFunction function;
    private ColorSpace shadingColorSpace;
    private PDFunction shadingTinttransform;
    private PDShadingType3 shadingType;
    private float[] coords;
    private float[] domain;
    private boolean[] extend;
    private float[] background;
    private double x1x0;
    private double y1y0;
    private double r1r0;
    private double x1x0pow2;
    private double y1y0pow2;
    private double r0pow2;
    private float d1d0;
    private double denom;
    private static final Log LOG = LogFactory.getLog(RadialShadingContext.class);

    public RadialShadingContext(PDShadingType3 shadingType3, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) {
        this.shadingType = shadingType3;
        this.coords = shadingType3.getCoords().toFloatArray();
        if (ctm != null) {
            float[] coordsTemp = new float[this.coords.length];
            ctm.createAffineTransform().transform(this.coords, 0, coordsTemp, 0, 1);
            ctm.createAffineTransform().transform(this.coords, 3, coordsTemp, 3, 1);
            this.coords[2] = this.coords[2] * ctm.getXScale();
            this.coords[5] = this.coords[5] * ctm.getXScale();
            coordsTemp[1] = (float)pageHeight - coordsTemp[1];
            coordsTemp[4] = (float)pageHeight - coordsTemp[4];
            xform.transform(coordsTemp, 0, this.coords, 0, 1);
            xform.transform(coordsTemp, 3, this.coords, 3, 1);
            this.coords[2] = (float)((double)this.coords[2] * xform.getScaleX());
            this.coords[5] = (float)((double)this.coords[5] * xform.getScaleX());
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[4] = (float)pageHeight + translateY - this.coords[4];
        }
        try {
            PDColorSpace cs = this.shadingType.getColorSpace();
            if (!(cs instanceof PDDeviceRGB)) {
                this.shadingColorSpace = cs.getJavaColorSpace();
                if (cs instanceof PDDeviceN) {
                    this.shadingTinttransform = ((PDDeviceN)cs).getTintTransform();
                } else if (cs instanceof PDSeparation) {
                    this.shadingTinttransform = ((PDSeparation)cs).getTintTransform();
                }
            }
        }
        catch (IOException exception) {
            LOG.error("error while creating colorSpace", exception);
        }
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        this.domain = this.shadingType.getDomain() != null ? this.shadingType.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        COSArray extendValues = this.shadingType.getExtend();
        if (this.shadingType.getExtend() != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((COSBoolean)extendValues.get(0)).getValue();
            this.extend[1] = ((COSBoolean)extendValues.get(1)).getValue();
        } else {
            this.extend = new boolean[]{false, false};
        }
        this.x1x0 = this.coords[3] - this.coords[0];
        this.y1y0 = this.coords[4] - this.coords[1];
        this.r1r0 = this.coords[5] - this.coords[2];
        this.x1x0pow2 = Math.pow(this.x1x0, 2.0);
        this.y1y0pow2 = Math.pow(this.y1y0, 2.0);
        this.r0pow2 = Math.pow(this.coords[2], 2.0);
        this.denom = this.x1x0pow2 + this.y1y0pow2 - Math.pow(this.r1r0, 2.0);
        this.d1d0 = this.domain[1] - this.domain[0];
        COSArray bg = shadingType3.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
        }
    }

    public void dispose() {
        this.outputColorModel = null;
        this.function = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
        this.shadingType = null;
    }

    public ColorModel getColorModel() {
        return this.outputColorModel;
    }

    public Raster getRaster(int x, int y, int w, int h2) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h2);
        float inputValue = -1.0f;
        int[] data = new int[w * h2 * 4];
        for (int j2 = 0; j2 < h2; ++j2) {
            for (int i2 = 0; i2 < w; ++i2) {
                boolean useBackground = false;
                float[] inputValues = this.calculateInputValues(x + i2, y + j2);
                if (Float.isNaN(inputValues[0]) && Float.isNaN(inputValues[1])) {
                    if (this.background == null) continue;
                    useBackground = true;
                } else {
                    if (inputValues[0] >= this.domain[0] && inputValues[0] <= this.domain[1]) {
                        inputValue = inputValues[1] >= this.domain[0] && inputValues[1] <= this.domain[1] ? Math.max(inputValues[0], inputValues[1]) : inputValues[0];
                    } else if (inputValues[1] >= this.domain[0] && inputValues[1] <= this.domain[1]) {
                        inputValue = inputValues[1];
                    } else if (this.extend[0] && this.extend[1]) {
                        inputValue = Math.max(inputValues[0], inputValues[1]);
                    } else if (this.extend[0]) {
                        inputValue = inputValues[0];
                    } else if (this.extend[1]) {
                        inputValue = inputValues[1];
                    } else {
                        if (this.background == null) continue;
                        useBackground = true;
                    }
                    if (inputValue > this.domain[1]) {
                        if (this.extend[1]) {
                            inputValue = this.domain[1];
                        } else {
                            if (this.background == null) continue;
                            useBackground = true;
                        }
                    } else if (inputValue < this.domain[0]) {
                        if (this.extend[0]) {
                            inputValue = this.domain[0];
                        } else {
                            if (this.background == null) continue;
                            useBackground = true;
                        }
                    }
                }
                float[] values = null;
                int index = (j2 * w + i2) * 4;
                if (useBackground) {
                    values = this.background;
                } else {
                    try {
                        float input = this.domain[0] + this.d1d0 * inputValue;
                        values = this.shadingType.evalFunction(input);
                    }
                    catch (IOException exception) {
                        LOG.error("error while processing a function", exception);
                    }
                }
                if (this.shadingColorSpace != null) {
                    if (this.shadingTinttransform != null) {
                        try {
                            values = this.shadingTinttransform.eval(values);
                        }
                        catch (IOException exception) {
                            LOG.error("error while processing a function", exception);
                        }
                    }
                    values = this.shadingColorSpace.toRGB(values);
                }
                data[index] = (int)(values[0] * 255.0f);
                data[index + 1] = (int)(values[1] * 255.0f);
                data[index + 2] = (int)(values[2] * 255.0f);
                data[index + 3] = 255;
            }
        }
        raster.setPixels(0, 0, w, h2, data);
        return raster;
    }

    private float[] calculateInputValues(int x, int y) {
        double p = (double)(-((float)x - this.coords[0])) * this.x1x0 - (double)((float)y - this.coords[1]) * this.y1y0 - (double)this.coords[2] * this.r1r0;
        double q = Math.pow((float)x - this.coords[0], 2.0) + Math.pow((float)y - this.coords[1], 2.0) - this.r0pow2;
        double root = Math.sqrt(p * p - this.denom * q);
        float root1 = (float)((-p + root) / this.denom);
        float root2 = (float)((-p - root) / this.denom);
        if (this.denom < 0.0) {
            return new float[]{root1, root2};
        }
        return new float[]{root2, root1};
    }

    public float[] getCoords() {
        return this.coords;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public boolean[] getExtend() {
        return this.extend;
    }

    public PDFunction getShadingTintTransform() {
        return this.shadingTinttransform;
    }
}

