/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io.ccitt;

public class PackedBitArray {
    private int bitCount;
    private byte[] data;

    public PackedBitArray(int bitCount) {
        this.bitCount = bitCount;
        int byteCount = (bitCount + 7) / 8;
        this.data = new byte[byteCount];
    }

    private int byteOffset(int offset) {
        return offset / 8;
    }

    private int bitOffset(int offset) {
        return offset % 8;
    }

    public void set(int offset) {
        int byteOffset;
        int n2 = byteOffset = this.byteOffset(offset);
        this.data[n2] = (byte)(this.data[n2] | 1 << this.bitOffset(offset));
    }

    public void clear(int offset) {
        int byteOffset = this.byteOffset(offset);
        int bitOffset = this.bitOffset(offset);
        int n2 = byteOffset;
        this.data[n2] = (byte)(this.data[n2] & ~(1 << bitOffset));
    }

    public void setBits(int offset, int length, int bit) {
        if (bit == 0) {
            this.clearBits(offset, length);
        } else {
            this.setBits(offset, length);
        }
    }

    public void setBits(int offset, int length) {
        if (length == 0) {
            return;
        }
        int startBitOffset = this.bitOffset(offset);
        int firstByte = this.byteOffset(offset);
        int lastBitOffset = offset + length;
        if (lastBitOffset > this.getBitCount()) {
            throw new IndexOutOfBoundsException("offset + length > bit count");
        }
        int lastByte = this.byteOffset(lastBitOffset);
        int endBitOffset = this.bitOffset(lastBitOffset);
        if (firstByte == lastByte) {
            int mask = (1 << endBitOffset) - (1 << startBitOffset);
            int n2 = firstByte;
            this.data[n2] = (byte)(this.data[n2] | mask);
        } else {
            int n3 = firstByte;
            this.data[n3] = (byte)(this.data[n3] | 255 << startBitOffset);
            for (int i2 = firstByte + 1; i2 < lastByte; ++i2) {
                this.data[i2] = -1;
            }
            if (endBitOffset > 0) {
                int n4 = lastByte;
                this.data[n4] = (byte)(this.data[n4] | 255 >> 8 - endBitOffset);
            }
        }
    }

    public void clearBits(int offset, int length) {
        if (length == 0) {
            return;
        }
        int startBitOffset = offset % 8;
        int firstByte = this.byteOffset(offset);
        int lastBitOffset = offset + length;
        int lastByte = this.byteOffset(lastBitOffset);
        int endBitOffset = lastBitOffset % 8;
        if (firstByte == lastByte) {
            int mask = (1 << endBitOffset) - (1 << startBitOffset);
            int n2 = firstByte;
            this.data[n2] = (byte)(this.data[n2] & ~mask);
        } else {
            int n3 = firstByte;
            this.data[n3] = (byte)(this.data[n3] & ~(255 << startBitOffset));
            for (int i2 = firstByte + 1; i2 < lastByte; ++i2) {
                this.data[i2] = 0;
            }
            if (endBitOffset > 0) {
                int n4 = lastByte;
                this.data[n4] = (byte)(this.data[n4] & ~(255 >> 8 - endBitOffset));
            }
        }
    }

    public void clear() {
        this.clearBits(0, this.getBitCount());
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getByteCount() {
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return PackedBitArray.toBitString(this.data).substring(0, this.bitCount);
    }

    public static String toBitString(byte data) {
        byte[] buf = new byte[]{data};
        return PackedBitArray.toBitString(buf);
    }

    public static String toBitString(byte[] data) {
        return PackedBitArray.toBitString(data, 0, data.length);
    }

    public static String toBitString(byte[] data, int start, int len) {
        StringBuffer sb = new StringBuffer();
        int end = start + len;
        for (int x = start; x < end; ++x) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int mask = 1 << i2;
                int value = data[x] & mask;
                sb.append(value != 0 ? (char)'1' : '0');
            }
        }
        return sb.toString();
    }
}

