/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class SingleByteCharset
extends Charset {
    protected static final char REPLACEMENT_CHARACTER = '\ufffd';
    private final char[] toUnicodeMap;
    private byte[][] toByteMap;

    protected SingleByteCharset(String canonicalName, String[] aliases, char[] toUnicodeMap) {
        super(canonicalName, aliases);
        if (toUnicodeMap.length > 256) {
            throw new IllegalArgumentException("Single-byte encodings may have at most 256 characters.");
        }
        this.toUnicodeMap = new char[256];
        System.arraycopy(toUnicodeMap, 0, this.toUnicodeMap, 0, toUnicodeMap.length);
        this.initInverseMap();
    }

    private void initInverseMap() {
        this.toByteMap = new byte[256][];
        if (this.toUnicodeMap[0] != '\u0000') {
            throw new IllegalArgumentException("First character in map must be a NUL (0x0000) character.");
        }
        int len = this.toUnicodeMap.length;
        for (int i2 = 1; i2 < len; ++i2) {
            char ch = this.toUnicodeMap[i2];
            if (ch == '\ufffd') continue;
            int upper = ch >> 8;
            int lower = ch & 0xFF;
            if (upper > 255) {
                throw new IllegalArgumentException("Not a compatible character: " + ch + " (" + Integer.toHexString(ch) + ")");
            }
            byte[] map = this.toByteMap[upper];
            if (map == null) {
                map = new byte[256];
                this.toByteMap[upper] = map;
            }
            map[lower] = (byte)(i2 & 0xFF);
        }
    }

    public boolean contains(Charset cs) {
        return cs.getClass() == this.getClass();
    }

    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    private class Encoder
    extends CharsetEncoder {
        protected Encoder() {
            super(SingleByteCharset.this, 1.0f, 1.0f);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char ch = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                int upper = ch >> 8;
                int lower = ch & 0xFF;
                if (upper > 255) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                byte[] map = SingleByteCharset.this.toByteMap[upper];
                if (map == null) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                byte b2 = map[lower];
                if (b2 == 0) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(b2);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private class Decoder
    extends CharsetDecoder {
        protected Decoder() {
            super(SingleByteCharset.this, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                byte b2 = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                char ch = SingleByteCharset.this.toUnicodeMap[b2 & 0xFF];
                if (ch == '\ufffd') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(ch);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

