/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSArray
extends COSBase
implements Iterable<COSBase> {
    private List<COSBase> objects = new ArrayList<COSBase>();

    public void add(COSBase object) {
        this.objects.add(object);
    }

    public void add(COSObjectable object) {
        this.objects.add(object.getCOSObject());
    }

    public void add(int i2, COSBase object) {
        this.objects.add(i2, object);
    }

    public void clear() {
        this.objects.clear();
    }

    public void removeAll(Collection<COSBase> objectsList) {
        this.objects.removeAll(objectsList);
    }

    public void retainAll(Collection<COSBase> objectsList) {
        this.objects.retainAll(objectsList);
    }

    public void addAll(Collection<COSBase> objectsList) {
        this.objects.addAll(objectsList);
    }

    public void addAll(COSArray objectList) {
        if (objectList != null) {
            this.objects.addAll(objectList.objects);
        }
    }

    public void addAll(int i2, Collection<COSBase> objectList) {
        this.objects.addAll(i2, objectList);
    }

    public void set(int index, COSBase object) {
        this.objects.set(index, object);
    }

    public void set(int index, int intVal) {
        this.objects.set(index, COSInteger.get(intVal));
    }

    public void set(int index, COSObjectable object) {
        COSBase base = null;
        if (object != null) {
            base = object.getCOSObject();
        }
        this.objects.set(index, base);
    }

    public COSBase getObject(int index) {
        COSBase obj = this.objects.get(index);
        if (obj instanceof COSObject) {
            obj = ((COSObject)obj).getObject();
        } else if (obj instanceof COSNull) {
            obj = null;
        }
        return obj;
    }

    public COSBase get(int index) {
        return this.objects.get(index);
    }

    public int getInt(int index) {
        return this.getInt(index, -1);
    }

    public int getInt(int index, int defaultValue) {
        COSBase obj;
        int retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSNumber) {
            retval = ((COSNumber)obj).intValue();
        }
        return retval;
    }

    public void setInt(int index, int value) {
        this.set(index, COSInteger.get(value));
    }

    public void setName(int index, String name) {
        this.set(index, COSName.getPDFName(name));
    }

    public String getName(int index) {
        return this.getName(index, null);
    }

    public String getName(int index, String defaultValue) {
        COSBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSName) {
            retval = ((COSName)obj).getName();
        }
        return retval;
    }

    public void setString(int index, String string) {
        if (string != null) {
            this.set(index, new COSString(string));
        } else {
            this.set(index, null);
        }
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        COSBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSString) {
            retval = ((COSString)obj).getString();
        }
        return retval;
    }

    public int size() {
        return this.objects.size();
    }

    public COSBase remove(int i2) {
        return this.objects.remove(i2);
    }

    public boolean remove(COSBase o2) {
        return this.objects.remove(o2);
    }

    public boolean removeObject(COSBase o2) {
        boolean removed = this.remove(o2);
        if (!removed) {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                COSObject objEntry;
                COSBase entry = this.get(i2);
                if (!(entry instanceof COSObject) || !(objEntry = (COSObject)entry).getObject().equals(o2)) continue;
                return this.remove(entry);
            }
        }
        return removed;
    }

    public String toString() {
        return "COSArray{" + this.objects + "}";
    }

    @Override
    public Iterator<COSBase> iterator() {
        return this.objects.iterator();
    }

    public int indexOf(COSBase object) {
        int retval = -1;
        for (int i2 = 0; retval < 0 && i2 < this.size(); ++i2) {
            if (!this.get(i2).equals(object)) continue;
            retval = i2;
        }
        return retval;
    }

    public int indexOfObject(COSBase object) {
        int retval = -1;
        for (int i2 = 0; retval < 0 && i2 < this.size(); ++i2) {
            COSBase item = this.get(i2);
            if (item.equals(object)) {
                retval = i2;
                break;
            }
            if (!(item instanceof COSObject) || !((COSObject)item).getObject().equals(object)) continue;
            retval = i2;
            break;
        }
        return retval;
    }

    public void growToSize(int size) {
        this.growToSize(size, null);
    }

    public void growToSize(int size, COSBase object) {
        while (this.size() < size) {
            this.add(object);
        }
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromArray(this);
    }

    public float[] toFloatArray() {
        float[] retval = new float[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            retval[i2] = ((COSNumber)this.getObject(i2)).floatValue();
        }
        return retval;
    }

    public void setFloatArray(float[] value) {
        this.clear();
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.add(new COSFloat(value[i2]));
        }
    }

    public List<?> toList() {
        ArrayList<COSBase> retList = new ArrayList<COSBase>(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            retList.add(this.get(i2));
        }
        return retList;
    }
}

