/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;

public class WriteDecodedDoc {
    private static final String PASSWORD = "-password";
    private static final String NONSEQ = "-nonSeq";

    public void doIt(String in, String out) throws IOException, COSVisitorException {
        this.doIt(in, out, "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out, String password, boolean useNonSeqParser) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            if (useNonSeqParser) {
                doc = PDDocument.loadNonSeq(new File(in), null, password);
                doc.setAllSecurityToBeRemoved(true);
            } else {
                doc = PDDocument.load(in);
                if (doc.isEncrypted()) {
                    try {
                        doc.decrypt(password);
                        doc.setAllSecurityToBeRemoved(true);
                    }
                    catch (CryptographyException e2) {
                        e2.printStackTrace();
                        if (doc != null) {
                            doc.close();
                        }
                        return;
                    }
                }
            }
            Iterator<COSObject> i2 = doc.getDocument().getObjects().iterator();
            while (i2.hasNext()) {
                COSBase base = i2.next().getObject();
                if (!(base instanceof COSStream)) continue;
                COSStream cosStream = (COSStream)base;
                cosStream.getUnfilteredStream();
                cosStream.setFilters(null);
            }
            doc.save(out);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        WriteDecodedDoc app = new WriteDecodedDoc();
        String password = "";
        boolean useNonSeqParser = false;
        String pdfFile = null;
        String outputFile = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals(PASSWORD)) {
                if (++i2 >= args.length) {
                    WriteDecodedDoc.usage();
                }
                password = args[i2];
                continue;
            }
            if (args[i2].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i2];
                continue;
            }
            outputFile = args[i2];
        }
        if (pdfFile == null) {
            WriteDecodedDoc.usage();
        } else {
            try {
                if (outputFile == null) {
                    outputFile = WriteDecodedDoc.calculateOutputFilename(pdfFile);
                }
                app.doIt(pdfFile, outputFile, password, useNonSeqParser);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private static String calculateOutputFilename(String filename) {
        String outputFilename = filename.toLowerCase().endsWith(".pdf") ? filename.substring(0, filename.length() - 4) : filename;
        outputFilename = outputFilename + "_unc.pdf";
        return outputFilename;
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-x.y.z.jar WriteDecodedDoc [OPTIONS] <input-file> [output-file]\n  -password <password>      Password to decrypt the document\n  -nonSeq                   Enables the new non-sequential parser\n  <input-file>              The PDF document to be decompressed\n  [output-file]             The filename for the decompressed pdf\n");
    }
}

