/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        int numHMetrics = hHeader.getNumberOfHMetrics();
        int numGlyphs = ttf.getNumberOfGlyphs();
        this.advanceWidth = new int[numHMetrics];
        this.leftSideBearing = new short[numHMetrics];
        for (int i2 = 0; i2 < numHMetrics; ++i2) {
            this.advanceWidth[i2] = data.readUnsignedShort();
            this.leftSideBearing[i2] = data.readSignedShort();
        }
        int numberNonHorizontal = numGlyphs - numHMetrics;
        this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
        for (int i3 = 0; i3 < numberNonHorizontal; ++i3) {
            this.nonHorizontalLeftSideBearing[i3] = data.readSignedShort();
        }
        this.initialized = true;
    }

    public int[] getAdvanceWidth() {
        return this.advanceWidth;
    }

    public void setAdvanceWidth(int[] advanceWidthValue) {
        this.advanceWidth = advanceWidthValue;
    }
}

