/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class CMAPEncodingEntry {
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private Map<Integer, Integer> characterCodeToGlyphId = new HashMap<Integer, Integer>();

    public void initData(TTFDataStream data) throws IOException {
        this.platformId = data.readUnsignedShort();
        this.platformEncodingId = data.readUnsignedShort();
        this.subTableOffset = data.readUnsignedInt();
    }

    public void initSubtable(CMAPTable cmap, int numGlyphs, TTFDataStream data) throws IOException {
        data.seek(cmap.getOffset() + this.subTableOffset);
        int subtableFormat = data.readUnsignedShort();
        if (subtableFormat < 8) {
            long length = data.readUnsignedShort();
            long version = data.readUnsignedShort();
        } else {
            data.readUnsignedShort();
            long length = data.readUnsignedInt();
            long version = data.readUnsignedInt();
        }
        switch (subtableFormat) {
            case 0: {
                this.processSubtype0(data);
                break;
            }
            case 2: {
                this.processSubtype2(data, numGlyphs);
                break;
            }
            case 4: {
                this.processSubtype4(data, numGlyphs);
                break;
            }
            case 6: {
                this.processSubtype6(data, numGlyphs);
                break;
            }
            case 8: {
                this.processSubtype8(data, numGlyphs);
                break;
            }
            case 10: {
                this.processSubtype10(data, numGlyphs);
                break;
            }
            case 12: {
                this.processSubtype12(data, numGlyphs);
                break;
            }
            case 13: {
                this.processSubtype13(data, numGlyphs);
                break;
            }
            case 14: {
                this.processSubtype14(data, numGlyphs);
                break;
            }
            default: {
                throw new IOException("Unknown cmap format:" + subtableFormat);
            }
        }
    }

    protected void processSubtype8(TTFDataStream data, int numGlyphs) throws IOException {
        int[] is32 = data.readUnsignedByteArray(8192);
        long nbGroups = data.readUnsignedInt();
        if (nbGroups > 65536L) {
            throw new IOException("CMap ( Subtype8 ) is invalid");
        }
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i2 = 0L; i2 < nbGroups; ++i2) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode > endCode || 0L > firstCode) {
                throw new IOException("Range invalid");
            }
            for (long j2 = firstCode; j2 <= endCode; ++j2) {
                int currentCharCode;
                if (j2 > Integer.MAX_VALUE) {
                    throw new IOException("[Sub Format 8] Invalid Character code");
                }
                if ((is32[(int)j2 / 8] & 1 << (int)j2 % 8) == 0) {
                    currentCharCode = (int)j2;
                } else {
                    long LEAD_OFFSET = 55232L;
                    long lead = LEAD_OFFSET + (j2 >> 10);
                    long trail = 56320L + (j2 & 0x3FFL);
                    long SURROGATE_OFFSET = -56613888L;
                    long codepoint = (lead << 10) + trail + SURROGATE_OFFSET;
                    if (codepoint > Integer.MAX_VALUE) {
                        throw new IOException("[Sub Format 8] Invalid Character code");
                    }
                    currentCharCode = (int)codepoint;
                }
                long glyphIndex = startGlyph + (j2 - firstCode);
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = currentCharCode;
                this.characterCodeToGlyphId.put(currentCharCode, (int)glyphIndex);
            }
        }
    }

    protected void processSubtype10(TTFDataStream data, int numGlyphs) throws IOException {
        long startCode = data.readUnsignedInt();
        long numChars = data.readUnsignedInt();
        if (numChars > Integer.MAX_VALUE) {
            throw new IOException("Invalid number of Characters");
        }
        if (startCode < 0L || startCode > 0x10FFFFL || startCode + numChars > 0x10FFFFL || startCode + numChars >= 55296L && startCode + numChars <= 57343L) {
            throw new IOException("Invalid Characters codes");
        }
    }

    protected void processSubtype12(TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i2 = 0L; i2 < nbGroups; ++i2) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j2 = 0L; j2 <= endCode - firstCode; ++j2) {
                if (firstCode + j2 > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                long glyphIndex = startGlyph + j2;
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = (int)(firstCode + j2);
                this.characterCodeToGlyphId.put((int)(firstCode + j2), (int)glyphIndex);
            }
        }
    }

    protected void processSubtype13(TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        for (long i2 = 0L; i2 < nbGroups; ++i2) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long glyphId = data.readUnsignedInt();
            if (glyphId > (long)numGlyphs) {
                throw new IOException("CMap contains an invalid glyph index");
            }
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j2 = 0L; j2 <= endCode - firstCode; ++j2) {
                if (firstCode + j2 > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                this.glyphIdToCharacterCode[(int)glyphId] = (int)(firstCode + j2);
                this.characterCodeToGlyphId.put((int)(firstCode + j2), (int)glyphId);
            }
        }
    }

    protected void processSubtype14(TTFDataStream data, int numGlyphs) throws IOException {
        throw new IOException("CMap subtype 14 not yet implemented");
    }

    protected void processSubtype6(TTFDataStream data, int numGlyphs) throws IOException {
        int firstCode = data.readUnsignedShort();
        int entryCount = data.readUnsignedShort();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        int[] glyphIdArray = data.readUnsignedShortArray(entryCount);
        for (int i2 = 0; i2 < entryCount; ++i2) {
            this.glyphIdToCharacterCode[glyphIdArray[i2]] = firstCode + i2;
            this.characterCodeToGlyphId.put(firstCode + i2, glyphIdArray[i2]);
        }
    }

    protected void processSubtype4(TTFDataStream data, int numGlyphs) throws IOException {
        int segCountX2 = data.readUnsignedShort();
        int segCount = segCountX2 / 2;
        int searchRange = data.readUnsignedShort();
        int entrySelector = data.readUnsignedShort();
        int rangeShift = data.readUnsignedShort();
        int[] endCount = data.readUnsignedShortArray(segCount);
        int reservedPad = data.readUnsignedShort();
        int[] startCount = data.readUnsignedShortArray(segCount);
        int[] idDelta = data.readUnsignedShortArray(segCount);
        int[] idRangeOffset = data.readUnsignedShortArray(segCount);
        HashMap<Integer, Integer> tmpGlyphToChar = new HashMap<Integer, Integer>();
        long currentPosition = data.getCurrentPosition();
        for (int i2 = 0; i2 < segCount; ++i2) {
            int start = startCount[i2];
            int end = endCount[i2];
            int delta = idDelta[i2];
            int rangeOffset = idRangeOffset[i2];
            if (start == 65535 || end == 65535) continue;
            for (int j2 = start; j2 <= end; ++j2) {
                if (rangeOffset == 0) {
                    int glyphid = (j2 + delta) % 65536;
                    tmpGlyphToChar.put(glyphid, j2);
                    this.characterCodeToGlyphId.put(j2, glyphid);
                    continue;
                }
                long glyphOffset = currentPosition + (long)((rangeOffset / 2 + (j2 - start) + (i2 - segCount)) * 2);
                data.seek(glyphOffset);
                int glyphIndex = data.readUnsignedShort();
                if (glyphIndex == 0) continue;
                glyphIndex += delta;
                if (tmpGlyphToChar.containsKey(glyphIndex %= 65536)) continue;
                tmpGlyphToChar.put(glyphIndex, j2);
                this.characterCodeToGlyphId.put(j2, glyphIndex);
            }
        }
        this.glyphIdToCharacterCode = new int[(Integer)Collections.max(tmpGlyphToChar.keySet()) + 1];
        Arrays.fill(this.glyphIdToCharacterCode, 0);
        for (Map.Entry entry : tmpGlyphToChar.entrySet()) {
            this.glyphIdToCharacterCode[((Integer)entry.getKey()).intValue()] = (Integer)entry.getValue();
        }
    }

    protected void processSubtype2(TTFDataStream data, int numGlyphs) throws IOException {
        int[] subHeaderKeys = new int[256];
        int maxSubHeaderIndex = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            subHeaderKeys[i2] = data.readUnsignedShort();
            maxSubHeaderIndex = Math.max(maxSubHeaderIndex, subHeaderKeys[i2] / 8);
        }
        SubHeader[] subHeaders = new SubHeader[maxSubHeaderIndex + 1];
        for (int i3 = 0; i3 <= maxSubHeaderIndex; ++i3) {
            int firstCode = data.readUnsignedShort();
            int entryCount = data.readUnsignedShort();
            short idDelta = data.readSignedShort();
            int idRangeOffset = data.readUnsignedShort() - (maxSubHeaderIndex + 1 - i3 - 1) * 8 - 2;
            subHeaders[i3] = new SubHeader(firstCode, entryCount, idDelta, idRangeOffset);
        }
        long startGlyphIndexOffset = data.getCurrentPosition();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (int i4 = 0; i4 <= maxSubHeaderIndex; ++i4) {
            SubHeader sh = subHeaders[i4];
            int firstCode = sh.getFirstCode();
            int idRangeOffset = sh.getIdRangeOffset();
            short idDelta = sh.getIdDelta();
            int entryCount = sh.getEntryCount();
            data.seek(startGlyphIndexOffset + (long)idRangeOffset);
            for (int j2 = 0; j2 < entryCount; ++j2) {
                int charCode = i4;
                charCode = (charCode << 8) + (firstCode + j2);
                int p = data.readUnsignedShort();
                if (p > 0) {
                    p = (p + idDelta) % 65536;
                }
                this.glyphIdToCharacterCode[p] = charCode;
                this.characterCodeToGlyphId.put(charCode, p);
            }
        }
    }

    protected void processSubtype0(TTFDataStream data) throws IOException {
        byte[] glyphMapping = data.read(256);
        this.glyphIdToCharacterCode = new int[256];
        for (int i2 = 0; i2 < glyphMapping.length; ++i2) {
            int glyphIndex = (glyphMapping[i2] + 256) % 256;
            this.glyphIdToCharacterCode[glyphIndex] = i2;
            this.characterCodeToGlyphId.put(i2, glyphIndex);
        }
    }

    public int[] getGlyphIdToCharacterCode() {
        return this.glyphIdToCharacterCode;
    }

    public void setGlyphIdToCharacterCode(int[] glyphIdToCharacterCodeValue) {
        this.glyphIdToCharacterCode = glyphIdToCharacterCodeValue;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int platformEncodingIdValue) {
        this.platformEncodingId = platformEncodingIdValue;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformIdValue) {
        this.platformId = platformIdValue;
    }

    public int getGlyphId(int characterCode) {
        Integer glyphId = this.characterCodeToGlyphId.get(characterCode);
        return glyphId == null ? 0 : glyphId;
    }

    private class SubHeader {
        private int firstCode;
        private int entryCount;
        private short idDelta;
        private int idRangeOffset;

        private SubHeader(int firstCode, int entryCount, short idDelta, int idRangeOffset) {
            this.firstCode = firstCode;
            this.entryCount = entryCount;
            this.idDelta = idDelta;
            this.idRangeOffset = idRangeOffset;
        }

        private int getFirstCode() {
            return this.firstCode;
        }

        private int getEntryCount() {
            return this.entryCount;
        }

        private short getIdDelta() {
            return this.idDelta;
        }

        private int getIdRangeOffset() {
            return this.idRangeOffset;
        }
    }
}

