/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CharStringConverter;
import org.apache.fontbox.cff.CharStringRenderer;
import org.apache.fontbox.cff.IndexData;
import org.apache.fontbox.cff.Type1CharStringParser;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFFont {
    private String fontname = null;
    private Map<String, Object> topDict = new LinkedHashMap<String, Object>();
    private Map<String, Object> privateDict = new LinkedHashMap<String, Object>();
    private CFFEncoding fontEncoding = null;
    private CFFCharset fontCharset = null;
    private Map<String, byte[]> charStringsDict = new LinkedHashMap<String, byte[]>();
    private IndexData globalSubrIndex = null;
    private IndexData localSubrIndex = null;

    public String getName() {
        return this.fontname;
    }

    public void setName(String name) {
        this.fontname = name;
    }

    public Object getProperty(String name) {
        Object topDictValue = this.topDict.get(name);
        if (topDictValue != null) {
            return topDictValue;
        }
        Object privateDictValue = this.privateDict.get(name);
        if (privateDictValue != null) {
            return privateDictValue;
        }
        return null;
    }

    public void addValueToTopDict(String name, Object value) {
        if (value != null) {
            this.topDict.put(name, value);
        }
    }

    public Map<String, Object> getTopDict() {
        return this.topDict;
    }

    public void addValueToPrivateDict(String name, Object value) {
        if (value != null) {
            this.privateDict.put(name, value);
        }
    }

    public Map<String, Object> getPrivateDict() {
        return this.privateDict;
    }

    public Collection<Mapping> getMappings() {
        Mapping mapping;
        byte[] bytes;
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        HashSet<String> mappedNames = new HashSet<String>();
        for (CFFEncoding.Entry entry : this.fontEncoding.getEntries()) {
            byte[] bytes2;
            String charName = this.fontCharset.getName(entry.getSID());
            if (charName == null || (bytes2 = this.charStringsDict.get(charName)) == null) continue;
            Mapping mapping2 = new Mapping();
            mapping2.setCode(entry.getCode());
            mapping2.setSID(entry.getSID());
            mapping2.setName(charName);
            mapping2.setBytes(bytes2);
            mappings.add(mapping2);
            mappedNames.add(charName);
        }
        if (this.fontEncoding instanceof CFFParser.EmbeddedEncoding) {
            CFFParser.EmbeddedEncoding embeddedEncoding = (CFFParser.EmbeddedEncoding)this.fontEncoding;
            for (CFFParser.EmbeddedEncoding.Supplement supplement : embeddedEncoding.getSupplements()) {
                String charName = this.fontCharset.getName(supplement.getGlyph());
                if (charName == null || (bytes = this.charStringsDict.get(charName)) == null) continue;
                mapping = new Mapping();
                mapping.setCode(supplement.getCode());
                mapping.setSID(supplement.getGlyph());
                mapping.setName(charName);
                mapping.setBytes(bytes);
                mappings.add(mapping);
                mappedNames.add(charName);
            }
        }
        int code = 256;
        for (CFFCharset.Entry entry : this.fontCharset.getEntries()) {
            String name = entry.getName();
            if (mappedNames.contains(name) || (bytes = this.charStringsDict.get(name)) == null) continue;
            mapping = new Mapping();
            mapping.setCode(code++);
            mapping.setSID(entry.getSID());
            mapping.setName(name);
            mapping.setBytes(bytes);
            mappings.add(mapping);
            mappedNames.add(name);
        }
        return mappings;
    }

    public int getWidth(int SID) throws IOException {
        int nominalWidth = this.privateDict.containsKey("nominalWidthX") ? ((Number)this.privateDict.get("nominalWidthX")).intValue() : 0;
        int defaultWidth = this.privateDict.containsKey("defaultWidthX") ? ((Number)this.privateDict.get("defaultWidthX")).intValue() : 1000;
        for (Mapping m2 : this.getMappings()) {
            if (m2.getSID() != SID) continue;
            CharStringRenderer csr = null;
            if (((Number)this.getProperty("CharstringType")).intValue() == 2) {
                List<Object> lSeq = m2.toType2Sequence();
                csr = new CharStringRenderer(false);
                csr.render(lSeq);
            } else {
                List<Object> lSeq = m2.toType1Sequence();
                csr = new CharStringRenderer();
                csr.render(lSeq);
            }
            return csr.getWidth() != 0 ? csr.getWidth() + nominalWidth : defaultWidth;
        }
        return this.getNotDefWidth(defaultWidth, nominalWidth);
    }

    protected int getNotDefWidth(int defaultWidth, int nominalWidth) throws IOException {
        CharStringRenderer csr;
        byte[] glyphDesc = this.getCharStringsDict().get(".notdef");
        if (((Number)this.getProperty("CharstringType")).intValue() == 2) {
            Type2CharStringParser parser = new Type2CharStringParser();
            List<Object> lSeq = parser.parse(glyphDesc, this.getGlobalSubrIndex(), this.getLocalSubrIndex());
            csr = new CharStringRenderer(false);
            csr.render(lSeq);
        } else {
            Type1CharStringParser parser = new Type1CharStringParser();
            List<Object> lSeq = parser.parse(glyphDesc, this.getLocalSubrIndex());
            csr = new CharStringRenderer();
            csr.render(lSeq);
        }
        return csr.getWidth() != 0 ? csr.getWidth() + nominalWidth : defaultWidth;
    }

    public CFFEncoding getEncoding() {
        return this.fontEncoding;
    }

    public void setEncoding(CFFEncoding encoding) {
        this.fontEncoding = encoding;
    }

    public CFFCharset getCharset() {
        return this.fontCharset;
    }

    public void setCharset(CFFCharset charset) {
        this.fontCharset = charset;
    }

    public Map<String, byte[]> getCharStringsDict() {
        return this.charStringsDict;
    }

    public CharStringConverter createConverter() {
        Number defaultWidthX = (Number)this.getProperty("defaultWidthX");
        Number nominalWidthX = (Number)this.getProperty("nominalWidthX");
        return new CharStringConverter(defaultWidthX.intValue(), nominalWidthX.intValue());
    }

    public CharStringRenderer createRenderer() {
        return new CharStringRenderer();
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.fontname + ", topDict=" + this.topDict + ", privateDict=" + this.privateDict + ", encoding=" + this.fontEncoding + ", charset=" + this.fontCharset + ", charStringsDict=" + this.charStringsDict + "]";
    }

    public void setGlobalSubrIndex(IndexData globalSubrIndex) {
        this.globalSubrIndex = globalSubrIndex;
    }

    public IndexData getGlobalSubrIndex() {
        return this.globalSubrIndex;
    }

    public IndexData getLocalSubrIndex() {
        return this.localSubrIndex;
    }

    public void setLocalSubrIndex(IndexData localSubrIndex) {
        this.localSubrIndex = localSubrIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Mapping {
        private int mappedCode;
        private int mappedSID;
        private String mappedName;
        private byte[] mappedBytes;

        public List<Object> toType1Sequence() throws IOException {
            CharStringConverter converter = CFFFont.this.createConverter();
            return converter.convert(this.toType2Sequence());
        }

        public List<Object> toType2Sequence() throws IOException {
            Type2CharStringParser parser = new Type2CharStringParser();
            return parser.parse(this.getBytes(), CFFFont.this.getGlobalSubrIndex(), CFFFont.this.getLocalSubrIndex());
        }

        public int getCode() {
            return this.mappedCode;
        }

        private void setCode(int code) {
            this.mappedCode = code;
        }

        public int getSID() {
            return this.mappedSID;
        }

        private void setSID(int sid) {
            this.mappedSID = sid;
        }

        public String getName() {
            return this.mappedName;
        }

        private void setName(String name) {
            this.mappedName = name;
        }

        public byte[] getBytes() {
            return this.mappedBytes;
        }

        private void setBytes(byte[] bytes) {
            this.mappedBytes = bytes;
        }
    }
}

