/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.RealVectorChangingVisitor;
import org.apache.commons.math3.linear.RealVectorFormat;
import org.apache.commons.math3.linear.RealVectorPreservingVisitor;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class ArrayRealVector
extends RealVector
implements Serializable {
    private static final long serialVersionUID = -1097961340710804027L;
    private static final RealVectorFormat DEFAULT_FORMAT = RealVectorFormat.getInstance();
    private double[] data;

    public ArrayRealVector() {
        this.data = new double[0];
    }

    public ArrayRealVector(int size) {
        this.data = new double[size];
    }

    public ArrayRealVector(int size, double preset) {
        this.data = new double[size];
        Arrays.fill(this.data, preset);
    }

    public ArrayRealVector(double[] d2) {
        this.data = (double[])d2.clone();
    }

    public ArrayRealVector(double[] d2, boolean copyArray) throws NullArgumentException {
        if (d2 == null) {
            throw new NullArgumentException();
        }
        this.data = copyArray ? (double[])d2.clone() : d2;
    }

    public ArrayRealVector(double[] d2, int pos, int size) throws NullArgumentException, NumberIsTooLargeException {
        if (d2 == null) {
            throw new NullArgumentException();
        }
        if (d2.length < pos + size) {
            throw new NumberIsTooLargeException(pos + size, (Number)d2.length, true);
        }
        this.data = new double[size];
        System.arraycopy(d2, pos, this.data, 0, size);
    }

    public ArrayRealVector(Double[] d2) {
        this.data = new double[d2.length];
        for (int i2 = 0; i2 < d2.length; ++i2) {
            this.data[i2] = d2[i2];
        }
    }

    public ArrayRealVector(Double[] d2, int pos, int size) throws NullArgumentException, NumberIsTooLargeException {
        if (d2 == null) {
            throw new NullArgumentException();
        }
        if (d2.length < pos + size) {
            throw new NumberIsTooLargeException(pos + size, (Number)d2.length, true);
        }
        this.data = new double[size];
        for (int i2 = pos; i2 < pos + size; ++i2) {
            this.data[i2 - pos] = d2[i2];
        }
    }

    public ArrayRealVector(RealVector v) throws NullArgumentException {
        if (v == null) {
            throw new NullArgumentException();
        }
        this.data = new double[v.getDimension()];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = v.getEntry(i2);
        }
    }

    public ArrayRealVector(ArrayRealVector v) throws NullArgumentException {
        this(v, true);
    }

    public ArrayRealVector(ArrayRealVector v, boolean deep) {
        this.data = deep ? (double[])v.data.clone() : v.data;
    }

    public ArrayRealVector(ArrayRealVector v1, ArrayRealVector v2) {
        this.data = new double[v1.data.length + v2.data.length];
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2.data, 0, this.data, v1.data.length, v2.data.length);
    }

    public ArrayRealVector(ArrayRealVector v1, RealVector v2) {
        int l1 = v1.data.length;
        int l2 = v2.getDimension();
        this.data = new double[l1 + l2];
        System.arraycopy(v1.data, 0, this.data, 0, l1);
        for (int i2 = 0; i2 < l2; ++i2) {
            this.data[l1 + i2] = v2.getEntry(i2);
        }
    }

    public ArrayRealVector(RealVector v1, ArrayRealVector v2) {
        int l1 = v1.getDimension();
        int l2 = v2.data.length;
        this.data = new double[l1 + l2];
        for (int i2 = 0; i2 < l1; ++i2) {
            this.data[i2] = v1.getEntry(i2);
        }
        System.arraycopy(v2.data, 0, this.data, l1, l2);
    }

    public ArrayRealVector(ArrayRealVector v1, double[] v2) {
        int l1 = v1.getDimension();
        int l2 = v2.length;
        this.data = new double[l1 + l2];
        System.arraycopy(v1.data, 0, this.data, 0, l1);
        System.arraycopy(v2, 0, this.data, l1, l2);
    }

    public ArrayRealVector(double[] v1, ArrayRealVector v2) {
        int l1 = v1.length;
        int l2 = v2.getDimension();
        this.data = new double[l1 + l2];
        System.arraycopy(v1, 0, this.data, 0, l1);
        System.arraycopy(v2.data, 0, this.data, l1, l2);
    }

    public ArrayRealVector(double[] v1, double[] v2) {
        int l1 = v1.length;
        int l2 = v2.length;
        this.data = new double[l1 + l2];
        System.arraycopy(v1, 0, this.data, 0, l1);
        System.arraycopy(v2, 0, this.data, l1, l2);
    }

    public ArrayRealVector copy() {
        return new ArrayRealVector(this, true);
    }

    public ArrayRealVector add(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            int dim = vData.length;
            this.checkVectorDimensions(dim);
            ArrayRealVector result = new ArrayRealVector(dim);
            double[] resultData = result.data;
            for (int i2 = 0; i2 < dim; ++i2) {
                resultData[i2] = this.data[i2] + vData[i2];
            }
            return result;
        }
        this.checkVectorDimensions(v);
        double[] out = (double[])this.data.clone();
        Iterator<RealVector.Entry> it = v.iterator();
        while (it.hasNext()) {
            RealVector.Entry e2 = it.next();
            int n2 = e2.getIndex();
            out[n2] = out[n2] + e2.getValue();
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector subtract(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            int dim = vData.length;
            this.checkVectorDimensions(dim);
            ArrayRealVector result = new ArrayRealVector(dim);
            double[] resultData = result.data;
            for (int i2 = 0; i2 < dim; ++i2) {
                resultData[i2] = this.data[i2] - vData[i2];
            }
            return result;
        }
        this.checkVectorDimensions(v);
        double[] out = (double[])this.data.clone();
        Iterator<RealVector.Entry> it = v.iterator();
        while (it.hasNext()) {
            RealVector.Entry e2 = it.next();
            int n2 = e2.getIndex();
            out[n2] = out[n2] - e2.getValue();
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector map(UnivariateFunction function) {
        return this.copy().mapToSelf(function);
    }

    public ArrayRealVector mapToSelf(UnivariateFunction function) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = function.value(this.data[i2]);
        }
        return this;
    }

    public RealVector mapAddToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] + d2;
        }
        return this;
    }

    public RealVector mapSubtractToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] - d2;
        }
        return this;
    }

    public RealVector mapMultiplyToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] * d2;
        }
        return this;
    }

    public RealVector mapDivideToSelf(double d2) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = this.data[i2] / d2;
        }
        return this;
    }

    public ArrayRealVector ebeMultiply(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            int dim = vData.length;
            this.checkVectorDimensions(dim);
            ArrayRealVector result = new ArrayRealVector(dim);
            double[] resultData = result.data;
            for (int i2 = 0; i2 < dim; ++i2) {
                resultData[i2] = this.data[i2] * vData[i2];
            }
            return result;
        }
        this.checkVectorDimensions(v);
        double[] out = (double[])this.data.clone();
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            int n2 = i3;
            out[n2] = out[n2] * v.getEntry(i3);
        }
        return new ArrayRealVector(out, false);
    }

    public ArrayRealVector ebeDivide(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            int dim = vData.length;
            this.checkVectorDimensions(dim);
            ArrayRealVector result = new ArrayRealVector(dim);
            double[] resultData = result.data;
            for (int i2 = 0; i2 < dim; ++i2) {
                resultData[i2] = this.data[i2] / vData[i2];
            }
            return result;
        }
        this.checkVectorDimensions(v);
        double[] out = (double[])this.data.clone();
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            int n2 = i3;
            out[n2] = out[n2] / v.getEntry(i3);
        }
        return new ArrayRealVector(out, false);
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double dotProduct(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            this.checkVectorDimensions(vData.length);
            double dot = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                dot += this.data[i2] * vData[i2];
            }
            return dot;
        }
        return super.dotProduct(v);
    }

    public double getNorm() {
        double sum = 0.0;
        for (double a2 : this.data) {
            sum += a2 * a2;
        }
        return FastMath.sqrt(sum);
    }

    public double getL1Norm() {
        double sum = 0.0;
        for (double a2 : this.data) {
            sum += FastMath.abs(a2);
        }
        return sum;
    }

    public double getLInfNorm() {
        double max = 0.0;
        for (double a2 : this.data) {
            max = FastMath.max(max, FastMath.abs(a2));
        }
        return max;
    }

    public double getDistance(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            this.checkVectorDimensions(vData.length);
            double sum = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double delta = this.data[i2] - vData[i2];
                sum += delta * delta;
            }
            return FastMath.sqrt(sum);
        }
        this.checkVectorDimensions(v);
        double sum = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double delta = this.data[i3] - v.getEntry(i3);
            sum += delta * delta;
        }
        return FastMath.sqrt(sum);
    }

    public double getL1Distance(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            this.checkVectorDimensions(vData.length);
            double sum = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double delta = this.data[i2] - vData[i2];
                sum += FastMath.abs(delta);
            }
            return sum;
        }
        this.checkVectorDimensions(v);
        double sum = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double delta = this.data[i3] - v.getEntry(i3);
            sum += FastMath.abs(delta);
        }
        return sum;
    }

    public double getLInfDistance(RealVector v) throws DimensionMismatchException {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            this.checkVectorDimensions(vData.length);
            double max = 0.0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                double delta = this.data[i2] - vData[i2];
                max = FastMath.max(max, FastMath.abs(delta));
            }
            return max;
        }
        this.checkVectorDimensions(v);
        double max = 0.0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            double delta = this.data[i3] - v.getEntry(i3);
            max = FastMath.max(max, FastMath.abs(delta));
        }
        return max;
    }

    public RealMatrix outerProduct(RealVector v) {
        if (v instanceof ArrayRealVector) {
            double[] vData = ((ArrayRealVector)v).data;
            int m2 = this.data.length;
            int n2 = vData.length;
            RealMatrix out = MatrixUtils.createRealMatrix(m2, n2);
            for (int i2 = 0; i2 < m2; ++i2) {
                for (int j2 = 0; j2 < n2; ++j2) {
                    out.setEntry(i2, j2, this.data[i2] * vData[j2]);
                }
            }
            return out;
        }
        int m3 = this.data.length;
        int n3 = v.getDimension();
        RealMatrix out = MatrixUtils.createRealMatrix(m3, n3);
        for (int i3 = 0; i3 < m3; ++i3) {
            for (int j3 = 0; j3 < n3; ++j3) {
                out.setEntry(i3, j3, this.data[i3] * v.getEntry(j3));
            }
        }
        return out;
    }

    public double getEntry(int index) throws OutOfRangeException {
        try {
            return this.data[index];
        }
        catch (IndexOutOfBoundsException e2) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)index, 0, this.getDimension() - 1);
        }
    }

    public int getDimension() {
        return this.data.length;
    }

    public RealVector append(RealVector v) {
        try {
            return new ArrayRealVector(this, (ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            return new ArrayRealVector(this, v);
        }
    }

    public ArrayRealVector append(ArrayRealVector v) {
        return new ArrayRealVector(this, v);
    }

    public RealVector append(double in) {
        double[] out = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        out[this.data.length] = in;
        return new ArrayRealVector(out, false);
    }

    public RealVector getSubVector(int index, int n2) throws OutOfRangeException, NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        ArrayRealVector out = new ArrayRealVector(n2);
        try {
            System.arraycopy(this.data, index, out.data, 0, n2);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + n2 - 1);
        }
        return out;
    }

    public void setEntry(int index, double value) throws OutOfRangeException {
        try {
            this.data[index] = value;
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
        }
    }

    public void addToEntry(int index, double increment) throws OutOfRangeException {
        try {
            int n2 = index;
            this.data[n2] = this.data[n2] + increment;
        }
        catch (IndexOutOfBoundsException e2) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)index, 0, this.data.length - 1);
        }
    }

    public void setSubVector(int index, RealVector v) throws OutOfRangeException {
        if (v instanceof ArrayRealVector) {
            this.setSubVector(index, ((ArrayRealVector)v).data);
        } else {
            try {
                for (int i2 = index; i2 < index + v.getDimension(); ++i2) {
                    this.data[i2] = v.getEntry(i2 - index);
                }
            }
            catch (IndexOutOfBoundsException e2) {
                this.checkIndex(index);
                this.checkIndex(index + v.getDimension() - 1);
            }
        }
    }

    public void setSubVector(int index, double[] v) throws OutOfRangeException {
        try {
            System.arraycopy(v, 0, this.data, index, v.length);
        }
        catch (IndexOutOfBoundsException e2) {
            this.checkIndex(index);
            this.checkIndex(index + v.length - 1);
        }
    }

    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        return DEFAULT_FORMAT.format(this);
    }

    protected void checkVectorDimensions(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n2) throws DimensionMismatchException {
        if (this.data.length != n2) {
            throw new DimensionMismatchException(this.data.length, n2);
        }
    }

    public boolean isNaN() {
        for (double v : this.data) {
            if (!Double.isNaN(v)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        if (this.isNaN()) {
            return false;
        }
        for (double v : this.data) {
            if (!Double.isInfinite(v)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealVector)) {
            return false;
        }
        RealVector rhs = (RealVector)other;
        if (this.data.length != rhs.getDimension()) {
            return false;
        }
        if (rhs.isNaN()) {
            return this.isNaN();
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (this.data[i2] == rhs.getEntry(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 9;
        }
        return MathUtils.hash(this.data);
    }

    public ArrayRealVector combine(double a2, double b2, RealVector y) throws DimensionMismatchException {
        return this.copy().combineToSelf(a2, b2, y);
    }

    public ArrayRealVector combineToSelf(double a2, double b2, RealVector y) throws DimensionMismatchException {
        if (y instanceof ArrayRealVector) {
            double[] yData = ((ArrayRealVector)y).data;
            this.checkVectorDimensions(yData.length);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                this.data[i2] = a2 * this.data[i2] + b2 * yData[i2];
            }
        } else {
            this.checkVectorDimensions(y);
            for (int i3 = 0; i3 < this.data.length; ++i3) {
                this.data[i3] = a2 * this.data[i3] + b2 * y.getEntry(i3);
            }
        }
        return this;
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor visitor) {
        visitor.start(this.data.length, 0, this.data.length - 1);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            visitor.visit(i2, this.data[i2]);
        }
        return visitor.end();
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor.start(this.data.length, start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            visitor.visit(i2, this.data[i2]);
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor visitor) {
        return this.walkInDefaultOrder(visitor);
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor, start, end);
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor visitor) {
        visitor.start(this.data.length, 0, this.data.length - 1);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = visitor.visit(i2, this.data[i2]);
        }
        return visitor.end();
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor.start(this.data.length, start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            this.data[i2] = visitor.visit(i2, this.data[i2]);
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor visitor) {
        return this.walkInDefaultOrder(visitor);
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor, start, end);
    }
}

