/*
 * Decompiled with CFR 0.152.
 */
package drivers.xgenconnect;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.xgenconnect.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 300;
    public static final int DEFAULTMAXAREAS = 8;
    public static String UIPREFIX;
    public boolean startupevents;
    public boolean firstloop = true;
    private boolean gui = true;
    public String name;
    public String host;
    public String username;
    public String password;
    public int pollinterval = 1000;
    private Thread currentThread;
    private String urlCredentials;
    private int generalInfoCounter = 0;
    private int logSize = 300;
    private int maxAreas = 8;
    private Vector<String> logs;
    private String logsVar;
    private String lastLogVar;
    private long lastLogTs = 0L;
    private Log mostRecentLog;
    private ArrayList<Log> templogs = new ArrayList();
    private ArrayList<String> sessions = new ArrayList();
    private int sessionIndex = 0;
    private final String[] areaStates = new String[]{"armed.ready", "RESERVED", "armed.partial", "armed.away", "delay.1.exit", "delay.2.exit", "delay.entry", "RESERVED", "alarm.fire", "alarm.panic", "alarm.burg", "alarm.medic", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "nightmode", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "zones.bypassed", "zones.trouble", "zones.tamper", "zones.lowbattery", "zones.lost", "RESERVED", "RESERVED", "RESERVED"};
    private final String[] zoneStates = new String[]{"open", "tamper", "trouble", "bypass", "inhibited", "alarm", "lowbatt", "supervision", "RESERVED", "chime", "RESERVED", "alarm.mem", "RESERVED", "activity.fail", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED"};
    public static final String[] WEBOBJECTS;

    static {
        WEBOBJECTS = new String[]{"xgenconnect"};
    }

    public boolean init(String name, HashMap<String, String> config) {
        try {
            String resp;
            super.init(name);
            this.name = name;
            UIPREFIX = String.valueOf(name) + ".";
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                int port = Integer.parseInt(config.get("port"));
                this.host = String.valueOf(inet.getHostName()) + ":" + port;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            try {
                int max = Integer.parseInt(config.get("maxareas"));
                if (max >= 1 && max <= 16) {
                    this.maxAreas = max;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            this.urlCredentials = "lgname=" + this.username + "&lgpin=" + this.password;
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            if (config.containsKey("gui")) {
                this.gui = Boolean.parseBoolean(config.get("gui"));
            }
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 100 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e4) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            try {
                int n2 = Integer.parseInt(config.get("logsize"));
                if (n2 <= 400) {
                    this.logSize = n2;
                }
            }
            catch (Exception e5) {
                this.messageLog(String.valueOf(name) + ": logsize ignored");
            }
            if ((resp = Driver.urlPost("http://" + this.host + "/user/api/login.cgi", "application/x-www-form-urlencoded", this.urlCredentials, null, null)) == null || !resp.startsWith("200")) {
                return false;
            }
            this.readAllStatuses(resp.substring(4));
        }
        catch (Exception e6) {
            this.errorLog("Initialization failed - " + e6.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
        this.loadLogs();
        this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
        return true;
    }

    public boolean loop() {
        this.currentThread = Thread.currentThread();
        if (this.generalInfoCounter >= 100) {
            this.generalInfoCounter = 0;
        }
        try {
            String httpResp;
            if (this.generalInfoCounter++ == 0) {
                httpResp = Driver.urlPost("http://" + this.host + "/user/api/x_names.cgi", "application/x-www-form-urlencoded", this.urlCredentials, this.username, this.password);
                if (httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get all names");
                }
                if (!httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + httpResp.substring(4));
                }
                this.readAllNames(httpResp.substring(4));
                this.sleep(100L);
                httpResp = Driver.urlPost("http://" + this.host + "/user/api/s_names.cgi", "application/x-www-form-urlencoded", this.urlCredentials, this.username, this.password);
                if (httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get zone names");
                }
                if (!httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + httpResp.substring(4));
                }
                this.readZoneNames(httpResp.substring(4));
                this.sleep(100L);
            }
            if ((httpResp = Driver.urlPost("http://" + this.host + "/user/api/allstat.json", "application/x-www-form-urlencoded", this.urlCredentials, this.username, this.password)) == null) {
                throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get general status");
            }
            if (!httpResp.startsWith("200")) {
                throw new Exception(String.valueOf(this.name) + " - " + httpResp.substring(4));
            }
            this.readAllStatuses(httpResp.substring(4));
            this.sleep(100L);
            this.readRecordLog();
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
                this.securityLog("HSYCO ONLINE");
                userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "false");
                userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "false");
            }
            if (this.lastLogTs != 0L && System.currentTimeMillis() > this.lastLogTs + 5000L) {
                this.uiSet("log0", "value", "");
                this.lastLogTs = 0L;
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2.getMessage());
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.online", "visible", "true");
            userBase.uiSet(String.valueOf(UIPREFIX) + "connection.panel", "visible", "true");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        this.addSession(session);
        if (id.startsWith("areas.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.internal", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.name", "value", "Area " + num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.cont", "visible", "true");
            return "!";
        }
        if (id.equals("area.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "area.sel.cont", "visible", "false");
            return "!";
        }
        if (id.equals("subarea.armed.partial")) {
            String area = userBase.uiGet(session, String.valueOf(UIPREFIX) + "area.internal");
            int bank = Integer.parseInt(area) < 9 ? 0 : 1;
            this.command("area." + bank + "." + area, "1");
            return "!";
        }
        if (id.equals("subarea.armed.away")) {
            String area = userBase.uiGet(session, String.valueOf(UIPREFIX) + "area.internal");
            int bank = Integer.parseInt(area) < 9 ? 0 : 1;
            this.command("area." + bank + "." + area, "2");
            return "!";
        }
        if (id.equals("subarea.armed.0")) {
            String area = userBase.uiGet(session, String.valueOf(UIPREFIX) + "area.internal");
            int bank = Integer.parseInt(area) < 9 ? 0 : 1;
            this.command("area." + bank + "." + area, "0");
            return "!";
        }
        if (id.startsWith("zones.list")) {
            String num = id.split("\\.")[2];
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.internal", num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.name", "value", "Zone " + num);
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.cont", "visible", "true");
            this.updateAreaUIStatus();
            this.updateZoneUIStatuses(session);
            return "!";
        }
        if (id.equals("zone.sel.close")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.cont", "visible", "false");
            return "!";
        }
        if (id.equals("zone.sel.bypass")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("zone." + zone + ".5", "1");
            return "!";
        }
        if (id.equals("zone.sel.unbypass")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("zone." + zone + ".5", "0");
            return "!";
        }
        if (id.equals("zone.sel.chime")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("zone." + zone + ".6", "1");
            return "!";
        }
        if (id.equals("zone.sel.nochime")) {
            String zone = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
            this.command("zone." + zone + ".6", "0");
            return "!";
        }
        if (id.equals("areas.armed.partial")) {
            this.command("area.0.all", "1");
            this.command("area.1.all", "1");
            return "!";
        }
        if (id.equals("areas.armed.away")) {
            this.command("area.0.all", "2");
            this.command("area.1.all", "1");
            return "!";
        }
        if (id.equals("areas.armed.0")) {
            this.command("area.0.all", "0");
            this.command("area.1.all", "1");
            return "!";
        }
        return "";
    }

    public void command(String name, String value) {
        String resp = null;
        String url = null;
        String command = null;
        try {
            String[] fields = name.split("\\.");
            if (fields[0].equals("area")) {
                int areaMask;
                int areaBank = Integer.parseInt(fields[1]);
                if (areaBank == 1 && this.maxAreas < 9) {
                    return;
                }
                if (fields[2].equals("all")) {
                    areaMask = this.calculateTotalAreaMask(areaBank);
                } else {
                    int exp = Integer.parseInt(fields[2]);
                    if (exp > this.maxAreas) {
                        return;
                    }
                    if (areaBank == 1) {
                        exp -= 8;
                    }
                    areaMask = (int)Math.pow(2.0, exp - 1);
                }
                url = "http://" + this.host + "/user/keyfunction.cgi";
                command = String.valueOf(this.urlCredentials) + "&start=" + areaBank + "&mask=" + areaMask + "&fnum=" + value;
            } else if (fields[0].equals("zone")) {
                int zoneTmp = Integer.parseInt(fields[1]) - 1;
                String zone = String.valueOf(zoneTmp);
                String cmd = fields[2];
                url = "http://" + this.host + "/user/zonefunction.cgi";
                command = String.valueOf(this.urlCredentials) + "&zone=" + zone + "&cmd=" + cmd + "&opt=" + value;
            } else if (fields[0].equals("camera") && fields[1].equals("trigger")) {
                url = "http://" + this.host + "/user/api/video.cgi";
                command = String.valueOf(this.urlCredentials) + "&num=" + value;
            } else if (fields[0].equals("scene") && fields[1].equals("trigger")) {
                url = "http://" + this.host + "/user/api/scene.cgi";
                command = String.valueOf(this.urlCredentials) + "&num=" + value;
            }
            int i2 = 0;
            while (i2 < 5) {
                resp = Driver.urlPost(url, "application/x-www-form-urlencoded", command, this.username, this.password);
                if (resp != null && resp.startsWith("200")) {
                    try {
                        this.currentThread.interrupt();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.errorLog(String.valueOf(this.name) + " - error in HTTP POST request - " + url);
                this.sleep(100L);
                ++i2;
            }
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + name + ": " + value + " - " + e2.getMessage());
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void readAllStatuses(String rawMsg) throws Exception {
        JSONObject json = new JSONObject(rawMsg);
        if (json.has("error")) {
            this.decodeError200(json.getJSONObject("error"));
        }
        try {
            char lessHex;
            char mostHex;
            JSONArray areas = json.getJSONArray("areas");
            String areastates = areas.getString(0);
            int i2 = 0;
            while (i2 < areastates.length()) {
                mostHex = areastates.charAt(i2);
                lessHex = areastates.charAt(i2 + 1);
                if (!this.areaStates[i2 / 2].equals("RESERVED")) {
                    this.decodeAreaZoneState(true, mostHex, lessHex, 0, this.areaStates[i2 / 2]);
                }
                i2 += 2;
            }
            JSONArray zones = json.getJSONArray("zones");
            int maxLen = this.zoneStates.length < zones.length() ? this.zoneStates.length : zones.length();
            int i3 = 0;
            while (i3 < maxLen) {
                String zoneState = zones.getString(i3);
                int j2 = 0;
                while (j2 < zoneState.length()) {
                    mostHex = zoneState.charAt(j2);
                    lessHex = zoneState.charAt(j2 + 1);
                    if (!this.zoneStates[i3].equals("RESERVED")) {
                        this.decodeAreaZoneState(false, mostHex, lessHex, j2 / 2 * 8, this.zoneStates[i3]);
                    }
                    j2 += 2;
                }
                ++i3;
            }
            if (json.has("system")) {
                JSONArray system = json.getJSONArray("system");
                String s = "";
                int i4 = 0;
                while (i4 < system.length()) {
                    s = String.valueOf(s) + "," + this.replaceSpecialChars(system.getString(i4));
                    ++i4;
                }
                s = s.length() == 0 ? "" : s.substring(1);
                this.ioWrite("system.status", s);
            }
        }
        catch (Exception e2) {
            throw new Exception("JSON response format error - query all status - " + e2.getMessage());
        }
        this.updateAreaUIStatus();
        for (String session : this.sessions) {
            this.updateZoneUIStatuses(session);
        }
    }

    private void decodeError200(JSONObject json) throws Exception {
        int code = json.getInt("code");
        switch (code) {
            case 0: {
                throw new Exception("User permission denied");
            }
            case 1: {
                throw new Exception("Check username and PIN are correct");
            }
            case 2: {
                throw new Exception("Session timed out or logged in from another location");
            }
            case 3: {
                throw new Exception("Maximum of four users are already logged in");
            }
            case 4: {
                throw new Exception("Too many username or PIN failures, try again later");
            }
        }
    }

    private void decodeAreaZoneState(boolean area, char mostHex, char lessHex, int startIndex, String state) {
        int m2 = Integer.parseInt(String.valueOf(mostHex), 16);
        int l2 = Integer.parseInt(String.valueOf(lessHex), 16);
        String mBin = Integer.toBinaryString(m2);
        String lBin = Integer.toBinaryString(l2);
        mBin = this.bitConvert(mBin);
        lBin = this.bitConvert(lBin);
        StringBuilder s = new StringBuilder(String.valueOf(mBin) + lBin).reverse();
        String prefix = area ? "a" : "z";
        int i2 = 0;
        while (i2 < s.length()) {
            String val;
            String string = val = s.charAt(i2) == '1' ? "1" : "0";
            if (startIndex + i2 + 1 <= this.maxAreas) {
                this.ioWrite(String.valueOf(prefix) + (startIndex + i2 + 1) + "." + state, val);
            }
            if (!area && this.gui) {
                this.uiSet(String.valueOf(prefix) + (startIndex + i2 + 1) + "." + state, "visible", val.equals("1") ? "true" : "false");
            }
            ++i2;
        }
    }

    private String bitConvert(String s) {
        switch (s.length()) {
            case 1: {
                return "000" + s;
            }
            case 2: {
                return "00" + s;
            }
            case 3: {
                return "0" + s;
            }
        }
        return s;
    }

    private void readAllNames(String rawMsg) throws Exception {
        JSONObject json = new JSONObject(rawMsg);
        if (json.has("error")) {
            this.decodeError200(json.getJSONObject("error"));
        }
        try {
            int i2;
            if (json.has("areas")) {
                JSONArray areaNames = json.getJSONArray("areas");
                i2 = 0;
                while (i2 < areaNames.length() && i2 < this.maxAreas) {
                    this.ioWrite("a" + (i2 + 1) + ".name", this.replaceSpecialChars(areaNames.getString(i2)));
                    ++i2;
                }
            }
            if (json.has("sensors")) {
                JSONArray sensorNames = json.getJSONArray("sensors");
                i2 = 0;
                while (i2 < sensorNames.length()) {
                    this.ioWrite("sensor." + (i2 + 1) + ".name", this.replaceSpecialChars(sensorNames.getString(i2)));
                    ++i2;
                }
            }
            if (json.has("scenes")) {
                JSONArray sceneNames = json.getJSONArray("scenes");
                i2 = 0;
                while (i2 < sceneNames.length()) {
                    this.ioWrite("scene." + (i2 + 1) + ".name", this.replaceSpecialChars(sceneNames.getString(i2)));
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            throw new Exception("JSON response format error - query all names - " + e2.getMessage());
        }
    }

    private void readZoneNames(String rawMsg) throws Exception {
        JSONObject json = new JSONObject(rawMsg);
        if (json.has("error")) {
            this.decodeError200(json.getJSONObject("error"));
        }
        try {
            if (json.has("s_names")) {
                JSONArray zoneNames = json.getJSONArray("s_names");
                StringBuilder values = new StringBuilder();
                StringBuilder labels = new StringBuilder();
                int i2 = 0;
                while (i2 < zoneNames.length()) {
                    this.ioWrite("z" + (i2 + 1) + ".name", this.replaceSpecialChars(zoneNames.getString(i2)));
                    values.append("," + (i2 + 1));
                    labels.append(",Zone " + (i2 + 1));
                    ++i2;
                }
                if (values.length() > 0) {
                    userBase.uiSet(String.valueOf(UIPREFIX) + "zones.list", "values", values.substring(1));
                    userBase.uiSet(String.valueOf(UIPREFIX) + "zones.list", "labels", labels.substring(1));
                }
            }
        }
        catch (Exception e2) {
            throw new Exception("JSON response format error - query zone names - " + e2.getMessage());
        }
    }

    private void loadLogs() {
        block13: {
            this.logsVar = "__HSYCO__XGEN_" + this.name + ".log!";
            this.lastLogVar = "__HSYCO__XGEN_last_log!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(this.logsVar);
                    if (s == null) {
                        this.logs = new Vector(this.logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    this.logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    this.logs = new Vector(this.logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String lastIndex = userBase.varGet(this.lastLogVar);
        if (lastIndex != null) {
            this.mostRecentLog = new Log("", 0L, Integer.parseInt(lastIndex));
        }
    }

    void securityLog(String event) {
        String message = event;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        String guiEntry = "<div style=\"font-size:17px\">" + message + "</div>";
        this.logs.add(0, guiEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            guiEntry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message);
        this.lastLogTs = System.currentTimeMillis();
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logsVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void readRecordLog() throws Exception {
        int lastLogIndex = 0;
        int increment = 0;
        int step = 10;
        Log firstLog = null;
        boolean stop = false;
        String startIndex = "";
        this.templogs.clear();
        while (!stop && increment < 300) {
            block9: {
                String httpResp = Driver.urlPost("http://" + this.host + "/user/api/events.cgi", "application/x-www-form-urlencoded", String.valueOf(this.urlCredentials) + "&count=" + step + startIndex, this.username, this.password);
                if (httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - query events log");
                }
                if (!httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + httpResp.substring(4));
                }
                try {
                    JSONObject json = new JSONObject(httpResp.substring(4));
                    lastLogIndex = json.getInt("last");
                    JSONArray events2 = json.getJSONArray("events");
                    int i2 = 0;
                    while (i2 < events2.length()) {
                        JSONObject event = events2.getJSONObject(i2);
                        int index = event.getInt("id");
                        String msg = this.replaceSpecialChars(event.getString("text"));
                        long time = event.getLong("time");
                        Log log = new Log(msg, time, index);
                        if (this.mostRecentLog != null && this.mostRecentLog.getIndex() == index) {
                            stop = true;
                            break;
                        }
                        if (increment == 0 && i2 == 0) {
                            firstLog = log;
                        }
                        this.templogs.add(log);
                        ++i2;
                    }
                }
                catch (Exception e2) {
                    if (!this.isVerboseLog()) break block9;
                    this.errorLog(String.valueOf(this.name) + " - error reading JSON response in record logs - " + e2.getMessage());
                }
            }
            this.sleep(100L);
            startIndex = "&start=" + (lastLogIndex - (increment += step));
        }
        if (firstLog != null) {
            this.mostRecentLog = firstLog;
        }
        this.writeLogs();
    }

    private void writeLogs() {
        Collections.reverse(this.templogs);
        for (Log log : this.templogs) {
            if (log.getMessage().isEmpty()) continue;
            this.securityLog(log.getMessage());
        }
        if (this.mostRecentLog != null) {
            userBase.varSet(this.lastLogVar, "" + this.mostRecentLog.getIndex());
        }
    }

    private String replaceSpecialChars(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, "UTF-8").replaceAll("\u00c3", "\u00e0");
    }

    private void addSession(String session) {
        if (this.sessions.contains(session)) {
            return;
        }
        if (this.sessionIndex >= 10) {
            this.sessionIndex = 0;
        }
        this.sessions.add(this.sessionIndex++, session);
    }

    private void updateAreaUIStatus() {
        boolean tamper = false;
        int i2 = 1;
        while (i2 < this.maxAreas) {
            String tmp = userBase.ioGet(String.valueOf(this.name) + ".a" + i2 + ".zones.tamper");
            if (tmp != null && tmp.equals("1")) {
                tamper = true;
                break;
            }
            ++i2;
        }
        if (tamper) {
            userBase.uiSet(String.valueOf(UIPREFIX) + "area.tamper.mem.label.1", "visible", "true");
        } else {
            userBase.uiSet(String.valueOf(UIPREFIX) + "area.tamper.mem.label.1", "visible", "false");
        }
        boolean alarm = false;
        int i3 = 1;
        while (i3 < this.maxAreas) {
            String alarm1 = userBase.ioGet(String.valueOf(this.name) + ".a" + i3 + ".alarm.burg");
            String alarm2 = userBase.ioGet(String.valueOf(this.name) + ".a" + i3 + ".alarm.fire");
            String alarm3 = userBase.ioGet(String.valueOf(this.name) + ".a" + i3 + ".alarm.medic");
            String alarm4 = userBase.ioGet(String.valueOf(this.name) + ".a" + i3 + ".alarm.panic");
            if (alarm1 != null && alarm1.equals("1") || alarm2 != null && alarm2.equals("1") || alarm3 != null && alarm3.equals("1") || alarm4 != null && alarm4.equals("1")) {
                alarm = true;
                break;
            }
            ++i3;
        }
        if (alarm) {
            userBase.uiSet(String.valueOf(UIPREFIX) + "area.alarm.mem.label.1", "visible", "true");
        } else {
            userBase.uiSet(String.valueOf(UIPREFIX) + "area.alarm.mem.label.1", "visible", "false");
        }
        String areaVals = "";
        String areaLabs = "";
        int i4 = 1;
        while (i4 <= this.maxAreas) {
            areaVals = String.valueOf(areaVals) + "," + i4;
            String away = userBase.ioGet(String.valueOf(this.name) + ".a" + i4 + ".armed.away");
            String partial = userBase.ioGet(String.valueOf(this.name) + ".a" + i4 + ".armed.partial");
            if (away != null && away.equals("1")) {
                areaLabs = String.valueOf(areaLabs) + ",<img src=\"/blue/pic/inim/inim-lock.png\" width=\"25\" height=\"25\"> Area " + i4;
            } else if (partial != null && partial.equals("1")) {
                areaLabs = String.valueOf(areaLabs) + ",<img src=\"/blue/pic/inim/inim-lockpart.png\" width=\"25\" height=\"25\"> Area " + i4;
            } else if (partial != null && partial.equals("0") && away != null && away.equals("0")) {
                areaLabs = String.valueOf(areaLabs) + ",<img src=\"/blue/pic/inim/inim-unlock-tr.png\" width=\"25\" height=\"25\"> Area " + i4;
            }
            ++i4;
        }
        userBase.uiSet(String.valueOf(UIPREFIX) + "areas.list", "values", areaVals.substring(1));
        userBase.uiSet(String.valueOf(UIPREFIX) + "areas.list", "labels", areaLabs.substring(1));
    }

    private void updateZoneUIStatuses(String session) {
        String num = userBase.uiGet(session, String.valueOf(UIPREFIX) + "zone.internal");
        if (num == null) {
            return;
        }
        String open = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".open");
        if (open != null && open.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.open.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.open.label", "visible", "false");
        }
        String alarm = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".alarm");
        if (alarm != null && alarm.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.alarm.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.alarm.label", "visible", "false");
        }
        String tamper = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".tamper");
        if (tamper != null && tamper.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.tamper.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.tamper.label", "visible", "false");
        }
        String bypass = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".bypass");
        if (bypass != null && bypass.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.bypassed.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.bypassed.label", "visible", "false");
        }
        String chime = userBase.ioGet(String.valueOf(this.name) + ".z" + num + ".chime");
        if (chime != null && chime.equals("1")) {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.chime.label", "visible", "true");
        } else {
            userBase.uiSet(session, String.valueOf(UIPREFIX) + "zone.sel.chime.label", "visible", "false");
        }
    }

    private int calculateTotalAreaMask(int areaBank) {
        if (areaBank == 0) {
            switch (this.maxAreas) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 7;
                }
                case 4: {
                    return 15;
                }
                case 5: {
                    return 31;
                }
                case 6: {
                    return 63;
                }
                case 7: {
                    return 127;
                }
            }
            return 255;
        }
        if (areaBank == 1) {
            switch (this.maxAreas) {
                case 9: {
                    return 1;
                }
                case 10: {
                    return 3;
                }
                case 11: {
                    return 7;
                }
                case 12: {
                    return 15;
                }
                case 13: {
                    return 31;
                }
                case 14: {
                    return 63;
                }
                case 15: {
                    return 127;
                }
                case 16: {
                    return 255;
                }
            }
        }
        return 0;
    }
}

