/*
 * Decompiled with CFR 0.152.
 */
package drivers.wolf8access;

import com.hsyco.userBase;
import drivers.wolf8access.Driver;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicInteger;

public class Listener
extends Thread {
    private final Driver driver;
    private final String comm;
    private boolean run = false;
    private byte[] buffer = new byte[100];
    private int idx = 0;
    private long lastMsgTs;

    public Listener(Driver driver, String comm) {
        this.driver = driver;
        this.comm = comm;
    }

    @Override
    public void run() {
        try {
            this.run = true;
            block2: while (this.run) {
                byte[] bs = this.driver.readCommBytes(this.comm, 1);
                if (bs != null) {
                    byte[] byArray = bs;
                    int n2 = bs.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        byte b2 = byArray[n3];
                        if (!(b2 != 13 || this.buffer[0] == 116 && this.idx < 9 || this.buffer[0] == 112 && this.idx < 13)) {
                            this.processMessage(this.buffer, this.idx);
                            this.idx = 0;
                            continue block2;
                        }
                        if (this.idx < this.buffer.length) {
                            this.buffer[this.idx++] = b2;
                        } else {
                            this.driver.readCommBytes(this.comm, 0);
                            this.idx = 0;
                        }
                        ++n3;
                    }
                    continue;
                }
                Listener.sleep(1000L);
            }
        }
        catch (Throwable e2) {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(byte[] data, int len) throws Exception {
        int Y;
        int i2;
        Object c2;
        String msg = String.valueOf(this.driver.getName()) + " - Process: ";
        int i3 = 0;
        while (i3 < len) {
            byte b2 = data[i3];
            c2 = b2 >= 32 && b2 <= 126 ? "" + (char)b2 : "??";
            msg = String.valueOf(msg) + Integer.toHexString(b2 & 0xFF) + "(" + (String)c2 + ") ";
            ++i3;
        }
        if (this.driver.isDriverInVerboseLog()) {
            userBase.messageLog(msg);
        }
        this.lastMsgTs = System.currentTimeMillis();
        if (data[0] == 119) {
            if (data[1] == 79 && data[2] == 75) {
                this.driver.respLock.set(-2);
            } else {
                this.end();
            }
        } else if (data[0] == 98) {
            int increment = this.driver.getSerialNum().isEmpty() ? 2 : 4;
            i2 = 0;
            while (i2 < len) {
                c2 = this.driver.respLock;
                synchronized (c2) {
                    this.driver.respLock.set(Integer.parseInt("" + (char)data[i2 + 1]));
                    this.driver.respLock.notifyAll();
                    this.driver.respLock.wait(100L);
                }
                i2 += increment;
            }
        } else if (data[0] == 116) {
            int sec = 0;
            i2 = 1;
            while (i2 <= 8) {
                sec += (data[i2] & 0xF) << (8 - i2) * 4;
                ++i2;
            }
            GregorianCalendar cal = (GregorianCalendar)Driver.EPOCH.clone();
            cal.add(13, sec);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = dateFormat.format(cal.getTime());
            this.driver.ioWrite("time", time);
        } else if (data[0] == 75) {
            Y = data[1] - 48;
            if (len == 5) {
                String XXX = "" + this.toNum(data, 2, 3, 10);
                this.driver.ioWriteForced("p" + Y + ".mem.ok", XXX);
            } else if (len == 6) {
                String XXX = "" + this.toNum(data, 3, 3, 10);
                if (data[2] == 73) {
                    this.driver.ioWriteForced("p" + Y + ".key", XXX);
                } else if (data[2] == 80) {
                    this.driver.ioWriteForced("p" + Y + ".mem.err", XXX);
                } else if (data[2] == 77) {
                    this.driver.ioWriteForced("p" + Y + ".mem.full", XXX);
                }
            }
        } else if (data[0] == 77) {
            Y = data[1] - 48;
            String XXX = "" + this.toNum(data, 2, 3, 10);
            this.driver.ioWriteForced("p" + Y + ".mem.free", XXX);
        } else if (data[0] == 84) {
            String XXXXX;
            Y = data[1] - 48;
            try {
                XXXXX = "" + this.toNum(data, 2, 5, 10);
            }
            catch (Exception e2) {
                XXXXX = "M";
            }
            this.driver.ioWriteForced("p" + Y + ".reltime", XXXXX);
        } else if (data[0] == 76) {
            Y = data[1] - 48;
            this.driver.ioWriteForced("p" + Y + ".open", data[2] == 79 ? "1" : "0");
            this.driver.ioWrite("p" + Y + ".alarm.comm", "0");
        } else if (data[0] == 65) {
            Y = data[2] - 48;
            if (data[1] == 68) {
                this.driver.ioWriteForced("p" + Y + ".alarm.forced", "1");
            } else if (data[1] == 66) {
                this.driver.ioWriteForced("p" + Y + ".alarm.comm", "1");
            }
        } else if (data[0] == 68) {
            Y = data[1] - 48;
            this.driver.ioWriteForced("p" + Y + ".mem.clear", data[2] == 79 ? "1" : "0");
        } else if (data[0] == 78) {
            int offset = 0;
            if (data[1] == 66) {
                offset = 1;
            }
            int Y2 = data[offset + 1] - 48;
            int xxx = this.toNum(data, offset + 2, 3, 10);
            int kkkkkk = this.toNum(data, offset + 5, 6, 16);
            if (xxx != 0 || kkkkkk != 0) {
                this.driver.ioWrite("p" + Y2 + ".blocked", offset == 1 ? "1" : "0");
                boolean manager = (kkkkkk & 0x800000) == 0;
                boolean blocked = (kkkkkk & 0x400000) == 0;
                this.driver.ioWriteForced("p" + Y2 + ".k" + xxx + ".sn", "" + (kkkkkk &= 0x3FFFFF));
                this.driver.ioWriteForced("p" + Y2 + ".k" + xxx + ".manager", manager ? "1" : "0");
                this.driver.ioWriteForced("p" + Y2 + ".k" + xxx + ".blocked", blocked ? "1" : "0");
            } else {
                this.driver.respLock.set(100);
            }
        } else if (data[0] == 69) {
            Y = data[1] - 48;
            AtomicInteger atomicInteger = this.driver.respLock;
            synchronized (atomicInteger) {
                int xxx;
                if (data[2] == 79 && data[3] == 75 && (xxx = this.driver.respLock.get()) >= 0) {
                    this.driver.ioWriteForced("p" + Y + ".k" + xxx + ".blocked", "1");
                }
            }
        } else if (data[0] == 86) {
            Y = data[1] - 48;
            AtomicInteger atomicInteger = this.driver.respLock;
            synchronized (atomicInteger) {
                int xxx;
                if (data[2] == 79 && data[3] == 75 && (xxx = this.driver.respLock.get()) >= 0) {
                    this.driver.ioWriteForced("p" + Y + ".k" + xxx + ".blocked", "0");
                }
            }
        } else if (data[0] == 82) {
            Y = data[1] - 48;
            this.driver.ioWriteForced("p" + Y + ".mem.refresh", data[2] == 79 ? "1" : "0");
        } else if (data[0] == 66) {
            Y = data[1] - 48;
            if (data[2] == 79 && data[3] == 75) {
                this.driver.ioWriteForced("p" + Y + ".blocked", "1");
            }
        } else if (data[0] == 85) {
            Y = data[1] - 48;
            if (data[2] == 79 && data[3] == 75) {
                this.driver.ioWriteForced("p" + Y + ".blocked", "0");
            }
        }
        AtomicInteger atomicInteger = this.driver.respLock;
        synchronized (atomicInteger) {
            this.driver.respLock.notifyAll();
        }
    }

    private int toNum(byte[] data, int offset, int length, int radix) throws Exception {
        return Integer.parseInt(new String(data, offset, length, "ASCII"), radix);
    }

    boolean isOk() {
        long fromLastMsg = System.currentTimeMillis() - this.lastMsgTs;
        long doubleInterval = 40000L;
        String tooMuchTime = "";
        if (fromLastMsg >= doubleInterval) {
            tooMuchTime = " - it passed too much time from last message!";
        }
        if (this.driver.isDriverInVerboseLog()) {
            userBase.messageLog("driver listener running: " + this.run + " - time from last message: " + fromLastMsg + "ms" + tooMuchTime);
        }
        return this.run && fromLastMsg < doubleInterval;
    }

    void end() {
        this.run = false;
        this.interrupt();
    }
}

