/*
 * Decompiled with CFR 0.152.
 */
package drivers.tsecmacs;

import com.hsyco.hsyco;
import drivers.tsecmacs.Driver;
import drivers.tsecmacs.Utils;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;

public class httpUtils {
    private static HttpURLConnection establishConnection(String path, String method, String host, String token) {
        HttpURLConnection con = null;
        try {
            String url = "https://" + host + path;
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            if (token != null || method.equals("GET") || method.equals("POST")) {
                con.setRequestProperty("Authorization", "Bearer " + token);
            } else {
                con.setRequestProperty("Content-Type", "application/json");
            }
            con.setDoOutput(true);
            con.setRequestMethod(method);
            con.setConnectTimeout(20000);
            con.setReadTimeout(10000);
            return con;
        }
        catch (Exception e2) {
            con.disconnect();
            hsyco.errorLog("Connection exception in request " + path.substring(1) + ": " + e2.toString());
            return null;
        }
    }

    public static void getData(Driver driver, String address, String port, String type) {
        String token = driver.token;
        HttpURLConnection con = null;
        OutputStream os = null;
        try {
            try {
                String json;
                String tosend = json = "{ \"VarName\": \"All-" + type + "-Data\" }";
                con = httpUtils.establishConnection("/generalRequest.json", "POST", String.valueOf(address) + ":" + port, token);
                os = con.getOutputStream();
                os.write(tosend.getBytes());
                os.flush();
                if (con.getResponseCode() == 200) {
                    Utils.dataExtractor(driver, con, type);
                } else if (con.getResponseCode() == 401) {
                    httpUtils.obtainToken(driver, 0, address, port, driver.username, driver.password);
                    httpUtils.getData(driver, address, port, type);
                }
            }
            catch (JSONException e2) {
                hsyco.errorLog("Json error: password malformed. " + e2.toString());
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    con.disconnect();
                }
                catch (Exception exception) {}
            }
            catch (Exception e3) {
                hsyco.errorLog("Exception in request login: " + e3.toString());
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    con.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                con.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static void getAlarmsData(Driver driver, String address, String port, String type) {
        String token = driver.token;
        HttpURLConnection con = null;
        OutputStream os = null;
        try {
            try {
                String json;
                String tosend = json = "{ \"VarName\": \"All-" + type + "-Alarms\" }";
                con = httpUtils.establishConnection("/generalRequest.json", "POST", String.valueOf(address) + ":" + port, token);
                os = con.getOutputStream();
                os.write(tosend.getBytes());
                os.flush();
                if (con.getResponseCode() == 200) {
                    Utils.dataAlarmsExtractor(driver, con, type);
                } else if (con.getResponseCode() == 401) {
                    httpUtils.obtainToken(driver, 0, address, port, driver.username, driver.password);
                    httpUtils.getAlarmsData(driver, address, port, type);
                }
            }
            catch (JSONException e2) {
                hsyco.errorLog("Json error: password malformed. " + e2.toString());
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    con.disconnect();
                }
                catch (Exception exception) {}
            }
            catch (Exception e3) {
                hsyco.errorLog("Exception in request login: " + e3.toString());
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    con.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                con.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean obtainToken(Driver driver, Integer accessType, String address, String port, String username, String password) {
        HttpURLConnection con = null;
        OutputStream os = null;
        try {
            String json;
            String tosend = json = "{\n\"VarName\": \"Login\",\n    \"Data\": {\n        \"ValueObj\": {\n            \"UserAccess\": {\n                \"Id\":1,\n                \"Username\":\"" + username + "\",\n" + "                \"Password\":\"" + password + "\",\n" + "                \"AccessType\":" + accessType + "\n" + "            }\n" + "        }\n" + "    }\n" + "}";
            con = httpUtils.establishConnection("/generalRequest.json", "PUT", String.valueOf(address) + ":" + port, null);
            os = con.getOutputStream();
            os.write(tosend.getBytes());
            os.flush();
            if (con.getResponseCode() == 200) {
                return Utils.loginDataExtractor(driver, con, address, port, username, password);
                {
                }
            }
        }
        catch (JSONException e2) {
            hsyco.errorLog("Json error: password malformed. " + e2.toString());
        }
        catch (Exception e3) {
            hsyco.errorLog("Exception in request login: " + e3.toString());
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                con.disconnect();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean setSensorStatus(Driver driver, String sensorId, String status, String address, String port) {
        HttpURLConnection con = null;
        OutputStream os = null;
        try {
            String json;
            String tosend = json = "{\n  \"VarName\": \"Sensor-Is-Enable\",\n  \"Data\": {\n    \"ValueObj\": {\n      \"Sensor\": {\n        \"Id\": " + sensorId + ",\n" + "        \"IsEnable\": " + status + "\n" + "      }\n" + "    }\n" + "  }\n" + "}";
            con = httpUtils.establishConnection("/generalRequest.json", "PUT", String.valueOf(address) + ":" + port, driver.token);
            os = con.getOutputStream();
            os.write(tosend.getBytes());
            os.flush();
            if (con.getResponseCode() == 200) {
                return Utils.sesnorStatusExtractor(con);
                {
                }
            }
        }
        catch (JSONException e2) {
            hsyco.errorLog(String.valueOf(driver.driverName) + " - Json error: password malformed. " + e2.toString());
        }
        catch (Exception e3) {
            hsyco.errorLog(String.valueOf(driver.driverName) + " - Exception in request sensor status: " + e3.toString());
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                con.disconnect();
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

