/*
 * Decompiled with CFR 0.152.
 */
package drivers.tlabq;

import com.hsyco.userBase;
import java.util.HashMap;
import java.util.Map;

public class Log {
    private static final Map<Integer, String[]> TXT_EVENT_TYPES = new HashMap<Integer, String[]>();
    private static final Map<Integer, String[]> TXT_DEVICE_TYPES;
    private static final String[] TXT_QUICK_ARMING;
    private static final String[] TXT_QUICK_DISARMING;
    private static final String[] TXT_USER;
    private static final String[] TXT_ZONE;
    private static final String[] TXT_REMOTE_CONTROL;
    private static final String[] TXT_RADIO_HOOTER;
    private static final String[] TXT_END_MAINTENANCE;
    private static final String[] TXT_START_MAINTENANCE;
    private static final String[] TXT_REMOTE_USER;
    private static final String[] TXT_KEYBOARD;
    private static final String[] TXT_AREA;
    static int LANGUAGE;
    private int[] log;

    static {
        TXT_EVENT_TYPES.put(0, new String[]{"Armed", "Inserimento"});
        TXT_EVENT_TYPES.put(1, new String[]{"Disarmed", "Disinserimento"});
        TXT_EVENT_TYPES.put(2, new String[]{"Alarm", "Allarme"});
        TXT_EVENT_TYPES.put(3, new String[]{"Pre-alarm", "Preallarme"});
        TXT_EVENT_TYPES.put(4, new String[]{"Tamper", "Manomissione"});
        TXT_EVENT_TYPES.put(5, new String[]{"Theft", "Rapina"});
        TXT_EVENT_TYPES.put(6, new String[]{"Technical event", "Evento tecnico"});
        TXT_EVENT_TYPES.put(7, new String[]{"Technical fault", "Guasto tecnico"});
        TXT_EVENT_TYPES.put(8, new String[]{"Fire", "Incendio"});
        TXT_EVENT_TYPES.put(9, new String[]{"Medical emergency", "Emergenza medica"});
        TXT_EVENT_TYPES.put(10, new String[]{"Flooding", "Allagamento"});
        TXT_EVENT_TYPES.put(11, new String[]{"Coertion", "Coercizione"});
        TXT_EVENT_TYPES.put(12, new String[]{"Radio interference", "Interferenza radio"});
        TXT_EVENT_TYPES.put(13, new String[]{"Radio-device supervision", "Supervisione dispositivo radio"});
        TXT_EVENT_TYPES.put(15, new String[]{"No power", "Mancanza alimentazione"});
        TXT_EVENT_TYPES.put(16, new String[]{"Low battery", "Batteria scarica"});
        TXT_EVENT_TYPES.put(17, new String[]{"Maintenance", "Manutenzione"});
        TXT_EVENT_TYPES.put(18, new String[]{"PSTN fault", "Guasto PSTN"});
        TXT_EVENT_TYPES.put(19, new String[]{"GSM fault", "Guasto GSM"});
        TXT_EVENT_TYPES.put(20, new String[]{"Insufficient SIM credit", "Credito SIM insufficiente"});
        TXT_EVENT_TYPES.put(21, new String[]{"Medical emergency", "Emergenza medica"});
        TXT_EVENT_TYPES.put(22, new String[]{"Theft", "Rapina"});
        TXT_EVENT_TYPES.put(23, new String[]{"Radio hooter fault", "Guasto sirena radio"});
        TXT_EVENT_TYPES.put(24, new String[]{"Remote access", "Accesso remoto"});
        TXT_EVENT_TYPES.put(25, new String[]{"Keyboard fault", "Guasto tastiera"});
        TXT_EVENT_TYPES.put(26, new String[]{"Device tamper", "Manomissione dispositivo"});
        TXT_EVENT_TYPES.put(28, new String[]{"Blinded zone", "Accecamento zona"});
        TXT_EVENT_TYPES.put(29, new String[]{"Cloud access", "Accesso da cloud"});
        TXT_EVENT_TYPES.put(224, new String[]{"System restart", "Restart sistema"});
        TXT_DEVICE_TYPES = new HashMap<Integer, String[]>();
        TXT_DEVICE_TYPES.put(1, new String[]{"Keyboard", "Tastiera"});
        TXT_DEVICE_TYPES.put(2, new String[]{"Sensor", "Sensore"});
        TXT_DEVICE_TYPES.put(3, new String[]{"Expansion", "Espansione"});
        TXT_DEVICE_TYPES.put(4, new String[]{"Proximity reader", "Inseritore"});
        TXT_DEVICE_TYPES.put(5, new String[]{"Key zone", "Zona punto chiave"});
        TXT_DEVICE_TYPES.put(6, new String[]{"Timer", "Timer"});
        TXT_DEVICE_TYPES.put(7, new String[]{"SMS", "SMS"});
        TXT_DEVICE_TYPES.put(8, new String[]{"Remote user", "Utente remoto"});
        TXT_DEVICE_TYPES.put(9, new String[]{"Remote control", "Radiocomando"});
        TXT_DEVICE_TYPES.put(10, new String[]{"Radio hooter", "Sirena radio"});
        TXT_DEVICE_TYPES.put(11, new String[]{"Battery charger", "Carica batteria"});
        TXT_DEVICE_TYPES.put(12, new String[]{"PSTN or GSM phone", "Telefono PSTN o GSM"});
        TXT_DEVICE_TYPES.put(13, new String[]{"Radiobus", "Radiobus"});
        TXT_DEVICE_TYPES.put(254, new String[]{"System", "Sistema"});
        TXT_QUICK_ARMING = new String[]{"Quick arming", "Inserimento rapido"};
        TXT_QUICK_DISARMING = new String[]{"Quick disarming", "Disinserimento rapido"};
        TXT_USER = new String[]{"User", "Utente"};
        TXT_ZONE = new String[]{"Zone", "Zona"};
        TXT_REMOTE_CONTROL = new String[]{"Remote control", "Radiocomando"};
        TXT_RADIO_HOOTER = new String[]{"Radio hooter", "Sirena radio"};
        TXT_END_MAINTENANCE = new String[]{"End maintenance", "Fine manutenzione"};
        TXT_START_MAINTENANCE = new String[]{"Start maintenance", "Inizio manutenzione"};
        TXT_REMOTE_USER = new String[]{"Remote user", "Utente remoto"};
        TXT_KEYBOARD = new String[]{"Keyboard", "Tastiera"};
        TXT_AREA = new String[]{"Area", "Area"};
        LANGUAGE = 0;
    }

    public Log(int[] n2) {
        this.log = n2;
    }

    public boolean equals(Object o2) {
        Log l2 = (Log)o2;
        int i2 = 0;
        while (i2 < this.log.length) {
            if (this.log[i2] != l2.log[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public String decodeLogMessage(String iosId) {
        int eventTypeId = this.log[0];
        if (!TXT_EVENT_TYPES.containsKey(eventTypeId)) {
            return "";
        }
        String s = TXT_EVENT_TYPES.get(eventTypeId)[LANGUAGE];
        int devTypeId = this.log[1];
        String devType = "";
        if (TXT_DEVICE_TYPES.containsKey(devTypeId)) {
            devType = TXT_DEVICE_TYPES.get(devTypeId)[LANGUAGE];
        }
        if (eventTypeId == 0 || eventTypeId == 1) {
            s = String.valueOf(s) + " - " + devType;
            if (devTypeId == 1 || devTypeId == 4) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
                s = this.log[3] == 255 && eventTypeId == 0 ? String.valueOf(s) + " - " + TXT_QUICK_ARMING[LANGUAGE] : (this.log[3] == 255 && eventTypeId == 1 ? String.valueOf(s) + " - " + TXT_QUICK_DISARMING[LANGUAGE] : String.valueOf(s) + " - " + this.getTxt(iosId, TXT_USER, "u", null, this.log[3] + 1));
                s = String.valueOf(s) + this.bitmapGroups(iosId);
            } else if (devTypeId == 6 || devTypeId == 5 || devTypeId == 9) {
                s = String.valueOf(s) + " " + (this.log[2] + 1) + this.bitmapGroups(iosId);
            } else if (devTypeId == 8) {
                s = String.valueOf(s) + this.bitmapGroups(iosId);
            } else if (devTypeId == 12) {
                s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_USER, "u", null, this.log[3] + 1) + this.bitmapGroups(iosId);
            }
        } else if (eventTypeId == 2 || eventTypeId == 3 || eventTypeId == 4 || eventTypeId == 5 || eventTypeId == 6 || eventTypeId == 7 || eventTypeId == 8 || eventTypeId == 9 || eventTypeId == 10 || eventTypeId == 28) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_ZONE, "z", this.log[3] == 128 ? "e" : null, this.log[2] + 1);
        } else if (eventTypeId == 21 || eventTypeId == 22) {
            s = String.valueOf(s) + " - " + TXT_REMOTE_CONTROL[LANGUAGE] + " " + (this.log[2] + 1);
        } else if (eventTypeId == 26 || eventTypeId == 16) {
            s = String.valueOf(s) + " - " + devType;
            if (devTypeId != 254) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
            }
        } else if (eventTypeId == 23) {
            s = String.valueOf(s) + " - " + TXT_RADIO_HOOTER[LANGUAGE] + " " + (this.log[2] + 1);
        } else if (eventTypeId == 15) {
            s = String.valueOf(s) + " - " + devType;
            if (devTypeId == 11) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
            }
        } else if (eventTypeId == 11) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_USER, "u", null, this.log[3] + 1);
        } else if (eventTypeId == 17) {
            s = this.log[1] == 0 ? String.valueOf(s) + " - " + TXT_END_MAINTENANCE[LANGUAGE] : String.valueOf(s) + " - " + TXT_START_MAINTENANCE[LANGUAGE];
            s = this.log[2] == 0 ? String.valueOf(s) + " - " + this.getTxt(iosId, TXT_USER, "u", null, this.log[3] + 1) : String.valueOf(s) + " - " + TXT_REMOTE_USER[LANGUAGE];
        } else if (eventTypeId == 13) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_ZONE, "z", null, this.log[2] + 1);
        } else if (eventTypeId == 25) {
            s = String.valueOf(s) + " - " + TXT_KEYBOARD[LANGUAGE] + " " + (this.log[2] + 1);
        } else if (eventTypeId == 24) {
            s = String.valueOf(s) + " - " + this.log[3] + "." + this.log[4] + "." + this.log[5] + "." + this.log[6];
        } else if (eventTypeId == 29) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_USER, "u", null, this.log[3] + 1);
        }
        return s;
    }

    private String getTxt(String iosId, String[] txts, String prefix, String suffix, int id) {
        String nameDp = String.valueOf(iosId) + "." + prefix + id;
        if (suffix != null) {
            nameDp = String.valueOf(nameDp) + suffix;
        }
        nameDp = String.valueOf(nameDp) + ".name";
        String name = userBase.ioGet(nameDp);
        String txt = String.valueOf(txts[LANGUAGE]) + " ";
        if (name != null && !name.isEmpty()) {
            txt = String.valueOf(txt) + name + " (";
        }
        txt = String.valueOf(txt) + id;
        if (suffix != null) {
            txt = String.valueOf(txt) + suffix;
        }
        if (name != null) {
            txt = String.valueOf(txt) + ")";
        }
        return txt;
    }

    public String bitmapGroups(String iosId) {
        String s = "";
        if (this.log[4] != 0) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_AREA, "a", null, 1) + " [" + Log.decodeBitmapGroups(this.log[4]) + "]";
        }
        if (this.log[5] != 0) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_AREA, "a", null, 2) + " [" + Log.decodeBitmapGroups(this.log[5]) + "]";
        }
        if (this.log[6] != 0) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_AREA, "a", null, 3) + " [" + Log.decodeBitmapGroups(this.log[6]) + "]";
        }
        if (this.log[7] != 0) {
            s = String.valueOf(s) + " - " + this.getTxt(iosId, TXT_AREA, "a", null, 4) + " [" + Log.decodeBitmapGroups(this.log[7]) + "]";
        }
        return s;
    }

    public static String decodeBitmapGroups(int b2) {
        String res = "";
        String s = Integer.toBinaryString(b2);
        switch (Integer.toBinaryString(b2).length()) {
            case 1: {
                s = "000" + s;
                break;
            }
            case 2: {
                s = "00" + s;
                break;
            }
            case 3: {
                s = "0" + s;
            }
        }
        if (s.charAt(3) == '1') {
            res = String.valueOf(res) + ",A";
        }
        if (s.charAt(2) == '1') {
            res = String.valueOf(res) + ",B";
        }
        if (s.charAt(1) == '1') {
            res = String.valueOf(res) + ",C";
        }
        if (s.charAt(0) == '1') {
            res = String.valueOf(res) + ",D";
        }
        if (res.length() != 0) {
            return res.substring(1);
        }
        return "";
    }

    public String getTime() {
        int hours = this.log[10];
        int minutes = this.log[11];
        int day = this.log[12];
        int month = this.log[13];
        int yearLow = this.log[14];
        int yearHigh = this.log[15];
        int year = yearHigh * 256 + yearLow;
        return String.valueOf(day < 10 ? "0" : "") + day + "/" + (month < 10 ? "0" : "") + month + "/" + year + " " + (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public static Log readMostRecentLog(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            String[] fields = s.split(",");
            int[] n2 = new int[fields.length];
            int i2 = 0;
            while (i2 < fields.length) {
                n2[i2] = Integer.parseInt(fields[i2]);
                ++i2;
            }
            return new Log(n2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String writeMostRecentLog() {
        StringBuilder s = new StringBuilder();
        int i2 = 0;
        while (i2 < this.log.length) {
            s.append("," + this.log[i2]);
            ++i2;
        }
        if (s.length() > 0) {
            return s.substring(1);
        }
        return "";
    }
}

