/*
 * Decompiled with CFR 0.152.
 */
package drivers.texecom;

import drivers.texecom.Driver;
import drivers.texecom.RespException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class Consumer {
    static final Consumer OK_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            if (len != 5 || resp[0] != 79 || resp[1] != 75) {
                String err = new String(resp, 0, len - 3, StandardCharsets.US_ASCII);
                throw new RespException("Response: " + err);
            }
        }
    };
    static final Consumer PANEL_ID_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            String id = new String(resp, 0, 32, StandardCharsets.US_ASCII);
            driver.messageLog("Connected to panel: " + id);
        }
    };
    static final Consumer ZONE_STATUS_CONSUMER = new Consumer(){
        private int startZone;

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            int i2 = 0;
            while (i2 < (len - 3) / 2) {
                int z = i2 + this.startZone + 1;
                byte lb = resp[i2 * 2];
                byte hb = resp[i2 * 2 + 1];
                int stat = lb & 3;
                int fault = lb >>> 2 & 1;
                int test = lb >>> 3 & 1;
                int alarm = lb >>> 4 & 1;
                int manByp = lb >>> 5 & 1;
                int autoByp = lb >>> 6 & 1;
                int latched = hb & 1;
                int walk = hb >>> 1 & 1;
                int activity = hb >>> 2 & 1;
                if (stat == 0) {
                    driver.ioWrite("z" + z + ".open", "0", true);
                    driver.ioWrite("z" + z + ".tamper", "0", true);
                    driver.ioWrite("z" + z + ".short", "0", true);
                } else if (stat == 1) {
                    driver.ioWrite("z" + z + ".open", "1", true);
                    driver.ioWrite("z" + z + ".tamper", "0", true);
                    driver.ioWrite("z" + z + ".short", "0", true);
                } else if (stat == 2) {
                    driver.ioWrite("z" + z + ".open", "0", true);
                    driver.ioWrite("z" + z + ".tamper", "1", true);
                    driver.ioWrite("z" + z + ".short", "0", true);
                } else if (stat == 3) {
                    driver.ioWrite("z" + z + ".open", "0", true);
                    driver.ioWrite("z" + z + ".tamper", "0", true);
                    driver.ioWrite("z" + z + ".short", "1", true);
                }
                driver.ioWrite("z" + z + ".fault", "" + fault, true);
                driver.ioWrite("z" + z + ".test", "" + test, true);
                driver.ioWrite("z" + z + ".alarm", "" + alarm, true);
                driver.ioWrite("z" + z + ".bypass.man", "" + manByp, true);
                driver.ioWrite("z" + z + ".bypass.auto", "" + autoByp, true);
                driver.ioWrite("z" + z + ".latched", "" + latched, true);
                driver.ioWrite("z" + z + ".walk", "" + walk, true);
                driver.ioWrite("z" + z + ".activity", "" + activity, true);
                ++i2;
            }
        }

        @Override
        void setOption(int option) {
            this.startZone = option;
        }
    };
    static final Consumer SYSTEM_STATUS_CONSUMER = new Consumer(){
        private final String[] BLOCK0 = new String[]{"fault.ats", "fault.mains", "fault.fuse.aux", "tamper.bell", "tamper.aux", "tamper.lid", "engineer", "confirm"};
        private final String[] BLOCK1 = new String[]{"service", "fault.fuse.bell", "fault.battery", "test.battery", "light", "open", "armed", "coms.fail"};
        private final String[] BLOCK2 = new String[]{"coms.success", "coms.active", "udl.lockout", "udl.call", "udl.enabled", "alarm.confirmed", "custom1a", "custom1b"};
        private final String[] BLOCK3 = new String[]{"custom2a", "custom2b", "custom2ab", "radio.fail", "radio.success", "radio.nosig", "radio.lost", "custom3a"};
        private final String[] BLOCK4 = new String[]{"custom3b", "custom3ab", "custom4a", "custom4b", "custom4ab", "com1.fault", "com2.fault", "com1.nosig"};
        private final String[] BLOCK5 = new String[]{"com2.nosig", "coms.fault", "radio.jam", "radio.tamper", "test.detector", "test.remote", "noats", "fault.cie"};
        private final String[] BLOCK6 = new String[]{"psu.fault.fuse", "psu.fault.battery", "test.wd", "psu.fault.mains", "com1.power", "com2.power", "com3.power", "fault.ip"};
        private final String[] BLOCK7 = new String[]{"battery.low", "fault.ps", "fault.charger"};

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            this.map(driver, this.BLOCK0, resp[0]);
            this.map(driver, this.BLOCK1, resp[1]);
            this.map(driver, this.BLOCK2, resp[2]);
            this.map(driver, this.BLOCK3, resp[3]);
            this.map(driver, this.BLOCK4, resp[4]);
            this.map(driver, this.BLOCK5, resp[5]);
            this.map(driver, this.BLOCK6, resp[6]);
            this.map(driver, this.BLOCK7, resp[7]);
        }
    };
    static final Consumer PARTITIONS_STATUS_CONSUMER = new Consumer(){
        private final String[] flags = new String[]{"alarm", "alarm.guard", "alarm.guard.access", "alarm.entry", "alarm.confirmed", "alarm.audible", "alarm.silent", "alarm.gas", "alarm.pa", "alarm.pa.silent", "alarm.duress", "alarm.fire", "alarm.medical", "alarms.aux", "tamper", "abort", "ready", "entry", "entry.2", "exit", "entryexit", "armed", "armed.full", "armed.part", "arming.part", "armable.force", "armed.force", "armed.fail", "bell.sab", "bell.scb", "strobe", "detector.latch", "detector.reset", "test.walk", "bypass", "bypass24", "reset", "strike", "chime.mimic", "chime.enabled", "doubleknowck", "beampair", "test.zone", "test.fail", "alarm.internal", "arming.auto", "arming.time", "code.1", "code.2", "secured", "arm.part.1", "arm.part.2", "arm.part.3", "alarm.custom", "warning.zone", "warning.arm", "forced", "locked", "armed.all", "arm.time.disabled", "armedalarm", "alarm.intruder", "speaker.mimic", "armedexit", "detector.fault", "detector.masked", "fault", "led", "armed.full.entry", "fire", "pa.confirmed", "alarm.confirmed2"};

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            int partitionsPerFlag = (len - 3) / 18;
            int i2 = 0;
            while (i2 < 18) {
                String flag = this.flags[driver.REQ_PARTITIONS_OUTPUT_STATUS[2] + i2];
                int p = 0;
                while (p < driver.maxPartition) {
                    int b2 = p / 8;
                    int v = resp[i2 * partitionsPerFlag + b2];
                    v = v >>> p % 8 & 1;
                    driver.ioWrite("p" + (p + 1) + "." + flag, "" + v, true);
                    ++p;
                }
                ++i2;
            }
        }
    };
    static final Consumer LCD_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            String text = new String(resp, 0, 32, StandardCharsets.US_ASCII);
            driver.ioWrite("keypad.text", text, false);
            driver.uiSet("keypad.text", "text", text);
        }
    };
    static final Consumer LOG_POINTER_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            int pointer = (resp[1] & 0xFF) * 256 + (resp[0] & 0xFF);
            if (driver.logPointer != pointer) {
                try {
                    if (driver.logPointer >= 0) {
                        int i2 = driver.logPointer;
                        while (i2 < pointer) {
                            driver.REQ_LOG_EVENT[3] = (byte)i2;
                            driver.REQ_LOG_EVENT[4] = (byte)(i2 >>> 8);
                            driver.writeAndProcessResp(driver.REQ_LOG_EVENT, 0, LOG_EVENT_CONSUMER);
                            driver.logPointer = i2++;
                        }
                    }
                    driver.logPointer = pointer;
                }
                catch (IOException e2) {
                    driver.errorLog("Error processing logs: " + e2);
                }
            }
        }
    };
    static final Consumer LOG_EVENT_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            String text = new String(resp, 0, len - 3, StandardCharsets.US_ASCII);
            driver.securityLog(text);
        }
    };
    static final Consumer OUTPUTS_STATUS_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            int i2 = 0;
            while (i2 < 8) {
                int v = resp[0] >>> i2 & 1;
                driver.ioWrite("o" + (i2 + 1), "" + v, true);
                v = resp[1] >>> i2 & 1;
                driver.ioWrite("ox" + (i2 + 1), "" + v, true);
                ++i2;
            }
        }
    };
    static final Consumer TIME_CONSUMER = new Consumer(){

        @Override
        void accept(Driver driver, byte[] resp, int len) throws RespException {
            StringBuilder sb = new StringBuilder();
            if (resp[2] < 10) {
                sb.append('0');
            }
            sb.append(resp[2]);
            sb.append("-");
            if (resp[1] < 10) {
                sb.append('0');
            }
            sb.append(resp[1]);
            sb.append("-");
            if (resp[0] < 10) {
                sb.append('0');
            }
            sb.append(resp[0]);
            sb.append(" ");
            if (resp[3] < 10) {
                sb.append('0');
            }
            sb.append(resp[3]);
            sb.append(":");
            if (resp[4] < 10) {
                sb.append('0');
            }
            sb.append(resp[4]);
            driver.ioWrite("time", sb.toString(), false);
        }
    };

    abstract void accept(Driver var1, byte[] var2, int var3) throws RespException;

    void setOption(int option) {
    }

    void map(Driver driver, String[] dps, byte map) {
        int i2 = 0;
        while (i2 < dps.length) {
            int v = map >>> i2 & 1;
            driver.ioWrite(dps[i2], "" + v, true);
            ++i2;
        }
    }
}

