/*
 * Decompiled with CFR 0.152.
 */
package drivers.telegram;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.util;
import drivers.telegram.TelegramBot;
import drivers.telegram.requests.SendMessageRequest;
import drivers.telegram.requests.SendPhotoRequest;
import drivers.telegram.types.Message;
import drivers.telegram.types.ReplyKeyboardMarkup;
import drivers.telegram.types.ReplyMarkup;
import drivers.telegram.types.Update;
import drivers.telegram.types.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final int POLLING_TIMEOUT_SECONDS = 30;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static Properties passwords = new Properties();
    private static Properties tokens = new Properties();
    private String serverName = null;
    private Boolean online = null;
    private String token = null;
    private String password = null;
    private TelegramBot telegram = null;
    private Integer offset = null;
    private Properties users = new Properties();
    private File usersFile = null;
    private long usersFileLastModified = -1L;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.serverName = name;
        this.token = config.get("token");
        this.token = tokens.containsKey(this.serverName) ? tokens.getProperty(this.serverName) : config.get("token");
        this.password = passwords.containsKey(this.serverName) ? passwords.getProperty(this.serverName) : config.get("password");
        this.usersFile = new File("telegram-" + this.serverName.toLowerCase() + ".ini");
        if (this.password != null) {
            this.usersFileCheckLoad();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        block27: {
            try {
                if (this.token != null) {
                    if (this.telegram == null) {
                        this.telegram = new TelegramBot(this.token);
                        String botName = this.telegram.getBotName(10000);
                        this.online = true;
                        this.ioWrite("connection", "online");
                        this.ioWrite("bot", botName);
                        break block27;
                    }
                    List<Update> updates = this.telegram.pollUpdates(this.offset, null, 30);
                    int i2 = 0;
                    while (i2 < updates.size()) {
                        Update update = updates.get(i2);
                        Message message = null;
                        try {
                            message = update.getMessage();
                        }
                        catch (JSONException e2) {
                            try {
                                message = new Message((JSONObject)update.get("edited_message"));
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                        }
                        int updateId = update.getUpdateId();
                        if (this.offset == null || updateId >= this.offset) {
                            this.offset = updateId + 1;
                        }
                        if (message != null) {
                            String text = message.getText();
                            User sender = message.getFrom();
                            long id = sender.getId();
                            if (Configuration.verboseLog) {
                                this.messageLog(String.valueOf(this.serverName) + ": Message: " + message.toString().replaceAll("[\\t\\n\\r]+", " "));
                            }
                            if (this.password != null) {
                                this.usersFileCheckLoad();
                            }
                            if (this.password != null && text != null && this.password.equals(text.trim())) {
                                if (this.users.containsKey(Long.toString(id))) {
                                    this.messageLog(String.valueOf(this.serverName) + ": User id: " + id + " already authenticated");
                                } else if (!this.users.containsKey("-" + id)) {
                                    Properties properties = this.users;
                                    synchronized (properties) {
                                        this.users.put(Long.toString(id), this.getUserFullName(sender));
                                        this.usersFileSave();
                                    }
                                    this.messageLog(String.valueOf(this.serverName) + ": User id: " + id + " authenticated");
                                } else {
                                    this.errorLog(String.valueOf(this.serverName) + ": Authentication message rejected from disabled sender id: " + id + " (" + this.getUserFullName(sender) + ")");
                                }
                            } else if (this.password == null || this.users.containsKey(Long.toString(id))) {
                                this.ioWriteForced("message.json", message.toString());
                                if (text != null) {
                                    this.ioWriteForced("message." + id, text);
                                }
                            } else if (Configuration.verboseLog) {
                                this.errorLog(String.valueOf(this.serverName) + ": Message rejected from unauthorized sender id: " + id + " (" + this.getUserFullName(sender) + ")");
                            }
                        }
                        ++i2;
                    }
                    break block27;
                }
                if (this.online != null && this.online.booleanValue()) {
                    this.end();
                }
                this.sleep(5000L);
            }
            catch (Exception e3) {
                this.errorLog(String.valueOf(this.serverName) + ": Polling exception: " + e3);
                this.sleep(5000L);
                this.end();
            }
        }
        return true;
    }

    public boolean end() {
        this.telegram = null;
        this.online = false;
        this.ioWrite("connection", "offline");
        this.ioWrite("bot", "");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        block27: {
            String nameLowerCase = name.toLowerCase();
            String valueTrimmed = value == null ? "" : value.trim();
            try {
                if (nameLowerCase.startsWith("message.")) {
                    ReplyKeyboardMarkup replyKeyboard;
                    String text;
                    int messageId;
                    String chatId;
                    String parseMode;
                    String[] to = nameLowerCase.substring(8).split("[.]");
                    if (to[0].equals("html") || to[0].equals("image")) {
                        parseMode = to[0];
                        chatId = to[1];
                        messageId = to.length == 3 ? Integer.parseInt(to[2]) : 0;
                    } else {
                        parseMode = null;
                        chatId = to[0];
                        messageId = to.length == 2 ? Integer.parseInt(to[1]) : 0;
                    }
                    int keyboardStartIndex = valueTrimmed.indexOf(91);
                    if (keyboardStartIndex >= 0 && valueTrimmed.endsWith("]")) {
                        text = valueTrimmed.substring(0, keyboardStartIndex).trim();
                        String[][] keyboard = Driver.matrixParser(valueTrimmed.substring(keyboardStartIndex + 1, valueTrimmed.length() - 1));
                        replyKeyboard = new ReplyKeyboardMarkup(keyboard, false, true, false);
                    } else {
                        text = valueTrimmed;
                        replyKeyboard = null;
                    }
                    if (chatId.equalsIgnoreCase("all")) {
                        if (this.password != null) {
                            this.usersFileCheckLoad();
                        }
                        Enumeration<Object> e2 = this.users.keys();
                        while (e2.hasMoreElements()) {
                            String u = (String)e2.nextElement();
                            if (u.startsWith("-")) continue;
                            this.send(Long.parseLong(u), text, parseMode, 0, replyKeyboard);
                        }
                    } else {
                        this.send(Long.parseLong(chatId), text, parseMode, messageId, replyKeyboard);
                    }
                    break block27;
                }
                if (name.equalsIgnoreCase("password")) {
                    if (valueTrimmed.length() > 0) {
                        this.password = new String(valueTrimmed);
                        passwords.put(this.serverName, this.password);
                    } else {
                        this.password = null;
                        passwords.remove(this.serverName);
                    }
                    break block27;
                }
                if (name.equalsIgnoreCase("token")) {
                    if (valueTrimmed.length() > 0 && !valueTrimmed.equals(this.token)) {
                        this.end();
                        this.token = new String(valueTrimmed);
                        tokens.put(this.serverName, this.token);
                    } else if (valueTrimmed.length() == 0) {
                        this.end();
                        this.token = null;
                        tokens.remove(this.serverName);
                    }
                    break block27;
                }
                if (name.equalsIgnoreCase("disable")) {
                    Properties properties = this.users;
                    synchronized (properties) {
                        if (this.users.containsKey(value)) {
                            String userName = this.users.getProperty(value);
                            this.users.remove(value);
                            this.users.put("-" + value, userName);
                            this.usersFileSave();
                            this.messageLog(String.valueOf(this.serverName) + ": User id: " + value + " disabled");
                        }
                        break block27;
                    }
                }
                if (!name.equalsIgnoreCase("enable")) break block27;
                Properties properties = this.users;
                synchronized (properties) {
                    if (this.users.containsKey("-" + value)) {
                        String userName = this.users.getProperty("-" + value);
                        this.users.remove("-" + value);
                        this.users.put(value, userName);
                        this.usersFileSave();
                        this.messageLog(String.valueOf(this.serverName) + ": User id: " + value + " enabled");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void send(long chatId, String text, String parseMode, Integer replyToMessageId, ReplyMarkup replyMarkup) throws Exception {
        if ("image".equals(parseMode)) {
            String textl = text.toLowerCase();
            if (textl.startsWith("cam:")) {
                Object r;
                File f2;
                int i2 = text.indexOf(32);
                if (i2 == -1) {
                    text = "";
                    f2 = util.getCameraTempFile(textl);
                } else {
                    text = text.substring(i2).trim();
                    f2 = util.getCameraTempFile(textl.substring(0, i2));
                }
                try {
                    r = this.telegram.sendRequest(new SendPhotoRequest(chatId, f2.toPath(), text, 0, replyMarkup), 10000);
                }
                finally {
                    f2.delete();
                }
                if (Configuration.verboseLog) {
                    this.messageLog(String.valueOf(this.serverName) + ": Message sent: " + r.toString().replaceAll("[\\t\\n\\r]+", " "));
                }
            } else if (textl.startsWith("file:")) {
                File f3;
                int i3 = text.indexOf(32);
                if (i3 == -1) {
                    f3 = new File(text.substring(5));
                    text = "";
                } else {
                    f3 = new File(text.substring(5, i3));
                    text = text.substring(i3).trim();
                }
                Object r = this.telegram.sendRequest(new SendPhotoRequest(chatId, f3.toPath(), text, 0, replyMarkup), 10000);
                if (Configuration.verboseLog) {
                    this.messageLog(String.valueOf(this.serverName) + ": Message sent: " + r.toString().replaceAll("[\\t\\n\\r]+", " "));
                }
            }
        } else {
            Object r = this.telegram.sendRequest(new SendMessageRequest(chatId, text, parseMode, false, 0, replyMarkup), 10000);
            if (Configuration.verboseLog) {
                this.messageLog(String.valueOf(this.serverName) + ": Message sent: " + r.toString().replaceAll("[\\t\\n\\r]+", " "));
            }
        }
    }

    private String getUserFullName(User user2) {
        StringBuffer sb = new StringBuffer();
        try {
            String first = user2.getFirstName();
            String last = user2.getLastName();
            if (first != null) {
                sb.append(first);
            }
            if (first != null && last != null) {
                sb.append(" ");
            }
            if (last != null) {
                sb.append(last);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usersFileCheckLoad() {
        try {
            Properties properties = this.users;
            synchronized (properties) {
                long t = this.usersFile.lastModified();
                if (t == this.usersFileLastModified) {
                    return;
                }
                this.usersFileLastModified = t;
                if (t == 0L) {
                    this.users.clear();
                    hsyco.messageLog(String.valueOf(this.serverName) + ": " + this.usersFile.getName() + " users file cleared");
                } else {
                    FileInputStream fis = new FileInputStream(this.usersFile);
                    this.users.load(fis);
                    fis.close();
                    hsyco.messageLog(String.valueOf(this.serverName) + ": " + this.usersFile.getName() + " users file reloaded");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usersFileSave() throws Exception {
        File tempFile = new File(String.valueOf(isWindows ? "_" : ".~") + this.usersFile.getName());
        FileOutputStream fos = new FileOutputStream(tempFile);
        Properties properties = this.users;
        synchronized (properties) {
            this.users.store(fos, "Generated by HSYCO 3.9.0 BETA Build 0139 DEV 23");
            fos.flush();
            fos.close();
            if (isWindows) {
                this.usersFile.delete();
            }
            tempFile.renameTo(this.usersFile);
            this.usersFile.setWritable(true, false);
            this.usersFileLastModified = this.usersFile.lastModified();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[][] matrixParser(String text) {
        int state = 0;
        Vector<Vector> matrix = new Vector<Vector>();
        Vector row = null;
        StringBuffer item = null;
        try {
            int i2 = 0;
            while (i2 < text.length()) {
                char c2 = text.charAt(i2);
                block1 : switch (c2) {
                    case '[': {
                        switch (state) {
                            case 0: {
                                state = 1;
                                row = new Vector();
                                item = new StringBuffer();
                                break block1;
                            }
                        }
                        return null;
                    }
                    case ']': {
                        switch (state) {
                            case 1: {
                                state = 0;
                                row.add(item.toString().trim());
                                matrix.add(row);
                                break block1;
                            }
                        }
                        return null;
                    }
                    case ',': {
                        switch (state) {
                            case 0: {
                                break block1;
                            }
                            case 1: {
                                row.add(item.toString().trim());
                                item = new StringBuffer();
                                break block1;
                            }
                        }
                        return null;
                    }
                    case ' ': {
                        switch (state) {
                            case 0: {
                                break block1;
                            }
                            case 1: {
                                item.append(c2);
                                break block1;
                            }
                        }
                        return null;
                    }
                    default: {
                        item.append(c2);
                    }
                }
                ++i2;
            }
            String[][] ret = new String[matrix.size()][];
            int i3 = 0;
            while (i3 < ret.length) {
                row = (Vector)matrix.get(i3);
                String[] retr = new String[row.size()];
                int j2 = 0;
                while (j2 < retr.length) {
                    retr[j2] = (String)row.get(j2);
                    ++j2;
                }
                ret[i3] = retr;
                ++i3;
            }
            return ret;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

