/*
 * Decompiled with CFR 0.152.
 */
package drivers.teledata;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String host = null;
    private int unitid = 1;
    private boolean gui = true;
    private boolean startupevent = true;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String name = null;
    private int online = -1;
    private int currentPanelIndex = 1;
    private int loopsNumber = 1;
    private int panelsNumber = 1;
    private int startRegPanel1 = 9000;
    private int startRegPanel2 = 17000;
    private boolean readError = false;
    static String FILE1 = "./teledata.ini";
    private boolean fileCheck = false;
    private long timestamp1;

    public boolean init(String name, HashMap<String, String> config) {
        block21: {
            super.init(name);
            this.name = name;
            try {
                this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            String s = config.get("unitid");
            if (s != null) {
                try {
                    this.unitid = Integer.parseInt(s);
                }
                catch (NumberFormatException e3) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - unitid ignored");
                }
            }
            if ((s = config.get("loopsnumber")) != null) {
                try {
                    this.loopsNumber = Integer.parseInt(s);
                    if (this.loopsNumber > 16) {
                        this.loopsNumber = 16;
                    }
                }
                catch (NumberFormatException e4) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - loopsnumber ignored");
                }
            }
            if ((s = config.get("panelsnumber")) != null) {
                try {
                    this.panelsNumber = Integer.parseInt(s);
                    if (this.panelsNumber > 12) {
                        this.panelsNumber = 12;
                    }
                }
                catch (NumberFormatException e5) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - sensorsnumber ignored");
                }
            }
            if ((s = config.get("gui")) != null) {
                try {
                    this.gui = Boolean.parseBoolean(s);
                }
                catch (Exception e6) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
                }
            }
            if ((s = config.get("startupevents")) != null) {
                try {
                    this.startupevent = Boolean.parseBoolean(s);
                }
                catch (Exception e7) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents gui ignored");
                }
            }
            try {
                this.loadNames();
            }
            catch (FileNotFoundException e8) {
                if (!this.isVerboseLog()) break block21;
                this.messageLog(String.valueOf(name) + ": cannot load teledata.ini file...");
            }
        }
        return true;
    }

    public boolean loop() {
        int startingReg = 0;
        startingReg = this.currentPanelIndex == 1 ? this.startRegPanel1 : this.startRegPanel2 + 4000 * (this.currentPanelIndex - 2);
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ": current panel: " + this.currentPanelIndex + " | starting register: " + startingReg);
        }
        this.readCumulativeStatus();
        this.readPanelStatus(startingReg);
        ++this.currentPanelIndex;
        if (this.currentPanelIndex > this.panelsNumber) {
            block6: {
                this.currentPanelIndex = 1;
                if (!this.startupevent) {
                    this.startupevent = true;
                }
                try {
                    this.checkNames();
                }
                catch (FileNotFoundException e2) {
                    if (!this.isVerboseLog()) break block6;
                    this.messageLog(String.valueOf(this.name) + ": error while loading teledata.ini file");
                }
            }
            if (this.readError) {
                this.ioWrite("connection", "offline");
                return false;
            }
            this.ioWrite("connection", "online");
        }
        return true;
    }

    public boolean end() {
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        block11: {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + ": command: " + name + " / value: " + value);
            }
            if (name.equalsIgnoreCase("reset")) {
                try {
                    int val = Integer.valueOf(value);
                    if (val > 12) break block11;
                    byte panelAddr = (byte)val;
                    byte highNibble = (byte)(panelAddr << 4);
                    byte[] byArray = new byte[2];
                    byArray[1] = highNibble;
                    byte[] cmd = byArray;
                    userBase.modbusWriteSingleRegister(this.host, this.unitid, 13, cmd);
                    this.ioWrite("reset", "1");
                    this.sleep(1000L);
                    this.ioWrite("reset", "0");
                    byte[] cmd2 = new byte[2];
                    userBase.modbusWriteSingleRegister(this.host, this.unitid, 13, cmd2);
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(name) + ": reset command ok");
                    }
                    break block11;
                }
                catch (Exception e2) {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(name) + ": reset command error");
                    }
                    break block11;
                }
            }
            if (name.equalsIgnoreCase("silence")) {
                try {
                    int val = Integer.valueOf(value);
                    if (val <= 12) {
                        byte panelAddr = (byte)val;
                        byte highNibble = (byte)(panelAddr << 4);
                        byte[] byArray = new byte[2];
                        byArray[1] = highNibble;
                        byte[] cmd = byArray;
                        userBase.modbusWriteSingleRegister(this.host, this.unitid, 12, cmd);
                        this.ioWrite("silence", "1");
                        this.sleep(1000L);
                        this.ioWrite("silence", "0");
                        byte[] cmd2 = new byte[2];
                        userBase.modbusWriteSingleRegister(this.host, this.unitid, 12, cmd2);
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(name) + ": silence command ok");
                        }
                    }
                }
                catch (Exception e3) {
                    if (!this.isVerboseLog()) break block11;
                    this.messageLog(String.valueOf(name) + ": silence command error");
                }
            }
        }
    }

    private void readCumulativeStatus() {
        int startingReg2 = 61001;
        int cPanel = 1;
        while (cPanel <= this.panelsNumber) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": panel " + cPanel + " | cumulative status, starting register: " + startingReg2);
            }
            byte[] response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, startingReg2, 16);
            this.sleep(200L);
            if (response != null) {
                String responseHex = Driver.bytesToHex(response);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": panel " + cPanel + " | cumulative status, response: " + Driver.bytesToHex(response));
                }
                if (responseHex.startsWith("03")) {
                    int cLoop = 1;
                    int i2 = 2;
                    while (i2 < response.length) {
                        byte[] arrB = new byte[]{response[i2], response[i2 + 1]};
                        int value = this.byteArrayToInt(arrB);
                        boolean set = false;
                        String lastValue = userBase.ioGet(String.valueOf(this.name) + ".panel." + cPanel + ".loop." + cLoop + ".value");
                        String newValue = String.valueOf(value);
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": cumulative status, last value: " + lastValue + " | current value: " + newValue);
                        }
                        try {
                            if (!lastValue.equalsIgnoreCase(newValue)) {
                                if (this.isVerboseLog()) {
                                    this.messageLog(String.valueOf(this.name) + ": cumulative status, last value: " + lastValue + " | current value: " + value + " | set = true");
                                }
                                set = true;
                            }
                        }
                        catch (Exception e2) {
                            if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + ": cumulative status, last value: " + lastValue + " | current value: " + value + " | EXCEPTION set = true");
                            }
                            set = true;
                        }
                        if (set) {
                            if (this.startupevent) {
                                this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".value", String.valueOf(value));
                            } else {
                                this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".value", String.valueOf(value));
                            }
                            if (this.gui) {
                                this.uiSet("panel." + cPanel + ".loop." + cLoop + ".value", "value", String.valueOf(value));
                            }
                            switch (value) {
                                case 0: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 1: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 2: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 3: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 4: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 5: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 6: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "1");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "1");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "0");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "true");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "false");
                                    break;
                                }
                                case 7: {
                                    if (this.startupevent) {
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWrite("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "1");
                                    } else {
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".normal", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fire", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefault", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".prealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "0");
                                        this.ioWriteNoEvents("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "1");
                                    }
                                    if (!this.gui) break;
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".normal", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fire", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefault", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".prealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".fireprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".faultprealarm", "visible", "false");
                                    this.uiSet("panel." + cPanel + ".loop." + cLoop + ".firefaultprealarm", "visible", "true");
                                    break;
                                }
                            }
                        }
                        if (++cLoop <= this.loopsNumber) {
                            ++i2;
                            ++i2;
                            continue;
                        }
                        break;
                    }
                } else {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                    }
                    if (this.online != 0) {
                        this.online = 0;
                        this.readError = true;
                    }
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
                }
                if (this.online != 0) {
                    this.online = 0;
                    this.readError = true;
                }
            }
            startingReg2 += 16;
            ++cPanel;
        }
    }

    private void readPanelStatus(int startingReg) {
        this.readSensorsStatus(startingReg);
    }

    private void readSensorsStatus(int startingReg) {
        int currentLoopIndex = 1;
        while (currentLoopIndex <= this.loopsNumber) {
            int currentSensorIndex = 1;
            int i2 = 1;
            while (i2 <= 3) {
                if (i2 > 1) {
                    startingReg += 100;
                }
                byte[] response = i2 < 3 ? userBase.modbusReadHoldingRegisters(this.host, this.unitid, startingReg, 100) : userBase.modbusReadHoldingRegisters(this.host, this.unitid, startingReg, 40);
                this.sleep(100L);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": panel " + this.currentPanelIndex + " | loop: " + currentLoopIndex + " | sensors status, reading from register: " + startingReg);
                }
                if (response != null) {
                    String responseHex = Driver.bytesToHex(response);
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": panel " + this.currentPanelIndex + " | loop: " + currentLoopIndex + " | sensors status, response: " + Driver.bytesToHex(response));
                    }
                    if (responseHex.startsWith("03")) {
                        int j2 = 2;
                        while (j2 < response.length) {
                            byte[] arrB = new byte[]{response[j2], response[j2 + 1]};
                            int value = this.byteArrayToInt(arrB);
                            boolean set = false;
                            String lastValue = userBase.ioGet(String.valueOf(this.name) + ".panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".value");
                            String newValue = String.valueOf(value);
                            if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.name) + ": sensors, last value: " + lastValue + " | current value: " + newValue);
                            }
                            try {
                                if (!lastValue.equalsIgnoreCase(newValue)) {
                                    if (this.isVerboseLog()) {
                                        this.messageLog(String.valueOf(this.name) + ": sensors, last value: " + lastValue + " | current value: " + value + " | set = true");
                                    }
                                    set = true;
                                }
                            }
                            catch (Exception e2) {
                                if (this.isVerboseLog()) {
                                    this.messageLog(String.valueOf(this.name) + ": sensors, last value: " + lastValue + " | current value: " + value + " | EXCEPTION set = true");
                                }
                                set = true;
                            }
                            if (set) {
                                if (this.startupevent) {
                                    this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".value", String.valueOf(value));
                                } else {
                                    this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".value", String.valueOf(value));
                                }
                                if (this.gui) {
                                    this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex, "value", String.valueOf(value));
                                }
                                switch (value) {
                                    case 0: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 1: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 2: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 3: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 4: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 5: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 6: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 7: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 8: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 9: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 10: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "1");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "1");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "0");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "true");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "false");
                                        break;
                                    }
                                    case 11: {
                                        if (this.startupevent) {
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWrite("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "1");
                                        } else {
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "0");
                                            this.ioWriteNoEvents("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "1");
                                        }
                                        if (!this.gui) break;
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".normal", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".firealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".short", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".lost", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".excluded", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".maintenance", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiolowbattery", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiotamper", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".radiointerference", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".alarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".prealarm", "visible", "false");
                                        this.uiSet("panel." + this.currentPanelIndex + ".loop." + currentLoopIndex + ".sensor." + currentSensorIndex + ".techalarm", "visible", "true");
                                        break;
                                    }
                                }
                            }
                            this.sleep(5L);
                            ++j2;
                            ++currentSensorIndex;
                            ++j2;
                        }
                    } else {
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex);
                        }
                        if (this.online != 0) {
                            this.online = 0;
                            this.readError = true;
                        }
                    }
                } else {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": no MODBUS TCP response");
                    }
                    if (this.online != 0) {
                        this.online = 0;
                        this.readError = true;
                    }
                }
                ++i2;
            }
            startingReg += 40;
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": current panel " + this.currentPanelIndex + " | last register: " + (startingReg - 1));
            }
            ++currentLoopIndex;
        }
    }

    private void checkNames() throws FileNotFoundException {
        long timestampnow = 0L;
        boolean modified = false;
        if (!this.fileCheck) {
            this.timestamp1 = new File(FILE1).lastModified();
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  file teledata.ini timestamp: " + this.timestamp1);
            }
            this.fileCheck = true;
        } else {
            timestampnow = new File(FILE1).lastModified();
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  file teledata.ini timestamp: " + this.timestamp1 + " | now: " + timestampnow);
            }
            if (this.timestamp1 != timestampnow) {
                modified = true;
                this.timestamp1 = timestampnow;
            }
        }
        if (modified) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  file teledata.ini has changed, reload");
            }
            this.loadNames();
        }
    }

    private void loadNames() throws FileNotFoundException {
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  loading teledata.ini file");
        }
        Scanner sc = new Scanner(new File(FILE1));
        sc.useDelimiter("(\\n)");
        while (sc.hasNext()) {
            String next = sc.next();
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  line: " + next);
            }
            String[] spl = next.split("=");
            String dp = spl[0].replaceAll("\\s+", "");
            String n2 = spl[1].trim();
            String[] spl2 = dp.split("\\.");
            if (!this.name.equalsIgnoreCase(spl2[0])) continue;
            dp = dp.replace(String.valueOf(this.name) + ".", "");
            this.ioWriteNoEvents(String.valueOf(dp) + ".name", n2);
            if (!this.gui) continue;
            this.uiSet(String.valueOf(dp) + ".name", "value", n2);
        }
        sc.close();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    public static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        int i2 = 0;
        while (i2 < hex.length()) {
            String str = hex.substring(i2, i2 + 2);
            output.append((char)Integer.parseInt(str, 16));
            i2 += 2;
        }
        return output.toString();
    }

    private int byteArrayToInt(byte[] b2) {
        int val = (b2[0] & 0xFF) << 8 | b2[1] & 0xFF;
        return val;
    }
}

