/*
 * Decompiled with CFR 0.152.
 */
package drivers.sonos;

import com.hsyco.Configuration;
import drivers.sonos.Driver;
import drivers.sonos.actions.AVTransportAction;
import drivers.sonos.actions.Action;
import drivers.sonos.actions.AddURIToQueueAction;
import drivers.sonos.actions.RemoveFromQueueAction;
import drivers.sonos.actions.RenderingControlAction;
import drivers.sonos.actions.SeekTrackNumAction;
import drivers.sonos.actions.SetAVTransportURIAction;
import drivers.sonos.actions.SetRelativeVolumeAction;
import drivers.sonos.actions.SetVolumeAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;

class Player {
    private static final String UPnP_BODY_HEADER = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body>";
    private static final String UPnP_BODY_TRAILER = "</s:Body></s:Envelope>";
    private static final int SUBSCRIBE_TIMEOUT_SECONDS = 3600;
    private int actualSubscribeTimeoutSeconds = 3600;
    private static final long RESUBSCRIBE_ADVANCE = 600000L;
    private final Driver driver;
    private final String id;
    private final String baseUrl;
    private Map<String, String> subscriptionSids = new HashMap<String, String>();
    private long lastSubscribe;
    private String state;
    private String trackUri;
    private String trackNumber;
    boolean playAfterUri;
    String uriBeforePlay;
    Thread playThread;
    String playUriTrackNumber;

    Player(Driver driver, String room, String baseUrl) {
        this.driver = driver;
        this.id = room.toLowerCase().replaceAll("\\s+", "-");
        this.baseUrl = baseUrl;
    }

    String getId() {
        return this.id;
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    void getState() throws Exception {
        Map<String, String> r = this.post(AVTransportAction.GET_TRANSPORT_INFO);
        this.state = r.get("CurrentTransportState");
        if (this.state == null) {
            this.ioWrite("state", "unknown");
        } else {
            this.state = this.state.toLowerCase();
            if (this.state.equals("playing")) {
                this.ioWrite("state", "play");
                this.uiSet("state.play", "visible", "true");
                this.uiSet("state.pause", "visible", "false");
                this.uiSet("state.transitioning", "visible", "false");
                this.uiSet("state.stop", "visible", "false");
            } else if (this.state.equals("paused_playback")) {
                this.ioWrite("state", "pause");
                this.uiSet("state.play", "visible", "false");
                this.uiSet("state.pause", "visible", "true");
                this.uiSet("state.transitioning", "visible", "false");
                this.uiSet("state.stop", "visible", "false");
            } else if (this.state.equals("transitioning")) {
                this.ioWrite("state", "transitioning");
                this.uiSet("state.play", "visible", "false");
                this.uiSet("state.pause", "visible", "false");
                this.uiSet("state.transitioning", "visible", "true");
                this.uiSet("state.stop", "visible", "false");
            } else if (this.state.equals("stopped")) {
                this.ioWrite("state", "stop");
                this.uiSet("state.play", "visible", "false");
                this.uiSet("state.pause", "visible", "false");
                this.uiSet("state.transitioning", "visible", "false");
                this.uiSet("state.stop", "visible", "true");
            }
        }
        String status = r.get("CurrentTransportStatus");
        this.ioWrite("status", status == null ? "unknown" : status.toLowerCase());
        r = this.post(AVTransportAction.GET_POSITION_INFO);
        this.trackNumber = r.get("Track");
        this.ioWrite("track.number", this.trackNumber == null ? "unknown" : this.trackNumber);
        this.uiSet("track.number", "value", this.trackNumber == null ? "" : this.trackNumber);
        Map<String, String> metadata = this.getTrackMetadata(r.get("TrackMetaData"));
        String title = metadata.get("title");
        this.ioWrite("track.title", title == null ? "unknown" : title);
        this.uiSet("track.title", "value", title == null ? "" : title);
        String creator = metadata.get("creator");
        this.ioWrite("track.creator", creator == null ? "unknown" : creator);
        this.uiSet("track.creator", "value", creator == null ? "" : creator);
        String album = metadata.get("album");
        this.ioWrite("track.album", album == null ? "unknown" : album);
        this.uiSet("track.album", "value", album == null ? "" : album);
        String albumarturi = metadata.get("albumarturi");
        this.ioWrite("track.albumarturi", albumarturi == null ? "unknown" : albumarturi);
        this.trackUri = r.get("TrackURI");
        this.ioWrite("track.uri", this.trackUri == null ? "unknown" : this.trackUri);
        r = this.post(RenderingControlAction.GET_MUTE);
        String mute = r.get("CurrentMute");
        if (mute == null) {
            this.ioWrite("mute", "unknown");
        } else {
            this.ioWrite("mute", mute);
            if (mute.equals("1")) {
                this.uiSet("mute.1", "visible", "true");
                this.uiSet("mute.0", "visible", "false");
            } else {
                this.uiSet("mute.0", "visible", "true");
                this.uiSet("mute.1", "visible", "false");
            }
        }
        r = this.post(RenderingControlAction.GET_VOLUME);
        String volume = r.get("CurrentVolume");
        this.ioWrite("volume", volume == null ? "unknown" : volume);
        this.uiSet("volume", "value", volume == null ? "" : volume);
        this.setReachable(true);
        this.playUriCleanup();
    }

    void setReachable(boolean reachable) {
        if (reachable) {
            this.ioWrite("reachable", "1");
        } else {
            this.ioWrite("reachable", "0");
            this.lastSubscribe = 0L;
        }
    }

    void subscribe() throws Exception {
        if (this.lastSubscribe < System.currentTimeMillis() - (long)(this.actualSubscribeTimeoutSeconds * 1000) + 600000L) {
            this.subscribe("/MediaRenderer/AVTransport/Event");
            this.subscribe("/MediaRenderer/RenderingControl/Event");
            this.lastSubscribe = System.currentTimeMillis();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void subscribe(String publisher) throws Exception {
        slash = this.baseUrl.lastIndexOf(47);
        colon = this.baseUrl.lastIndexOf(58);
        host = this.baseUrl.substring(slash + 1, colon);
        port = Integer.parseInt(this.baseUrl.substring(colon + 1));
        callbackUri = "http://" + this.driver.localHost + ":" + 1077 + publisher;
        if (Configuration.verboseLog) {
            this.driver.messageLog("Subscribing: " + callbackUri);
        }
        sock = null;
        bw = null;
        br = null;
        try {
            sock = new Socket(host, port);
            sock.setSoTimeout(5000);
            bw = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), Charset.forName("UTF-8")));
            br = new BufferedReader(new InputStreamReader(sock.getInputStream(), Charset.forName("UTF-8")));
            bw.write("SUBSCRIBE " + publisher + " HTTP/1.1\r\n");
            bw.write("HOST: " + this.driver.localHost + "\r\n");
            sid = this.subscriptionSids.get(publisher);
            if (sid == null) {
                bw.write("CALLBACK: <" + callbackUri + ">\r\n");
                bw.write("NT: upnp:event\r\n");
            } else {
                bw.write(String.valueOf(sid) + "\r\n");
            }
            bw.write("TIMEOUT: Second-3600\r\n");
            bw.write("\r\n");
            bw.flush();
            sid = null;
            timeout = null;
            line = br.readLine();
            if (line.equalsIgnoreCase("HTTP/1.1 200 OK")) ** GOTO lbl40
            if (line.equalsIgnoreCase("HTTP/1.1 412 Precondition Failed")) {
                this.subscriptionSids.remove(publisher);
            }
            throw new Exception("Response error: " + line);
lbl-1000:
            // 1 sources

            {
                if (line.startsWith("SID:")) {
                    sid = line;
                    continue;
                }
                if (!line.startsWith("TIMEOUT:")) continue;
                timeout = line;
lbl40:
                // 4 sources

                ** while ((line = br.readLine()) != null)
            }
lbl41:
            // 1 sources

            this.subscriptionSids.put(publisher, sid);
            if (timeout != null && (toInt = Integer.parseInt(timeout = timeout.substring(timeout.indexOf(45) + 1))) < this.actualSubscribeTimeoutSeconds) {
                this.actualSubscribeTimeoutSeconds = toInt;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception var15_18) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception var15_19) {}
            }
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception var15_20) {}
            }
        }
    }

    private void ioWrite(String name, String value) {
        this.driver.ioWrite(String.valueOf(this.id) + "." + name, value);
    }

    private void uiSet(String id, String attr, String value) {
        this.driver.uiSet(String.valueOf(this.id) + "." + id, attr, value);
    }

    private Map<String, String> post(Action action) throws Exception {
        if (Configuration.verboseLog) {
            this.driver.messageLog("Action: " + action.getAction());
        }
        HttpURLConnection connection = null;
        try {
            int respCode;
            boolean ok;
            StringBuilder body = new StringBuilder(UPnP_BODY_HEADER);
            body.append("<u:").append(action.getAction()).append(" ");
            body.append("xmlns:u=\"").append(action.getService()).append("\">");
            body.append(action.getParameters());
            body.append("</u:").append(action.getAction()).append(">");
            body.append(UPnP_BODY_TRAILER);
            byte[] data = body.toString().getBytes(Charset.forName("UTF-8"));
            URL url = new URL(String.valueOf(this.baseUrl) + action.getEndpoint());
            if (Configuration.verboseLog) {
                this.driver.messageLog("Post request to: " + url);
                this.driver.messageLog("Post request body: " + body);
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setRequestProperty("SOAPAction", "\"" + action.getService() + "#" + action.getAction() + "\"");
            connection.setRequestProperty("Connection", "Close");
            connection.setRequestProperty("Content-Length", Integer.toString(data.length));
            connection.setDoOutput(true);
            connection.getOutputStream().write(data);
            if (Configuration.verboseLog) {
                this.driver.messageLog("Post request sent");
            }
            boolean bl = ok = (respCode = connection.getResponseCode()) == 200;
            if (!ok) {
                throw new Exception("Action response error");
            }
            Map<String, String> map = this.getResponseParams(connection);
            return map;
        }
        catch (Exception e2) {
            throw new Exception("Error processing action: " + action.getAction() + " - " + e2.getLocalizedMessage(), e2);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private Map<String, String> getTrackMetadata(String xml) {
        HashMap<String, String> metadata;
        block24: {
            metadata = new HashMap<String, String>();
            if (xml != null && !xml.isEmpty() && !xml.equalsIgnoreCase("NOT_IMPLEMENTED")) {
                XMLEventReader eventReader = null;
                StringReader sr = null;
                try {
                    try {
                        sr = new StringReader(xml);
                        eventReader = Driver.XML_INPUT_FACTORY.createXMLEventReader(sr);
                        while (eventReader.hasNext()) {
                            XMLEvent elem;
                            XMLEvent event = eventReader.nextEvent();
                            if (event.isStartElement()) {
                                elem = event.asStartElement();
                                String name = elem.getName().getLocalPart();
                                if (!name.equals("title") && !name.equals("creator") && !name.equals("album") && !name.equals("albumArtURI")) continue;
                                StringBuilder val = new StringBuilder();
                                event = eventReader.nextEvent();
                                while (event.isCharacters()) {
                                    val.append(event.asCharacters().getData());
                                    event = eventReader.nextEvent();
                                }
                                metadata.put(name.toLowerCase(), val.toString());
                                continue;
                            }
                            if (!event.isEndElement() || !(elem = event.asEndElement()).getName().getPrefix().equals("u")) continue;
                            break;
                        }
                    }
                    catch (Exception e2) {
                        this.driver.errorLog("Error getting track metadata - " + e2);
                        if (sr != null) {
                            try {
                                sr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (eventReader == null) break block24;
                        try {
                            eventReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (sr != null) {
                        try {
                            sr.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (eventReader != null) {
                        try {
                            eventReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return metadata;
    }

    private Map<String, String> getResponseParams(HttpURLConnection connection) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        XMLEventReader eventReader = null;
        InputStream in = null;
        try {
            in = connection.getInputStream();
            eventReader = Driver.XML_INPUT_FACTORY.createXMLEventReader(in, "UTF-8");
            boolean put = false;
            while (eventReader.hasNext()) {
                XMLEvent elem;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    elem = event.asStartElement();
                    if (put) {
                        StringBuilder val = new StringBuilder();
                        event = eventReader.nextEvent();
                        while (event.isCharacters()) {
                            val.append(event.asCharacters().getData());
                            event = eventReader.nextEvent();
                        }
                        String key = elem.getName().getLocalPart();
                        prms.put(key, val.toString());
                        continue;
                    }
                    if (!elem.getName().getPrefix().equals("u")) continue;
                    put = true;
                    continue;
                }
                if (event.isEndElement() && (elem = event.asEndElement()).getName().getPrefix().equals("u")) break;
            }
            HashMap<String, String> hashMap = prms;
            return hashMap;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    void command(String name, String value) throws Exception {
        if (name.equalsIgnoreCase("state")) {
            if (value.equalsIgnoreCase("pause")) {
                this.post(AVTransportAction.PAUSE);
            } else if (value.equalsIgnoreCase("stop")) {
                this.post(AVTransportAction.STOP);
            } else if (value.equalsIgnoreCase("play")) {
                this.post(AVTransportAction.PLAY);
            }
        } else if (name.equalsIgnoreCase("play")) {
            this.playUri(value);
        } else if (name.equalsIgnoreCase("play.pathname")) {
            String uri = "http://" + this.driver.localHost + ":" + Configuration.HTTPServerPort + value;
            this.playUri(uri);
        } else if (name.equalsIgnoreCase("volume")) {
            if (value.startsWith("+") || value.startsWith("-")) {
                this.post(new SetRelativeVolumeAction(value));
            } else {
                this.post(new SetVolumeAction(value));
            }
        } else if (name.equalsIgnoreCase("mute")) {
            RenderingControlAction a2 = value.equals("1") ? RenderingControlAction.SET_MUTE_TRUE : RenderingControlAction.SET_MUTE_FALSE;
            this.post(a2);
        } else if (name.equalsIgnoreCase("queue")) {
            if (value.equalsIgnoreCase("next")) {
                this.post(AVTransportAction.NEXT);
            } else if (value.equalsIgnoreCase("prev")) {
                this.post(AVTransportAction.PREVIOUS);
            } else {
                try {
                    Integer.parseInt(value);
                    this.post(new SeekTrackNumAction(value));
                }
                catch (NumberFormatException e2) {
                    int sep = value.indexOf(58);
                    String trackNumber = value.substring(0, sep);
                    String uri = value.substring(sep + 1);
                    this.post(new AddURIToQueueAction(uri, "", trackNumber, false));
                }
            }
        } else {
            throw new Exception("unknown command");
        }
    }

    private void playUri(String uri) throws Exception {
        boolean bl = this.playAfterUri = "playing".equals(this.state) || "transitioning".equals(this.state);
        if (this.trackUri == null || !this.isQueueUri(this.trackUri)) {
            this.uriBeforePlay = this.trackUri;
            this.post(new SetAVTransportURIAction(uri, ""));
        } else {
            try {
                this.playUriTrackNumber = "" + (Integer.parseInt(this.trackNumber) + 1);
            }
            catch (Exception e2) {
                this.playUriTrackNumber = "1";
            }
            this.post(new AddURIToQueueAction(uri, "", this.playUriTrackNumber, false));
            try {
                this.post(AVTransportAction.NEXT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.post(AVTransportAction.PLAY);
    }

    private boolean isQueueUri(String uri) {
        if (uri.startsWith("x-rincon-queue:")) {
            return true;
        }
        String[] pp = uri.split("://");
        return pp.length < 3;
    }

    private void playUriCleanup() {
        if (this.uriBeforePlay != null) {
            if (this.state.equals("stopped")) {
                try {
                    this.post(new SetAVTransportURIAction(this.uriBeforePlay, ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.playAfterUri) {
                    try {
                        this.post(AVTransportAction.PLAY);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.uriBeforePlay = null;
            }
        } else if (this.playUriTrackNumber != null && (!this.playUriTrackNumber.equals(this.trackNumber) || this.playUriTrackNumber.equals("1") && this.state.equals("stopped"))) {
            if (!this.playAfterUri) {
                try {
                    this.post(AVTransportAction.PAUSE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.post(new RemoveFromQueueAction(this.playUriTrackNumber));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.playUriTrackNumber = null;
        }
    }
}

