/*
 * Decompiled with CFR 0.152.
 */
package drivers.smtpserver;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import drivers.smtpserver.Driver;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

class RequestProcessor
implements Runnable {
    private static List<Socket> pool = new LinkedList<Socket>();
    private static int numThreads = 0;
    private static int activeConnections = 0;
    private static boolean poolOverflow = false;
    private Driver driver;

    RequestProcessor(Driver driver) {
        this.driver = driver;
        ++numThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processRequest(Socket request) {
        List<Socket> list = pool;
        synchronized (list) {
            if (activeConnections < numThreads) {
                if (poolOverflow) {
                    poolOverflow = false;
                }
                pool.add(pool.size(), request);
                pool.notify();
            } else {
                if (!poolOverflow) {
                    poolOverflow = true;
                    hsyco.errorLog("SMTP server error: too many connections [" + activeConnections + "]");
                }
                try {
                    request.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        currentThread.setName(String.valueOf(currentThread.getName()) + "-smtpserver");
        while (true) {
            block101: {
                BufferedReader in;
                InputStreamReader is;
                Writer out;
                Socket connection;
                block98: {
                    List<Socket> list = pool;
                    synchronized (list) {
                        while (true) {
                            if (!pool.isEmpty()) {
                                try {
                                    connection = pool.remove(0);
                                    break;
                                }
                                catch (Exception e2) {
                                    return;
                                }
                            }
                            try {
                                pool.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        ++activeConnections;
                    }
                    BufferedOutputStream raw = null;
                    out = null;
                    is = null;
                    in = null;
                    String from = null;
                    String to = null;
                    try {
                        try {
                            InetAddress addr = connection.getInetAddress();
                            raw = new BufferedOutputStream(connection.getOutputStream());
                            out = new OutputStreamWriter((OutputStream)raw, "UTF-8");
                            is = new InputStreamReader(connection.getInputStream(), "UTF-8");
                            in = new BufferedReader(is);
                            out.write("220 " + Configuration.publicServerName + " SMTP\r\n");
                            out.flush();
                            String line = in.readLine().toLowerCase();
                            if (!line.contains("helo ") && !line.contains("ehlo ")) break block98;
                            out.write("250 " + Configuration.publicServerName + " Hello " + addr.getHostAddress() + ", pleased to meet you\r\n");
                            out.flush();
                            while (true) {
                                StringBuffer json;
                                block100: {
                                    int i2;
                                    Vector<String> body;
                                    String returnpath;
                                    int contenttransferencoding;
                                    String charset;
                                    String contenttype;
                                    String date;
                                    String subject;
                                    block99: {
                                        if ((line = in.readLine()).equalsIgnoreCase("quit")) {
                                            out.write("221 " + Configuration.publicServerName + " closing connection\r\n");
                                            out.flush();
                                            break;
                                        }
                                        if (!line.toLowerCase().contains("mail from:")) continue;
                                        from = line.substring(10).trim().toLowerCase();
                                        out.write("250 " + from + "... Sender ok\r\n");
                                        out.flush();
                                        line = in.readLine();
                                        if (!line.toLowerCase().contains("rcpt to:")) continue;
                                        to = line.substring(8).trim().toLowerCase();
                                        out.write("250 " + to + "... Recipient ok\r\n");
                                        out.flush();
                                        line = in.readLine();
                                        if (!line.equalsIgnoreCase("data")) continue;
                                        out.write("354 Enter mail, end with \".\" on a line by itself\r\n");
                                        out.flush();
                                        subject = null;
                                        date = null;
                                        contenttype = "text/plain";
                                        charset = "us-ascii";
                                        String boundary = null;
                                        contenttransferencoding = 0;
                                        returnpath = null;
                                        boolean header = true;
                                        body = new Vector<String>();
                                        json = new StringBuffer();
                                        while (true) {
                                            if ((line = in.readLine()).equals(".")) {
                                                out.write("250 Message accepted for delivery\r\n");
                                                out.flush();
                                                if (!this.driver.rawBody) {
                                                    break;
                                                }
                                                break block99;
                                            }
                                            if (header) {
                                                if (line.length() == 0) {
                                                    header = false;
                                                    continue;
                                                }
                                                if (line.charAt(0) == '\t') continue;
                                                String lline = line.toLowerCase();
                                                if (lline.startsWith("subject:")) {
                                                    subject = RequestProcessor.decodeQuotedPrintableSubject(line.substring(8).trim());
                                                    continue;
                                                }
                                                if (lline.startsWith("from:")) {
                                                    from = line.substring(5).trim();
                                                    continue;
                                                }
                                                if (lline.startsWith("to:")) {
                                                    to = line.substring(3).trim();
                                                    continue;
                                                }
                                                if (lline.startsWith("date:")) {
                                                    date = line.substring(5).trim();
                                                    continue;
                                                }
                                                if (lline.startsWith("content-type:")) {
                                                    if (line.endsWith(";")) {
                                                        line = String.valueOf(line) + in.readLine();
                                                    }
                                                    ContentTypeHeader cth = RequestProcessor.parseContentType(line);
                                                    contenttype = cth.contentType;
                                                    charset = cth.charset;
                                                    boundary = cth.boundary;
                                                    continue;
                                                }
                                                if (lline.startsWith("return-path:")) {
                                                    returnpath = line.substring(12).trim();
                                                    continue;
                                                }
                                                if (!lline.startsWith("content-transfer-encoding:")) continue;
                                                if (lline.endsWith("quoted-printable")) {
                                                    contenttransferencoding = 1;
                                                    continue;
                                                }
                                                if (lline.endsWith("base64")) {
                                                    contenttransferencoding = 2;
                                                    continue;
                                                }
                                                if (!lline.endsWith("7bit")) continue;
                                                contenttransferencoding = 3;
                                                continue;
                                            }
                                            if (body.size() >= 64) continue;
                                            body.add(line);
                                        }
                                        if (contenttype.equalsIgnoreCase("multipart/alternative") && boundary != null) {
                                            boolean done = false;
                                            Vector<String> textplainbody = null;
                                            int multipartstate = 0;
                                            int i3 = 0;
                                            while (true) {
                                                if (done || i3 >= body.size()) {
                                                    body = textplainbody;
                                                    break;
                                                }
                                                line = (String)body.elementAt(i3);
                                                String lline = line.toLowerCase();
                                                switch (multipartstate) {
                                                    case 0: {
                                                        if (!line.contains(boundary)) break;
                                                        multipartstate = 1;
                                                        break;
                                                    }
                                                    case 1: {
                                                        if (lline.startsWith("content-transfer-encoding:")) {
                                                            if (lline.endsWith("quoted-printable")) {
                                                                contenttransferencoding = 1;
                                                                break;
                                                            }
                                                            if (lline.endsWith("base64")) {
                                                                contenttransferencoding = 2;
                                                                break;
                                                            }
                                                            if (!lline.endsWith("7bit")) break;
                                                            contenttransferencoding = 3;
                                                            break;
                                                        }
                                                        if (lline.startsWith("content-type:")) {
                                                            if (line.endsWith(";")) {
                                                                line = String.valueOf(line) + (String)body.elementAt(++i3);
                                                            }
                                                            ContentTypeHeader pct = RequestProcessor.parseContentType(line);
                                                            contenttype = pct.contentType;
                                                            charset = pct.charset;
                                                            break;
                                                        }
                                                        if (lline.length() != 0 || !contenttype.equals("text/plain")) break;
                                                        textplainbody = new Vector<String>();
                                                        multipartstate = 2;
                                                        break;
                                                    }
                                                    case 2: {
                                                        if (line.contains(boundary)) {
                                                            if (textplainbody == null) {
                                                                multipartstate = 1;
                                                                break;
                                                            }
                                                            done = true;
                                                            break;
                                                        }
                                                        if (textplainbody == null) break;
                                                        textplainbody.add(line);
                                                        break;
                                                    }
                                                }
                                                ++i3;
                                            }
                                        }
                                    }
                                    json.append("{");
                                    json.append(String.valueOf(JSONObject.quote("from")) + ":" + JSONObject.quote(from != null ? from : ""));
                                    json.append(",");
                                    json.append(String.valueOf(JSONObject.quote("to")) + ":" + JSONObject.quote(to != null ? to : ""));
                                    json.append(",");
                                    json.append(String.valueOf(JSONObject.quote("subject")) + ":" + JSONObject.quote(subject != null ? subject : ""));
                                    json.append(",");
                                    json.append(String.valueOf(JSONObject.quote("date")) + ":" + JSONObject.quote(date != null ? date : ""));
                                    json.append(",");
                                    json.append(String.valueOf(JSONObject.quote("contenttype")) + ":" + JSONObject.quote(contenttype != null ? contenttype : ""));
                                    json.append(",");
                                    json.append(String.valueOf(JSONObject.quote("returnpath")) + ":" + JSONObject.quote(returnpath != null ? returnpath : ""));
                                    json.append("," + JSONObject.quote("body") + ":[");
                                    if (contenttransferencoding == 1 || contenttransferencoding == 3) {
                                        StringBuffer sb = null;
                                        String s = null;
                                        i2 = 0;
                                        while (true) {
                                            if (i2 >= body.size()) {
                                                if (sb == null) break block100;
                                                json.append(JSONObject.quote(sb.toString()));
                                                break block100;
                                            }
                                            if (i2 > 0 && sb == null) {
                                                json.append(",");
                                            }
                                            if ((s = (String)body.elementAt(i2)).endsWith("=")) {
                                                if (sb == null) {
                                                    sb = new StringBuffer();
                                                }
                                                sb.append(RequestProcessor.decodeQuotedPrintable(s, charset));
                                            } else if (sb == null) {
                                                json.append(JSONObject.quote(RequestProcessor.decodeQuotedPrintable(s, charset)));
                                            } else {
                                                sb.append(RequestProcessor.decodeQuotedPrintable(s, charset));
                                                json.append(JSONObject.quote(sb.toString()));
                                                sb = null;
                                            }
                                            ++i2;
                                        }
                                    }
                                    if (contenttransferencoding == 2) {
                                        String[] lines;
                                        StringBuffer sb = new StringBuffer();
                                        int i4 = 0;
                                        while (true) {
                                            if (i4 >= body.size()) {
                                                lines = new String(Base64.decode(sb.toString()), charset).split("\\r?\\n");
                                                i2 = 0;
                                                break;
                                            }
                                            sb.append((String)body.elementAt(i4));
                                            ++i4;
                                        }
                                        while (i2 < lines.length) {
                                            if (i2 > 0) {
                                                json.append(",");
                                            }
                                            json.append(JSONObject.quote(lines[i2]));
                                            ++i2;
                                        }
                                    } else {
                                        int i5 = 0;
                                        while (i5 < body.size()) {
                                            if (i5 > 0) {
                                                json.append(",");
                                            }
                                            json.append(JSONObject.quote((String)body.elementAt(i5)));
                                            ++i5;
                                        }
                                    }
                                }
                                json.append("]}");
                                this.driver.ioWriteInternal("mail", json.toString());
                            }
                        }
                        catch (Exception e3) {
                            if (Configuration.verboseLog) {
                                hsyco.errorLog("SMTP Server - Generic exception in processor loop: " + e3);
                            }
                            try {
                                Thread.sleep((long)(Math.random() * 5000.0));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                out.flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                out.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {}
                            break block101;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            out.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            out.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            connection.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<Socket> list = pool;
            synchronized (list) {
                --activeConnections;
            }
        }
    }

    private static String decodeQuotedPrintable(String str, String charset) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String hex = null;
        int state = 0;
        try {
            int i2 = 0;
            while (i2 < str.length()) {
                char c2 = str.charAt(i2);
                switch (state) {
                    case 0: {
                        if (c2 == '=') {
                            state = 1;
                            break;
                        }
                        bos.write(c2);
                        break;
                    }
                    case 1: {
                        hex = Character.toString(c2);
                        state = 2;
                        break;
                    }
                    case 2: {
                        hex = String.valueOf(hex) + Character.toString(c2);
                        bos.write(Integer.parseInt(hex, 16));
                        state = 0;
                    }
                }
                ++i2;
            }
            return bos.toString(charset);
        }
        catch (Exception e2) {
            return str;
        }
    }

    private static String decodeQuotedPrintableSubject(String str) {
        try {
            String[] sa;
            if (str.startsWith("=?") && str.endsWith("?=") && (sa = str.substring(2, str.length() - 2).split("[?]")).length == 3) {
                if (sa[1].equals("Q")) {
                    return RequestProcessor.decodeQuotedPrintable(sa[2], sa[0]).replaceAll("_", " ");
                }
                if (sa[1].equals("B")) {
                    return new String(Base64.decode(sa[2]), sa[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static ContentTypeHeader parseContentType(String str) throws Exception {
        ContentTypeHeader decoded = new ContentTypeHeader();
        String[] sa = str.split("[;]");
        int i2 = 0;
        while (i2 < sa.length) {
            String section = sa[i2].trim();
            String sectionl = section.toLowerCase();
            if (sectionl.startsWith("content-type:")) {
                decoded.contentType = RequestProcessor.unquote(section.substring(13).trim());
            } else if (sectionl.startsWith("boundary")) {
                decoded.boundary = RequestProcessor.unquote(section.split("=", 2)[1].trim());
            } else if (sectionl.startsWith("charset")) {
                decoded.charset = RequestProcessor.unquote(section.split("=", 2)[1].trim());
            }
            ++i2;
        }
        return decoded;
    }

    private static String unquote(String str) {
        try {
            if (str.startsWith("\"")) {
                str = str.substring(1);
            }
            if (str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    static class ContentTypeHeader {
        String contentType;
        String boundary;
        String charset;

        ContentTypeHeader() {
        }
    }
}

