/*
 * Decompiled with CFR 0.152.
 */
package drivers.sigfox;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.sigfox.AlarmHubBase;
import drivers.sigfox.AlarmHubStatus;
import drivers.sigfox.Device;
import drivers.sigfox.ThreadDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final String APIURL = "api.sigfox.com/v2";
    public static final int DEFAULTPOLLINTERVAL = 3000;
    public static final int DEFAULTCALLBACKPORT = 4445;
    public static final String VERSION = "1.5";
    public static HashMap<String, Driver> driversList = new HashMap();
    private Driver DRIVER;
    private int callbackport = 4445;
    private boolean startupevents;
    private int pollinterval = 3000;
    private boolean firstloop = true;
    private String devicesfile;
    private ThreadDispatcher tdsp = null;
    public boolean acceptunknown;
    private boolean updateAllStatuses = true;
    private int deviceTypeLoopIndex = 0;
    private String nextUrl;
    public String name;
    public String username;
    public String password;
    public String callbackPath;
    public String callbackkey;
    public String callbackiprange;
    public ArrayList<String> deviceTypes = new ArrayList();
    public HashMap<String, Device> devices = new HashMap();

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            this.devicesfile = "sigfox-devices_" + name + ".ini";
            this.callbackPath = "/hsyco/sigfox/" + name;
            driversList.put(String.valueOf(name) + ".", this);
            this.DRIVER = this;
            try {
                this.callbackport = Integer.parseInt(config.get("callbackport"));
            }
            catch (Exception e2) {
                this.messageLog(String.valueOf(name) + ": callbackport ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            this.callbackkey = config.get("callbackkey");
            if (this.callbackkey == null) {
                this.messageLog(String.valueOf(name) + ": callbackkey ignored");
            }
            this.callbackiprange = config.get("callbackiprange");
            if (this.callbackiprange == null) {
                this.messageLog(String.valueOf(name) + ": callbackiprange ignored");
            }
            this.acceptunknown = Boolean.parseBoolean(config.get("acceptunknown"));
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 300 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            this.readSigfoxDevicesFile();
            if (this.username != null && this.password != null) {
                this.updateAllStatuses();
            }
            this.loadDevicesSeqNumber();
            if (this.callbackkey != null) {
                this.tdsp = new ThreadDispatcher(this.callbackport, this.DRIVER);
                this.tdsp.start();
            }
            this.ioWrite("driver.version", VERSION);
            this.messageLog(String.valueOf(name) + " - driver started with callback port: " + this.callbackport + " | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval + " | acceptunknown: " + this.acceptunknown);
            return true;
        }
        catch (Exception e4) {
            this.errorLog("Initialization failed - " + e4.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        try {
            JSONObject response = null;
            long timestamp = 0L;
            if (this.username != null && this.password != null) {
                Calendar calendar = GregorianCalendar.getInstance();
                int mm = calendar.get(12);
                if (mm == 0) {
                    if (this.updateAllStatuses) {
                        this.updateAllStatuses();
                        this.updateAllStatuses = false;
                        return true;
                    }
                } else {
                    this.updateAllStatuses = true;
                }
                block4: for (String deviceTypeId : this.deviceTypes) {
                    int index = this.deviceTypes.indexOf(deviceTypeId);
                    if (index != this.deviceTypeLoopIndex) continue;
                    if (this.nextUrl == null) {
                        this.nextUrl = "https://api.sigfox.com/v2/device-types/" + deviceTypeId + "/messages";
                    }
                    try {
                        response = this.callAPIService(this.nextUrl);
                        JSONArray arr = response.getJSONArray("data");
                        if (this.isVerboseLog()) {
                            this.messageLog(String.valueOf(this.name) + " - debug - " + response);
                        }
                        int i2 = arr.length() - 1;
                        while (true) {
                            if (i2 < 0) {
                                this.nextUrl = null;
                                if (!response.has("paging")) continue block4;
                                JSONObject nextPage = response.getJSONObject("paging");
                                if (!nextPage.has("next")) break;
                                this.nextUrl = nextPage.getString("next");
                                continue block4;
                            }
                            String convertedLqi = null;
                            String seqNumber = null;
                            String data = null;
                            JSONObject message = arr.getJSONObject(i2);
                            JSONObject device = message.getJSONObject("device");
                            String deviceId = device.getString("id");
                            timestamp = message.has("time") ? message.getLong("time") : System.currentTimeMillis();
                            if (message.has("seqNumber")) {
                                seqNumber = String.valueOf(message.getInt("seqNumber"));
                            }
                            if (message.has("lqi")) {
                                int lqi = message.getInt("lqi");
                                convertedLqi = String.valueOf(lqi);
                            }
                            if (message.has("data")) {
                                data = message.getString("data");
                            }
                            this.updateMsg(deviceId, seqNumber, data, timestamp, null, null, convertedLqi, null);
                            --i2;
                        }
                        this.incrementLoopIndex();
                        break;
                    }
                    catch (Exception e2) {
                        if (response == null) {
                            throw new Exception("HTTP call failed - " + this.nextUrl);
                        }
                        throw new Exception("error in HTTP response - " + this.nextUrl);
                    }
                }
            }
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e3) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e3.getMessage());
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.tdsp.callbackSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tdsp.executor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    public JSONObject callAPIService(String path) throws Exception {
        JSONObject result = null;
        try {
            String httpcall = Driver.urlGet(path, this.username, this.password);
            if (httpcall != null) {
                if (httpcall.startsWith("400")) {
                    throw new Exception("Invalid value or type");
                }
                if (httpcall.startsWith("401")) {
                    throw new Exception("Unauthorized");
                }
                if (httpcall.startsWith("404")) {
                    throw new Exception("Resource not found");
                }
                if (httpcall.startsWith("429")) {
                    throw new Exception("Too many requests");
                }
                result = new JSONObject(httpcall.substring(4));
            }
        }
        catch (Exception e2) {
            throw new Exception("Error in request " + path + " - " + e2.getMessage());
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void decodeMessage(String data, String devId) {
        Device dev = this.devices.get(devId);
        String type = dev.getModel();
        if (type != null) {
            if (type.equals("AlarmHubBase")) {
                AlarmHubBase.decodeMsg(devId, data, this.DRIVER);
            } else if (type.equals("AlarmHubStatus")) {
                AlarmHubStatus.decodeMsg(devId, data, this.DRIVER);
            }
        }
    }

    public void updateMsg(String id, String seqNumber, String data, long timestamp, String temp, String batt, String lqi, String deviceTypeId) {
        if (!this.containsId(id)) {
            if (this.acceptunknown) {
                this.devices.put(id, new Device(id, null, null));
            } else {
                return;
            }
        }
        Device dev = this.devices.get(id);
        int oldSeq = dev.getLastSeqNumber();
        if (seqNumber == null || Integer.parseInt(seqNumber) > oldSeq) {
            if (seqNumber != null) {
                dev.setLastSeqNumber(Integer.parseInt(seqNumber));
                this.devices.put(id, dev);
                this.writeDevicesSeqNumber();
            }
            if (data != null && !this.firstloop) {
                this.ioWriteForced("device." + id.toLowerCase() + ".msg", data);
                this.decodeMessage(data, id);
            }
            if (temp != null) {
                this.ioWrite("device." + id.toLowerCase() + ".temp", temp);
            }
            if (batt != null) {
                this.ioWrite("device." + id.toLowerCase() + ".batt.tx", batt);
            }
            if (lqi != null) {
                this.ioWrite("device." + id.toLowerCase() + ".lqi", lqi);
            }
            if (deviceTypeId != null) {
                this.ioWrite("device." + id.toLowerCase() + ".devicetype", deviceTypeId);
            }
            this.ioWrite("device." + id.toLowerCase() + ".lastseen", "" + timestamp);
        }
    }

    public void updateDeviceNameAndModel(String oldId, String newId, String name, String model) {
        Device dev;
        if (oldId.equals(newId)) {
            dev = this.devices.get(oldId);
            dev.setName(name);
            dev.setModel(model);
        } else {
            this.devices.remove(oldId);
            dev = new Device(newId, model, name);
        }
        this.devices.put(newId, dev);
        this.ioWrite("device." + newId.toLowerCase() + ".name", name);
        this.ioWrite("device." + newId.toLowerCase() + ".model", model);
    }

    public void updateAllStatuses() throws Exception {
        String devname;
        String id;
        try {
            String nextUrl = "https://api.sigfox.com/v2/device-types/";
            while (nextUrl != null) {
                JSONObject nextPage;
                JSONObject json = this.callAPIService(nextUrl);
                JSONArray data = json.getJSONArray("data");
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " - debug - " + data);
                }
                int i2 = 0;
                while (i2 < data.length()) {
                    JSONObject obj = (JSONObject)data.get(i2);
                    id = obj.getString("id");
                    if (!this.deviceTypes.contains(id)) {
                        this.deviceTypes.add(id);
                    }
                    if (obj.has("name")) {
                        devname = obj.getString("name");
                        this.ioWrite("devicetype." + id.toLowerCase() + ".name", devname);
                    }
                    ++i2;
                }
                nextUrl = null;
                if (!json.has("paging") || !(nextPage = json.getJSONObject("paging")).has("next")) continue;
                nextUrl = nextPage.getString("next");
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + ": error retrieving device types list - " + e2.getMessage());
        }
        try {
            String devtypeid = null;
            String nextUrl = "https://api.sigfox.com/v2/devices/";
            while (nextUrl != null) {
                JSONObject nextPage;
                JSONObject json = this.callAPIService(nextUrl);
                JSONArray data = json.getJSONArray("data");
                int i3 = 0;
                while (i3 < data.length()) {
                    JSONObject obj = (JSONObject)data.get(i3);
                    id = obj.getString("id");
                    if (this.containsId(id) || this.acceptunknown) {
                        JSONObject token;
                        devname = null;
                        if (obj.has("name") && !this.containsId(id)) {
                            devname = obj.getString("name");
                            this.ioWrite("device." + id.toLowerCase() + ".name", devname);
                        }
                        if (obj.has("deviceType")) {
                            JSONObject devtype = obj.getJSONObject("deviceType");
                            devtypeid = devtype.getString("id");
                            this.ioWrite("device." + id.toLowerCase() + ".devicetype", devtypeid);
                        }
                        if (obj.has("token") && (token = obj.getJSONObject("token")).has("end")) {
                            long tokenEnd = token.getLong("end");
                            this.ioWrite("device." + id.toLowerCase() + ".token.end", "" + tokenEnd);
                        }
                        if (!this.containsId(id)) {
                            Device dev = new Device(id, null, devname);
                            this.devices.put(id, dev);
                        }
                    }
                    ++i3;
                }
                nextUrl = null;
                if (json.has("paging") && (nextPage = json.getJSONObject("paging")).has("next")) {
                    nextUrl = nextPage.getString("next");
                }
                this.sleep(100L);
            }
        }
        catch (Exception e3) {
            throw new Exception(String.valueOf(this.name) + ": error retrieving devices list - " + e3.getMessage());
        }
    }

    public void readSigfoxDevicesFile() throws Exception {
        BufferedReader br = null;
        File file = null;
        try {
            try {
                String next;
                file = new File(this.devicesfile);
                br = new BufferedReader(new FileReader(file));
                Pattern patternDevice = Pattern.compile("[^\\\\]:|[^\\\\](\\\\\\\\)+:");
                Pattern patternNameModel = Pattern.compile("[^\\\\],|[^\\\\](\\\\\\\\)+,");
                Pattern patternField = Pattern.compile("[^\\\\]=|[^\\\\](\\\\\\\\)+=");
                while ((next = br.readLine()) != null) {
                    Matcher matcher = patternDevice.matcher(next);
                    boolean devicePatternFound = matcher.find();
                    String[] fields = patternDevice.split(next);
                    String devId = fields[0];
                    String devName = null;
                    String devModel = null;
                    if (fields.length > 1) {
                        devId = String.valueOf(devId) + matcher.group().replaceAll(":$", "");
                        devId = Driver.replaceSpecialChars(devId);
                        matcher = patternNameModel.matcher(fields[1]);
                        matcher.find();
                        String[] devInfos = patternNameModel.split(fields[1]);
                        int i2 = 0;
                        while (i2 < devInfos.length) {
                            String nextField = devInfos[i2];
                            if (devInfos.length > 1) {
                                nextField = String.valueOf(nextField) + matcher.group().replaceAll(",$", "");
                            }
                            matcher = patternField.matcher(nextField);
                            matcher.find();
                            String[] fieldCouple = patternField.split(nextField);
                            fieldCouple[0] = String.valueOf(fieldCouple[0]) + matcher.group().replaceAll("=$", "");
                            if (fieldCouple[0].equals("model")) {
                                if (fieldCouple.length > 1) {
                                    devModel = fieldCouple[1];
                                    devModel = Driver.replaceSpecialChars(devModel);
                                }
                            } else if (fieldCouple[0].equals("name") && fieldCouple.length > 1) {
                                devName = fieldCouple[1];
                                devName = Driver.replaceSpecialChars(devName);
                            }
                            ++i2;
                        }
                    } else {
                        if (devicePatternFound) {
                            devId = String.valueOf(devId) + matcher.group().replaceAll(":$", "");
                        }
                        devId = Driver.replaceSpecialChars(devId);
                    }
                    Device device = new Device(devId, devModel, devName);
                    if (!this.containsId(devId)) {
                        this.devices.put(devId, device);
                    }
                    if (devModel != null) {
                        this.ioWrite("device." + devId.toLowerCase() + ".model", devModel);
                    }
                    if (devName == null) continue;
                    this.ioWrite("device." + devId.toLowerCase() + ".name", devName);
                }
            }
            catch (FileNotFoundException e2) {
                file.createNewFile();
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e3) {
                throw new Exception("exception while reading sigfox-devices_" + this.name + ".ini - " + e3.getLocalizedMessage());
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String replaceSpecialChars(String s) {
        return s.replaceAll("\\\\:", ":").replaceAll("\\\\=", "=").replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public boolean containsId(String newId) {
        for (String id : this.devices.keySet()) {
            if (!id.equalsIgnoreCase(newId)) continue;
            return true;
        }
        return false;
    }

    private void incrementLoopIndex() {
        ++this.deviceTypeLoopIndex;
        if (this.deviceTypeLoopIndex >= this.deviceTypes.size()) {
            this.deviceTypeLoopIndex = 0;
        }
    }

    private void loadDevicesSeqNumber() {
        String[] couples;
        String list = this.varGet(String.valueOf(this.name) + "_sigfox_devices_seq_numbers!");
        if (list == null) {
            return;
        }
        String[] stringArray = couples = list.split(",");
        int n2 = couples.length;
        int n3 = 0;
        while (n3 < n2) {
            String couple = stringArray[n3];
            String[] fields = couple.split("/");
            Device dev = this.devices.get(fields[0]);
            if (dev != null) {
                dev.setLastSeqNumber(Integer.parseInt(fields[1]));
                this.devices.put(fields[0], dev);
            }
            ++n3;
        }
    }

    private void writeDevicesSeqNumber() {
        StringBuilder s = new StringBuilder();
        for (String id : this.devices.keySet()) {
            Device dev = this.devices.get(id);
            s.append("," + id + "/" + dev.getLastSeqNumber());
        }
        if (s.length() > 0) {
            this.varSet(String.valueOf(this.name) + "_sigfox_devices_seq_numbers!", s.substring(1));
        }
    }

    public boolean isVerbose() {
        return this.isVerboseLog();
    }
}

