/*
 * Decompiled with CFR 0.152.
 */
package drivers.siemensedp;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import drivers.siemensedp.CRC;
import drivers.siemensedp.Driver;
import drivers.siemensedp.MessageFrameV2;
import java.io.IOException;

public abstract class MessageManager {
    public static MessageFrameV2 parseMessageFrame(String message) throws IOException {
        String msgProtocolId;
        if (Configuration.verboseLog) {
            hsyco.messageLog("SiemensEdp: Parsing message frame: 0x" + message);
        }
        MessageFrameV2 frame = new MessageFrameV2();
        String msgFrameLength = message.substring(0, 4);
        String remainingMessage = message.substring(4, message.length());
        if (Configuration.verboseLog) {
            hsyco.messageLog("SiemensEdp: [Frame info] Total message frame length: 0x" + msgFrameLength + ", " + Driver.bytesToUnsignedInteger(Driver.hexStringToByteArray(msgFrameLength)));
        }
        if (Driver.bytesToUnsignedShort(Driver.hexStringToByteArray(msgProtocolId = remainingMessage.substring(0, 2))) != frame.getProtocolId()) {
            throw new IOException("Wrong frame protocol id: " + msgProtocolId);
        }
        String msgFrameLayoutVersion = (remainingMessage = remainingMessage.substring(2, remainingMessage.length())).substring(0, 2);
        if (Driver.bytesToUnsignedShort(Driver.hexStringToByteArray(msgFrameLayoutVersion)) != frame.getFrameLayoutVersion()) {
            throw new IOException("Wrong frame layout version: " + msgFrameLayoutVersion);
        }
        remainingMessage = remainingMessage.substring(2, remainingMessage.length());
        String msgProtocolFlags = remainingMessage.substring(0, 2);
        frame.setProtocolFlags((byte)Driver.bytesToUnsignedShort(Driver.hexStringToByteArray(msgProtocolFlags)));
        remainingMessage = remainingMessage.substring(2, remainingMessage.length());
        String msgSequenceNumber = remainingMessage.substring(0, 8);
        frame.setSequenceNumber(Driver.hexStringToByteArray(msgSequenceNumber));
        remainingMessage = remainingMessage.substring(8, remainingMessage.length());
        String msgSourceId = remainingMessage.substring(0, 8);
        frame.setSourceId(Driver.hexStringToByteArray(msgSourceId));
        remainingMessage = remainingMessage.substring(8, remainingMessage.length());
        String msgDestinationId = remainingMessage.substring(0, 8);
        frame.setDestinationId(Driver.hexStringToByteArray(msgDestinationId));
        remainingMessage = remainingMessage.substring(8, remainingMessage.length());
        String msgMajorFunctionCode = remainingMessage.substring(0, 2);
        frame.setMajorFunctionCode((byte)Driver.bytesToUnsignedShort(Driver.hexStringToByteArray(msgMajorFunctionCode)));
        remainingMessage = remainingMessage.substring(2, remainingMessage.length());
        String msgMinorFunctionCode = remainingMessage.substring(0, 2);
        frame.setMinorFunctionCode((byte)Driver.bytesToUnsignedShort(Driver.hexStringToByteArray(msgMinorFunctionCode)));
        remainingMessage = remainingMessage.substring(2, remainingMessage.length());
        String msgCrcCheckSum = remainingMessage.substring(0, 4);
        remainingMessage = remainingMessage.substring(4, remainingMessage.length());
        String msgForCrc = message.substring(4, message.length());
        byte[] computedCrc = CRC.edp_calc_crc(msgForCrc, (short)2);
        if (!msgCrcCheckSum.equalsIgnoreCase(Driver.bytesToHex(computedCrc))) {
            if (Configuration.verboseLog) {
                hsyco.messageLog("SiemensEdp: [Frame info] Invalid Crc checksum: 0x" + msgCrcCheckSum + " supposed to be 0x" + Driver.bytesToHex(computedCrc));
            }
            throw new IOException("Not valid CRC Checksum");
        }
        frame.setCrcCheckSum(Driver.hexStringToByteArray(msgCrcCheckSum));
        String msgDataLength = remainingMessage.substring(0, 4);
        frame.setDataLength(Driver.hexStringToByteArray(msgDataLength));
        remainingMessage = remainingMessage.substring(4, remainingMessage.length());
        String msgData = remainingMessage.substring(0, Driver.bytesToUnsignedInteger(frame.getDataLength()) * 2);
        frame.setData(Driver.hexStringToByteArray(msgData));
        remainingMessage = remainingMessage.substring(Driver.bytesToUnsignedInteger(frame.getDataLength()) * 2, remainingMessage.length());
        if (Configuration.verboseLog) {
            frame.printInfo();
        }
        return frame;
    }

    public static MessageFrameV2 createMessageFrame(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte majorFunctionCode, byte minorFunctionCode, byte[] data) throws IOException {
        MessageFrameV2 frame = new MessageFrameV2();
        int totalLength = 2;
        frame.setProtocolFlags(protocolFlags);
        ++totalLength;
        frame.setSequenceNumber(sequenceNumber);
        totalLength += 4;
        frame.setSourceId(sourceId);
        totalLength += 4;
        frame.setDestinationId(destinationId);
        totalLength += 4;
        frame.setMajorFunctionCode(majorFunctionCode);
        ++totalLength;
        frame.setMinorFunctionCode(minorFunctionCode);
        ++totalLength;
        String lengthHexStr = Integer.toHexString(data.length);
        byte[] lengthByte = Driver.hexStringToByteArray(lengthHexStr);
        if (lengthByte.length < 2) {
            byte[] paddedArray = new byte[2];
            paddedArray[0] = lengthByte[0];
            lengthByte = paddedArray;
        }
        frame.setDataLength(lengthByte);
        totalLength += 2;
        frame.setData(data);
        totalLength += data.length;
        String crcString = frame.getCrcCheckSumString();
        byte[] res = CRC.edp_calc_crc(crcString, (short)2);
        frame.setCrcCheckSum(res);
        if ((totalLength += 2) % 16 != 0) {
            int paddingSize = 16 - totalLength % 16;
            byte[] padding = new byte[paddingSize];
            int i2 = 0;
            while (i2 < padding.length) {
                padding[i2] = -1;
                ++i2;
            }
            frame.setPadding(padding);
            totalLength += paddingSize;
        }
        if (Configuration.verboseLog) {
            frame.printHexString();
            frame.printInfo();
        }
        return frame;
    }

    public static MessageFrameV2 createTcpConnectionEstablishReply(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte[] data) throws IOException {
        int DATA_LENGTH = 8;
        if (data.length != DATA_LENGTH) {
            if (Configuration.verboseLog) {
                hsyco.messageLog("SiemensEdp: [Tcp connection establish reply] Invalid data length");
            }
            throw new IOException("Invalid tcp connection establish reply data length");
        }
        MessageFrameV2 frame = MessageManager.createMessageFrame(protocolFlags, sequenceNumber, sourceId, destinationId, (byte)1, (byte)3, data);
        return frame;
    }

    public static MessageFrameV2 createTcpConnectionPollReply(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte[] data) throws IOException {
        int DATA_LENGTH = 8;
        if (data.length != DATA_LENGTH) {
            if (Configuration.verboseLog) {
                hsyco.messageLog("SiemensEdp: [Tcp poll reply] Invalid data length");
            }
            throw new IOException("Invalid tcp poll reply data length");
        }
        MessageFrameV2 frame = MessageManager.createMessageFrame(protocolFlags, sequenceNumber, sourceId, destinationId, (byte)1, (byte)1, data);
        return frame;
    }

    public static MessageFrameV2 createSiaEventAck(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte[] data) throws IOException {
        MessageFrameV2 frame = MessageManager.createMessageFrame(protocolFlags, sequenceNumber, sourceId, destinationId, (byte)2, (byte)1, data);
        return frame;
    }

    public static MessageFrameV2 createCommand(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte[] data) throws IOException {
        MessageFrameV2 frame = MessageManager.createMessageFrame(protocolFlags, sequenceNumber, sourceId, destinationId, (byte)4, (byte)0, data);
        return frame;
    }

    public static MessageFrameV2 createXmlCommand(byte protocolFlags, byte[] sequenceNumber, byte[] sourceId, byte[] destinationId, byte[] data) throws IOException {
        MessageFrameV2 frame = MessageManager.createMessageFrame(protocolFlags, sequenceNumber, sourceId, destinationId, (byte)10, (byte)0, data);
        return frame;
    }
}

